//----------------------------------------------------------------------------
//
//  Z80R : Z80 Engine  for Intel x86 Protectmode (80386 later)
//
//                                       Copyright by Studio Milmake 1999-2000
//
//----------------------------------------------------------------------------

#include	<windows.h>

#include	"common.h"
#include	"x1_io.h"
#include	"x1_mem.h"
#include	"z80r.h"
#include	"z80r_mcr.h"


Z80RASM _ld_nop(void) { __asm { ret } }

Z80RASM _im_0(void) {

	__asm {
				mov		R_Z80IM, 0
				ret
	}
}

Z80RASM _im_1(void) {

	__asm {
				mov		R_Z80IM, 1
				ret
	}
}
Z80RASM _im_2(void) {

	__asm {
				mov		R_Z80IM, 2
				ret
	}
}

Z80RASM _retn(void) {

	__asm {
				and		Z80_IFF, not ((1 shl IFF_NMI) or (1 shl IFF_IRQ))
				MCR_RET
	}
}

Z80RASM _reti(void) {

	__asm {
				and		Z80_IFF, not (1 shl IFF_IRQ)
				MCR_RET
	}
}

Z80RASM _adc_hl_bc(void) { MCR_ADC_W(R_Z80BC) }
Z80RASM _adc_hl_de(void) { MCR_ADC_W(R_Z80DE) }
Z80RASM _adc_hl_sp(void) { MCR_ADC_W(R_Z80SP) }
Z80RASM _adc_hl_hl(void) {

	__asm {
				mov		ah, R_Z80F
				mov		dx, R_Z80HL
				mov		bx, dx
				sahf
				adc		dx, bx
				lahf
				mov		R_Z80HL, dx
				and		ah, (S_FLAG or Z_FLAG or C_FLAG)
				xor		bh, dh
				jns		adchlhl_nov
				or		ah, V_FLAG
adchlhl_nov:	and		dh, H_FLAG
				or		ah, dh
				mov		R_Z80F, ah
				ret
	}
}

Z80RASM _sbc_hl_bc(void) { MCR_SBC_W(R_Z80BC) }
Z80RASM _sbc_hl_de(void) { MCR_SBC_W(R_Z80DE) }
Z80RASM _sbc_hl_sp(void) { MCR_SBC_W(R_Z80SP) }
Z80RASM _sbc_hl_hl(void) {

	__asm {
				test	R_Z80F, C_FLAG
				jne		sbcwhl_c
				mov		R_Z80HL, 0				; nc
				mov		R_Z80F, (Z_FLAG or N_FLAG)
				ret
sbcwhl_c:		mov		R_Z80HL, -1				; c
				mov		R_Z80F, (S_FLAG or H_FLAG or N_FLAG or C_FLAG)
				ret
	}
}

Z80RASM _neg(void) {

	__asm {
				mov		al, R_Z80A
				mov		dl, al
				neg		al
				lahf
				and		ah, (Z_FLAG or S_FLAG or C_FLAG)
				or		ah, N_FLAG
				mov		dh, dl
				xor		dh, al
				and		dh, H_FLAG
				or		ah, dh
				and		dl, al
				rol		dl, 3
				and		dl, V_FLAG
				or		ah, dl
				xchg	al, ah
				mov		R_Z80AF, ax
				ret
	}
}

Z80RASM _ld_xword_bc(void) { LDx_W(R_Z80BC) }
Z80RASM _ld_xword_de(void) { LDx_W(R_Z80DE) }
Z80RASM _ld_xword_hl(void) { LDx_W(R_Z80HL) }
Z80RASM _ld_xword_sp(void) { LDx_W(R_Z80SP) }

Z80RASM _ld_bc_xword(void) { LDW_x(R_Z80BC) }
Z80RASM _ld_de_xword(void) { LDW_x(R_Z80DE) }
Z80RASM _ld_hl_xword(void) { LDW_x(R_Z80HL) }
Z80RASM _ld_sp_xword(void) { LDW_x(R_Z80SP) }

Z80RASM _ld_a_i(void) {

	__asm {
				mov		al, R_Z80I
				or		al, al
				lahf
				and		ah, (Z_FLAG or S_FLAG)
				test	Z80_IFF, 1 shl IFF_IFLAG
				jne		idai_nov
				or		ah, V_FLAG
idai_nov:		xchg	al, ah
				and		R_Z80AF, C_FLAG
				or		R_Z80AF, ax
				ret
	}
}

Z80RASM _ld_i_a(void) { MCR_LD(R_Z80I, R_Z80A) }

Z80RASM _ld_a_r(void) {

	__asm {
				mov		al, R_Z80R
				mov		ah, R_Z80R2
				and		ax, 807fh
				or		al, ah
				lahf
				and		ah, (Z_FLAG or S_FLAG)
				test	Z80_IFF, 1 shl IFF_IFLAG
				jne		idar_nov
				or		ah, V_FLAG
idar_nov:		xchg	al, ah
				and		R_Z80AF, C_FLAG
				or		R_Z80AF, ax
				ret
	}
}

Z80RASM _ld_r_a(void) {

	__asm {
				mov		al, R_Z80A
				mov		R_Z80R, al
				mov		R_Z80R2, al
				ret
	}
}

Z80RASM _rld(void) {

	__asm {
				mov		cx, R_Z80HL
				call	Z80_RDMEM
				mov		bx, R_Z80AF
				mov		dl, bh
				mov		dh, bh
				shl		ax, 4
				and		dx, 0f00fh
				or		dx, ax
				xor		eax, eax
				mov		al, dh
				and		bl, C_FLAG
				or		bl, ZSPtable[eax]
				mov		bh, dh
				mov		R_Z80AF, bx
				jmp		Z80_WRMEM
	}
}

Z80RASM _rrd(void) {

	__asm {
				mov		cx, R_Z80HL
				call	Z80_RDMEM
				mov		ah, al
				mov		bx, R_Z80AF
				mov		dl, bh
				mov		dh, bh
				and		dx, 0f00fh
				and		ax, 00ff0h
				or		dx, ax
				ror		dl, 4
				xor		eax, eax
				mov		al, dh
				and		bl, C_FLAG
				or		bl, ZSPtable[eax]
				mov		bh, dh
				mov		R_Z80AF, bx
				jmp		Z80_WRMEM
	}
}

Z80RASM _in_a_c(void) { MCR_Z80INF(R_Z80A) }
Z80RASM _in_b_c(void) { MCR_Z80INF(R_Z80B) }
Z80RASM _in_c_c(void) { MCR_Z80INF(R_Z80C) }
Z80RASM _in_d_c(void) { MCR_Z80INF(R_Z80D) }
Z80RASM _in_e_c(void) { MCR_Z80INF(R_Z80E) }
Z80RASM _in_l_c(void) { MCR_Z80INF(R_Z80L) }
Z80RASM _in_h_c(void) { MCR_Z80INF(R_Z80H) }
Z80RASM _in_0_c(void) {

	__asm {
				mov		cx, R_Z80BC
				call	Z80_In
				and		R_Z80F, C_FLAG
				and		eax, 0ffh
				mov		al, ZSPtable[eax]
				or		R_Z80F, al
				ret
	}
}

Z80RASM _out_c_a(void) { MCR_Z80OUT(R_Z80A) }
Z80RASM _out_c_b(void) { MCR_Z80OUT(R_Z80B) }
Z80RASM _out_c_c(void) { MCR_Z80OUT(R_Z80C) }
Z80RASM _out_c_d(void) { MCR_Z80OUT(R_Z80D) }
Z80RASM _out_c_e(void) { MCR_Z80OUT(R_Z80E) }
Z80RASM _out_c_l(void) { MCR_Z80OUT(R_Z80L) }
Z80RASM _out_c_h(void) { MCR_Z80OUT(R_Z80H) }
Z80RASM _out_c_0(void) { MCR_Z80OUT(0) }

Z80RASM _ind(void) {

	__asm {
				mov		cx, R_Z80BC
				call	Z80_In
				mov		dl, al
				mov		cx, R_Z80HL
				dec		R_Z80HL
				dec		R_Z80B
				lahf
				and		ah, Z_FLAG
				or		ah, N_FLAG
				mov		R_Z80F, ah
				jmp		fast_WRMEM
	}
}

Z80RASM _indr(void) {

	__asm {
				mov		cx, R_Z80BC
				call	Z80_In
				mov		dl, al
				mov		cx, R_Z80HL
				dec		R_Z80HL
				dec		R_Z80B
				je		in_b_zero
				mov		R_Z80F, N_FLAG
				add		Z80_ICount, 5
				sub		R_Z80PC, 2
				jmp		fast_WRMEM
in_b_zero:		mov		R_Z80F, (N_FLAG or Z_FLAG)
				jmp		fast_WRMEM
	}
}

Z80RASM _ini(void) {

	__asm {
				mov		cx, R_Z80BC
				call	Z80_In
				mov		dl, al
				mov		cx, R_Z80HL
				inc		R_Z80HL
				dec		R_Z80B
				lahf
				and		ah, Z_FLAG
				or		ah, N_FLAG
				mov		R_Z80F, ah
				jmp		fast_WRMEM
	}
}

Z80RASM _inir(void) {

	__asm {
				mov		cx, R_Z80BC
				call	Z80_In
				mov		dl, al
				mov		cx, R_Z80HL
				inc		R_Z80HL
				dec		R_Z80B
				je		in_b_zero
				mov		R_Z80F, N_FLAG
				add		Z80_ICount, 5
				sub		R_Z80PC, 2
				jmp		fast_WRMEM
in_b_zero:		mov		R_Z80F, (N_FLAG or Z_FLAG)
				jmp		fast_WRMEM
	}
}

Z80RASM _outd(void) {

	__asm {
				mov		cx, R_Z80HL
				dec		R_Z80HL
				call	fast_RDMEM
				mov		dl, al
				mov		cx, R_Z80BC
				dec		ch
				call	Z80_Out
				dec		R_Z80B
				lahf
				and		ah, Z_FLAG
				and		ah, N_FLAG
				mov		R_Z80F, ah
				ret
	}
}

Z80RASM _otdr(void) {

	__asm {
				mov		cx, R_Z80HL
				dec		R_Z80HL
				call	fast_RDMEM
				mov		dl, al
				mov		cx, R_Z80BC
				dec		ch
				call	Z80_Out
				dec		R_Z80B
				je		out_b_zero
				add		Z80_ICount, 5
				sub		R_Z80PC, 2
				mov		R_Z80F, N_FLAG
				ret
out_b_zero:		mov		R_Z80F, (N_FLAG or Z_FLAG)
				ret
	}
}

Z80RASM _outi(void) {

	__asm {
				mov		cx, R_Z80HL
				inc		R_Z80HL
				call	fast_RDMEM
				mov		dl, al
				mov		cx, R_Z80BC
				dec		ch
				call	Z80_Out
				dec		R_Z80B
				lahf
				and		ah, Z_FLAG
				or		ah, N_FLAG
				mov		R_Z80F, ah
				ret
	}
}

Z80RASM _otir(void) {

	__asm {
				mov		cx, R_Z80HL
				inc		R_Z80HL
				call	fast_RDMEM
				mov		dl, al
				mov		cx, R_Z80BC
				dec		ch
				call	Z80_Out
				dec		R_Z80B
				je		out_b_zero
				add		Z80_ICount, 5
				sub		R_Z80PC, 2
				mov		R_Z80F, N_FLAG
				ret
out_b_zero:		mov		R_Z80F, (N_FLAG or Z_FLAG)
				ret
	}
}

Z80RASM _ldd(void) {

	__asm {		mov		cx, R_Z80HL
				call	fast_RDMEM
				mov		dl, al
				mov		cx, R_Z80DE
				dec		R_Z80DE
				dec		R_Z80HL
				and		R_Z80F, 0e9h
				dec		R_Z80BC
				je		ldd_zero
				or		R_Z80F, V_FLAG
ldd_zero:		jmp		fast_WRMEM
	}
}

Z80RASM _lddr(void) {

	__asm {
				mov		cx, R_Z80HL
				call	fast_RDMEM
				mov		dl, al
				mov		cx, R_Z80DE
				dec		R_Z80DE
				dec		R_Z80HL
				and		R_Z80F, 0e9h
				dec		R_Z80BC
				je		ldd_zero
				or		R_Z80F, V_FLAG
				add		Z80_ICount, 5
				sub		R_Z80PC, 2
ldd_zero:		jmp		fast_WRMEM
	}
}

Z80RASM _ldi(void) {

	__asm {
				mov		cx, R_Z80HL
				call	fast_RDMEM
				mov		dl, al
				mov		cx, R_Z80DE
				inc		R_Z80DE
				inc		R_Z80HL
				and		R_Z80F, 0e9h
				dec		R_Z80BC
				je		ldd_zero
				or		R_Z80F, V_FLAG
ldd_zero:		jmp		fast_WRMEM
	}
}

Z80RASM _ldir(void) {

	__asm {
				mov		cx, R_Z80HL
				call	fast_RDMEM
				mov		dl, al
				mov		cx, R_Z80DE
				inc		R_Z80DE
				inc		R_Z80HL
				and		R_Z80F, 0e9h
				dec		R_Z80BC
				je		ldd_zero
				or		R_Z80F, V_FLAG
				add		Z80_ICount, 5
				sub		R_Z80PC, 2
ldd_zero:		jmp		fast_WRMEM
	}
}

Z80RASM _cpd(void) {

	__asm {
				mov		cx, R_Z80HL
				dec		R_Z80HL
				call	fast_RDMEM
				mov		dx, R_Z80AF
				and		dl, C_FLAG
				mov		ch, dh
				sub		dh, al
				lahf
				xor		al, dh
				xor		al, ch
				and		ax, ((Z_FLAG or S_FLAG) shl 8) or H_FLAG
				or		al, ah
				or		al, dl
				dec		R_Z80BC
				je		cp_bc_zero
				or		al, N_FLAG or V_FLAG
				mov		R_Z80F, al
				ret
cp_bc_zero:		or		al, N_FLAG
				mov		R_Z80F, al
				ret
	}
}

Z80RASM _cpdr(void) {

	__asm {
				mov		cx, R_Z80HL
				dec		R_Z80HL
				call	fast_RDMEM
				mov		dx, R_Z80AF
				and		dl, C_FLAG
				mov		ch, dh
				sub		dh, al
				je		cpd_z
				lahf
				xor		al, dh
				xor		al, ch
				and		ax, ((Z_FLAG or S_FLAG) shl 8) or H_FLAG
				or		al, ah
				or		al, dl
				dec		R_Z80BC
				je		cp_bc_zero
				add		Z80_ICount, 5
				sub		R_Z80PC, 2
				or		al, N_FLAG or V_FLAG
				mov		R_Z80F, al
				ret
cpd_z:			lahf
				xor		al, dh
				xor		al, ch
				and		ax, ((Z_FLAG or S_FLAG) shl 8) or H_FLAG
				or		al, ah
				or		al, dl
				dec		R_Z80BC
				je		cp_bc_zero
				or		al, N_FLAG or V_FLAG
				mov		R_Z80F, al
				ret
cp_bc_zero:		or		al, N_FLAG
				mov		R_Z80F, al
				ret
	}
}

Z80RASM _cpi(void) {

	__asm {
				mov		cx, R_Z80HL
				inc		R_Z80HL
				call	fast_RDMEM
				mov		dx, R_Z80AF
				and		dl, C_FLAG
				mov		ch, dh
				sub		dh, al
				lahf
				xor		al, dh
				xor		al, ch
				and		ax, ((Z_FLAG or S_FLAG) shl 8) or H_FLAG
				or		al, ah
				or		al, dl
				dec		R_Z80BC
				je		cp_bc_zero
				or		al, N_FLAG or V_FLAG
				mov		R_Z80F, al
				ret
cp_bc_zero:		or		al, N_FLAG
				mov		R_Z80F, al
				ret
	}
}

Z80RASM _cpir(void) {

	__asm {
				mov		cx, R_Z80HL
				inc		R_Z80HL
				call	fast_RDMEM
				mov		dx, R_Z80AF
				and		dl, C_FLAG
				mov		ch, dh
				sub		dh, al
				je		cpi_z
				lahf
				xor		al, dh
				xor		al, ch
				and		ax, ((Z_FLAG or S_FLAG) shl 8) or H_FLAG
				or		al, ah
				or		al, dl
				dec		R_Z80BC
				je		cp_bc_zero
				add		Z80_ICount, 5
				sub		R_Z80PC, 2
				or		al, N_FLAG or V_FLAG
				mov		R_Z80F, al
				ret
cpi_z:			lahf
				xor		al, dh
				xor		al, ch
				and		ax, ((Z_FLAG or S_FLAG) shl 8) or H_FLAG
				or		al, ah
				or		al, dl
				dec		R_Z80BC
				je		cp_bc_zero
				or		al, N_FLAG or V_FLAG
				mov		R_Z80F, al
				ret
cp_bc_zero:		or		al, N_FLAG
				mov		R_Z80F, al
				ret
	}
}


Z80ROPCODE opcode_ed[256] = {
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,		// 00
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,

		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,		// 10
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,

		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,		// 20
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,

		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,		// 30
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,

		_in_b_c,		_out_c_b,		_sbc_hl_bc,		_ld_xword_bc,	// 40
		_neg,			_retn,			_im_0,			_ld_i_a,
		_in_c_c,		_out_c_c,		_adc_hl_bc,		_ld_bc_xword,
		_neg,			_reti,			_im_0,			_ld_r_a,

		_in_d_c,		_out_c_d,		_sbc_hl_de,		_ld_xword_de,	// 50
		_neg,			_retn,			_im_1,			_ld_a_i,
		_in_e_c,		_out_c_e,		_adc_hl_de,		_ld_de_xword,
		_neg,			_reti,			_im_2,			_ld_a_r,

		_in_h_c,		_out_c_h,		_sbc_hl_hl,		_ld_xword_hl,	// 60
		_neg,			_retn,			_im_0,			_rrd,
		_in_l_c,		_out_c_l,		_adc_hl_hl,		_ld_hl_xword,
		_neg,			_reti,			_im_0,			_rld,

		_in_0_c,		_out_c_0,		_sbc_hl_sp,		_ld_xword_sp,	// 70
		_neg,			_retn,			_im_1,			_ld_nop,
		_in_a_c,		_out_c_a,		_adc_hl_sp,		_ld_sp_xword,
		_neg,			_reti,			_im_2,			_ld_nop,

		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,		// 80
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,

		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,		// 90
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,

		_ldi,			_cpi,			_ini,			_outi,			// a0
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ldd,			_cpd,			_ind,			_outd,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,

		_ldir,			_cpir,			_inir,			_otir,			// b0
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_lddr,			_cpdr,			_indr,			_otdr,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,

		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,		// c0
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,

		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,		// d0
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,

		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,		// e0
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,

		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,		// f0
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop,
		_ld_nop,		_ld_nop,		_ld_nop,		_ld_nop};

