#include	<windows.h>

#include	"common.h"
#include	"xmil.h"
#include	"x1.h"
#include	"x1_crtc.h"
#include	"x1_pcg.h"
#include	"x1_vram.h"
#include	"ddraws.h"
#include	"draw.h"
#include	"draw.mcr"
#include	"draw_sub.h"
#include	"draw_sub.mcr"


extern	BYTE	dispflg;
extern	BYTE	*dispp;
extern	BYTE	*dispp2;

extern	WORD	vramsize;
extern	BYTE	blinktest;
extern	BYTE	fontlpcnt;
extern	BYTE	vramylpcnt;
extern	WORD	vramylpad;


void width40x25_4096(void) {		// 40x25 4096colors(Low-reso)

	WORD	p;
	DWORD	*v;
	WORD	newline = 0;
	WORD	yp = 0;

		__asm {
				pushf
				cld
				mov		ax, ds
				push	es
				mov		es, ax
				push	esi
				push	edi

				mov		eax, offset screenmap
				mov		v, eax
				xor		bx, bx
				mov		fontycnt, bl
				movzx	esi, crtc.TXT_TOP
				mov		cx, vramsize
				or		cx, cx
				je		dischr_end

dispchrlpst:	cmp		si, (TRAM_MAX/2)
				jnc		dischr_end

				movzx	edx, byte ptr updatetmp[esi]
				test	dl, UPDATE_VRAM
				je		updatechr_e
				and		updatetmp[esi], (~UPDATE_VRAM)
				mov		newline, 1

				push	bx
				push	cx

				mov		p, si
				mov		dh, TXT_RAM[esi + TEXT_ATR]
				test	dh, blinktest
				je		notblinks
				xor		dh, X1ATR_REVERSE
notblinks:		test	dh, 0fh
				je		grphonly
				bt		dx, 4
				sbb		si, 0
				movzx	ecx, byte ptr TXT_RAM[esi + TEXT_ANK]
				mov		ch, TXT_RAM[esi + TEXT_KNJ]
				mov		edi, offset cwork
				test	byte ptr TXT_RAM[esi + TEXT_ATR], 20h
				jne		text0pcg
				test	cx, 80dfh
				je		textnone
				js		kanjiputs

				mov		ch, 0
				lea		esi, ANK_FNT[ecx*8]
				mov		cl, fontlpcnt
				push	edx
				and		dx, 15
				call	txtbeffects[edx*4]
attreffects:	pop		edx
				mov		dl, dh
				and		dx, 15
				mov		esi, offset cwork
				mov		edi, offset cwork+8
				call	planeeffects[edx*4]
				test	crtc.ZPRY, 1
				jne		screen1txtdwn
				inc		eax
				jne		screen1txtupt
				jmp		textonly

kanjiputs:		bt		cx, 14
				pushf
				push	edx
				call	adr2jis_x1t
				mov		cx, ax
				call	getfontjis
				mov		esi, eax
				pop		edx
				popf
				adc		esi, 0
				push	edx
				and		edx, 15
				movzx	ecx, fontlpcnt
				call	knjbeffects[edx*4]
				jmp		attreffects

text0pcg:		mov		al, dl
				and		eax, 15
				mov		esi, offset txtbeffects
				test	ch, 90h
				mov		ch, 0
				je		textpcgext
				and		cl, 0feh
				mov		esi, offset extbeffects
textpcgext:		mov		eax, [esi+eax*4]
				mov		edi, offset cwork+8
				lea		esi, pcg.B[ecx*8]
				mov		ecx, 8
				push	eax
				test	dh, 1
				je		plane1_off
				call	eax
				mov		cl, 8
				jmp		plane1_end
plane1_off:		xor		eax, eax
				stosd
				stosd
plane1_end:		pop		eax
				add		esi, 256*8
				push	eax
				test	dh, 2
				je		plane2_off
				call	eax
				mov		cl, 8
				jmp		plane2_end
plane2_off:		xor		eax, eax
				stosd
				stosd
plane2_end:		pop		eax
				add		esi, 256*8
				test	dh, 4
				je		plane4_off
				call	eax
				jmp		plane4_end
plane4_off:		xor		eax, eax
				stosd
				stosd
plane4_end:		mov		esi, offset cwork+8
				test	dh, 8
				jne		txtpcgrevs
				MASKMAKE3_0
				jmp		txtpcgmasksto
txtpcgrevs:		mov		edi, esi
				lodsd
				not		eax
				stosd
				mov		ebx, eax
				lodsd
				not		eax
				stosd
				mov		edx, eax
				lodsd
				not		eax
				stosd
				or		ebx, eax
				lodsd
				not		eax
				stosd
				or		edx, eax
				lodsd
				not		eax
				stosd
				or		ebx, eax
				lodsd
				not		eax
				stosd
				or		edx, eax
txtpcgmasksto:	mov		dword ptr (cwork), ebx
				mov		dword ptr (cwork+4), edx
				test	crtc.ZPRY, 1
				je		screen1txtup

				// OtBbNeLXg
screen1txtdwn:	movzx	esi, p
				rol		si, 5
				lea		esi, GRP_RAM[esi+PLANE_B+GRAM_BANK0L]
				mov		edi, offset cwork+8

				MASKMAKE3_0
				add		esi, GRAM_HALFSTEP - 24
				MASKMAKE3_1
				add		esi, GRAM_HALFSTEP - 24
				MASKMAKE3_1
				add		esi, GRAM_HALFSTEP - 24
				MASKMAKE3_1
				sub		esi, 24

				not		ebx
				not		edx

				mov		ecx, 3
downdest2lp1:	lodsd
				and		[edi], ebx
				or		[edi], eax
				lodsd
				and		[edi+4], edx
				or		[edi+4], eax
				sub		esi, GRAM_HALFSTEP + 8
				add		edi, 8
				loop	downdest2lp1
				movsd
				movsd
				mov		cl, 4
downdest2lp2:	movsd
				movsd
				movsd
				movsd
				add		esi, GRAM_HALFSTEP - 16
				loop	downdest2lp2
				and		dword ptr (cwork), ebx
				and		dword ptr (cwork+4), edx
				jmp		grphtxtout

				// eLXgOtBbN
screen1txtupt:	mov		ebx, dword ptr (cwork)
				mov		edx, dword ptr (cwork+4)
screen1txtup:	not		ebx
				not		edx
				movzx	esi, p
				rol		si, 5
				lea		esi, GRP_RAM[esi+PLANE_B+GRAM_BANK1H]
				mov		edi, offset cwork+8

				mov		ecx, 3
dwnputs1:		lodsd
				and		eax, ebx
				or		[edi], eax
				lodsd
				and		eax, edx
				or		[edi+4], eax
				sub		esi, GRAM_HALFSTEP + 8
				add		edi, 8
				loop	dwnputs1
				lodsd
				and		eax, ebx
				stosd
				lodsd
				and		eax, edx
				stosd
				mov		cl, 4
dwnputs2:		lodsd
				and		eax, ebx
				stosd
				lodsd
				and		eax, edx
				stosd
				lodsd
				and		eax, ebx
				stosd
				lodsd
				and		eax, edx
				stosd
				add		esi, GRAM_HALFSTEP - 16
				loop	dwnputs2
				jmp		grphtxtout

textnone:		test	dh, 8
				je		grphonly
				mov		eax, -1
				mov		ecx, 8
				rep stosd
				test	crtc.ZPRY, 1
				jne		screen1txtdwn
				inc		eax
				mov		cl, 9*2
				rep stosd
				jmp		grphtxtout

textonly:		mov		cl, 9*2
				rep stosd
				dec		eax
				mov		dword ptr (cwork), eax
				mov		dword ptr (cwork+4), eax
				jmp		grphtxtout

				// \
grphonly:		movzx	esi, p
				rol		si, 5
				lea		esi, GRP_RAM[esi+PLANE_B+GRAM_BANK1H]
				mov		edi, offset cwork
				xor		eax, eax
				stosd
				stosd
				mov		ecx, 3
grpholp1:		movsd
				movsd
				sub		esi, GRAM_HALFSTEP + 8
				loop	grpholp1
				movsd
				movsd
				mov		cl, 4
grpholp2:		movsd
				movsd
				movsd
				movsd
				add		esi, GRAM_HALFSTEP - 16
				loop	grpholp2
grphtxtout:		mov		esi, offset cwork
				mov		edi, v
				mov		cl, vramylpcnt
grphcpy64_lp:	movzx	ebx, byte ptr [esi+0]						; tg bit12
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BIT4]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BIT4 + 4]
				mov		bl, [esi+48]								; g0 bit11
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT3]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT3 + 4]
				mov		bl, [esi+64]								; g1 bit10
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT2 + 4]
				mov		bl, [esi+80]								; g2 bit9
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT1]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT1 + 4]
				mov		bl, [esi+96]								; g3 bit8
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT0]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT0 + 4]
				mov		[edi+SCREEN_WIDTH*0+320], eax
				mov		[edi+SCREEN_WIDTH*0+324], edx
				mov		[edi+SCREEN_WIDTH*1+320], eax
				mov		[edi+SCREEN_WIDTH*1+324], edx

				mov		bl, [esi+8]									; b3 bit0
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BIT0]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BIT0 + 4]
				mov		bl, [esi+16]								; b2 bit1
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT1]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT1 + 4]
				mov		bl, [esi+24]								; b1 bit2
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT2 + 4]
				mov		bl, [esi+32]								; b0 bit3
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT3]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT3 + 4]
				mov		bl, [esi+40]								; r0 bit7
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT7]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT7 + 4]
				mov		bl, [esi+56]								; r1 bit6
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT6]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT6 + 4]
				mov		bl, [esi+72]								; r2 bit5
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT5]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT5 + 4]
				mov		bl, [esi+88]								; r3 bit4
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT4]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT4 + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*0+4], edx
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*1+4], edx

				inc		esi
				add		edi, SCREEN_WIDTH*2
				dec		cl
				jne		grphcpy64_lp

				movzx	esi, p
				pop		cx
				pop		bx
updatechr_e:
				VRAMADRRESS_INC
				dec		cx
				jne		dispchrlpst
dischr_end:
				pop		edi
				pop		esi
				pop		es
				popf
		}
}




void width40x12_4096(void) {		// 40x12 4096colors(Low-reso)

	WORD	p;
	DWORD	*v;
	WORD	newline = 0;
	WORD	yp = 0;

		__asm {
				pushf
				cld
				mov		ax, ds
				push	es
				mov		es, ax
				push	esi
				push	edi

				mov		eax, offset screenmap
				mov		v, eax
				xor		bx, bx
				mov		fontycnt, bl
				movzx	esi, crtc.TXT_TOP
				mov		cx, vramsize
				or		cx, cx
				je		dischr_end

dispchrlpst:	cmp		si, (TRAM_MAX/2)
				jnc		dischr_end

				movzx	edx, byte ptr updatetmp[esi]
				test	dl, UPDATE_VRAM
				je		updatechr_e
				and		updatetmp[esi], (~UPDATE_VRAM)
				mov		newline, 1

				push	bx
				push	cx

				mov		p, si
				mov		dh, TXT_RAM[esi + TEXT_ATR]
				test	dh, blinktest
				je		notblinks
				xor		dh, X1ATR_REVERSE
notblinks:		test	dh, 0fh
				je		grphonly
				bt		dx, 4
				sbb		si, 0
				movzx	ecx, byte ptr TXT_RAM[esi + TEXT_ANK]
				mov		ch, TXT_RAM[esi + TEXT_KNJ]
				mov		edi, offset cwork
				test	byte ptr TXT_RAM[esi + TEXT_ATR], 20h
				jne		text0pcg
				test	cx, 80dfh
				je		textnone
				js		kanjiputs

				mov		ch, 0
				mov		esi, ecx
				shl		si, 4
				add		esi, offset KNJ_FNT
				mov		cl, fontlpcnt
				push	edx
				and		dx, 15
				call	txtbeffects16[edx*4]
attreffects:	pop		edx
				mov		dl, dh
				and		dx, 15
				mov		esi, offset cwork
				mov		edi, offset cwork+8
				call	planeeffects16[edx*4]
				test	crtc.ZPRY, 1
				jne		screen1txtdwn
				inc		eax
				jne		screen1txtup
				jmp		textonly

kanjiputs:		bt		cx, 14
				pushf
				push	edx
				call	adr2jis_x1t
				mov		cx, ax
				call	getfontjis
				mov		esi, eax
				pop		edx
				popf
				adc		esi, 0
				push	edx
				and		edx, 15
				movzx	ecx, fontlpcnt
				call	knjbeffects16[edx*4]
				jmp		attreffects

text0pcg:		mov		al, dl
				and		eax, 15
				mov		esi, offset pcgbeffectsx2
				test	ch, 90h
				mov		ch, 0
				je		textpcgext
				and		cl, 0feh
				mov		esi, offset txtbeffects16
textpcgext:		mov		eax, [esi+eax*4]
				mov		edi, offset cwork+8
				lea		esi, pcg.B[ecx*8]
				mov		ecx, 8
				push	eax
				test	dh, 1
				je		plane1_off
				call	eax
				mov		cl, 8
				jmp		plane1_end
plane1_off:		xor		eax, eax
				mov		[edi+64], eax
				mov		[edi+68], eax
				stosd
				stosd
plane1_end:		pop		eax
				add		esi, 256*8
				push	eax
				test	dh, 2
				je		plane2_off
				call	eax
				mov		cl, 8
				jmp		plane2_end
plane2_off:		xor		eax, eax
				mov		[edi+64], eax
				mov		[edi+68], eax
				stosd
				stosd
plane2_end:		pop		eax
				add		esi, 256*8
				test	dh, 4
				je		plane4_off
				call	eax
				jmp		plane4_end
plane4_off:		xor		eax, eax
				mov		[edi+64], eax
				mov		[edi+68], eax
				stosw
				stosw
plane4_end:		mov		edi, offset cwork
				mov		cl, 4
				test	dh, 8
				jne		pcgmask2
				PCG16MASK_NOR
				PCG16MASK_NOR
				add		edi, 64 - 8
				PCG16MASK_NOR
				PCG16MASK_NOR
				jmp		txtpcgmasksto
pcgmask2:		PCG16MASK_REV
				PCG16MASK_REV
				add		edi, 64 - 8
				PCG16MASK_REV
				PCG16MASK_REV

txtpcgmasksto:	test	crtc.ZPRY, 1
				je		screen1txtup

				// OtBbNeLXg
screen1txtdwn:	movzx	esi, p
				rol		si, 5
				lea		esi, GRP_RAM[esi+PLANE_B+GRAM_BANK0L]
				mov		edi, offset cwork+8

				MASKMAKE3_0
				add		esi, GRAM_HALFSTEP - 24
				MASKMAKE3_1
				add		esi, GRAM_HALFSTEP - 24
				MASKMAKE3_1
				add		esi, GRAM_HALFSTEP - 24
				MASKMAKE3_1
				sub		esi, 24
				not		ebx
				not		edx

				mov		ecx, 3
downdest2lp1:	lodsd
				and		[edi], ebx
				or		[edi], eax
				and		[edi+64], ebx
				or		[edi+64], eax
				lodsd
				and		[edi+4], edx
				or		[edi+4], eax
				and		[edi+68], edx
				or		[edi+68], eax
				sub		esi, GRAM_HALFSTEP + 8
				add		edi, 8
				loop	downdest2lp1
				lodsd									; B0
				mov		[edi+64], eax
				stosd
				lodsd
				mov		[edi+64], eax
				stosd
				and		dword ptr (cwork), ebx
				and		dword ptr (cwork+4), edx
				and		dword ptr (cwork+64), ebx
				and		dword ptr (cwork+68), edx
				add		edi, 24+64
				mov		dl, 4
downdest2lp2:	mov		cl, 4
downdest2lp3:	lodsd
				mov		[edi+64], eax
				stosd
				loop	downdest2lp3
				add		esi, GRAM_HALFSTEP - 16
				dec		dl
				jne		downdest2lp2
				jmp		grphtxtout

				// eLXgOtBbN
screen1txtup:	mov		ebx, dword ptr cwork
				not		ebx
				mov		edx, dword ptr (cwork + 4)
				not		edx
				movzx	esi, p
				rol		si, 5
				lea		esi, GRP_RAM[esi + PLANE_B + GRAM_BANK1H]
				mov		edi, offset (cwork + 8)
				mov		ecx, 3
dwnputs1:		lodsd
				and		eax, ebx
				or		[edi], eax
				lodsd
				and		eax, edx
				or		[edi+4], eax
				sub		esi, GRAM_HALFSTEP + 8
				add		edi, 8
				loop	dwnputs1
				lodsd
				and		eax, ebx
				stosd
				lodsd
				and		eax, edx
				stosd
				add		edi, (24+64)
				mov		cl, 4
dwnputs2:		lodsd
				and		eax, ebx
				stosd
				lodsd
				and		eax, edx
				stosd
				lodsd
				and		eax, ebx
				stosd
				lodsd
				and		eax, edx
				stosd
				add		esi, GRAM_HALFSTEP - 16
				loop	dwnputs2
											// esi = I[o[t[ R0
				sub		esi, GRAM_HALFSTEP + 8
				mov		ebx, dword ptr (cwork + 64)
				not		ebx
				mov		edx, dword ptr (cwork + 68)
				not		edx
				mov		edi, offset (cwork + 64 + 8)
				mov		cl, 3
dwnputs3:		lodsd
				and		eax, ebx
				or		[edi], eax
				lodsd
				and		eax, edx
				or		[edi+4], eax
				sub		esi, GRAM_HALFSTEP + 8
				add		edi, 8
				loop	dwnputs3
				lodsd
				and		eax, ebx
				stosd
				lodsd
				and		eax, edx
				stosd
				add		edi, (24 + 64)
				mov		cl, 4
dwnputs4:		lodsd
				and		eax, ebx
				stosd
				lodsd
				and		eax, edx
				stosd
				lodsd
				and		eax, ebx
				stosd
				lodsd
				and		eax, edx
				stosd
				add		esi, GRAM_HALFSTEP - 16
				loop	dwnputs4

grphtxtout:		mov		esi, offset cwork
				mov		edi, v
				mov		cl, vramylpcnt
grphcpy64_lp:	movzx	ebx, byte ptr [esi+0]						; tg bit12
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BIT4]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BIT4 + 4]
				mov		bl, [esi+136]								; g0 bit11
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT3]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT3 + 4]
				mov		bl, [esi+152]								; g1 bit10
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT2 + 4]
				mov		bl, [esi+168]								; g2 bit9
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT1]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT1 + 4]
				mov		bl, [esi+184]								; g3 bit8
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT0]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT0 + 4]
				mov		[edi+SCREEN_WIDTH*0+320], eax
				mov		[edi+SCREEN_WIDTH*0+324], edx
				mov		[edi+SCREEN_WIDTH*1+320], eax
				mov		[edi+SCREEN_WIDTH*1+324], edx
				mov		bl, [esi+8]									; b3 bit0
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BIT0]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BIT0 + 4]
				mov		bl, [esi+16]								; b2 bit1
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT1]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT1 + 4]
				mov		bl, [esi+24]								; b1 bit2
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT2 + 4]
				mov		bl, [esi+32]								; b0 bit3
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT3]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT3 + 4]
				mov		bl, [esi+128]								; r0 bit7
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT7]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT7 + 4]
				mov		bl, [esi+144]								; r1 bit6
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT6]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT6 + 4]
				mov		bl, [esi+160]								; r2 bit5
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT5]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT5 + 4]
				mov		bl, [esi+176]								; r3 bit4
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT4]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT4 + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*0+4], edx
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*1+4], edx

				mov		bl, [esi+64+0]								; tg bit12
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BIT4]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BIT4 + 4]
				mov		bl, [esi+64+136]							; g0 bit11
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT3]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT3 + 4]
				mov		bl, [esi+64+152]							; g1 bit10
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT2 + 4]
				mov		bl, [esi+64+168]							; g2 bit9
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT1]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT1 + 4]
				mov		bl, [esi+64+184]							; g3 bit8
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT0]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT0 + 4]
				mov		[edi+SCREEN_WIDTH*2+320], eax
				mov		[edi+SCREEN_WIDTH*2+324], edx
				mov		[edi+SCREEN_WIDTH*3+320], eax
				mov		[edi+SCREEN_WIDTH*3+324], edx

				mov		bl, [esi+64+8]								; b3 bit0
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BIT0]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BIT0 + 4]
				mov		bl, [esi+64+16]								; b2 bit1
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT1]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT1 + 4]
				mov		bl, [esi+64+24]								; b1 bit2
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT2 + 4]
				mov		bl, [esi+64+32]								; b0 bit3
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT3]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT3 + 4]
				mov		bl, [esi+64+128]							; r0 bit7
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT7]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT7 + 4]
				mov		bl, [esi+64+144]							; r1 bit6
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT6]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT6 + 4]
				mov		bl, [esi+64+160]							; r2 bit5
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT5]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT5 + 4]
				mov		bl, [esi+64+176]							; r3 bit4
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT4]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT4 + 4]
				mov		[edi+SCREEN_WIDTH*2+0], eax
				mov		[edi+SCREEN_WIDTH*2+4], edx
				mov		[edi+SCREEN_WIDTH*3+0], eax
				mov		[edi+SCREEN_WIDTH*3+4], edx

				inc		esi
				add		edi, SCREEN_WIDTH*4
				dec		cl
				jne		grphcpy64_lp
				jmp		updatechr_r


textnone:		test	dh, 8
				je		grphonly
				mov		eax, -1
				mov		ecx, 8
				rep stosd
				test	crtc.ZPRY, 1
				jne		screen1txtdwn

				mov		edi, v							// ^
				mov		cl, vramylpcnt
				shl		cx, 2
				mov		eax, 10101010h
				mov		edx, 07070707h
toufucpy_lp:	mov		[edi+000], edx
				mov		[edi+004], edx
				mov		[edi+320], eax
				mov		[edi+324], eax
				add		edi, SCREEN_WIDTH
				loop	toufucpy_lp
				jmp		updatechr_r


textonly:		mov		esi, offset (cwork + 8)			// eLXg`
				mov		edi, v
				mov		cl, vramylpcnt
textcpyonly_lp:	mov		eax, 10101010h
				mov		[edi+SCREEN_WIDTH*0+320], eax
				mov		[edi+SCREEN_WIDTH*0+324], eax
				mov		[edi+SCREEN_WIDTH*1+320], eax
				mov		[edi+SCREEN_WIDTH*1+324], eax
				mov		[edi+SCREEN_WIDTH*2+320], eax
				mov		[edi+SCREEN_WIDTH*2+324], edx
				mov		[edi+SCREEN_WIDTH*3+320], eax
				mov		[edi+SCREEN_WIDTH*3+324], eax

				movzx	ebx, byte ptr [esi]
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BIT0]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BIT0 + 4]
				mov		bl, [esi+8]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT1]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT1 + 4]
				mov		bl, [esi+16]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT2 + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*0+4], edx
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*1+4], edx

				mov		bl, [esi+64]
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BIT0]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BIT0 + 4]
				mov		bl, [esi+64+8]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT1]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT1 + 4]
				mov		bl, [esi+64+16]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT2 + 4]
				mov		[edi+SCREEN_WIDTH*2+0], eax
				mov		[edi+SCREEN_WIDTH*2+4], edx
				mov		[edi+SCREEN_WIDTH*3+0], eax
				mov		[edi+SCREEN_WIDTH*3+4], edx
				inc		esi
				add		edi, SCREEN_WIDTH*4
				dec		cl
				jne		textcpyonly_lp
				jmp		updatechr_r


				// \
grphonly:		movzx	esi, p							// Ot`
				rol		si, 5
				mov		edi, v
				mov		cl, vramylpcnt
grphcpyonly_lp:	movzx	ebx, byte ptr GRP_RAM[esi + PLANE_G + GRAM_BANK1H]
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BIT0]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BIT0 + 4]
				mov		bl, GRP_RAM[esi + PLANE_G + GRAM_BANK1L]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT1]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT1 + 4]
				mov		bl, GRP_RAM[esi + PLANE_G + GRAM_BANK0H]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT2 + 4]
				mov		bl, GRP_RAM[esi + PLANE_G + GRAM_BANK0L]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT3]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT3 + 4]
				mov		[edi+SCREEN_WIDTH*0+320], eax
				mov		[edi+SCREEN_WIDTH*0+324], edx
				mov		[edi+SCREEN_WIDTH*1+320], eax
				mov		[edi+SCREEN_WIDTH*1+324], edx
				mov		[edi+SCREEN_WIDTH*2+320], eax
				mov		[edi+SCREEN_WIDTH*2+324], edx
				mov		[edi+SCREEN_WIDTH*3+320], eax
				mov		[edi+SCREEN_WIDTH*3+324], edx
				mov		bl, GRP_RAM[esi + PLANE_B + GRAM_BANK1H]
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BIT0]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BIT0 + 4]
				mov		bl, GRP_RAM[esi + PLANE_R + GRAM_BANK1H]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT4]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT4 + 4]
				mov		bl, GRP_RAM[esi + PLANE_B + GRAM_BANK1L]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT1]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT1 + 4]
				mov		bl, GRP_RAM[esi + PLANE_R + GRAM_BANK1L]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT5]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT5 + 4]
				mov		bl, GRP_RAM[esi + PLANE_B + GRAM_BANK0H]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT2 + 4]
				mov		bl, GRP_RAM[esi + PLANE_R + GRAM_BANK0H]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT6]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT6 + 4]
				mov		bl, GRP_RAM[esi + PLANE_B + GRAM_BANK0L]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT3]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT3 + 4]
				mov		bl, GRP_RAM[esi + PLANE_R + GRAM_BANK0L]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT7]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT7 + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*0+4], edx
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*1+4], edx
				mov		[edi+SCREEN_WIDTH*2+0], eax
				mov		[edi+SCREEN_WIDTH*2+4], edx
				mov		[edi+SCREEN_WIDTH*3+0], eax
				mov		[edi+SCREEN_WIDTH*3+4], edx
				inc		esi
				add		edi, SCREEN_WIDTH*4
				dec		cl
				jne		grphcpyonly_lp

updatechr_r:	movzx	esi, p
				pop		cx
				pop		bx
updatechr_e:
				VRAMADRRESS_INC2
				dec		cx
				jne		dispchrlpst
dischr_end:
				pop		edi
				pop		esi
				pop		es
				popf
		}
}


