#include	<windows.h>

#include	"common.h"
#include	"xmil.h"
#include	"x1.h"
#include	"x1_crtc.h"
#include	"x1_pcg.h"
#include	"x1_vram.h"
#include	"ddraws.h"
#include	"draw.h"
#include	"draw.mcr"
#include	"draw_sub.h"
#include	"draw_sub.mcr"


extern	BYTE	dispflg;
extern	BYTE	*dispp;
extern	BYTE	*dispp2;

extern	WORD	vramsize;
extern	BYTE	blinktest;
extern	BYTE	fontlpcnt;
extern	BYTE	vramylpcnt;
extern	WORD	vramylpad;

static LABEL void __fastcall getgrphmaskpat2(void) {

	__asm {
				mov		ebx, [esi]
				or		ebx, [esi + 8]
				or		ebx, [esi + 16]
				or		ebx, [esi + GRAM_HALFSTEP]
				or		ebx, [esi + GRAM_HALFSTEP + 8]
				or		ebx, [esi + GRAM_HALFSTEP + 16]
				mov		edx, [esi + 4]
				or		edx, [esi + 4 + 8]
				or		edx, [esi + 4 + 16]
				or		edx, [esi + 4 + GRAM_HALFSTEP]
				or		edx, [esi + 4 + GRAM_HALFSTEP + 8]
				or		edx, [esi + 4 + GRAM_HALFSTEP + 16]
				ret
	}
}


void width40x12_64l(void) {			// 40x25 64colors low-reso

	WORD	p;
	DWORD	*v;
	WORD	newline = 0;
	WORD	yp = 0;

		__asm {
				pushf
				cld
				mov		ax, ds
				push	es
				mov		es, ax
				push	esi
				push	edi

				mov		eax, offset screenmap
				mov		v, eax
				xor		bx, bx
				mov		fontycnt, bl
				movzx	esi, crtc.TXT_TOP
				mov		cx, vramsize
				or		cx, cx
				je		dischr_end

dispchrlpst:	cmp		si, (TRAM_MAX/2)
				jnc		dischr_end

				movzx	edx, byte ptr updatetmp[esi]
				mov		al, dispflg
				test	dl, al
				je		updatechr_e
				not		al
				and		updatetmp[esi], al
				mov		newline, 1

				push	bx
				push	cx

				mov		p, si

				mov		dh, TXT_RAM[esi + TEXT_ATR]
				test	dh, blinktest
				je		notblinks
				xor		dh, X1ATR_REVERSE
notblinks:		test	dh, 0fh
				je		grphonly
				bt		dx, 4
				sbb		si, 0
				movzx	ecx, byte ptr TXT_RAM[esi + TEXT_ANK]
				mov		ch, TXT_RAM[esi + TEXT_KNJ]
				mov		edi, offset cwork
				test	byte ptr TXT_RAM[esi + TEXT_ATR], 20h
				jne		text0pcg
				test	cx, 80dfh
				je		textnone
				js		kanjiputs

				mov		ch, 0
				mov		esi, ecx
				shl		si, 4
				add		esi, offset KNJ_FNT
				mov		cl, fontlpcnt
				push	edx
				and		dx, 15
				call	txtbeffects16[edx*4]
attreffects:	pop		edx
				mov		dl, dh
				and		dx, 15
				mov		esi, offset cwork
				mov		edi, offset cwork+8
				call	planeeffects16[edx*4]
				test	crtc.ZPRY, 1
				jne		screen1txtdwn
				inc		eax
				jne		screen1txtup
				jmp		textonly

kanjiputs:		bt		cx, 14
				pushf
				push	edx
				call	adr2jis_x1t
				mov		cx, ax
				call	getfontjis
				mov		esi, eax
				pop		edx
				popf
				adc		esi, 0
				push	edx
				and		edx, 15
				movzx	ecx, fontlpcnt
				call	knjbeffects16[edx*4]
				jmp		attreffects

text0pcg:		mov		al, dl
				and		eax, 15
				mov		esi, offset pcgbeffectsx2
				test	ch, 90h
				mov		ch, 0
				je		textpcgext
				and		cl, 0feh
				mov		esi, offset txtbeffects16
textpcgext:		mov		eax, [esi+eax*4]
				mov		edi, offset cwork+8
				lea		esi, pcg.B[ecx*8]
				mov		ecx, 8
				push	eax
				test	dh, 1
				je		plane1_off
				call	eax
				mov		cl, 8
				jmp		plane1_end
plane1_off:		xor		eax, eax
				mov		[edi+64], eax
				mov		[edi+68], eax
				stosd
				stosd
plane1_end:		pop		eax
				add		esi, 256*8
				push	eax
				test	dh, 2
				je		plane2_off
				call	eax
				mov		cl, 8
				jmp		plane2_end
plane2_off:		xor		eax, eax
				mov		[edi+64], eax
				mov		[edi+68], eax
				stosd
				stosd
plane2_end:		pop		eax
				add		esi, 256*8
				test	dh, 4
				je		plane4_off
				call	eax
				jmp		plane4_end
plane4_off:		xor		eax, eax
				mov		[edi+64], eax
				mov		[edi+68], eax
				stosw
				stosw
plane4_end:		mov		edi, offset cwork
				mov		cl, 4
				test	dh, 8
				jne		pcgmask2
				PCG16MASK_NOR
				PCG16MASK_NOR
				add		edi, 64 - 8
				PCG16MASK_NOR
				PCG16MASK_NOR
				jmp		txtpcgmasksto
pcgmask2:		PCG16MASK_REV
				PCG16MASK_REV
				add		edi, 64 - 8
				PCG16MASK_REV
				PCG16MASK_REV

txtpcgmasksto:	test	crtc.ZPRY, 1
				je		screen1txtup

				// OtBbNeLXg
screen1txtdwn:	movzx	esi, p
				rol		si, 5
				add		esi, dispp
				add		esi, PLANE_B
				mov		edi, offset cwork+8

				MAKE_GRPHMASK2(GRAM_HALFSTEP)

				mov		ecx, 3
downdest2lp1:	lodsd
				and		[edi], ebx
				or		[edi], eax
				and		[edi+64], ebx
				or		[edi+64], eax
				lodsd
				and		[edi+4], edx
				or		[edi+4], eax
				and		[edi+68], edx
				or		[edi+68], eax
				add		edi, 8
				loop	downdest2lp1
				add		esi, GRAM_HALFSTEP-24
				mov		cl, 6
downdest2lp2:	lodsd
				mov		[edi+64], eax
				stosd
				loop	downdest2lp2

				and		dword ptr (cwork), ebx
				and		dword ptr (cwork+4), edx
				and		dword ptr (cwork+64), ebx
				and		dword ptr (cwork+68), edx
				jmp		grphtxtout

				// eLXgOtBbN
screen1txtup:	movzx	esi, p
				rol		si, 5
				add		esi, dispp
				add		esi, PLANE_B
				mov		edi, offset cwork+8
				mov		ebx, dword ptr (cwork+0)
				mov		edx, dword ptr (cwork+4)
				not		ebx
				not		edx
				mov		ecx, 3
dwnputs1:		lodsd
				and		eax, ebx
				or		[edi], eax
				lodsd
				and		eax, edx
				or		[edi+4], eax
				add		edi, 8
				loop	dwnputs1
				add		esi, GRAM_HALFSTEP - 24
				mov		cl, 3
dwnputs2:		lodsd
				and		eax, ebx
				stosd
				lodsd
				and		eax, edx
				stosd
				loop	dwnputs2
				sub		esi, GRAM_HALFSTEP + 24

				mov		edi, offset cwork+64+8
				mov		ebx, dword ptr (cwork+64)
				mov		edx, dword ptr (cwork+68)
				not		ebx
				not		edx
				mov		ecx, 3
dwnputs3:		lodsd
				and		eax, ebx
				or		[edi], eax
				lodsd
				and		eax, edx
				or		[edi+4], eax
				add		edi, 8
				loop	dwnputs3
				add		esi, GRAM_HALFSTEP - 24
				mov		cl, 3
dwnputs4:		lodsd
				and		eax, ebx
				stosd
				lodsd
				and		eax, edx
				stosd
				loop	dwnputs4
				jmp		grphtxtout

textnone:		test	dh, 8
				je		grphonly
				mov		eax, -1
				mov		ecx, 8
				rep stosd
				add		edi, 64-32
				mov		cl, 8
				rep stosd
				test	crtc.ZPRY, 1
				jne		screen1txtdwn
				inc		eax

textonly:		mov		edi, offset (cwork+32)
				mov		cl, 6
				rep stosd
				mov		edi, offset (cwork+32+64)
				mov		cl, 6
				rep stosd
				dec		eax
				mov		dword ptr (cwork), eax
				mov		dword ptr (cwork+4), eax
				mov		dword ptr (cwork+64), eax
				mov		dword ptr (cwork+68), eax
				jmp		grphtxtout

				// \
grphonly:		movzx	esi, p
				rol		si, 5
				add		esi, dispp
				add		esi, PLANE_B
				mov		edi, offset cwork
				xor		eax, eax
				stosd
				stosd
				mov		ecx, 6
				rep movsd
				add		esi, GRAM_HALFSTEP - 24
				mov		cl, 6
				rep movsd
				mov		edi, offset (cwork+64)
				stosd
				stosd
				sub		esi, GRAM_HALFSTEP + 24
				mov		cl, 6
				rep movsd
				add		esi, GRAM_HALFSTEP - 24
				mov		cl, 6
				rep movsd

grphtxtout:		mov		esi, offset cwork
				mov		edi, v
				mov		cl, vramylpcnt

grphcpy64_lp:	movzx	ebx, byte ptr [esi+0]
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BIT6]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BIT6 + 4]
				movzx	ebx, byte ptr [esi+8]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE + 4]
				movzx	ebx, byte ptr [esi+16]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED + 4]
				movzx	ebx, byte ptr [esi+24]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN + 4]
				movzx	ebx, byte ptr [esi+32]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE2 + 4]
				movzx	ebx, byte ptr [esi+40]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED2 + 4]
				movzx	ebx, byte ptr [esi+48]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN2 + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*0+4], edx
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*1+4], edx

				movzx	ebx, byte ptr [esi+64+0]
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BIT6]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BIT6 + 4]
				movzx	ebx, byte ptr [esi+64+8]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE + 4]
				movzx	ebx, byte ptr [esi+64+16]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED + 4]
				movzx	ebx, byte ptr [esi+64+24]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN + 4]
				movzx	ebx, byte ptr [esi+64+32]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE2 + 4]
				movzx	ebx, byte ptr [esi+64+40]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED2 + 4]
				movzx	ebx, byte ptr [esi+64+48]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN2 + 4]
				mov		[edi+SCREEN_WIDTH*2+0], eax
				mov		[edi+SCREEN_WIDTH*2+4], edx
				mov		[edi+SCREEN_WIDTH*3+0], eax
				mov		[edi+SCREEN_WIDTH*3+4], edx

				inc		esi
				add		edi, SCREEN_WIDTH*4
				dec		cl
				jne		grphcpy64_lp

				movzx	esi, p
				pop		cx
				pop		bx
updatechr_e:
				VRAMADRRESS_INC2
				dec		cx
				jne		dispchrlpst
dischr_end:
				pop		edi
				pop		esi
				pop		es
				popf
		}
}


void width40x12_64x2(void) {		// 40x25 64colors low-reso

	WORD	p;
	DWORD	*v;
	WORD	newline = 0;
	WORD	yp = 0;

		__asm {
				pushf
				cld
				mov		ax, ds
				push	es
				mov		es, ax
				push	esi
				push	edi

				mov		eax, offset screenmap
				mov		v, eax
				xor		bx, bx
				mov		fontycnt, bl
				movzx	esi, crtc.TXT_TOP
				mov		cx, vramsize
				or		cx, cx
				je		dischr_end

dispchrlpst:	cmp		si, (TRAM_MAX/2)
				jnc		dischr_end

				movzx	edx, byte ptr updatetmp[esi]
				test	dl, UPDATE_VRAM
				je		updatechr_e
				and		updatetmp[esi], (~UPDATE_VRAM)
				mov		newline, 1

				push	bx
				push	cx

				mov		p, si

				mov		dh, TXT_RAM[esi + TEXT_ATR]
				test	dh, blinktest
				je		notblinks
				xor		dh, X1ATR_REVERSE
notblinks:		test	dh, 0fh
				je		grphonly
				bt		dx, 4
				sbb		si, 0
				movzx	ecx, byte ptr TXT_RAM[esi + TEXT_ANK]
				mov		ch, TXT_RAM[esi + TEXT_KNJ]
				mov		edi, offset cwork
				test	byte ptr TXT_RAM[esi + TEXT_ATR], 20h
				jne		text0pcg
				test	cx, 80dfh
				je		textnone
				js		kanjiputs

				mov		ch, 0
				mov		esi, ecx
				shl		si, 4
				add		esi, offset KNJ_FNT
				mov		cl, fontlpcnt
				push	edx
				and		dx, 15
				call	txtbeffects16[edx*4]
attreffects:	pop		edx
				mov		dl, dh
				and		dx, 15
				mov		esi, offset cwork
				mov		edi, offset cwork+8
				call	planeeffects16[edx*4]
				inc		eax							; edi = (cwork+96)
				jne		txtandgrph
				test	crtc.ZPRY, 3
				jne		txtandgrph1

				mov		cl, 8
				rep stosd
				sub		edi, 64
				mov		cl, 8
				rep stosd
				jmp		grphtxtout

kanjiputs:		bt		cx, 14
				pushf
				push	edx
				call	adr2jis_x1t
				mov		cx, ax
				call	getfontjis
				mov		esi, eax
				pop		edx
				popf
				adc		esi, 0
				push	edx
				and		edx, 15
				movzx	ecx, fontlpcnt
				call	knjbeffects16[edx*4]
				jmp		attreffects

text0pcg:		mov		al, dl
				and		eax, 15
				mov		esi, offset pcgbeffectsx2
				test	ch, 90h
				mov		ch, 0
				je		textpcgext
				and		cl, 0feh
				mov		esi, offset txtbeffects16
textpcgext:		mov		eax, [esi+eax*4]
				mov		edi, offset cwork+8
				lea		esi, pcg.B[ecx*8]
				mov		ecx, 8
				push	eax
				test	dh, 1
				je		plane1_off
				call	eax
				mov		cl, 8
				jmp		plane1_end
plane1_off:		xor		eax, eax
				mov		[edi+64], eax
				mov		[edi+68], eax
				stosd
				stosd
plane1_end:		pop		eax
				add		esi, 256*8
				push	eax
				test	dh, 2
				je		plane2_off
				call	eax
				mov		cl, 8
				jmp		plane2_end
plane2_off:		xor		eax, eax
				mov		[edi+64], eax
				mov		[edi+68], eax
				stosd
				stosd
plane2_end:		pop		eax
				add		esi, 256*8
				test	dh, 4
				je		plane4_off
				call	eax
				jmp		plane4_end
plane4_off:		xor		eax, eax
				mov		[edi+64], eax
				mov		[edi+68], eax
				stosw
				stosw
plane4_end:		mov		edi, offset cwork
				mov		cl, 4
				test	dh, 8
				jne		pcgmask2
				PCG16MASK_NOR
				PCG16MASK_NOR
				add		edi, 64 - 8
				PCG16MASK_NOR
				PCG16MASK_NOR
				jmp		txtpcgmasksto
pcgmask2:		PCG16MASK_REV
				PCG16MASK_REV
				add		edi, 64 - 8
				PCG16MASK_REV
				PCG16MASK_REV
txtpcgmasksto:	mov		dword ptr (cwork), ebx
				mov		dword ptr (cwork+4), edx
				mov		dword ptr (cwork+64), ebx
				mov		dword ptr (cwork+68), edx

txtandgrph:		test	crtc.ZPRY, 3
				je		txtomoura
txtandgrph1:	test	crtc.ZPRY, 2
				je		omouratxt

				// \eLXg
				movzx	esi, p
				rol		si, 5
				add		esi, PLANE_B
				push	esi

				add		esi, dispp
				call	getgrphmaskpat2
				mov		edi, offset cwork+8
				mov		mask1, ebx
				mov		mask2, edx
				not		ebx
				not		edx
				mov		ecx, 3
txtmid2puts1:	lodsd
				and		[edi], ebx
				or		[edi], eax
				and		[edi+64], ebx
				or		[edi+64], eax
				lodsd
				and		[edi+4], edx
				or		[edi+4], eax
				and		[edi+68], edx
				or		[edi+68], eax
				add		edi, 8
				loop	txtmid2puts1
				add		esi, GRAM_HALFSTEP-24
				mov		cl, 6
txtmid2cpy1:	lodsd
				mov		[edi+64], eax
				stosd
				loop	txtmid2cpy1

				and		dword ptr (cwork), ebx
				and		dword ptr (cwork+4), edx
				and		dword ptr (cwork+64), ebx
				and		dword ptr (cwork+68), edx

				pop		esi
				jmp		downuragrph


				// eLXg\
txtomoura:		movzx	esi, p
				rol		si, 5
				add		esi, PLANE_B

				push	esi
				add		esi, dispp
				xor		eax, eax
				mov		mask1, eax
				mov		mask2, eax

				mov		ebx, dword ptr (cwork+0)
				mov		edx, dword ptr (cwork+4)
				not		ebx
				not		edx
				mov		edi, offset cwork + 8
				mov		ecx, 3
txtup2puts1:	lodsd
				or		mask1, eax
				and		eax, ebx
				or		[edi], eax
				lodsd
				or		mask2, eax
				and		eax, edx
				or		[edi+4], eax
				add		edi, 8
				loop	txtup2puts1
				add		esi, GRAM_HALFSTEP - 24
				mov		cl, 3
txtup2puts2:	lodsd
				or		mask1, eax
				and		eax, ebx
				stosd
				lodsd
				or		mask2, eax
				and		eax, edx
				stosd
				loop	txtup2puts2
				sub		esi, GRAM_HALFSTEP + 24

				mov		edi, offset cwork + 64 + 8
				mov		ebx, dword ptr (cwork+64)
				mov		edx, dword ptr (cwork+68)
				not		ebx
				not		edx
				mov		cl, 3
txtup2puts3:	lodsd
				and		eax, ebx
				or		[edi], eax
				lodsd
				and		eax, edx
				or		[edi+4], eax
				add		edi, 8
				loop	txtup2puts3
				add		esi, GRAM_HALFSTEP - 24
				mov		cl, 3
txtup2puts4:	lodsd
				and		eax, ebx
				stosd
				lodsd
				and		eax, edx
				stosd
				loop	txtup2puts4
				pop		esi

downuragrph:	add		esi, dispp2

				mov		ebx, dword ptr (cwork+0)
				or		ebx, mask1
				not		ebx
				mov		edx, dword ptr (cwork+4)
				or		edx, mask2
				not		edx
				mov		edi, offset cwork + 8
				MASK_LOWER_GRAPH(1)
				mov		[edi], ebx
				mov		[edi+4], edx
				sub		esi, GRAM_HALFSTEP + 24

				mov		ebx, dword ptr (cwork+64)
				or		ebx, mask1
				not		ebx
				mov		edx, dword ptr (cwork+68)
				or		edx, mask2
				not		edx
				mov		edi, offset cwork + 64 + 8
				MASK_LOWER_GRAPH(3)
				mov		[edi], ebx
				mov		[edi+4], edx

				jmp		grphtxtout


				// \eLXg
omouratxt:		movzx	esi, p
				rol		si, 5
				add		esi, PLANE_B
				push	esi

				add		esi, dispp2
				call	getgrphmaskpat2
				mov		dword ptr (cwork + 56), ebx
				mov		dword ptr (cwork + 60), edx
				mov		dword ptr (cwork + 64 + 56), ebx
				mov		dword ptr (cwork + 64 + 60), edx
				not		ebx
				not		edx
				mov		edi, offset (cwork + 8)
				mov		ecx, 3
txtdwn2puts1:	lodsd
				and		[edi], ebx
				or		[edi], eax
				and		[edi+64], ebx
				or		[edi+64], eax
				lodsd
				and		[edi+4], edx
				or		[edi+4], eax
				and		[edi+68], edx
				or		[edi+68], eax
				add		edi, 8
				loop	txtdwn2puts1
				add		esi, GRAM_HALFSTEP - 24
				mov		cl, 6
txtdwn2cpy1:	lodsd
				mov		[edi+64], eax
				stosd
				loop	txtdwn2cpy1
				and		dword ptr (cwork), ebx
				and		dword ptr (cwork+4), edx
				and		dword ptr (cwork+64), ebx
				and		dword ptr (cwork+68), edx

				pop		esi
				add		esi, dispp
				call	getgrphmaskpat2
				not		ebx
				not		edx
				and		dword ptr (cwork + 56), ebx
				and		dword ptr (cwork + 60), edx
				and		dword ptr (cwork + 64 + 56), ebx
				and		dword ptr (cwork + 64 + 60), edx

				mov		edi, offset (cwork + 8)
				mov		ecx, 3
txtdwn2puts2:	lodsd
				and		[edi], ebx
				or		[edi], eax
				and		[edi+64], ebx
				or		[edi+64], eax
				lodsd
				and		[edi+4], edx
				or		[edi+4], eax
				and		[edi+68], edx
				or		[edi+68], eax
				add		edi, 8
				loop	txtdwn2puts2
				add		esi, GRAM_HALFSTEP - 24
				mov		cl, 3
txtdwn2cpy2:	lodsd
				and		[edi], ebx
				or		[edi], eax
				and		[edi+64], ebx
				or		[edi+64], eax
				lodsd
				and		[edi+4], edx
				or		[edi+4], eax
				and		[edi+68], edx
				or		[edi+68], eax
				add		edi, 8
				loop	txtdwn2cpy2
				and		dword ptr (cwork), ebx
				and		dword ptr (cwork+4), edx
				and		dword ptr (cwork+64), ebx
				and		dword ptr (cwork+68), edx
				jmp		grphtxtout


textnone:		test	dh, 8
				je		grphonly
				mov		eax, -1
				mov		ecx, 8
				rep stosd
				add		edi, 64-32
				mov		cl, 8
				rep stosd
				test	crtc.ZPRY, 3
				jne		txtandgrph1
				inc		eax
				mov		cl, 8
				rep stosd
				mov		edi, offset (cwork+32)
				mov		cl, 8
				rep stosd
				jmp		grphtxtout

				// \
grphonly:		movzx	esi, p
				rol		si, 5
				add		esi, PLANE_B
				push	esi
				add		esi, dispp
				mov		edi, offset cwork
				xor		eax, eax
				mov		[edi+64], eax
				mov		[edi+68], eax
				stosd
				stosd
				mov		ebx, eax
				mov		edx, eax
				mov		ecx, 3
scrn2up1lp:		lodsd
				or		ebx, eax
				mov		[edi+64], eax
				stosd
				lodsd
				or		edx, eax
				mov		[edi+64], eax
				stosd
				loop	scrn2up1lp
				add		esi, GRAM_HALFSTEP - 24
				mov		cl, 3
scrn2up2lp:		lodsd
				or		ebx, eax
				mov		[edi+64], eax
				stosd
				lodsd
				or		edx, eax
				mov		[edi+64], eax
				stosd
				loop	scrn2up2lp
				pop		esi

				not		ebx
				not		edx

				add		esi, dispp2
				mov		edi, offset cwork+8
				mov		cl, 3
scrn2up3lp:		lodsd
				and		eax, ebx
				or		[edi], eax
				or		[edi+64], eax
				lodsd
				and		eax, edx
				or		[edi+4], eax
				or		[edi+68], eax
				add		edi, 8
				loop	scrn2up3lp
				add		esi, GRAM_HALFSTEP - 24
				mov		cl, 3
scrn2up4lp:		lodsd
				and		eax, ebx
				or		[edi], eax
				or		[edi+64], eax
				lodsd
				and		eax, edx
				or		[edi+4], eax
				or		[edi+68], eax
				add		edi, 8
				loop	scrn2up4lp
				mov		[edi], ebx
				mov		[edi+4], edx
				mov		[edi+64], ebx
				mov		[edi+68], edx

grphtxtout:		mov		esi, offset cwork
				mov		edi, v
				mov		cl, vramylpcnt
grphcpy64_lp:	movzx	ebx, byte ptr [esi+0]
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BIT7]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BIT7 + 4]
				movzx	ebx, byte ptr [esi+8]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE + 4]
				movzx	ebx, byte ptr [esi+16]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED + 4]
				movzx	ebx, byte ptr [esi+24]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN + 4]
				movzx	ebx, byte ptr [esi+32]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE2 + 4]
				movzx	ebx, byte ptr [esi+40]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED2 + 4]
				movzx	ebx, byte ptr [esi+48]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN2 + 4]
				movzx	ebx, byte ptr [esi+56]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT6]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT6 + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*0+4], edx
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*1+4], edx

				movzx	ebx, byte ptr [esi+64+0]
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BIT7]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BIT7 + 4]
				movzx	ebx, byte ptr [esi+64+8]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE + 4]
				movzx	ebx, byte ptr [esi+64+16]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED + 4]
				movzx	ebx, byte ptr [esi+64+24]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN + 4]
				movzx	ebx, byte ptr [esi+64+32]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE2 + 4]
				movzx	ebx, byte ptr [esi+64+40]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED2 + 4]
				movzx	ebx, byte ptr [esi+64+48]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN2 + 4]
				movzx	ebx, byte ptr [esi+64+56]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BIT6]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BIT6 + 4]
				mov		[edi+SCREEN_WIDTH*2+0], eax
				mov		[edi+SCREEN_WIDTH*2+4], edx
				mov		[edi+SCREEN_WIDTH*3+0], eax
				mov		[edi+SCREEN_WIDTH*3+4], edx

				inc		esi
				add		edi, SCREEN_WIDTH*4
				dec		cl
				jne		grphcpy64_lp

				movzx	esi, p
				pop		cx
				pop		bx
updatechr_e:
				VRAMADRRESS_INC2
				dec		cx
				jne		dispchrlpst
dischr_end:
				pop		edi
				pop		esi
				pop		es
				popf
		}
}



void width80x12_64s(void) {			// 80x25 64colors low-reso

	WORD	p;
	DWORD	*v;
	WORD	newline = 0;
	WORD	yp = 0;

		__asm {
				pushf
				cld
				mov		ax, ds
				push	es
				mov		es, ax
				push	esi
				push	edi

				mov		eax, offset screenmap
				mov		v, eax
				xor		bx, bx
				mov		fontycnt, bl
				movzx	esi, crtc.TXT_TOP
				mov		cx, vramsize
				or		cx, cx
				je		dischr_end

dispchrlpst:	cmp		si, (TRAM_MAX/2)
				jnc		dischr_end

				movzx	edx, byte ptr updatetmp[esi]
				test	dl, UPDATE_VRAM
				je		updatechr_e
				and		updatetmp[esi], (~UPDATE_VRAM)
				mov		newline, 1

				push	bx
				push	cx

				mov		p, si

				mov		dh, TXT_RAM[esi + TEXT_ATR]
				test	dh, blinktest
				je		notblinks
				xor		dh, X1ATR_REVERSE
notblinks:		test	dh, 0fh
				je		grphonly
				bt		dx, 4
				sbb		si, 0
				movzx	ecx, byte ptr TXT_RAM[esi + TEXT_ANK]
				mov		ch, TXT_RAM[esi + TEXT_KNJ]
				mov		edi, offset cwork
				test	byte ptr TXT_RAM[esi + TEXT_ATR], 20h
				jne		text0pcg
				test	cx, 80dfh
				je		textnone
				js		kanjiputs

				mov		ch, 0
				mov		esi, ecx
				shl		si, 4
				add		esi, offset KNJ_FNT
				mov		cl, fontlpcnt
				push	edx
				and		dx, 15
				call	txtbeffects16[edx*4]
attreffects:	pop		edx
				mov		dl, dh
				and		dx, 15
				mov		esi, offset cwork
				mov		edi, offset cwork+8
				call	planeeffects16[edx*4]
				test	crtc.ZPRY, 1
				jne		screen1txtdwn
				inc		eax
				jne		screen1txtup
				jmp		textonly

kanjiputs:		bt		cx, 14
				pushf
				push	edx
				call	adr2jis_x1t
				mov		cx, ax
				call	getfontjis
				mov		esi, eax
				pop		edx
				popf
				adc		esi, 0
				push	edx
				and		edx, 15
				movzx	ecx, fontlpcnt
				call	knjbeffects16[edx*4]
				jmp		attreffects

text0pcg:		mov		al, dl
				and		eax, 15
				mov		esi, offset pcgbeffectsx2
				test	ch, 90h
				mov		ch, 0
				je		textpcgext
				and		cl, 0feh
				mov		esi, offset txtbeffects16
textpcgext:		mov		eax, [esi+eax*4]
				mov		edi, offset cwork+8
				lea		esi, pcg.B[ecx*8]
				mov		ecx, 8
				push	eax
				test	dh, 1
				je		plane1_off
				call	eax
				mov		cl, 8
				jmp		plane1_end
plane1_off:		xor		eax, eax
				mov		[edi+64], eax
				mov		[edi+68], eax
				stosd
				stosd
plane1_end:		pop		eax
				add		esi, 256*8
				push	eax
				test	dh, 2
				je		plane2_off
				call	eax
				mov		cl, 8
				jmp		plane2_end
plane2_off:		xor		eax, eax
				mov		[edi+64], eax
				mov		[edi+68], eax
				stosd
				stosd
plane2_end:		pop		eax
				add		esi, 256*8
				test	dh, 4
				je		plane4_off
				call	eax
				jmp		plane4_end
plane4_off:		xor		eax, eax
				mov		[edi+64], eax
				mov		[edi+68], eax
				stosw
				stosw
plane4_end:		mov		edi, offset cwork
				mov		cl, 4
				test	dh, 8
				jne		pcgmask2
				PCG16MASK_NOR
				PCG16MASK_NOR
				add		edi, 64 - 8
				PCG16MASK_NOR
				PCG16MASK_NOR
				jmp		txtpcgmasksto
pcgmask2:		PCG16MASK_REV
				PCG16MASK_REV
				add		edi, 64 - 8
				PCG16MASK_REV
				PCG16MASK_REV

txtpcgmasksto:	test	crtc.ZPRY, 1
				je		screen1txtup

				// OtBbNeLXg
screen1txtdwn:	movzx	esi, p
				rol		si, 5
				lea		esi, GRP_RAM[esi + PLANE_B + GRAM_BANK0L]
				mov		edi, offset (cwork + 8)
				MAKE_GRPHMASK2(GRAM_SIZE)
				mov		ecx, 3
downdest2lp1:	lodsd
				and		[edi], ebx
				or		[edi], eax
				lodsd
				and		[edi+4], edx
				or		[edi+4], eax
				add		edi, 8
				loop	downdest2lp1
				add		esi, GRAM_SIZE - 24
				mov		cl, 6
				rep movsd
				and		dword ptr (cwork), ebx
				and		dword ptr (cwork + 4), edx

				sub		esi, (GRAM_SIZE + 24) - GRAM_HALFSTEP
				mov		edi, offset (cwork + 64 + 8)
				MAKE_GRPHMASK2(GRAM_SIZE)
				mov		cl, 3
downdest2lp2:	lodsd
				and		[edi], ebx
				or		[edi], eax
				lodsd
				and		[edi+4], edx
				or		[edi+4], eax
				add		edi, 8
				loop	downdest2lp2
				add		esi, GRAM_SIZE - 24
				mov		cl, 6
				rep movsd
				and		dword ptr (cwork + 64), ebx
				and		dword ptr (cwork + 68), edx

				jmp		grphtxtout

				// eLXgOtBbN
screen1txtup:	movzx	esi, p
				rol		si, 5
				lea		esi, GRP_RAM[esi + PLANE_B + GRAM_BANK0L]
				mov		edi, offset (cwork + 8)
				mov		ebx, dword ptr (cwork + 0)
				mov		edx, dword ptr (cwork + 4)
				not		ebx
				not		edx
				mov		ecx, 3
dwnputs1:		lodsd
				and		eax, ebx
				or		[edi], eax
				lodsd
				and		eax, edx
				or		[edi+4], eax
				add		edi, 8
				loop	dwnputs1
				add		esi, GRAM_SIZE - 24
				mov		cl, 3
dwnputs2:		lodsd
				and		eax, ebx
				stosd
				lodsd
				and		eax, edx
				stosd
				loop	dwnputs2

				sub		esi, (GRAM_SIZE + 24) - GRAM_HALFSTEP
				mov		edi, offset (cwork + 64 + 8)
				mov		ebx, dword ptr (cwork + 64)
				mov		edx, dword ptr (cwork + 68)
				not		ebx
				not		edx
				mov		ecx, 3
dwnputs3:		lodsd
				and		eax, ebx
				or		[edi], eax
				lodsd
				and		eax, edx
				or		[edi+4], eax
				add		edi, 8
				loop	dwnputs3
				add		esi, GRAM_SIZE - 24
				mov		cl, 3
dwnputs4:		lodsd
				and		eax, ebx
				stosd
				lodsd
				and		eax, edx
				stosd
				loop	dwnputs4
				jmp		grphtxtout

textnone:		test	dh, 8
				je		grphonly
				mov		eax, -1
				mov		ecx, 8
				rep stosd
				add		edi, 64 - 32
				mov		cl, 8
				rep stosd
				test	crtc.ZPRY, 1
				jne		screen1txtdwn
				inc		eax

textonly:		mov		edi, offset (cwork+32)
				mov		cl, 6
				rep stosd
				mov		edi, offset (cwork+32+64)
				mov		cl, 6
				rep stosd
				dec		eax
				mov		dword ptr (cwork), eax
				mov		dword ptr (cwork+4), eax
				mov		dword ptr (cwork+64), eax
				mov		dword ptr (cwork+68), eax
				jmp		grphtxtout

				// \
grphonly:		movzx	esi, p
				rol		si, 5
				lea		esi, GRP_RAM[esi + PLANE_B + GRAM_BANK0L]
				mov		edi, offset cwork
				xor		eax, eax
				stosd
				stosd
				mov		ecx, 6
				rep movsd
				add		esi, GRAM_SIZE - 24
				mov		cl, 6
				rep movsd
				mov		edi, offset (cwork+64)
				stosd
				stosd
				sub		esi, (GRAM_SIZE + 24) - GRAM_HALFSTEP
				mov		cl, 6
				rep movsd
				add		esi, GRAM_SIZE - 24
				mov		cl, 6
				rep movsd

grphtxtout:		mov		esi, offset cwork
				mov		edi, v
				mov		cl, vramylpcnt

grphcpy64_lp:	movzx	ebx, byte ptr [esi+0]
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BIT6]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BIT6 + 4]
				movzx	ebx, byte ptr [esi+8]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE + 4]
				movzx	ebx, byte ptr [esi+16]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED + 4]
				movzx	ebx, byte ptr [esi+24]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN + 4]
				movzx	ebx, byte ptr [esi+32]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE2 + 4]
				movzx	ebx, byte ptr [esi+40]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED2 + 4]
				movzx	ebx, byte ptr [esi+48]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN2 + 4]
				mov		[edi+SCREEN_WIDTH*0+0], eax
				mov		[edi+SCREEN_WIDTH*0+4], edx
				mov		[edi+SCREEN_WIDTH*1+0], eax
				mov		[edi+SCREEN_WIDTH*1+4], edx

				movzx	ebx, byte ptr [esi+64+0]
				mov		eax, bmp2byte_table[ebx*8 + BMP2B_BIT6]
				mov		edx, bmp2byte_table[ebx*8 + BMP2B_BIT6 + 4]
				movzx	ebx, byte ptr [esi+64+8]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE + 4]
				movzx	ebx, byte ptr [esi+64+16]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED + 4]
				movzx	ebx, byte ptr [esi+64+24]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN + 4]
				movzx	ebx, byte ptr [esi+64+32]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_BLUE2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_BLUE2 + 4]
				movzx	ebx, byte ptr [esi+64+40]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_RED2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_RED2 + 4]
				movzx	ebx, byte ptr [esi+64+48]
				or		eax, bmp2byte_table[ebx*8 + BMP2B_GREEN2]
				or		edx, bmp2byte_table[ebx*8 + BMP2B_GREEN2 + 4]
				mov		[edi+SCREEN_WIDTH*2+0], eax
				mov		[edi+SCREEN_WIDTH*2+4], edx
				mov		[edi+SCREEN_WIDTH*3+0], eax
				mov		[edi+SCREEN_WIDTH*3+4], edx

				inc		esi
				add		edi, SCREEN_WIDTH*4
				dec		cl
				jne		grphcpy64_lp

				movzx	esi, p
				pop		cx
				pop		bx
updatechr_e:
				VRAMADRRESS_INC2
				dec		cx
				jne		dispchrlpst
dischr_end:
				pop		edi
				pop		esi
				pop		es
				popf
		}
}
