#include	<windows.h>
#include	<windowsx.h>
#include	<io.h>

#include	"xmil.h"
#include	"dialog.h"
#include	"dosio.h"

#define		CFGLEN		(MAX_PATH + 32)

		BYTE	init_flag = 0;

		char	ini_title[]		= "Xmillennium";

		char	cfgWINPOSX[]	= "WindposX";
		char	cfgWINPOSY[]	= "WindposY";
		char	cfgSTARTDIR[]	= "StartDir";
		char	cfgBMPDIR[]		= "bmap_Dir";

		char	cfgOPMSOUND[]	= "OPMsound";
		char	cfgSKIPLINE[]	= "SkipLine";
		char	cfgIPLROM[]		= "IPL_TYPE";
		char	cfgRESOLUTE[]	= "Resolute";
		char	cfgSAMPLINGRT[]	= "SampleHz";
		char	cfgDELAY[]		= "Latencys";
		char	cfgBTNRAPID[]	= "btnRAPID";
		char	cfgBTNMODE[]	= "btn_MODE";
		char	cfgCPU8MHz[]	= "cpu_8MHz";
		char	cfgNOWAIT[]		= "s_NOWAIT";
		char	cfgFRAMES[]		= "SkpFrame";
		char	cfgDEPTH[]		= "LinLIGHT";
		char	cfgLIGHT[]		= "BlkLIGHT";
		char	cfgLICENCE[]	= "Licenced";
		char	cfgSEEKSND[]	= "Seek_Snd";
		char	cfgSEEKVOL[]	= "Seek_Vol";
		char	cfgTXTLIGHT[]	= "TxtLIGHT";
		char	cfgTXTMODE[]	= "Text_Ext";
		char	cfgTXT400[]		= "Text_400";
		char	cfgSOUNDPRY[]	= "SoundPly";
		char	cfgDSOUND3[]	= "D_Sound3";
		char	cfgPUCHI[]		= "PUCHInos";
		char	cfgJOYSTICK[]	= "Joystick";
		char	cfgMOUSE[]		= "MouseInt";
		char	cfgWINSNAP[]	= "Win_Snap";

extern	int		winx;
extern	int		winy;
extern	char	fileselectfolder[MAX_PATH];
extern	char	bmpfilefolder[MAX_PATH];


static char *makeHEX(long para, BYTE length) {

static	char	hexstrtmp[9];
		char	*p;
		char	c;

	if (length >= 8) {
		length = 8;
	}
	p = hexstrtmp + length;
	*p = '\0';
	while(length--) {
		p--;
		c = (char)(para & 0x0f);
		if (c < 10) {
			*p = c + '0';
		}
		else {
			*p = c + '7';			//	'7' = 'A' - 10;
		}
		para >>= 4;
	}
	return(p);
}


static long solveHEX(char *str) {

	long	ret;
	int		i;
	char	c;

	ret = 0;
	for (i=0; i<8; i++) {
		c = *str++;
		if ((c >= '0') && (c <= '9')) {
			c -= '0';
		}
		else if ((c >= 'A') && (c <= 'F')) {
			c -= '7';
		}
		else if ((c >= 'a') && (c <= 'f')) {
			c -= 'W';
		}
		else {
			break;
		}
		ret <<= 4;
		ret += (long) c;
	}
	return(ret);
}


static char *makeBOOL(BYTE value) {

	if (value) {
		return("true");
	}
	return("false");
}


BYTE solveBOOL(LPSTR str) {

	if ((!Aacmp(str, "TRUE")) || (!Aacmp(str, "ON")) ||
		(!Aacmp(str, "+")) || (!Aacmp(str, "1")) ||
		(!Aacmp(str, "ENABLE"))) {
		return(1);
	}
	return(0);
}


void initload(void) {

	char	initfile[MAX_PATH + 5];
	char	cfgstr[CFGLEN];

	init_flag = 0;

	strcpy(initfile, __argv[0]);
	cutExtName(initfile);
	strcat(initfile, ".ini");

	winx = GetPrivateProfileInt(ini_title, cfgWINPOSX,
										CW_USEDEFAULT, initfile);
	winy = GetPrivateProfileInt(ini_title, cfgWINPOSY,
										CW_USEDEFAULT, initfile);

	GetPrivateProfileString(ini_title, cfgSTARTDIR, "",
							fileselectfolder, MAX_PATH, initfile);
	GetPrivateProfileString(ini_title, cfgBMPDIR, "",
							bmpfilefolder, MAX_PATH, initfile);

	GetPrivateProfileString(ini_title, cfgOPMSOUND, "0",
										cfgstr, CFGLEN, initfile);
	xmilcfg.SOUND_SW = solveBOOL(cfgstr);

	GetPrivateProfileString(ini_title, cfgSKIPLINE, "1",
										cfgstr, CFGLEN, initfile);
	xmilcfg.SKIP_LINE = solveBOOL(cfgstr);

	xmilcfg.ROM_TYPE = (BYTE)GetPrivateProfileInt(ini_title, cfgIPLROM,
														2, initfile);
	GetPrivateProfileString(ini_title, cfgRESOLUTE, "1",
										cfgstr, CFGLEN, initfile);
	xmilcfg.DIP_SW = (BYTE)solveHEX(cfgstr);

	xmilcfg.samplingrate = (WORD)GetPrivateProfileInt(
								ini_title, cfgSAMPLINGRT, 22050, initfile);
	xmilcfg.delayms = (WORD)GetPrivateProfileInt(
								ini_title, cfgDELAY, 1000, initfile);

	GetPrivateProfileString(ini_title, cfgBTNRAPID, "0",
										cfgstr, CFGLEN, initfile);
	xmilcfg.BTN_RAPID = solveBOOL(cfgstr);
	GetPrivateProfileString(ini_title, cfgBTNMODE, "0",
										cfgstr, CFGLEN, initfile);
	xmilcfg.BTN_MODE = solveBOOL(cfgstr);
	GetPrivateProfileString(ini_title, cfgCPU8MHz, "0",
										cfgstr, CFGLEN, initfile);
	xmilcfg.CPU8MHz = solveBOOL(cfgstr);

	GetPrivateProfileString(ini_title, cfgNOWAIT, "0",
										cfgstr, CFGLEN, initfile);
	xmilcfg.NOWAIT = solveBOOL(cfgstr);
	xmilcfg.DRAW_SKIP = (BYTE)GetPrivateProfileInt(ini_title, cfgFRAMES,
															1, initfile);

	if (GetPrivateProfileString(ini_title, cfgLICENCE, "",
				&licenced[LICENCED_POS], LICENCED_LENG, initfile)) {
		if (kanji1st(licenced, LICENCED_POS + LICENCED_LENG - 2)) {
			licenced[LICENCED_POS + LICENCED_LENG - 2] = '\0';
		}
	}

	GetPrivateProfileString(ini_title, cfgDEPTH, "60",
										cfgstr, CFGLEN, initfile);
	xmilcfg.LINEDEPTH = (BYTE)solveHEX(cfgstr);
	GetPrivateProfileString(ini_title, cfgLIGHT, "20",
										cfgstr, CFGLEN, initfile);
	xmilcfg.BLKLIGHT = (BYTE)solveHEX(cfgstr);
	GetPrivateProfileString(ini_title, cfgTXTLIGHT, "60",
										cfgstr, CFGLEN, initfile);
	xmilcfg.LINETEXT = (BYTE)solveHEX(cfgstr);

	GetPrivateProfileString(ini_title, cfgSEEKSND, "1",
										cfgstr, CFGLEN, initfile);
	xmilcfg.MOTOR = solveBOOL(cfgstr);
	if ((xmilcfg.MOTORVOL = (BYTE)GetPrivateProfileInt(ini_title, cfgSEEKVOL,
												80, initfile)) > 100) {
		xmilcfg.MOTORVOL = 100;
	}

	GetPrivateProfileString(ini_title, cfgTXTMODE, "0",
										cfgstr, CFGLEN, initfile);
	xmilcfg.TEXTMODE = (BYTE)solveBOOL(cfgstr);
	GetPrivateProfileString(ini_title, cfgTXT400, "0",
										cfgstr, CFGLEN, initfile);
	xmilcfg.TEXT400L = (BYTE)solveHEX(cfgstr);

	GetPrivateProfileString(ini_title, cfgSOUNDPRY, "1",
										cfgstr, CFGLEN, initfile);
	xmilcfg.SOUNDPLY = (BYTE)solveBOOL(cfgstr);
	GetPrivateProfileString(ini_title, cfgPUCHI, "1",
										cfgstr, CFGLEN, initfile);
	xmilcfg.PUCHI = (BYTE)solveBOOL(cfgstr);
	GetPrivateProfileString(ini_title, cfgDSOUND3, "0",
										cfgstr, CFGLEN, initfile);
	xmilcfg.DSOUND3 = (BYTE)solveBOOL(cfgstr);

	GetPrivateProfileString(ini_title, "Z80_SAVE", "0",
										cfgstr, CFGLEN, initfile);
	xmilcfg.Z80SAVE = (BYTE)solveBOOL(cfgstr);

	GetPrivateProfileString(ini_title, cfgJOYSTICK, "1",
										cfgstr, CFGLEN, initfile);
	xmilcfg.JOYSTICK = (BYTE)solveBOOL(cfgstr);

	GetPrivateProfileString(ini_title, cfgMOUSE, "0",
										cfgstr, CFGLEN, initfile);
	xmilcfg.MOUSE_SW = (BYTE)solveBOOL(cfgstr);

	GetPrivateProfileString(ini_title, cfgWINSNAP, "1",
										cfgstr, CFGLEN, initfile);
	xmilcfg.WINSNAP = (BYTE)solveBOOL(cfgstr);
}


void initsave(void) {

	char	initfile[MAX_PATH + 5];
	char	str[CFGLEN];

	if (!init_flag) {
		return;
	}

	strcpy(initfile, __argv[0]);
	cutExtName(initfile);
	strcat(initfile, ".ini");

	wsprintf(str, "%d", winx);
	WritePrivateProfileString(ini_title, cfgWINPOSX, str, initfile);
	wsprintf(str, "%d", winy);
	WritePrivateProfileString(ini_title, cfgWINPOSY, str, initfile);

	WritePrivateProfileString(ini_title, cfgSTARTDIR,
										fileselectfolder, initfile);
	WritePrivateProfileString(ini_title, cfgBMPDIR,
										bmpfilefolder, initfile);

	WritePrivateProfileString(ini_title, cfgOPMSOUND,
									makeBOOL(xmilcfg.SOUND_SW), initfile);

	WritePrivateProfileString(ini_title, cfgSKIPLINE,
									makeBOOL(xmilcfg.SKIP_LINE), initfile);

	wsprintf(str, "%u", xmilcfg.ROM_TYPE);
	WritePrivateProfileString(ini_title, cfgIPLROM, str, initfile);
	WritePrivateProfileString(ini_title, cfgRESOLUTE,
									makeHEX(xmilcfg.DIP_SW, 2), initfile);

	wsprintf(str, "%u", xmilcfg.samplingrate);
	WritePrivateProfileString(ini_title, cfgSAMPLINGRT, str, initfile);
	wsprintf(str, "%u", xmilcfg.delayms);
	WritePrivateProfileString(ini_title, cfgDELAY, str, initfile);

	WritePrivateProfileString(ini_title, cfgBTNRAPID,
									makeBOOL(xmilcfg.BTN_RAPID), initfile);
	WritePrivateProfileString(ini_title, cfgBTNMODE,
									makeBOOL(xmilcfg.BTN_MODE), initfile);
	WritePrivateProfileString(ini_title, cfgCPU8MHz,
									makeBOOL(xmilcfg.CPU8MHz), initfile);

	WritePrivateProfileString(ini_title, cfgNOWAIT,
									makeBOOL(xmilcfg.NOWAIT), initfile);
	wsprintf(str, "%u", xmilcfg.DRAW_SKIP);
	WritePrivateProfileString(ini_title, cfgFRAMES, str, initfile);

	WritePrivateProfileString(ini_title, cfgDEPTH,
									makeHEX(xmilcfg.LINEDEPTH, 2), initfile);
	WritePrivateProfileString(ini_title, cfgLIGHT,
									makeHEX(xmilcfg.BLKLIGHT, 2), initfile);
	WritePrivateProfileString(ini_title, cfgTXTLIGHT,
									makeHEX(xmilcfg.LINETEXT, 2), initfile);

	WritePrivateProfileString(ini_title, cfgSEEKSND,
									makeBOOL(xmilcfg.MOTOR), initfile);
	wsprintf(str, "%u", xmilcfg.MOTORVOL);
	WritePrivateProfileString(ini_title, cfgSEEKVOL, str, initfile);

	WritePrivateProfileString(ini_title, cfgTXTMODE,
									makeBOOL(xmilcfg.TEXTMODE), initfile);
	WritePrivateProfileString(ini_title, cfgTXT400,
									makeHEX(xmilcfg.TEXT400L, 1), initfile);

	WritePrivateProfileString(ini_title, cfgSOUNDPRY,
									makeBOOL(xmilcfg.SOUNDPLY), initfile);
	WritePrivateProfileString(ini_title, cfgPUCHI,
									makeBOOL(xmilcfg.PUCHI), initfile);
	WritePrivateProfileString(ini_title, cfgDSOUND3,
									makeBOOL(xmilcfg.DSOUND3), initfile);

	WritePrivateProfileString(ini_title, cfgJOYSTICK,
									makeBOOL(xmilcfg.JOYSTICK & 1), initfile);

	WritePrivateProfileString(ini_title, cfgMOUSE,
									makeBOOL(xmilcfg.MOUSE_SW & 1), initfile);

	WritePrivateProfileString(ini_title, cfgWINSNAP,
									makeBOOL(xmilcfg.WINSNAP & 1), initfile);
}

