#include	<windows.h>
#include	<windowsx.h>
#include	<stdio.h>

#include	"resource.h"
#include	"xmil.h"
#include	"x1.h"
#include	"x1_fdc.h"
#include	"dosio.h"
#include	"ini.h"
#include	"menu.h"
#include	"draw.h"
#include	"ddraws.h"
#include	"palettes.h"
#include	"dsounds.h"
#include	"fdd_mtr.h"
#include	"fdd_ini.h"

#define	MFCHECK(a) ((a)?MF_CHECKED:MF_UNCHECKED)

		char	fileselectfolder[MAX_PATH] = "";
		char	bmpfilefolder[MAX_PATH] = "";
extern	HWND	hWndMain;

LPSTR savefileselect(LPSTR filter, LPSTR defname, LPSTR ext, LPSTR title) {

		OPENFILENAME	ofn;
		BOOL			r;
static	char			pathname[MAX_PATH+16];
static	char			filename[MAX_PATH];
		int				i;
		char			*p;

	ZeroMemory(&ofn, sizeof(OPENFILENAME));

	strcpy(pathname, bmpfilefolder);
	cutFileName(pathname);
	p = pathname + strlen(pathname);
	for (i=0; i<10000; i++) {
		wsprintf(filename, defname, i);
		strcpy(p, filename);
		if (file_attr(pathname) == -1) {
			break;
		}
	}
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hWndMain;
	ofn.lpstrFilter = filter;
	ofn.lpstrFile = pathname;
	ofn.lpstrFileTitle = filename;
	ofn.nFilterIndex = 1;
	ofn.nMaxFile = MAX_PATH;
	ofn.nMaxFileTitle = sizeof(filename);
	ofn.Flags = OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY;
	ofn.lpstrDefExt = ext;
	ofn.lpstrTitle = title;

	STOP_DIRECTSOUND();
	mx_topwinui();
	r = GetSaveFileName(&ofn);
	mx_clearwinui();
	PLAY_DIRECTSOUND();
	if (!r) {
		return(NULL);
	}
	INIT_RENEWAL
		strcpy(bmpfilefolder, pathname);
	return(pathname);
}


static LPSTR fileselect(LPSTR defname) {

		OPENFILENAME	ofn;
		BOOL			r;
static	char			pathname[MAX_PATH];
static	char			filename[MAX_PATH] = "";

	if ((defname == NULL) || (defname[0] == '\0')) {
		defname = fileselectfolder;
	}
	strcpy(pathname, defname);
	ZeroMemory(&ofn, sizeof(OPENFILENAME));
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hWndMain;
	ofn.lpstrFilter =	"2D image files (*.2d)\0"						\
											"*.2d\0"					\
						"D88 image files (*.D88;*.88D)\0"				\
											"*.d88;*.88d\0"				\
						"X1 image files (*.2D;*.D88;*.88D)\0"			\
											"*.2d;*.d88;*.88d\0"		\
						"Disk macro (*.d8u)\0"							\
											"*.d8u\0"					\
						"All supported Files\0"							\
											"*.2d;*.d88;*.88d;*.d8u\0"	\
						"All files (*.*)\0*.*\0\0";
	ofn.nFilterIndex = 5;
	ofn.lpstrFile = pathname;
	ofn.lpstrFileTitle = filename;
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_FILEMUSTEXIST;
	ofn.lpstrDefExt = "d88";
	ofn.lpstrTitle = "ҰނJ";

	STOP_DIRECTSOUND();
	mx_topwinui();
	r = GetOpenFileName(&ofn);
	mx_clearwinui();
	PLAY_DIRECTSOUND();
	if (!r) {
		return(NULL);
	}

	INIT_RENEWAL
		strcpy(fileselectfolder, pathname);
//		cutFileName(fileselectfolder);
	return(pathname);
}


void changefdd(short drv) {

	LPSTR	p;

	p = fileselect(FDC_NAME[drv]);
	if (p) {
		if (is_d8ufile(p)) {
			fdd_ini(p);
		}
		else {
			x1_set_fd(drv, 0, p);
		}
	}
	makecaption(1);
}


void makecaption(BYTE flg) {

	char	work[1024];
	char	*p;

	strcpy(work, szProgName);
	if (flg) {
		p = (char *)x1_get_fname(0);
		if (*p) {
			strcat(work, "  FDD0:");
			strcat(work, getFileName(p));
		}
		p = (char *)x1_get_fname(1);
		if (*p) {
			strcat(work, "  FDD1:");
			strcat(work, getFileName(p));
		}
	}
	SetWindowText(hWndMain, work);
}


void disable_windowmenu(void) {

	HMENU	hmenu = GetMenu(hWndMain);

	EnableMenuItem(hmenu, IDM_WINDOW, MF_GRAYED);
	EnableMenuItem(hmenu, IDM_FULLSCREEN, MF_GRAYED);
}


void xmenu_setiplrom(BYTE num) {

	HMENU	hmenu = GetMenu(hWndMain);

	xmilcfg.ROM_TYPE = num;
	CheckMenuItem(hmenu, IDM_TURBOZ, MFCHECK(num == 3));
	CheckMenuItem(hmenu, IDM_TURBO, MFCHECK(num == 2));
	CheckMenuItem(hmenu, IDM_X1ROM, MFCHECK(num == 1));
}

void xmenu_setskipline(BYTE value) {

	xmilcfg.SKIP_LINE = value & 1;
	CheckMenuItem(GetMenu(hWndMain), IDM_SKIPLINE, MFCHECK(xmilcfg.SKIP_LINE));
	reflesh_palette();
	palandply = 1;
}

void xmenu_setsound(BYTE value) {

	xmilcfg.SOUND_SW = value;
	CheckMenuItem(GetMenu(hWndMain), IDM_FMBOARD, MFCHECK(value));
}

void xmenu_setresolute(BYTE value) {

	HMENU	hmenu = GetMenu(hWndMain);

	value &= DIP_RESOLUTE;
	xmilcfg.DIP_SW &= (~DIP_RESOLUTE);
	xmilcfg.DIP_SW |= value;
	CheckMenuItem(hmenu, IDM_HIGHRES, MFCHECK(!value));
	CheckMenuItem(hmenu, IDM_LOWRES, MFCHECK(value));
}

void xmenu_setbootmedia(BYTE value) {

	HMENU	hmenu = GetMenu(hWndMain);

	value &= DIP_BOOTMEDIA;
	xmilcfg.DIP_SW &= (~DIP_BOOTMEDIA);
	xmilcfg.DIP_SW |= value;
	CheckMenuItem(hmenu, IDM_BOOT2D, MFCHECK(!value));
	CheckMenuItem(hmenu, IDM_BOOT2HD, MFCHECK(value));
}

void xmenu_setkey(BYTE value) {

	HMENU	hmenu = GetMenu(hWndMain);

	if (value >= 3) {
		value = 0;
	}
	xmilcfg.KEY_MODE = value;
	CheckMenuItem(hmenu, IDM_KEY, MFCHECK(value == 0));
	CheckMenuItem(hmenu, IDM_JOY1, MFCHECK(value == 1));
	CheckMenuItem(hmenu, IDM_JOY2, MFCHECK(value == 2));
}

void xmenu_setbtnrapid(BYTE value) {

	xmilcfg.BTN_RAPID = value;
	CheckMenuItem(GetMenu(hWndMain), IDM_RAPID, MFCHECK(xmilcfg.BTN_RAPID));
}

void xmenu_setbtnmode(BYTE value) {

	xmilcfg.BTN_MODE = value & 1;
	CheckMenuItem(GetMenu(hWndMain), IDM_JOYX, MFCHECK(xmilcfg.BTN_MODE));
}


void xmenu_setcpuspeed(BYTE value) {

	xmilcfg.CPU8MHz = value & 1;
	CheckMenuItem(GetMenu(hWndMain), IDM_8MHZ, MFCHECK(xmilcfg.CPU8MHz));
}


void xmenu_setwidth(BYTE value) {

	HMENU	hmenu = GetMenu(hWndMain);

	CheckMenuItem(hmenu, IDM_WIDTH80, MFCHECK(!value));
	CheckMenuItem(hmenu, IDM_WIDTH40, MFCHECK(value));
}

void xmenu_setwaitflg(BYTE value) {

	xmilcfg.NOWAIT = value & 1;
	CheckMenuItem(GetMenu(hWndMain), IDM_NOWAIT, MFCHECK(xmilcfg.NOWAIT));
}

void xmenu_setflame(BYTE value) {

	HMENU	hmenu = GetMenu(hWndMain);

	xmilcfg.DRAW_SKIP = value;
	CheckMenuItem(hmenu, IDM_RASTER, MFCHECK(!value));
	CheckMenuItem(hmenu, IDM_60FPS, MFCHECK(value == 1));
	CheckMenuItem(hmenu, IDM_30FPS, MFCHECK(value == 2));
	CheckMenuItem(hmenu, IDM_20FPS, MFCHECK(value == 3));
	CheckMenuItem(hmenu, IDM_15FPS, MFCHECK(value == 4));
}

void xmenu_setmotorflg(BYTE value) {

	xmilcfg.MOTOR = value & 1;
	CheckMenuItem(GetMenu(hWndMain), IDM_SEEKSND, MFCHECK(xmilcfg.MOTOR));
}

void xmenu_setz80save(BYTE value) {

	if (!value) {
		EnableMenuItem(GetMenu(hWndMain), IDM_Z80SAVE, MF_GRAYED);
	}
}

void xmenu_setjoystick(BYTE value) {

	HMENU	hmenu = GetMenu(hWndMain);

	xmilcfg.JOYSTICK &= 0x80;
	xmilcfg.JOYSTICK |= (value & 0x7f);

	if (value & 2) {
		EnableMenuItem(hmenu, IDM_JOYSTICK, MF_GRAYED);
	}
	else {
		CheckMenuItem(hmenu, IDM_JOYSTICK, MFCHECK(value & 1));
	}
}

void xmenu_opmlog(BYTE value) {

	CheckMenuItem(GetMenu(hWndMain), IDM_OPMLOG, MFCHECK(value));
}

void xmenu_setdispmode(BYTE value) {

	value &= 1;
	xmilcfg.DISPSYNC = value;
	CheckMenuItem(GetMenu(hWndMain), IDM_DISPSYNC, MFCHECK(value));
}

void xmenu_setmouse(BYTE value) {

	value &= 1;
	xmilcfg.MOUSE_SW = value;
	CheckMenuItem(GetMenu(hWndMain), IDM_MOUSE, MFCHECK(value));
}

void xmenu_setwinsnap(BYTE value) {

	value &= 1;
	xmilcfg.WINSNAP = value;
	CheckMenuItem(GetSystemMenu(hWndMain, FALSE),
									IDM_SNAPENABLE, MFCHECK(value));
}
