#include	<windows.h>
#include	<dsound.h>
#include	"common.h"
#include	"xmil.h"
#include	"dsounds.h"
#include	"opm.h"
#include	"dosio.h"

extern	HWND	hWndMain;

	LPDIRECTSOUND		pDSound = NULL;

	BYTE	pcmbuffer[2*2*44100];
	BYTE	*curpcmbuf = pcmbuffer;

	WORD	pcmbufsize[300];
	WORD	ds_rate = 22050;
	DWORD	ds_halfbuffer = 22050 * PCMMUL / 2;

	DWORD	pcmfreemax = 22050;
	DWORD	eventbuffer = OPM_NOMAKE;
	DWORD	framesoundcnt = 0;

	BYTE	usedsound3 = 0;


#define	AVE(a, b)	((a+b)/2)

void dsounds_init(void) {

	ZeroMemory(pcmbufsize, sizeof(pcmbufsize));
}


void dsounds_makepara(void) {

	WORD	i, cnt, lastcnt;
	WORD	delay;

	ds_rate = xmilcfg.samplingrate;
	if (xmilcfg.samplingrate < 11025) {
		ds_rate = 11025;
	}
	else if (xmilcfg.samplingrate > 55500) {
		ds_rate = 55500;
	}
	INX1F_init();
	INX1F_PSGmode(xmilcfg.PUCHI);

	delay = xmilcfg.delayms;
	if (delay < 100) {
		delay = 100;
	}
	else if (delay > 1000) {
		delay = 1000;
	}

	framesoundcnt = ds_rate / 60;
	lastcnt = 0;
	for (i=0; i<266; i++) {
		cnt = (ds_rate * (i+1)) / (60 * 266);
		pcmbufsize[i] = cnt - lastcnt;
		lastcnt = cnt;
	}

	pcmfreemax = (DWORD)ds_rate * delay / 2000;
	ds_halfbuffer = (DWORD)pcmfreemax * PCMMUL;
}



// --------------------------------------------------------------- mix directx

int dx_InitDirectSound(void) {

	if (!xmilcfg.samplingrate) {
		return(FAILURE);
	}
	dsounds_init();
	if (FAILED(DirectSoundCreate(NULL, &pDSound, NULL))) {
		RELEASE(pDSound);
		return(FAILURE);
	}
	if (FAILED(pDSound->SetCooperativeLevel(hWndMain, DSSCL_PRIORITY))) {
		if (FAILED(pDSound->SetCooperativeLevel(hWndMain, DSSCL_NORMAL))) {
			RELEASE(pDSound);
			return(FAILURE);
		}
	}
	return(SUCCESS);
}


// ---------------------------------------------------------- mix directx3, 7

#ifndef USE_DSOUND7

int InitDirectSound(void) {

	usedsound3 = 1;
	if (dx_InitDirectSound()) {
		return(FAILURE);
	}
	return(dx3_InitSoundBuffer());
}

void TermDirectSound(void) {

	dx3_TermSoundBuffer();
	RELEASE(pDSound);
}

#else

		DSOUNDS	dsounds = {	dx7_PlayDirectSound,
							dx7_StopDirectSound,
							dx7_InitSoundBuffer,
							dx7_TermSoundBuffer,
							dx7_MakeSoundBuffer,
							dx7_ProcSoundBuffer,
							dx7_WaveInit,
							dx7_WaveAllTerm,
							dx7_WaveCreate,
							dx7_WavePlay,
							dx7_WaveStop,
							dx7_WaveVolume,
							dx7_WaveRelease};

static	DSOUNDS	dsounds3 = {dx3_PlayDirectSound,
							dx3_StopDirectSound,
							dx3_InitSoundBuffer,
							dx3_TermSoundBuffer,
							dx3_MakeSoundBuffer,
							dx3_ProcSoundBuffer,
							dx3_WaveInit,
							dx3_WaveAllTerm,
							dx3_WaveCreate,
							dx3_WavePlay,
							dx3_WaveStop,
							dx3_WaveVolume,
							dx3_WaveRelease};

static	DSOUNDS	dsounds7 = {dx7_PlayDirectSound,
							dx7_StopDirectSound,
							dx7_InitSoundBuffer,
							dx7_TermSoundBuffer,
							dx7_MakeSoundBuffer,
							dx7_ProcSoundBuffer,
							dx7_WaveInit,
							dx7_WaveAllTerm,
							dx7_WaveCreate,
							dx7_WavePlay,
							dx7_WaveStop,
							dx7_WaveVolume,
							dx7_WaveRelease};


int InitDirectSound(void) {

	usedsound3 = 0;
	dsounds = dsounds7;
	if (dx_InitDirectSound()) {
		return(FAILURE);
	}
	if (!dx7_InitSoundBuffer()) {
		if (!xmilcfg.DSOUND3) {
			return(SUCCESS);
		}
	}
	else {
		usedsound3 = 1;
	}
	dx7_TermSoundBuffer();
	dsounds = dsounds3;
	return(dx3_InitSoundBuffer());
}

void TermDirectSound(void) {

	STREAM_TERM();
	RELEASE(pDSound);
}

#endif	// USE_DSOUND7
