#include	<windows.h>
#include	"common.h"
#include	"x1.h"
#include	"dosio.h"

// Qm[`FbN

static	char	ankfontname[] = "PC88.FNT";
static	char	knj1fontname[] = "KANJI1.ROM";
static	char	knj2fontname[] = "KANJI2.ROM";

											// vg^Cv
void ank8cnv(BYTE *src, int datacount);		// PC-88 datacount = 21
void pc88sjiscpy1(BYTE *dst, BYTE *src, WORD from, WORD to);
void pc88sjiscpy2(BYTE *dst, BYTE *src, WORD from, WORD to);


// PC88̃tHg gp
BYTE pc88fontread(BYTE loaded) {

	FILEH	fh;
	BYTE	loaded88font = 0;
	HANDLE	hwork;
	BYTE	*work;

	// A[P[g
	if ((hwork = GlobalAlloc(GPTR, 0x20000)) == NULL) {
		return(0);							// A[P[gɎs
	}

	// bNyу|C^擾
	if ((work = (BYTE *)GlobalLock(hwork)) == NULL) {
		GlobalFree(hwork);					// A[P[gɎs
		return(0);
	}

	// QȊOǂޕKv͂H
	if ((~loaded) & (FONT_ALL ^ FONT_KNJ2)) {

		// ǂݍł݂
		if ((fh = file_open_c(knj1fontname)) != (FILEH)-1) {
			if (file_lread(fh, work, 0x20000) == 0x20000) {

				// 8dot ANKǂޕKv邩
				if (!(loaded & FONT_ANK8)) {
					ank8cnv(work + 0x1000, 21);
					loaded88font |= FONT_ANK8;
				}

				// 16dot ASCIIǂޕKv邩
				if (!(loaded & FONT_ANK16a)) {
					memcpy(&KNJ_FNT[0x0000], work + 0x0000, 0x800);
					loaded88font |= FONT_ANK16a;
				}

				// 16dot ANK(0x80`)ǂޕKv邩
				if (!(loaded & FONT_ANK16b)) {
					memcpy(&KNJ_FNT[0x0800], work + 0x0800, 0x800);
					loaded88font |= FONT_ANK16b;
				}

				// ꐅǂݍށH
				if (!(loaded & FONT_KNJ1)) {

					// SJISR[h 0x8140 ` 0x84bf ̃Rs[
					pc88sjiscpy1(&KNJ_FNT[0x01000], work, 0x8140, 0x84c0);

					// SJISR[h 0x8890 ` 0x989e ̃Rs[
					pc88sjiscpy1(&KNJ_FNT[0x08000], work, 0x8890, 0x989f);

					loaded88font |= FONT_KNJ1;
				}
			}

			// N[Y ZNVI
			file_close(fh);
		}
	}

	// QǂޕKv͂H
	if (!(loaded & FONT_KNJ2)) {

		// ǂݍł݂
		if ((fh = file_open_c(knj2fontname)) != (FILEH)-1) {
			if (file_lread(fh, work, 0x20000) == 0x20000) {

				// SJISR[h 0x989f ` 0x9fff ̃Rs[
				pc88sjiscpy2(&KNJ_FNT[0x281e0], work, 0x989f, 0xa000);

				// SJISR[h 0xe040 ` 0xeaaf ̃Rs[
				pc88sjiscpy2(&KNJ_FNT[0x36e00], work, 0xe040, 0xeab0);

				loaded88font |= FONT_KNJ2;
			}

			// N[Y ZNVI
			file_close(fh);
		}
	}

	loaded |= loaded88font;

	// ANKǂݍޕKv͂H
	if ((~loaded) & (FONT_ANK8 | FONT_ANK16)) {

		// ǂݍł݂
		if ((fh = file_open_c(ankfontname)) != (FILEH)-1) {

			// ǂݍł݂
			if (file_read(fh, work, 0x1800) != 0x1800) {

				// 8dot ANKǂޕKv邩
				if (!(loaded & FONT_ANK8)) {
					ank8cnv(work, 21);
					loaded88font |= FONT_ANK8;
				}

				// 16dot ASCIIǂޕKv邩
				if (!(loaded & FONT_ANK16a)) {
					memcpy(&KNJ_FNT[0x0000], work + 0x0800, 0x800);
					loaded88font |= FONT_ANK16a;
				}

				// 16dot ANK(0x80`)ǂޕKv邩
				if (!(loaded & FONT_ANK16b)) {
					memcpy(&KNJ_FNT[0x0800], work + 0x1000, 0x800);
					loaded88font |= FONT_ANK16b;
				}
			}

			// N[Y ANK͏I
			file_close(fh);
		}
	}

	// 
	GlobalUnlock(hwork);
	GlobalFree(hwork);

	return(loaded88font);
}


// ̎w͈͂̃R[h Rs[
static void pc88sjiscpy1(BYTE *dst, BYTE *src, WORD from, WORD to) {

	int		y;
	BYTE	*p;
	WORD	sjis;
	WORD	jis;

	for (sjis=from; sjis<to; sjis++) {

		// R[hSJISJISɕϊ
		jis = sjis2jis(sjis);

		p = NULL;
		// ʂJISR[h͈͓H
		if (((jis & 0x0ff) >= 0x21) && ((jis & 0x0ff) <= 0x7e)) {
			// BITMAP̊̃|C^߂

								// 2121`277e
			if (((jis / 0x100) >= 0x21) && ((jis / 0x100) <= 0x27)) {
				p = src + ((jis & 0x1f) * 0x20)
							+ ((DWORD)((jis - 0x2000) / 0x100) * 0x400)
							+ ((DWORD)(jis & 0x60) * 0x100);
			}
								// 3021`4f7e
			else if (((jis / 0x100) >= 0x30) && ((jis / 0x100) <= 0x4f)) {
				p = src + ((jis & 0x1f) * 0x20)
					+ ((DWORD)(jis & 0x700) * 4)
					+ ((DWORD)(((jis - 0x3000) / 0x800) ^ 2) * 0x2000)
					+ ((DWORD)((jis & 0x60) / 0x20) * 0x8000);
			}
		}

		if (p != NULL) {					// KiR[hȂ
			// Rs[
			for (y=0; y<16; y++) {
				*dst++ = *p++;
				*dst++ = *p++;
			}
		}
		else {								// KiOR[h
			// 0 fill
			ZeroMemory(dst, 32);
			dst += 32;
		}
	}
}


static void pc88sjiscpy2(BYTE *dst, BYTE *src, WORD from, WORD to) {

	int		y;
	BYTE	*p;
	WORD	sjis;
	WORD	jis;

	for (sjis=from; sjis<to; sjis++) {

		// R[hSJISJISɕϊ
		jis = sjis2jis(sjis);

		p = NULL;
		// ʂJISR[h͈͓H
		if (((jis & 0x0ff) >= 0x21) && ((jis & 0x0ff) <= 0x7e)) {
			// BITMAP̊̃|C^߂

								// 7021`737e
			if (((jis / 0x100) >= 0x71) && ((jis / 0x100) <= 0x73)) {
				p = src + ((jis & 0x1f) * 0x20)
							+ ((DWORD)((jis - 0x7000) / 0x100) * 0x400)
							+ ((DWORD)(jis & 0x60) * 0x100);
			}
								// 5021`6f7e
			else if (((jis / 0x100) >= 0x50) && ((jis / 0x100) <= 0x6f)) {
				p = src + ((jis & 0x1f) * 0x20)
					+ ((DWORD)(jis & 0x700) * 4)
					+ ((DWORD)((jis - 0x5000) / 0x800) * 0x2000)
					+ ((DWORD)((jis & 0x60) / 0x20) * 0x8000);
			}
		}

		if (p != NULL) {					// KiR[hȂ
			// Rs[
			for (y=0; y<16; y++) {
				*dst++ = *p++;
				*dst++ = *p++;
			}
		}
		else {								// KiOR[h
			// 0 fill
			ZeroMemory(dst, 32);
			dst += 32;
		}
	}
}

