#include	<windows.h>
#include	"xmil.h"
#include	"x1.h"
#include	"x1_crtc.h"
#include	"ddraws.h"
#include	"draw.h"

static	BYTE	blankcol = 0;
static	WORD	halfgrp = 0;
static	WORD	halftxt = 0;

		PALETTE_TABLE	TEXTPALS[24];
		PALETTE_TABLE	GRPHPALS[2][16];
		PALETTE_TABLE	GRPHPALS64[2][64];
		PALETTE_TABLE	GRPHPAL4096[4096+8];
		WORD			GRPHPAL16bit[4096+8];

void textpalette1(BYTE num) {

	PALETTE_TABLE	c;
	BYTE			f = 0;

	c.b.flag = 0;
	c.b.blue = (crtc_TEXTPAL[num] & 0x3) * 0x55;
	if (c.b.blue < blankcol) {
		f |= 1;
	}
	c.b.green = ((crtc_TEXTPAL[num] & 0x30) >> 4) * 0x55;
	if (c.b.green < blankcol) {
		f |= 2;
	}
	c.b.red = ((crtc_TEXTPAL[num] & 0x0c) >> 2) * 0x55;
	if (c.b.red < blankcol) {
		f |= 4;
	}
	if (f == 7) {
		c.d = 0x010101 * blankcol;
	}
	GRPHPAL4096[4096+num].d = c.d;
	if ((SCREENMODE & SCMD_COLORMASK) == SCMD_COLOR16) {
		GRPHPAL16bit[4096+num] = ddraw16bitpal(c);
	}

	TEXTPALS[num].d = c.d;
	TEXTPALS[num].b.flag = num + START_EXT;

	TEXTPALS[num+8].b.blue = (halftxt * c.b.blue) / 0x00ff;
	TEXTPALS[num+8].b.green = (halftxt * c.b.green) / 0x00ff;
	TEXTPALS[num+8].b.red = (halftxt * c.b.red) / 0x00ff;
	TEXTPALS[num+8].b.flag = num + START_EXT + 0x08;

	TEXTPALS[num+16].b.blue = (halfgrp * c.b.blue) / 0x00ff;
	TEXTPALS[num+16].b.green = (halfgrp * c.b.green) / 0x00ff;
	TEXTPALS[num+16].b.red = (halfgrp * c.b.red) / 0x00ff;
	TEXTPALS[num+16].b.flag = num + START_EXT + 0x10;

	palandply = 1;
}


void grphpalette1(BYTE bank, BYTE num) {

	PALETTE_TABLE	c;
	BYTE			f = 0;

	c.b.blue = (crtc_GRPHPAL[bank][num] & 0xf) * 0x11;
	if (c.b.blue < blankcol) {
		f |= 1;
	}
	c.b.green = (crtc_GRPHPAL[bank][num] >> 8) * 0x11;
	if (c.b.green < blankcol) {
		f |= 2;
	}
	c.b.red = ((crtc_GRPHPAL[bank][num] & 0xf0) >> 4) * 0x11;
	if (c.b.red < blankcol) {
		f |= 4;
	}
	if (f == 7) {
		c.d = 0x010101 * blankcol;
	}

	GRPHPALS64[bank][num].d = c.d;
	GRPHPALS64[bank][num].b.flag = num + START_PAL;
	if (!(((num >> 3) ^ num) & 7)) {
		num &= 7;
		GRPHPALS[bank][num+0].d = c.d;
		GRPHPALS[bank][num+0].b.flag = num + START_EXT + 0x18;
		GRPHPALS[bank][num+8].b.blue = (halfgrp * c.b.blue) / 0xff;
		GRPHPALS[bank][num+8].b.green = (halfgrp * c.b.green) / 0xff;
		GRPHPALS[bank][num+8].b.red = (halfgrp * c.b.red) / 0xff;
		GRPHPALS[bank][num+8].b.flag = num + START_EXT + 0x20;
	}
	palandply = 1;
}


void grphpal4096(WORD num) {

	PALETTE_TABLE	c;
	BYTE			f = 0;

	c.b.flag = 0;
	c.b.blue = (crtc_PAL4096[num] & 0xf) * 0x11;
	if (c.b.blue < blankcol) {
		f |= 1;
	}
	c.b.green = (crtc_PAL4096[num] >> 8) * 0x11;
	if (c.b.green < blankcol) {
		f |= 2;
	}
	c.b.red = ((crtc_PAL4096[num] & 0xf0) >> 4) * 0x11;
	if (c.b.red < blankcol) {
		f |= 4;
	}
	if (f == 7) {
		c.d = 0x010101 * blankcol;
	}
	GRPHPAL4096[num].d = c.d;
	if ((SCREENMODE & SCMD_COLORMASK) == SCMD_COLOR16) {
		GRPHPAL16bit[num] = ddraw16bitpal(c);
	}
	palandply = 1;
}



void reflesh_palette(void) {

	BYTE	i, j;
	WORD	k;

	blankcol = xmilcfg.BLKLIGHT;
	if ((!xmilcfg.SKIP_LINE) || (crtc.SCRN_BITS & SCRN_24KHZ)) {
		blankcol >>= 1;
	}
	halfgrp = xmilcfg.LINEDEPTH;
	switch(xmilcfg.TEXT400L) {
		case 0:
			halftxt = xmilcfg.LINEDEPTH;
			break;
		case 1:
			halftxt = 0xff;
			break;
		default:
			halftxt = xmilcfg.LINETEXT;
			break;
	}

	for (i=0; i<8; i++) {
		textpalette1(i);
	}
	for (j=0; j<2; j++) {
		for (i=0; i<64; i++) {
			grphpalette1(j, i);
		}
	}
	for (k=0; k<4096; k++) {
		grphpal4096(k);
	}
}

