#include	<windows.h>
#include	<stdio.h>
#include	<string.h>

#include	"common.h"
#include	"xmil.h"
#include	"x1.h"
#include	"x1_scpu.h"
#include	"x1_8255.h"
#include	"x1_pcg.h"
#include	"x1_crtc.h"
#include	"x1_vram.h"
#include	"x1_fdc.h"
#include	"x1_dma.h"
#include	"x1_dmam.h"
#include	"x1_ctc.h"
#include	"x1_clndr.h"
#include	"x1_sio.h"
#include	"x1_sound.h"
#include	"x1_cmt.h"
#include	"input.h"
#include	"draw.h"
#include	"ddraws.h"
#include	"timer.h"
#include	"dosio.h"
#include	"trace.h"
#include	"dsounds.h"
#include	"menu.h"
#include	"deffnt.h"
#include	"otherfnt.h"

	X1_FLAG		x1flg = {250, 0, 1, 1, 0};
	BYTE		mMAIN[0x10000];
	BYTE		mBIOS[0x8000];
	BYTE		mBANK[16][0x8000];
	BYTE		KNJ_FNT[0x4bc00];
	BYTE		GRP_RAM[0x20000];
	BYTE		TXT_RAM[0x01800];
	WORD		v_cnt;
	int			s_cnt;

	BYTE		*RAM0r;
	BYTE		*RAM0w;
	BYTE		lastmem;
	WORD		h_cntbase;

/***********************************************************************
	IPL-ROM LOAD
***********************************************************************/

void ipl_load(void) {

	FILEH	hdl;

	ZeroMemory(mBIOS, sizeof(mBIOS));
	memcpy(mBIOS, DEFROM, sizeof(DEFROM));

	if (x1flg.ROM_TYPE >= 2) {
		if ((hdl = file_open_c("IPLROM.X1T")) != (FILEH)-1) {
			file_read(hdl, mBIOS, 0x8000);
			file_close(hdl);
		}
	}
	else if (x1flg.ROM_TYPE == 1) {
		if ((hdl = file_open_c("IPLROM.X1")) != (FILEH)-1) {
			file_read(hdl, mBIOS, 0x8000);
			file_close(hdl);
		}
	}
}


/***********************************************************************
	FONT-ROM LOAD
***********************************************************************/

void fnt_load(void) {

	FILEH	fh;
	BYTE	loaded = 0;
	BYTE	x1loaded;

	if ((fh = file_open_c("FNT0808.X1")) != (FILEH)-1) {
		file_read(fh, ANK_FNT[0], 8*256);
		file_close(fh);
		loaded |= FONT_ANK8;
	}

	if ((fh = file_open_c("FNT0816.X1")) != (FILEH)-1) {
		file_read(fh, KNJ_FNT, 0x1000);
		file_close(fh);
		loaded |= FONT_ANK16a | FONT_ANK16b;
	}
	if ((fh = file_open_c("FNT1616.X1")) != (FILEH)-1) {
		file_lread(fh, &KNJ_FNT[0x1000], 0x4ac00);
		file_close(fh);
		loaded |= FONT_KNJ1 | FONT_KNJ2;
	}

	x1loaded = loaded;

	if ((~loaded) & (FONT_ANK16a | FONT_KNJ1)) {
		loaded |= fm7fontread(loaded);
	}

	if (loaded != FONT_ALL) {
		loaded |= pc88fontread(loaded);
	}

	if (loaded != FONT_ALL) {
		loaded |= x68kfontread(loaded);
	}

	if ((~loaded) & (FONT_ALL ^ FONT_ANK8)) {
		loaded |= t98fontread(loaded);
	}

	// Ō ANK16̃pb`
	if (!(x1loaded & FONT_ANK16a)) {
		patch_ank16();
	}
}


/***********************************************************************
	
***********************************************************************/

BYTE reset_x1(BYTE ROM_TYPE, BYTE SOUND_SW, BYTE DIP_SW) {

	x1_psg_reset();
	x1_opm_reset();

	x1flg.HSYNC_CLK = 250;
	x1flg.ROM_SW = 1;
	x1flg.ROM_TYPE = ROM_TYPE;
	x1flg.SOUND_SW = SOUND_SW;
	x1flg.DIP_SW = DIP_SW;

	// XN[[h̕ύX...
	if (x1flg.ROM_TYPE >= 3) {
		if (changescreen(SCMD_SET65536)) {
			x1flg.ROM_TYPE = 2;
			changescreen(SCMD_SET256);
		}
	}

	textdrawproc_renewal();
	ipl_load();

	Z80_Reset();

	lastmem = 0x78;
	RAM0r = mBIOS;
	RAM0w = mMAIN;
	h_cntbase = 0;

#if 0
	RAM0r = mMAIN;
	x1flg.ROM_SW = 0;
#if 1
	{
		FILEH	fh;
#if 1
		if ((fh = file_open_c("euphory.ram")) != (FILEH)-1) {
			file_read(fh, &mMAIN[0x0000], 0xffff);
			file_close(fh);
		}
#else
		if ((fh = file_open_c("chackn.pop")) != (FILEH)-1) {
			file_read(fh, &mMAIN[0x0000], 0xffff);
			file_close(fh);
		}
#endif
	}
#else
	{
		FILEH	fh;
		if ((fh = file_open_c("sys.com")) != (FILEH)-1) {
			file_read(fh, &mMAIN[0x0000], 4096);
			file_close(fh);
		}
		if ((fh = file_open_c("sc.com")) != (FILEH)-1) {
			file_read(fh, &mMAIN[0x1000], 4096);
			file_close(fh);
		}
		if ((fh = file_open_c("s.dat")) != (FILEH)-1) {
			file_read(fh, &mMAIN[0xe000], 0x2000);
			file_close(fh);
		}
	}
	x1_set_fd(0, 0, "d:\\prv_project\\work\\test.d88");
#endif
#endif

	clndr_init();

	init_fdc();
	init_scpu();
	init_8255();
	init_crtc();
	init_vram();

	init_dma();
	init_ctc();
	init_pcg();
	init_cmt();
	init_sio();

	return(SUCCESS);
}



/***********************************************************************
	s^I
***********************************************************************/

static	BYTE	keyintcnt = 0;
static	BYTE	flame = 0;
static	BYTE	inttiming = 0;

void x1r_init(void) {

	TRACE_START();

	init_draw();
	fnt_load();
	reset_x1(xmilcfg.ROM_TYPE, xmilcfg.SOUND_SW, xmilcfg.DIP_SW);

	timer_init(60);

	x1_psg_cont();
	x1_opm_cont();
	keyboard_init();
	keyboard_reset();
	timer_setcount(0);
}


void x1r_exec(void) {

extern	BYTE	disp_flashscreen;

	v_cnt = 0;
	s_cnt = 0;
	xmilcfg.DISPSYNC &= 1;
	inttiming = xmilcfg.CPU8MHz & 1;

	if (disp_flashscreen) {
		while(s_cnt < 266) {
			while(h_cnt < x1flg.HSYNC_CLK) {
				Z80_Execute();
				x1_dma();
				TRACE1();
			}
			h_cnt -= x1flg.HSYNC_CLK;
			h_cntbase += x1flg.HSYNC_CLK;
			inttiming ^= 2;
			if (inttiming != 3) {
				if (xmilcfg.SOUNDPLY) {
					STREAM_MAKES(pcmbufsize[s_cnt]);
				}
				s_cnt++;
				x1_ctc_int();
				if (!((++keyintcnt) & 15)) {
					x1_sub_int();
					if (xmilcfg.MOUSE_SW) {
						x1_sio();
					}
				}
			}
			v_cnt++;
			if (crtc.CRT_YL == v_cnt) {
				pcg.vsync = 1;
				if (xmilcfg.DISPSYNC == 1) {
					xmilcfg.DISPSYNC |= 0x80;
					scrnupdate();
				}
			}
		}
	}
	else {
		while(s_cnt < 266) {
			while(h_cnt < x1flg.HSYNC_CLK) {
				Z80_Execute();
				x1_dma();
				TRACE1();
			}
			h_cnt -= x1flg.HSYNC_CLK;
			h_cntbase += x1flg.HSYNC_CLK;
			inttiming ^= 2;
			if (inttiming != 3) {
				if (xmilcfg.SOUNDPLY) {
					STREAM_MAKES(pcmbufsize[s_cnt]);
				}
				s_cnt++;
				x1_ctc_int();
				if (!((++keyintcnt) & 15)) {
					x1_sub_int();
					if (xmilcfg.MOUSE_SW) {
						x1_sio();
					}
				}
			}
			if (!(xmilcfg.DISPSYNC & 0x80)) {
				scrnupdate1line(v_cnt);
			}
			v_cnt++;
			if (crtc.CRT_YL == v_cnt) {
				pcg.vsync = 1;
				if (xmilcfg.DISPSYNC == 1) {
					xmilcfg.DISPSYNC |= 0x80;
					scrnupdate();
				}
			}
		}
	}
	if (++flame >= 60) {
		flame = 0;
		clndr_inc();
	}
	if (!xmilcfg.SOUNDPLY) {
		STREAM_MAKES(framesoundcnt);
	}
	if (!(xmilcfg.DISPSYNC & 0x80)) {
		scrnupdate();
	}
}


void x1r_term(void) {

	timer_term();
	x1_opm_stop();
	x1_psg_stop();
	keyboard_term();
	TRACE_END();

	x1_set_fd(0, 0, NULL);
	x1_set_fd(1, 0, NULL);
	x1_set_fd(2, 0, NULL);
	x1_set_fd(3, 0, NULL);
}



X1_IOR x1_dipsw_r(WORD port) {

	return(x1flg.DIP_SW);
}
