#include	<windows.h>
#include	<stdio.h>
#include	<string.h>
#include	"xmil.h"
#include	"x1.h"
#include	"x1_cmt.h"
#include	"x1_scpu.h"
#include	"x1_clndr.h"
#include	"input.h"
#include	"dosio.h"

/***********************************************************************
	SUB CPU
***********************************************************************/

		SCPU_TABLE	scpu;

//							  e3 e4 e5 e6 e7 e8 e9 ea eb ec ed ee ef
const	BYTE	CMD_TBL[] = {  0, 1, 0, 0, 1, 0, 1, 0, 0, 3, 0, 3, 0};
const	BYTE	DAT_TBL[] = {  3, 0, 0, 2, 0, 1, 0, 1, 1, 0, 3, 0, 3};


//**********************************************************************

void init_scpu(void) {

	ZeroMemory(&scpu, sizeof(scpu));
	scpu.OBF = 1;
}

//**********************************************************************

// L[{[h荞
short x1_sub_int(void) {								// 990922

#if 1
	if ((!KEY_INT) || (scpu.CMD_CNT) || (scpu.DAT_CNT) ||
		(!Z80_Able_interrupt())) {						// 荞߂Ȃ
		return(1);										// ܂T`
	}
#else
	if ((!KEY_INT) || (scpu.CMD_CNT) || (scpu.DAT_CNT)) {
		return(1);
	}
#endif
	KEY_INT = 0;
	if (!scpu.Ex[4][0]) {				// 荞ݕsv̂Ă
		return(1);
	}
	if (KEY_HIT) {						// L[ꂽꍇ
		keyboard_inkey(xmilcfg.KEY_MODE, scpu.Ex[0x06]);
		if (!scpu.Ex[0x06][1]) {		// ȃL[̂Ă
			return(1);
		}
		scpu.INT_SW = 1;
	}
	else {
		if (!scpu.INT_SW) {				// ĂȂ犄荞܂Ȃ
			return(1);
		}
		scpu.INT_SW = 0;
		keyboard_inkey(xmilcfg.KEY_MODE, scpu.Ex[0x06]);
	}

//	x1_sub_w(0x1900, 0xe6);				// KeyǂݎŃXe[^Xς
										// ܂悤ɂȂ....
	scpu.MODE = 0xe6;
	scpu.CMD_CNT = 0;
	scpu.DAT_CNT = 2;
	scpu.datap = SCPUOFST(Ex[0xe6 - 0xe0][0]);
	scpu.OBF = 0;
	scpu.IBF = 1;

	Z80_Cause_Interrupt2(scpu.Ex[4][0]);
	return(0);
}

//**********************************************************************

X1_IOW x1_sub_w(WORD port, BYTE value) {

	if (scpu.IBF) {
		return;
	}
	if (!scpu.CMD_CNT) {
		scpu.MODE = value;
		scpu.CMD_CNT = 0;
		scpu.DAT_CNT = 0;
		if (value >= 0xd0 && value <= 0xd7) {
			scpu.CMD_CNT = 6;
			scpu.DAT_CNT = 0;
		}
		else if (value >= 0xd8 && value <= 0xdf) {
			scpu.CMD_CNT = 0;
			scpu.DAT_CNT = 6;
		}
		else if (value >= 0xe3 && value <= 0xef) {
			scpu.CMD_CNT = CMD_TBL[value - 0xe3];
			scpu.DAT_CNT = DAT_TBL[value - 0xe3];
		}
		if (value < 0xe0) {
			scpu.datap = SCPUOFST(Dx[value - 0xd0][0]);
		}
		else {
			scpu.datap = SCPUOFST(Ex[value - 0xe0][0]);
		}
		switch(scpu.MODE) {							// 990225 puni
			case 0xe3:
				if (xmilcfg.KEY_MODE) {
					scpu.Ex[0x03][0] = 0;
					scpu.Ex[0x03][1] = 0;
					scpu.Ex[0x03][2] = 0;
				}
				else {
					keyboard_e3(scpu.Ex[0x03]);
				}
				break;

			case 0xe6:
				keyboard_inkey(xmilcfg.KEY_MODE, scpu.Ex[0x06]);
				break;

			case 0xed:
				clndr_getdate(scpu.Ex[0x0d]);
				break;

			case 0xef:
				clndr_gettime(scpu.Ex[0x0f]);
				break;
		}
	}
	else {
		*((BYTE *)(&scpu) + scpu.datap) = value;
		scpu.datap++;
		if (--scpu.CMD_CNT == 0) {
			switch(scpu.MODE) {
				case 0xe9:
					cmt_ctrl(scpu.Ex[0x9][0]);
					break;
				case 0xec:
					clndr_setdate(scpu.Ex[0x0c]);
					break;
				case 0xee:
					clndr_settime(scpu.Ex[0x0e]);
					break;
			}
		}
	}
	scpu.OBF = (BYTE)(scpu.DAT_CNT?0:1);
	scpu.IBF = (BYTE)(scpu.DAT_CNT?1:0);
}


X1_IOR x1_sub_r(WORD port) {

	BYTE	ret;
#if 1										// D-SIDE Œʂ悤Ɂc
	if (!scpu.DAT_CNT) {					// |C^͕ςȂH
		scpu.DAT_CNT++;

		switch(scpu.MODE) {						// 990225 puni
			case 0xe3:
				if (xmilcfg.KEY_MODE) {
					scpu.Ex[0x03][0] = 0;
					scpu.Ex[0x03][1] = 0;
					scpu.Ex[0x03][2] = 0;
				}
				else {
					keyboard_e3(scpu.Ex[0x03]);
				}
				break;

			case 0xe6:
				keyboard_inkey(xmilcfg.KEY_MODE, scpu.Ex[0x06]);
				break;

			case 0xed:
				clndr_getdate(scpu.Ex[0x0d]);
				break;

			case 0xef:
				clndr_gettime(scpu.Ex[0x0f]);
				break;
		}
	}

#else
	if (scpu.OBF) {
		return(0);
	}
#endif
	ret = 0;
	switch(scpu.MODE) {
		case 0xd8:
		case 0xd9:
		case 0xda:
		case 0xdb:
		case 0xdc:
		case 0xdd:
		case 0xde:
		case 0xdf:
			ret = scpu.Dx[scpu.MODE - 0xd8][6 - scpu.DAT_CNT];
			break;
		case 0xe3:
			ret = scpu.Ex[0x03][3 - scpu.DAT_CNT];
			break;
		case 0xe6:
			ret = scpu.Ex[0x06][2 - scpu.DAT_CNT];
			break;
		case 0xe8:
			ret = scpu.Ex[0x07][0];
			break;
		case 0xea:
			ret = cmt_ctrl_stat();
			break;
		case 0xeb:
			ret = cmt_tape_stat();
			break;
		case 0xed:
			ret = scpu.Ex[0x0d][3 - scpu.DAT_CNT];
			break;
		case 0xef:
			ret = scpu.Ex[0x0f][3 - scpu.DAT_CNT];
			break;
	}
	scpu.DAT_CNT--;
	scpu.OBF = (BYTE)(scpu.DAT_CNT?0:1);
	scpu.IBF = (BYTE)(scpu.DAT_CNT?1:0);
	return(ret);
}

