#include	<windows.h>
#include	<stdio.h>
#include	"common.h"
#include	"x1.h"
#include	"x1_crtc.h"
#include	"x1_pcg.h"
#include	"x1_vram.h"
#include	"draw.h"

// flags

		BYTE	*curvram;
		BYTE	curupdt;
		DWORD	updatemsk = 0x7ff;

void init_vram(void) {

	ZeroMemory(GRP_RAM, 0x20000);
	ZeroMemory(TXT_RAM, 0x01800);
	memset(&TXT_RAM[TEXT_ATR], 0x07, 0x800);
	memset(&TXT_RAM[TEXT_ANK], 0x20, 0x800);
	ZeroMemory(updatetmp, sizeof(updatetmp));
	curvram = &GRP_RAM[GRAM_BANK0];
	curupdt = UPDATE_VRAM0;
}

LABEL X1_IOW x1_txt_w(WORD port, BYTE value) {

	__asm {
				mov		eax, ecx
				and		eax, 07ffh
				cmp		ch, 30h
				jb		write_atr
				cmp		ch, 38h
				jb		write_ank
				cmp		x1flg.ROM_TYPE, 2
				jb		write_ank
				add		ax, TEXT_KNJ
				mov		dh, TXT_RAM[eax]
				jmp		txt_w_chgchk

write_ank:		add		ax, TEXT_ANK
				mov		dh, TXT_RAM[eax]
				jmp		txt_w_chgchk

write_atr:		add		ax, TEXT_ATR
				test	dl, X1ATR_BLINK
				je		atr_noblink
				mov		blinkflag, 1
atr_noblink:	mov		dh, TXT_RAM[eax]
				push	ebx
				mov		bl, dh
				xor		bl, dl
				and		bl, (X1ATR_Yx2 or X1ATR_Xx2)
				pop		ebx
				je		txt_w_chgchk
				mov		doubleatrchange, 1

txt_w_chgchk:	cmp		dl, dh
				je		txt_w_end
				mov		TXT_RAM[eax], dl
				mov		scrnflash, 1
				and		ah, 7
				test	byte ptr TXT_RAM[eax + TEXT_ATR], X1ATR_Xx2
				je		nortextupdate			// m[}
				or		word ptr updatetmp[eax], UPDATE_TVRAM * 101h
txt_w_end:		ret
nortextupdate:	or		byte ptr updatetmp[eax], UPDATE_TVRAM
				ret
	}
}

LABEL X1_IOR x1_txt_r(WORD port) {

	__asm {
				mov		eax, ecx
				and		eax, 07ffh
				cmp		ch, 30h
				jb		textram_atrr
				cmp		ch, 38h
				jb		textram_ankr
				cmp		x1flg.ROM_TYPE, 2
				jb		textram_ankr
				movzx	eax, byte ptr TXT_RAM[eax + TEXT_KNJ]
				ret
textram_ankr:	movzx	eax, byte ptr TXT_RAM[eax + TEXT_ANK]
				ret
textram_atrr:	movzx	eax, byte ptr TXT_RAM[eax + TEXT_ATR]
				ret
	}
}

LABEL X1_IOW x1_grp_w2(WORD port, BYTE value) {

	__asm {
				mov		eax, ecx
				and		eax, updatemsk
				mov		dh, curupdt
				or		updatetmp[eax], dh
				mov		scrnflash, 1
				mov		ah, ch
				and		ah, 03fh
				rol		ax, 5
				add		eax, curvram

				cmp		ch, 40h
				jc		plane_7
				js		plane_3
				jge		plane_6
				mov		[eax+PLANE_B], dl			// ah = 080h
				mov		[eax+PLANE_G], dl
				ret
plane_3:		mov		[eax+PLANE_B], dl			// ah = 0c0h
				mov		[eax+PLANE_R], dl
				ret
plane_7:		mov		[eax+PLANE_B], dl			// ah = 000h
plane_6:		mov		[eax+PLANE_R], dl			// ah = 040h
				mov		[eax+PLANE_G], dl
				ret
	}
}

LABEL X1_IOW x1_grp_w(WORD port, BYTE value) {

	__asm {
				xor		eax, eax
				mov		ax, cx
				rol		ax, 5
				add		eax, curvram
				cmp		[eax], dl
				je		nowritevram
				mov		[eax], dl
				mov		ax, cx
				and		eax, updatemsk
				mov		dh, curupdt
				or		updatetmp[eax], dh
				mov		scrnflash, 1
nowritevram:	ret
	}
}

LABEL X1_IOR x1_grp_r(WORD port) {

	__asm {
				xor		eax, eax
				mov		ax, cx
				rol		ax, 5
				add		eax, curvram
				movzx	eax, byte ptr [eax]
				ret
	}
}

