#include	<windows.h>
#include	<stdio.h>
#include	<string.h>

#include	"common.h"
#include	"resource.h"
#include	"xmil.h"
#include	"ddraws.h"
#include	"ddrawbmp.h"
#include	"dinputs.h"
#include	"x1.h"
#include	"x1_crtc.h"
#include	"dialog.h"
#include	"ini.h"
#include	"menu.h"
#include	"timer.h"
#include	"dsounds.h"
#include	"opm.h"
#include	"dosio.h"
#include	"trace.h"
#include	"input.h"
#include	"draw.h"
#include	"x1_fdc.h"
#include	"fdd_ini.h"
#include	"winloc.h"
#include	"mouses.h"
#include	"newdisk.h"

		char		szProgName[] = "X millennium";
const	char		szClassName[] = "Xmill-MainWindow";
		HWND		hWndMain;
		HWND		hInst;
		BYTE		xmilopening = 1;
		int			winx, winy;
		XMIL_CFG	xmilcfg = {0, 0, 1, 0, 1, 2, 0, 1, 22050, 1000, 0, 0,
								0, 0, 0, 80, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0,
								1};

BYTE changescreen(BYTE mode) {

	if (xm_setscreenmode(mode)) {
		mouse_running(MOUSE_STOP);
		xm_TermDirectDraw();
		xm_windowstats();
		if (xm_InitDirectDraw()) {
			disable_windowmenu();
			xm_setscreenmode(SCMD_XORWINDOWED);
			xm_windowstats();
			if (xm_InitDirectDraw()) {
				return(FAILURE);
			}
		}
		ddraws_redraw();
		mouse_running(MOUSE_CONT);
	}
	return(SUCCESS);
}


// --------------------------------------------------------------------------

LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) {

	PAINTSTRUCT	ps;
	RECT		rc;
	HDC			hdc;

	switch (msg) {
		case WM_CREATE:
			DragAcceptFiles(hWnd, TRUE);
			break;

		case WM_SYSCOMMAND:
			switch(wParam) {
				case IDM_SCREENCENTER:
					if (SCREENMODE & SCMD_WINDOWED) {
						xm_wincenter();
					}
					break;
				case IDM_SNAPENABLE:
					INIT_RENEWAL xmenu_setwinsnap(xmilcfg.WINSNAP ^ 1);
					break;
#ifdef TRACE
				case IDM_TRACEONOFF:
					trace_sw ^= 1;
					CheckMenuItem(GetSystemMenu(hWndMain, FALSE),
									IDM_TRACEONOFF, 
									(trace_sw?MF_CHECKED:MF_UNCHECKED));
					break;
#endif
				default:
					return(DefWindowProc(hWnd, msg, wParam, lParam));
			}
			break;

		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDM_IPLRESET:
					if (reset_x1(xmilcfg.ROM_TYPE,
								xmilcfg.SOUND_SW, xmilcfg.DIP_SW)) {
						PostQuitMessage(0);
					}
					break;
				case IDM_NMIRESET:
					Z80_NonMaskedInterrupt();
					break;
				case IDM_CONFIG:
					STOP_DIRECTSOUND();
					mx_topwinui();
					DialogBox(hInst, MAKEINTRESOURCE(IDD_CONFIG),
									hWnd, (DLGPROC)CfgDialogProc);
					mx_clearwinui();
					PLAY_DIRECTSOUND();
					break;
				case IDM_NEWDISK:
					STOP_DIRECTSOUND();
					mx_topwinui();
					newdisk(hWnd);
					mx_clearwinui();
					PLAY_DIRECTSOUND();
					break;
				case IDM_EXIT:
					SendMessage(hWnd, WM_CLOSE, 0, 0L);
					break;

				case IDM_FDD0OPEN:
					changefdd(0);
					break;
				case IDM_FDD0EJECT:
					x1_set_fd(0, 0, NULL);
					makecaption(1);
					break;

				case IDM_FDD1OPEN:
					changefdd(1);
					break;
				case IDM_FDD1EJECT:
					x1_set_fd(1, 0, NULL);
					makecaption(1);
					break;

				case IDM_TURBOZ:
					INIT_RENEWAL xmenu_setiplrom(3);
					break;
				case IDM_TURBO:
					INIT_RENEWAL xmenu_setiplrom(2);
					break;
				case IDM_X1ROM:
					INIT_RENEWAL xmenu_setiplrom(1);
					break;

				case IDM_BOOT2D:
					INIT_RENEWAL xmenu_setbootmedia(0);
					break;
				case IDM_BOOT2HD:
					INIT_RENEWAL xmenu_setbootmedia(DIP_BOOTMEDIA);
					break;

				case IDM_HIGHRES:
					INIT_RENEWAL xmenu_setresolute(0);
					break;
				case IDM_LOWRES:
					INIT_RENEWAL xmenu_setresolute(DIP_RESOLUTE);
					break;

				case IDM_WINDOW:
					if (changescreen(SCMD_SETWINDOWED)) {
						PostQuitMessage(0);
					}
					break;
				case IDM_FULLSCREEN:
					if (changescreen(SCMD_SETFULLSCREEN)) {
						PostQuitMessage(0);
					}
					break;
				case IDM_WIDTH80:
					crtc.TXT_XL = 80;
					crtc.GRP_XL = 640;
					vrambank_patch();
					scrnallflash = 1;
					break;
				case IDM_WIDTH40:
					crtc.TXT_XL = 40;
					crtc.GRP_XL = 320;
					vrambank_patch();
					scrnallflash = 1;
					break;
				case IDM_DISPSYNC:
					xmenu_setdispmode(xmilcfg.DISPSYNC ^ 1);
					break;
				case IDM_NOWAIT:
					INIT_RENEWAL xmenu_setwaitflg(xmilcfg.NOWAIT ^ 1);
					break;
				case IDM_RASTER:
					INIT_RENEWAL xmenu_setflame(0);
					break;
				case IDM_60FPS:
					INIT_RENEWAL xmenu_setflame(1);
					break;
				case IDM_30FPS:
					INIT_RENEWAL xmenu_setflame(2);
					break;
				case IDM_20FPS:
					INIT_RENEWAL xmenu_setflame(3);
					break;
				case IDM_15FPS:
					INIT_RENEWAL xmenu_setflame(4);
					break;

				case IDM_KEY:
					xmenu_setkey(0);
					break;
				case IDM_JOY1:
					xmenu_setkey(1);
					break;
				case IDM_JOY2:
					xmenu_setkey(2);
					break;
				case IDM_FMBOARD:
					INIT_RENEWAL xmenu_setsound(xmilcfg.SOUND_SW ^ 1);
					break;
				case IDM_JOYSTICK:
					INIT_RENEWAL xmenu_setjoystick(xmilcfg.JOYSTICK ^ 1);
					break;
				case IDM_MOUSE:
					INIT_RENEWAL xmenu_setmouse(xmilcfg.MOUSE_SW ^ 1);
					break;
				case IDM_8MHZ:
					INIT_RENEWAL xmenu_setcpuspeed(xmilcfg.CPU8MHz ^ 1);
					break;
				case IDM_SEEKSND:
					INIT_RENEWAL xmenu_setmotorflg(xmilcfg.MOTOR ^ 1);
					break;

				case IDM_BMPSAVE:
					bmpsave();
					break;
				case IDM_OPMLOG:
					INX1F_logging();
					break;
				case IDM_SKIPLINE:
					INIT_RENEWAL xmenu_setskipline(xmilcfg.SKIP_LINE ^ 1);
					break;
				case IDM_JOYX:
					INIT_RENEWAL xmenu_setbtnmode(xmilcfg.BTN_MODE ^ 1);
					break;
				case IDM_RAPID:
					INIT_RENEWAL xmenu_setbtnrapid(xmilcfg.BTN_RAPID ^ 1);
					break;
				case IDM_HALFBMP:
					bmpsavehalf();
					break;
				case IDM_Z80SAVE:
					debug_status();
					break;
				case IDM_ABOUT:
					STOP_DIRECTSOUND();
					mx_topwinui();
					DialogBox(NULL, MAKEINTRESOURCE(IDD_ABOUT),
									hWnd, (DLGPROC)AboutDialogProc);
					mx_clearwinui();
					PLAY_DIRECTSOUND();
					break;
			}
			break;

		case WM_ACTIVATE:
			joy_foregroundprc(wParam);
			if (LOWORD(wParam) != WA_INACTIVE) {
				scrn_drawall();
				mouse_running(MOUSE_CONT_M);
			}
			else {
				mouse_running(MOUSE_STOP_M);
			}
			break;

		case WM_PAINT:
			hdc = BeginPaint(hWnd, &ps);
			if (xmilopening) {

			    HDC			hmdc;
			    HBITMAP		hbmp;
			    BITMAP		bmp;
			    HINSTANCE	hinst;

			    hinst = (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE);
    			hbmp = LoadBitmap(hinst, "XMILBMP");
			    GetObject(hbmp, sizeof(BITMAP), &bmp);
			    hmdc = CreateCompatibleDC(hdc);
			    SelectObject(hmdc, hbmp);
			    BitBlt(hdc, (SCREEN_WIDTH - 201) / 2,
			    			(SCREEN_HEIGHT - 31) / 2,
							bmp.bmWidth, bmp.bmHeight, hmdc, 0, 0, SRCCOPY);
			    DeleteDC(hmdc);
	    		DeleteObject(hbmp);

    			hbmp = LoadBitmap(hinst, "ZILOG");
			    GetObject(hbmp, sizeof(BITMAP), &bmp);
			    hmdc = CreateCompatibleDC(hdc);
			    SelectObject(hmdc, hbmp);
			    BitBlt(hdc, (SCREEN_WIDTH - (101 + 8 + 41 + 8 + 68 + 1)),
			    			(SCREEN_HEIGHT - 38),
							bmp.bmWidth, bmp.bmHeight, hmdc, 0, 0, SRCCOPY);

    			hbmp = LoadBitmap(hinst, "TURBOZ");
			    GetObject(hbmp, sizeof(BITMAP), &bmp);
			    hmdc = CreateCompatibleDC(hdc);
			    SelectObject(hmdc, hbmp);
			    BitBlt(hdc, (SCREEN_WIDTH - (101 + 8 + 68 + 1)),
			    			(SCREEN_HEIGHT - 18),
							bmp.bmWidth, bmp.bmHeight, hmdc, 0, 0, SRCCOPY);

    			hbmp = LoadBitmap(hinst, "OPMSOUND");
			    GetObject(hbmp, sizeof(BITMAP), &bmp);
			    hmdc = CreateCompatibleDC(hdc);
			    SelectObject(hmdc, hbmp);
			    BitBlt(hdc, (SCREEN_WIDTH - (68+1)),
			    			(SCREEN_HEIGHT - (25+1)),
							bmp.bmWidth, bmp.bmHeight, hmdc, 0, 0, SRCCOPY);

			    DeleteDC(hmdc);
	    		DeleteObject(hbmp);
			}
			else {
//				ddraws_redraw();
				scrn_drawall();
			}
			EndPaint(hWnd, &ps);
			break;

		case WM_QUERYNEWPALETTE:
			scrn_palette();
			break;
		case WM_MOVE:
			if (SCREENMODE & SCMD_WINDOWED) {
				GetWindowRect(hWnd, &rc);
				INIT_RENEWAL
					winx = rc.left;
					winy = rc.top;
			}
			break;

		case WM_ENTERMENULOOP:
			STOP_DIRECTSOUND();
			mx_topwinui();
			if (!(SCREENMODE & SCMD_WINDOWED)) {
				DrawMenuBar(hWnd);
			}
			break;
		case WM_EXITMENULOOP:
			mx_clearwinui();
			PLAY_DIRECTSOUND();
			break;
		case WM_ENTERSIZEMOVE:
			STOP_DIRECTSOUND();
			mouse_running(MOUSE_STOP);
			win_movingstart();
			break;
		case WM_EXITSIZEMOVE:
			mouse_running(MOUSE_CONT);
			PLAY_DIRECTSOUND();
			break;
		case WM_MOVING:
			if (xmilcfg.WINSNAP) {
				win_movingproc((RECT *)lParam);
			}
			break;

		case WM_KEYDOWN:
			if (wParam == VK_F11) {
				mouse_running(MOUSE_XOR);
			}
			else {
				winkeydown106(wParam, lParam);
			}
			break;
		case WM_KEYUP:
			winkeyup106(wParam, lParam);
			break;

		case WM_SYSKEYDOWN:
			if (wParam == VK_F10) {
				return(DefWindowProc(hWnd, WM_SYSKEYDOWN, wParam, lParam));
			}
			winkeydown106(wParam, lParam);
			break;

		case WM_SYSKEYUP:
			if (wParam == VK_F10) {
				return(DefWindowProc(hWnd, WM_SYSKEYUP, wParam, lParam));
			}
			else {
				winkeyup106(wParam, lParam);
			}
			break;

		case WM_LBUTTONDOWN:
			if (!mouse_btn(MOUSE_LEFTDOWN)) {
				return(DefWindowProc(hWnd, msg, wParam, lParam));
			}
			break;
		case WM_LBUTTONUP:
			if (!mouse_btn(MOUSE_LEFTUP)) {
				return(DefWindowProc(hWnd, msg, wParam, lParam));
			}
			break;
		case WM_RBUTTONDOWN:
			if (!mouse_btn(MOUSE_RIGHTDOWN)) {
				return(DefWindowProc(hWnd, msg, wParam, lParam));
			}
			break;
		case WM_RBUTTONUP:
			if (!mouse_btn(MOUSE_RIGHTUP)) {
				return(DefWindowProc(hWnd, msg, wParam, lParam));
			}
			break;
#if 0
		case WM_IME_NOTIFY:
			if (wParam != IMN_OPENSTATUSWINDOW) {
				return(DefWindowProc(hWnd, msg, wParam, lParam));
			}
			break;
#endif
        case WM_DROPFILES:
			{
				HDROP		hDrop;
				char		DropFileName[MAX_PATH];
				int			uFileNo;
				int			i;

				hDrop = (HDROP)wParam;
        	    uFileNo = DragQueryFile((HDROP)wParam, 0xFFFFFFFF, NULL, 0);
				for (i=0; i<uFileNo; i++) {
					DragQueryFile(hDrop, i, DropFileName, MAX_PATH);
					if (is_d8ufile(DropFileName)) {
						fdd_ini(DropFileName);
						makecaption(1);
						break;
					}
				}
        	    DragFinish(hDrop);
				PLAY_DIRECTSOUND();
			}
			break;
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
		default:
			return(DefWindowProc(hWnd, msg, wParam, lParam));
	}
	return(0L);
}




int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPreInst,
										LPSTR lpszCmdLine, int nCmdShow) {
	WNDCLASS	xmil;
	MSG			msg;
	WORD		framecnt = 0;
	HMENU		hMenu;

	if ((hInst = FindWindow(szClassName, NULL)) != NULL) {
		ShowWindow(hInst, SW_RESTORE);
		SetForegroundWindow(hInst);
		return(FALSE);
	}

	hInst = hInstance;

	file_setcd(__argv[0]);
	initload();
	winkeyinit106();

	if (!hPreInst) {
		xmil.style = CS_BYTEALIGNCLIENT | CS_HREDRAW | CS_VREDRAW;
		xmil.lpfnWndProc = WndProc;
		xmil.cbClsExtra = 0;
		xmil.cbWndExtra = 0;
		xmil.hInstance = hInstance;
		xmil.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON1));
		xmil.hCursor = LoadCursor(NULL, IDC_ARROW);
		xmil.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
		xmil.lpszMenuName = MAKEINTRESOURCE(IDM_MAIN);
		xmil.lpszClassName = szClassName;
		if (!RegisterClass(&xmil)) {
			return(FALSE);
		}
	}

	hWndMain = CreateWindowEx(0,
						szClassName, szProgName,
						WS_OVERLAPPED | WS_SYSMENU | WS_CAPTION |
						WS_MINIMIZEBOX,
						CW_USEDEFAULT, CW_USEDEFAULT,
						SCREEN_WIDTH, SCREEN_HEIGHT,
						NULL, NULL, hInstance, NULL);

	xm_initwindowsize(SCREEN_WIDTH, SCREEN_HEIGHT);

	xmenu_setiplrom(xmilcfg.ROM_TYPE);
	xmenu_setsound(xmilcfg.SOUND_SW);
	xmenu_setskipline(xmilcfg.SKIP_LINE);
	xmenu_setresolute(xmilcfg.DIP_SW);
	xmenu_setbootmedia(xmilcfg.DIP_SW);
	xmenu_setkey(0);
	xmenu_setbtnrapid(xmilcfg.BTN_RAPID);
	xmenu_setbtnmode(xmilcfg.BTN_MODE);
	xmenu_setcpuspeed(xmilcfg.CPU8MHz);
	xmenu_setwaitflg(xmilcfg.NOWAIT);
	xmenu_setflame(xmilcfg.DRAW_SKIP);
	xmenu_setmotorflg(xmilcfg.MOTOR);
	xmenu_setz80save(xmilcfg.Z80SAVE);
	xmenu_setjoystick(xmilcfg.JOYSTICK);
	xmenu_setdispmode(xmilcfg.DISPSYNC);
	xmenu_setmouse(xmilcfg.MOUSE_SW);

	xm_setscreenmode(SCMD_SETWINDOWED);
	xm_windowstats();
	ShowWindow(hWndMain, nCmdShow);
	UpdateWindow(hWndMain);

	hMenu = GetSystemMenu(hWndMain, FALSE);
	InsertMenu(hMenu, 0, MF_BYPOSITION | MF_STRING, IDM_SCREENCENTER,
							"Z^O(&X)");
	InsertMenu(hMenu, 1, MF_BYPOSITION | MF_STRING, IDM_SNAPENABLE,
							"Xibv(&S)");
	InsertMenu(hMenu, 2, MF_BYPOSITION | MF_SEPARATOR, 0, NULL);
#ifdef TRACE
	InsertMenu(hMenu, 2, MF_BYPOSITION | MF_STRING, IDM_TRACEONOFF,
							"g[X");
#endif
	DrawMenuBar(hWndMain);

	xmenu_setwinsnap(xmilcfg.WINSNAP);

	ddraws_init();
	if (xm_InitDirectDraw()) {
		xm_TermDirectDraw();
		disable_windowmenu();
		xm_setscreenmode(SCMD_SETFULLSCREEN);
		xm_windowstats();
		if (xm_InitDirectDraw()) {
			xm_TermDirectDraw();
			MessageBox(hWndMain, "Couldn't create DirectDraw Object",
													szProgName, MB_OK);
			return(FALSE);
		}
	}
	INIT_RESET
	mx_initdinput();

	if (!InitDirectSound()) {
		WAVE_INIT();
		WAVE_CREATE("fddseek.wav", 0, xmilcfg.MOTORVOL);
		WAVE_CREATE("fddseek1.wav", 1, xmilcfg.MOTORVOL);
	}

	x1r_init();

	if (__argc > 1) {
		for (int i=1; i<__argc; i++) {
			if (is_d8ufile(__argv[i])) {
				fdd_ini(__argv[i]);
				makecaption(1);
				break;
			}
		}
	}

	ddraws_redraw();

	xmilopening = 0;

	while(1) {
		if (PeekMessage(&msg, 0, 0, 0, PM_NOREMOVE)) {
			if (!GetMessage(&msg, NULL, 0, 0)) {
				break;
			}
			if ((msg.message != WM_SYSKEYDOWN) &&
				(msg.message != WM_SYSKEYUP)) {
				TranslateMessage(&msg);
			}
			DispatchMessage(&msg);
		}
		else {
			if ((xmilcfg.NOWAIT) || (timer_getcount())) {
				timer_setcount(0);
				joy_flash();
				mouse_callback();
				x1r_exec();
				INX1F_INC;
			}
			STREAM_CALLBACK();
		}
	}

	mouse_running(MOUSE_OFF);

	INX1F_alltrash();
	x1r_term();

	WAVE_TERM();
	TermDirectSound();

	mx_termdinput();
	xm_TermDirectDraw();

	initsave();

	return(msg.wParam);
}

