//----------------------------------------------------------------------------
//
//  Z80R : Z80 Engine  for Intel x86 Protectmode (80386 later)
//
//                                       Copyright by Studio Milmake 1999-2000
//
//----------------------------------------------------------------------------

#include	<windows.h>

#include	"common.h"
#include	"x1_io.h"
#include	"x1_mem.h"
#include	"z80r.h"
#include	"z80r_mcr.h"

		Z80_Regs	R;
		WORD		Z80_ICount = 0;

extern	Z80ROPCODE opcode_main[256];

#include	"z80r_mcr.h"

	BYTE	ZSPtable[256] = {					// Z_FLAG, S_FLAG, P_FLAG
			0x44, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x00,
			0x00, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x04,
			0x00, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x04,
			0x04, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x00,
			0x00, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x04,
			0x04, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x00,
			0x04, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x00,
			0x00, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x04,
			0x00, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x04,
			0x04, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x00,
			0x04, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x00,
			0x00, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x04,
			0x04, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x00,
			0x00, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x04,
			0x00, 0x04, 0x04, 0x00, 0x04, 0x00, 0x00, 0x04,
			0x04, 0x00, 0x00, 0x04, 0x00, 0x04, 0x04, 0x00,
			0x80, 0x84, 0x84, 0x80, 0x84, 0x80, 0x80, 0x84,
			0x84, 0x80, 0x80, 0x84, 0x80, 0x84, 0x84, 0x80,
			0x84, 0x80, 0x80, 0x84, 0x80, 0x84, 0x84, 0x80,
			0x80, 0x84, 0x84, 0x80, 0x84, 0x80, 0x80, 0x84,
			0x84, 0x80, 0x80, 0x84, 0x80, 0x84, 0x84, 0x80,
			0x80, 0x84, 0x84, 0x80, 0x84, 0x80, 0x80, 0x84,
			0x80, 0x84, 0x84, 0x80, 0x84, 0x80, 0x80, 0x84,
			0x84, 0x80, 0x80, 0x84, 0x80, 0x84, 0x84, 0x80,
			0x84, 0x80, 0x80, 0x84, 0x80, 0x84, 0x84, 0x80,
			0x80, 0x84, 0x84, 0x80, 0x84, 0x80, 0x80, 0x84,
			0x80, 0x84, 0x84, 0x80, 0x84, 0x80, 0x80, 0x84,
			0x84, 0x80, 0x80, 0x84, 0x80, 0x84, 0x84, 0x80,
			0x80, 0x84, 0x84, 0x80, 0x84, 0x80, 0x80, 0x84,
			0x84, 0x80, 0x80, 0x84, 0x80, 0x84, 0x84, 0x80,
			0x84, 0x80, 0x80, 0x84, 0x80, 0x84, 0x84, 0x80,
			0x80, 0x84, 0x84, 0x80, 0x84, 0x80, 0x80, 0x84};

	BYTE cycles_main[256] = {
			 4,10, 7, 6, 4, 4, 7, 4, 4,11, 7, 6, 4, 4, 7, 4,
			 8,10, 7, 6, 4, 4, 7, 4, 7,11, 7, 6, 4, 4, 7, 4,
			 7,10,16, 6, 4, 4, 7, 4, 7,11,16, 6, 4, 4, 7, 4,
			 7,10,13, 6,11,11,10, 4, 7,11,13, 6, 4, 4, 7, 4,
			 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
			 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
			 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
			 7, 7, 7, 7, 7, 7, 4, 7, 4, 4, 4, 4, 4, 4, 7, 4,
			 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
			 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
			 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
			 4, 4, 4, 4, 4, 4, 7, 4, 4, 4, 4, 4, 4, 4, 7, 4,
			 5,10,10,10,10,11, 7,11, 5, 4,10, 0,10,10, 7,11,
			 5,10,10,11,10,11, 7,11, 5, 4,10,11,10, 0, 7,11,
			 5,10,10,19,10,11, 7,11, 5, 4,10, 4,10, 0, 7,11,
			 5,10,10, 4,10,11, 7,11, 5, 6,10, 4,10, 0, 7,11};

	BYTE cycles_xx[256] = {
			 0, 0, 0, 0, 0, 0, 0, 0, 0,15, 0, 0, 0, 0, 0, 0,
			 0, 0, 0, 0, 0, 0, 0, 0, 0,15, 0, 0, 0, 0, 0, 0,
			 0,14,20,10, 9, 9, 9, 0, 0,15,20,10, 9, 9, 9, 0,
			 0, 0, 0, 0,23,23,19, 0, 0,15, 0, 0, 0, 0, 0, 0,
			 0, 0, 0, 0, 9, 9,19, 0, 0, 0, 0, 0, 9, 9,19, 0,
			 0, 0, 0, 0, 9, 9,19, 0, 0, 0, 0, 0, 9, 9,19, 0,
			 9, 9, 9, 9, 9, 9,19, 9, 9, 9, 9, 9, 9, 9,19, 9,
			19,19,19,19,19,19,19,19, 0, 0, 0, 0, 9, 9,19, 0,
			 0, 0, 0, 0, 9, 9,19, 0, 0, 0, 0, 0, 9, 9,19, 0,
			 0, 0, 0, 0, 9, 9,19, 0, 0, 0, 0, 0, 9, 9,19, 0,
			 0, 0, 0, 0, 9, 9,19, 0, 0, 0, 0, 0, 9, 9,19, 0,
			 0, 0, 0, 0, 9, 9,19, 0, 0, 0, 0, 0, 9, 9,19, 0,
			 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			 0,14, 0,23, 0,15, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0,
			 0, 0, 0, 0, 0, 0, 0, 0, 0,10, 0, 0, 0, 0, 0, 0};

	BYTE cycles_ed[256] = {
			 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			12,12,15,20, 8, 8, 8, 9,12,12,15,20, 8, 8, 8, 9,
			12,12,15,20, 8, 8, 8, 9,12,12,15,20, 8, 8, 8, 9,
			12,12,15,20, 8, 8, 8,18,12,12,15,20, 8, 8, 8,18,
			12,12,15,20, 8, 8, 8, 0,12,12,15,20, 8, 8, 8, 0,
			 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			16,16,16,16, 0, 0, 0, 0,16,16,16,16, 0, 0, 0, 0,
			16,16,16,16, 0, 0, 0, 0,16,16,16,16, 0, 0, 0, 0,
			 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
			 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};


LABEL BYTE Z80_Able_interrupt(void) {

	__asm {
				test	Z80_IFF, (1 shl IFF_IFLAG) or (1 shl IFF_IRQ) or (1 shl IFF_NMI)
				setz	al
				ret
	}
}


LABEL void __fastcall Z80_Cause_Interrupt(BYTE irq) {

	__asm {
				push	ecx
				and		ecx, 0ffh
				btr		Z80_IFF, IFF_HALT
				jnc		irq_halt_clr
				inc		R_Z80PC
irq_halt_clr:	or		Z80_IFF, (1 shl IFF_IRQ) or (1 shl IFF_IFLAG)
				cmp		R_Z80IM, 1
				je		INT_IM_1
				jc		INT_IM_0
				mov		ch, R_Z80I
				call	fast_RDMEM_W
				xchg	R_Z80PC, ax
				sub		R_Z80SP, 2
				mov		cx, R_Z80SP
				mov		dx, ax
				call	fast_WRMEM_W
				pop		ecx
				ret
INT_IM_1:		add		Z80_ICount, 11
				mov		ax, 38h
				xchg	R_Z80PC, ax
				sub		R_Z80SP, 2
				mov		cx, R_Z80SP
				mov		dx, ax
				call	fast_WRMEM_W
				pop		ecx
				ret
INT_IM_0:		mov		al, cl
				cmp		al, 0ddh
				je		cannot_im0
				cmp		al, 0edh
				je		cannot_im0
				cmp		al, 0fdh
				je		cannot_im0
				movzx	edx, cycles_main[ecx]
				add		Z80_ICount, dx
				push	ebx
				call	opcode_main[ecx*4]
				pop		ebx
				pop		ecx
cannot_im0:		ret
	}
}


LABEL void __fastcall Z80_Cause_Interrupt2(BYTE irq) {

	__asm {
				push	ecx
				and		ecx, 0ffh
				btr		Z80_IFF, IFF_HALT
				jnc		irq_halt_clr
				inc		R_Z80PC
irq_halt_clr:	or		Z80_IFF, (1 shl IFF_IFLAG)
				cmp		R_Z80IM, 1
				je		INT_IM_1
				jc		INT_IM_0
				mov		ch, R_Z80I
				call	fast_RDMEM_W
				xchg	R_Z80PC, ax
				sub		R_Z80SP, 2
				mov		cx, R_Z80SP
				mov		dx, ax
				call	fast_WRMEM_W
				pop		ecx
				ret
INT_IM_1:		add		Z80_ICount, 11
				mov		ax, 38h
				xchg	R_Z80PC, ax
				sub		R_Z80SP, 2
				mov		cx, R_Z80SP
				mov		dx, ax
				call	fast_WRMEM_W
				pop		ecx
				ret
INT_IM_0:		mov		al, cl
				cmp		al, 0ddh
				je		cannot_im0
				cmp		al, 0edh
				je		cannot_im0
				cmp		al, 0fdh
				je		cannot_im0
				movzx	edx, cycles_main[ecx]
				add		Z80_ICount, dx
				push	ebx
				call	opcode_main[ecx*4]
				pop		ebx
				pop		ecx
cannot_im0:		ret
	}
}


LABEL void Z80_NonMaskedInterrupt(void) {

	__asm {
				bts		Z80_IFF, IFF_NMI
				jc		cantnmi
				btr		Z80_IFF, IFF_HALT
				jnc		nmi_halt_clr
				inc		R_Z80PC
nmi_halt_clr:	mov		dx, R_Z80PC
				mov		R_Z80PC, 66h
				sub		R_Z80SP, 2
				movzx	ecx, R_Z80SP
				jmp		fast_WRMEM_W
cantnmi:		ret
	}
}


void Z80_Reset(void) {

	Z80_ICount = 0;
	ZeroMemory(&R, sizeof(Z80_Regs));
	R.R = rand();
}


LABEL void Z80_Execute(void) {

	__asm {
				push	ebx
				inc		R.R
				movzx	ecx, R_Z80PC
				inc		R_Z80PC
				call	fast_RDMEM
				movzx	edx, cycles_main[eax]
				add		Z80_ICount, dx
				call	opcode_main[eax*4]

				inc		R.R
				movzx	ecx, R_Z80PC
				inc		R_Z80PC
				call	fast_RDMEM
				movzx	edx, cycles_main[eax]
				add		Z80_ICount, dx
				call	opcode_main[eax*4]
				pop		ebx
				ret
	}
}

