//----------------------------------------------------------------------------
//
//  Z80R : Z80 Engine  for Intel x86 Protectmode (80386 later)
//
//                                       Copyright by Studio Milmake 1999-2000
//
//----------------------------------------------------------------------------

#define	R_Z80A		R.AF.B.h
#define	R_Z80F		R.AF.B.l
#define	R_Z80B		R.BC.B.h
#define	R_Z80C		R.BC.B.l
#define	R_Z80D		R.DE.B.h
#define	R_Z80E		R.DE.B.l
#define	R_Z80H		R.HL.B.h
#define	R_Z80L		R.HL.B.l

#define	R_Z80AF		R.AF.W
#define	R_Z80BC		R.BC.W
#define	R_Z80DE		R.DE.W
#define	R_Z80HL		R.HL.W
#define	R_Z80IX		R.IX.W
#define	R_Z80IY		R.IY.W
#define	R_Z80PC		R.PC.W
#define	R_Z80SP		R.SP.W

#define	R_Z80AF2	R.AF2.W
#define	R_Z80BC2	R.BC2.W
#define	R_Z80DE2	R.DE2.W
#define	R_Z80HL2	R.HL2.W

#define	R_Z80I		R.I
#define R_Z80IM		R.IM
#define R_Z80R		R.R
#define R_Z80R2		R.R2

#define	Z80_IFF		R.IFF

#define	OP_BYTE														\
			__asm {	inc		cx									}	\
			__asm {	inc		R_Z80PC								}	\
			__asm {	call	fast_RDMEM							}

#define	OP_XHL														\
			__asm {	mov		cx, R_Z80HL							}	\
			__asm {	call	fast_RDMEM							}

#define	GET_PC_BYTE													\
			__asm {	inc		cx									}	\
			__asm {	inc		R_Z80PC								}	\
			__asm {	call	fast_RDMEM							}

#define	GET_PC_WORD													\
			__asm {	inc		cx									}	\
			__asm {	add		R_Z80PC, 2							}	\
			__asm {	call	fast_RDMEM_W						}

#define	MCR_INC(reg)												\
			__asm {	mov		dl, reg								}	\
			__asm {	mov		al, R_Z80F							}	\
			__asm {	and		al, C_FLAG							}	\
			__asm {	inc		reg									}	\
			__asm {	inc		dl									}	\
			__asm {	lahf										}	\
			__asm {	jno		incnoof								}	\
			__asm {	or		al, V_FLAG							}	\
incnoof:	__asm {	and		ah, (S_FLAG or Z_FLAG)				}	\
			__asm {	or		al, ah								}	\
			__asm {	test	dl, 0fh								}	\
			__asm {	jne		incnoh								}	\
			__asm {	or		al, H_FLAG							}	\
incnoh:		__asm {	mov		R_Z80F, al							}	\
			__asm {	ret											}

#define	MCR_INC_MEM(value)											\
			__asm { mov		cx, value							}	\
			__asm {	call	fast_RDMEM							}	\
			__asm {	mov		dl, R_Z80F							}	\
			__asm {	and		dl, C_FLAG							}	\
			__asm {	inc		al									}	\
			__asm {	lahf										}	\
			__asm {	jno		incmemnoof							}	\
			__asm {	or		dl, V_FLAG							}	\
incmemnoof:	__asm {	and		ah, (S_FLAG or Z_FLAG)				}	\
			__asm {	or		ah, dl								}	\
			__asm {	test	al, 0fh								}	\
			__asm {	jne		incmemnoh							}	\
			__asm {	or		ah, H_FLAG							}	\
incmemnoh:	__asm {	mov		R_Z80F, ah							}	\
			__asm {	mov		dl, al								}	\
			__asm {	jmp		fast_WRMEM							}

#define	MCR_INC_W(reg)												\
			__asm {	inc		reg									}	\
			__asm {	ret											}

#define	MCR_DEC(reg)												\
			__asm {	mov		dl, reg								}	\
			__asm {	mov		al, R_Z80F							}	\
			__asm {	and		al, C_FLAG							}	\
			__asm {	or		al, N_FLAG							}	\
			__asm {	test	dl, 0fh								}	\
			__asm {	jne		decnoh								}	\
			__asm {	or		al, H_FLAG							}	\
decnoh:		__asm {	dec		reg									}	\
			__asm {	lahf										}	\
			__asm {	jno		decnoof								}	\
			__asm {	or		al, V_FLAG							}	\
decnoof:	__asm {	and		ah, (Z_FLAG or S_FLAG)				}	\
			__asm {	or		al, ah								}	\
			__asm {	mov		R_Z80F, al							}	\
			__asm {	ret											}

#define	MCR_DEC_MEM(value)											\
			__asm {	mov		cx, value							}	\
			__asm {	call	fast_RDMEM							}	\
			__asm {	mov		dl, R_Z80F							}	\
			__asm {	and		dl, C_FLAG							}	\
			__asm {	or		dl, N_FLAG							}	\
			__asm {	test	al, 0fh								}	\
			__asm {	jne		decmemnoh							}	\
			__asm {	or		dl, H_FLAG							}	\
decmemnoh:	__asm {	dec		al									}	\
			__asm {	lahf										}	\
			__asm {	jno		decmemnoof							}	\
			__asm {	or		dl, V_FLAG							}	\
decmemnoof:	__asm {	and		ah, (Z_FLAG or S_FLAG)				}	\
			__asm {	or		ah, dl								}	\
			__asm {	mov		R_Z80F, ah							}	\
			__asm {	mov		dl, al								}	\
			__asm {	jmp		fast_WRMEM							}

#define	MCR_DEC_W(reg)												\
			__asm {	dec		reg									}	\
			__asm {	ret											}


#define	MCR_LD(dst, src)											\
			__asm {	mov		al, src								}	\
			__asm {	mov		dst, al								}	\
			__asm { ret											}

#define	MCR_LD_W(dst, src)											\
			__asm {	mov		ax, src								}	\
			__asm {	mov		dst, ax								}	\
			__asm { ret											}

#define	LDB_b(dst)													\
			OP_BYTE													\
			__asm {	mov		dst, al								}	\
			__asm { ret											}

#define	LDB_x(dst, src)												\
			__asm {	mov		cx, src								}	\
			__asm {	call	fast_RDMEM							}	\
			__asm {	mov		dst, al								}	\
			__asm { ret											}

#define	LDx_B(dst, src)												\
			__asm {	mov		dl, src								}	\
			__asm {	mov		cx, dst								}	\
			__asm { jmp		fast_WRMEM							}

#define	LDW_w(dst)													\
			GET_PC_WORD												\
			__asm {	mov		dst, ax								}	\
			__asm {	ret											}

#define	LDW_x(dst)													\
			GET_PC_WORD												\
			__asm {	mov		cx, ax								}	\
			__asm {	call	fast_RDMEM_W						}	\
			__asm {	mov		dst, ax								}	\
			__asm {	ret											}

#define	LDx_W(src)													\
			GET_PC_WORD												\
			__asm {	mov		cx, ax								}	\
			__asm {	mov		dx, src								}	\
			__asm {	jmp		fast_WRMEM_W						}


#define	MCR_ADD														\
			__asm {	mov		dl, R_Z80A							}	\
			__asm {	mov		dh, dl								}	\
			__asm {	add		dh, al								}	\
			__asm {	lahf										}	\
			__asm {	and		ah, 11000001b						}	\
			__asm {	mov		cl, dl								}	\
			__asm {	xor		cl, dh								}	\
			__asm {	xor		cl, al								}	\
			__asm {	and		cl, H_FLAG							}	\
			__asm {	or		ah, cl								}	\
			__asm {	xor		dl, al								}	\
			__asm {	xor		dl, 80h								}	\
			__asm {	xor		al, dh								}	\
			__asm {	and		al, dl								}	\
			__asm {	rol		al, 3								}	\
			__asm {	and		al, V_FLAG							}	\
			__asm {	or		al, ah								}	\
			__asm {	mov		ah, dh								}	\
			__asm {	mov		R_Z80AF, ax							}	\
			__asm { ret											}

#define	MCR_ADC														\
			__asm {	mov		dx, R_Z80AF							}	\
			__asm {	mov		ah, dl								}	\
			__asm {	mov		dl, dh								}	\
			__asm {	sahf										}	\
			__asm {	adc		dh, al								}	\
			__asm {	lahf										}	\
			__asm {	and		ah, 11000001b						}	\
			__asm {	mov		cl, dl								}	\
			__asm {	xor		cl, dh								}	\
			__asm {	xor		cl, al								}	\
			__asm {	and		cl, H_FLAG							}	\
			__asm {	or		ah, cl								}	\
			__asm {	xor		dl, al								}	\
			__asm {	xor		dl, 80h								}	\
			__asm {	xor		al, dh								}	\
			__asm {	and		al, dl								}	\
			__asm {	rol		al, 3								}	\
			__asm {	and		al, V_FLAG							}	\
			__asm {	or		al, ah								}	\
			__asm {	mov		ah, dh								}	\
			__asm {	mov		R_Z80AF, ax							}	\
			__asm { ret											}

#define	MCR_SUB														\
			__asm {	mov		dl, R_Z80A							}	\
			__asm {	mov		dh, dl								}	\
			__asm {	sub		dh, al								}	\
			__asm {	lahf										}	\
			__asm {	and		ah, 11000001b						}	\
			__asm {	or		ah, N_FLAG							}	\
			__asm {	mov		cl, dl								}	\
			__asm {	xor		cl, dh								}	\
			__asm {	xor		cl, al								}	\
			__asm {	and		cl, H_FLAG							}	\
			__asm {	or		ah, cl								}	\
			__asm {	xor		al, dl								}	\
			__asm {	xor		dl, dh								}	\
			__asm {	and		al, dl								}	\
			__asm {	rol		al, 3								}	\
			__asm {	and		al, V_FLAG							}	\
			__asm {	or		al, ah								}	\
			__asm {	mov		ah, dh								}	\
			__asm {	mov		R_Z80AF, ax							}	\
			__asm { ret											}

#define	MCR_SBC														\
			__asm {	mov		dx, R_Z80AF							}	\
			__asm {	mov		ah, dl								}	\
			__asm {	mov		dl, dh								}	\
			__asm {	sahf										}	\
			__asm {	sbb		dh, al								}	\
			__asm {	lahf										}	\
			__asm {	and		ah, 11000001b						}	\
			__asm {	or		ah, N_FLAG							}	\
			__asm {	mov		cl, dl								}	\
			__asm {	xor		cl, dh								}	\
			__asm {	xor		cl, al								}	\
			__asm {	and		cl, H_FLAG							}	\
			__asm {	or		ah, cl								}	\
			__asm {	xor		al, dl								}	\
			__asm {	xor		dl, dh								}	\
			__asm {	and		al, dl								}	\
			__asm {	rol		al, 3								}	\
			__asm {	and		al, V_FLAG							}	\
			__asm {	or		al, ah								}	\
			__asm {	mov		ah, dh								}	\
			__asm {	mov		R_Z80AF, ax							}	\
			__asm { ret											}

#define	MCR_AND														\
			__asm {	and		al, R_Z80A							}	\
			__asm {	mov		ah, ZSPtable[eax]					}	\
			__asm {	xchg	al, ah								}	\
			__asm {	mov		R_Z80AF, ax							}	\
			__asm { ret											}

#define	MCR_OR														\
			__asm {	or		al, R_Z80A							}	\
			__asm {	mov		ah, ZSPtable[eax]					}	\
			__asm {	xchg	al, ah								}	\
			__asm {	mov		R_Z80AF, ax							}	\
			__asm { ret											}

#define	MCR_XOR														\
			__asm {	xor		al, R_Z80A							}	\
			__asm {	mov		ah, ZSPtable[eax]					}	\
			__asm {	xchg	al, ah								}	\
			__asm {	mov		R_Z80AF, ax							}	\
			__asm { ret											}

#define	MCR_CP														\
			__asm {	mov		dl, R_Z80A							}	\
			__asm {	mov		dh, dl								}	\
			__asm {	sub		dh, al								}	\
			__asm {	lahf										}	\
			__asm {	and		ah, 11000001b						}	\
			__asm {	or		ah, N_FLAG							}	\
			__asm {	mov		cl, dl								}	\
			__asm {	xor		cl, dh								}	\
			__asm {	xor		cl, al								}	\
			__asm {	and		cl, H_FLAG							}	\
			__asm {	or		ah, cl								}	\
			__asm {	xor		al, dl								}	\
			__asm {	xor		dl, dh								}	\
			__asm {	and		al, dl								}	\
			__asm {	rol		al, 3								}	\
			__asm {	and		al, V_FLAG							}	\
			__asm {	or		al, ah								}	\
			__asm {	mov		R_Z80F, al							}	\
			__asm { ret											}


#define	regADD(reg)	{ __asm { mov al, reg } MCR_ADD }
#define	regADC(reg) { __asm { mov al, reg } MCR_ADC }
#define	regSUB(reg) { __asm { mov al, reg } MCR_SUB }
#define	regSBC(reg) { __asm { mov al, reg } MCR_SBC }

#define	regAND(reg)	{ __asm { movzx eax, reg } MCR_AND }
#define	regOR(reg)	{ __asm { movzx eax, reg } MCR_OR }
#define	regXOR(reg)	{ __asm { movzx eax, reg } MCR_XOR }
#define	regCP(reg)	{ __asm { mov al, reg } MCR_CP }


#define	MCR_ADD_W(reg1, reg2)										\
			__asm {	mov		al, R_Z80F							}	\
			__asm {	and		al, (S_FLAG or Z_FLAG or V_FLAG)	}	\
			__asm {	mov		dx, reg1							}	\
			__asm {	mov		bx, dx								}	\
			__asm {	mov		cx, reg2							}	\
			__asm {	add		dx, cx								}	\
			__asm {	adc		al, 0								}	\
			__asm {	xor		ch, bh								}	\
			__asm {	xor		ch, dh								}	\
			__asm {	and		ch, H_FLAG							}	\
			__asm {	or		al, ch								}	\
			__asm {	mov		reg1, dx							}	\
			__asm {	mov		R_Z80F, al							}	\
			__asm {	ret											}

#define	MCR_ADDx2(reg)												\
			__asm {	mov		al, R_Z80F							}	\
			__asm {	and		al, (S_FLAG or Z_FLAG or V_FLAG)	}	\
			__asm {	shl		reg, 1								}	\
			__asm {	adc		al, 0								}	\
			__asm {	test	reg, (H_FLAG shl 8)					}	\
			__asm {	je		addw2_noh							}	\
			__asm {	or		al, H_FLAG							}	\
addw2_noh:	__asm {	mov		R_Z80F, al							}	\
			__asm {	ret											}


#define	MCR_EXX(reg1, reg2)											\
			__asm {	mov		ax, reg1							}	\
			__asm { xchg	reg2, ax							}	\
			__asm {	mov		reg1, ax							}

#define	MCR_EX(reg1, reg2)											\
			MCR_EXX(reg1, reg2)										\
			__asm {	ret											}

#define	MCR_EX_XSP(reg)												\
			__asm {	mov		cx, R_Z80SP							}	\
			__asm {	call	fast_RDMEM_W						}	\
			__asm {	xchg	reg, ax								}	\
			__asm {	mov		dx, ax								}	\
			__asm {	jmp		fast_WRMEM_W						}


#define	MCR_PUSH(reg)												\
			__asm {	mov		dx, reg								}	\
			__asm {	sub		R_Z80SP, 2							}	\
			__asm {	mov		cx, R_Z80SP							}	\
			__asm {	jmp		fast_WRMEM_W						}

#define	MCR_POP(reg)												\
			__asm {	mov		cx, R_Z80SP							}	\
			__asm {	add		R_Z80SP, 2							}	\
			__asm {	call	fast_RDMEM_W						}	\
			__asm {	mov		reg, ax								}	\
			__asm {	ret											}


#define	MCR_RST(adrs)												\
			__asm {	mov		dx, adrs							}	\
			__asm {	xchg	R_Z80PC, dx							}	\
			__asm {	sub		R_Z80SP, 2							}	\
			__asm {	mov		cx, R_Z80SP							}	\
			__asm {	jmp		fast_WRMEM_W						}


#define	MCR_CALL													\
			__asm {	inc		cx									}	\
			__asm {	mov		dx, cx								}	\
			__asm {	add		dx, 2								}	\
			__asm {	call	fast_RDMEM_W						}	\
			__asm {	mov		R_Z80PC, ax							}	\
			__asm {	sub		R_Z80SP, 2							}	\
			__asm {	mov		cx, R_Z80SP							}	\
			__asm {	call	fast_WRMEM_W						}	\
			__asm {	add		Z80_ICount, 7						}	\
			__asm {	ret											}

#define	MCR_CALLFLG(flg)											\
			__asm {	test	R_Z80F, flg							}	\
			__asm {	jne		calloperate							}	\
			__asm {	add		R_Z80PC, 2							}	\
			__asm {	ret											}	\
calloperate:MCR_CALL

#define	MCR_CALLNFLG(flg)											\
			__asm {	test	R_Z80F, flg							}	\
			__asm {	je		calloperate							}	\
			__asm {	add		R_Z80PC, 2							}	\
			__asm {	ret											}	\
calloperate:MCR_CALL

#define	MCR_RETS													\
			__asm {	mov		cx, R_Z80SP							}	\
			__asm {	add		R_Z80SP, 2							}	\
			__asm {	call	fast_RDMEM_W						}	\
			__asm {	mov		R_Z80PC, ax							}	\
			__asm {	add		Z80_ICount, 6						}

#define	MCR_RET														\
			MCR_RETS												\
			__asm {	ret											}

#define	MCR_RETFLG(flg)												\
			__asm {	test	R_Z80F, flg							}	\
			__asm {	je		retoperate							}	\
			MCR_RETS												\
retoperate:	__asm {	ret											}

#define	MCR_RETNFLG(flg)											\
			__asm {	test	R_Z80F, flg							}	\
			__asm {	jne		retoperate							}	\
			MCR_RETS												\
retoperate:	__asm {	ret											}


#define	MCR_JP														\
			__asm {	inc		cx									}	\
			__asm {	call	fast_RDMEM_W						}	\
			__asm {	mov		R_Z80PC, ax							}	\
			__asm {	ret											}

#define	MCR_JPFLG(flg)												\
			__asm {	test	R_Z80F, flg							}	\
			__asm {	jne		jpoperate							}	\
			__asm {	add		R_Z80PC, 2							}	\
			__asm {	ret											}	\
jpoperate:	MCR_JP

#define	MCR_JPNFLG(flg)												\
			__asm {	test	R_Z80F, flg							}	\
			__asm {	je		jpoperate							}	\
			__asm {	add		R_Z80PC, 2							}	\
			__asm {	ret											}	\
jpoperate:	MCR_JP


#define	MCR_JR														\
			__asm {	inc		cx									}	\
			__asm {	call	fast_RDMEM							}	\
			__asm {	cbw											}	\
			__asm {	inc		ax									}	\
			__asm {	add		R_Z80PC, ax							}	\
			__asm {	add		Z80_ICount, 5						}	\
			__asm {	ret											}

#define	MCR_JRFLG(flg)												\
			__asm {	test	R_Z80F, flg							}	\
			__asm {	jne		jroperate							}	\
			__asm {	inc		R_Z80PC								}	\
			__asm {	ret											}	\
jroperate:	MCR_JR

#define	MCR_JRNFLG(flg)												\
			__asm {	test	R_Z80F, flg							}	\
			__asm {	je		jroperate							}	\
			__asm {	inc		R_Z80PC								}	\
			__asm {	ret											}	\
jroperate:	MCR_JR

#define	MCR_DJNZ													\
			__asm {	dec		R_Z80B								}	\
			__asm {	jne		jroperate							}	\
			__asm {	inc		R_Z80PC								}	\
			__asm {	ret											}	\
jroperate:	MCR_JR


#define	MCR_Z80OUT(value)											\
			__asm {	mov		dl, value							}	\
			__asm {	mov		cx, R_Z80BC							}	\
			__asm {	jmp		Z80_Out								}

#define	MCR_Z80INF(reg)												\
			__asm {	mov		cx, R_Z80BC							}	\
			__asm { call	Z80_In								}	\
			__asm {	mov		reg, al								}	\
			__asm { and		R_Z80F, C_FLAG						}	\
			__asm { and		eax, 0ffh							}	\
			__asm { mov		al, ZSPtable[eax]					}	\
			__asm { or		R_Z80F, al							}	\
			__asm {	ret											}

#define	MCR_ADC_W(reg)												\
			__asm {	mov		ah, R_Z80F							}	\
			__asm {	mov		dx, R_Z80HL							}	\
			__asm {	mov		bx, dx								}	\
			__asm {	mov		cx, reg								}	\
			__asm {	sahf										}	\
			__asm {	adc		dx, cx								}	\
			__asm {	lahf										}	\
			__asm {	and		ah, (S_FLAG or Z_FLAG or C_FLAG)	}	\
			__asm {	xor		bh, ch								}	\
			__asm {	mov		al, bh								}	\
			__asm {	xor		al, dh								}	\
			__asm {	and		al, H_FLAG							}	\
			__asm {	xor		bh, 80h								}	\
			__asm {	xor		ch, dh								}	\
			__asm {	and		bh, ch								}	\
			__asm {	rol		bh, 3								}	\
			__asm {	and		bh, V_FLAG							}	\
			__asm {	or		al, ah								}	\
			__asm {	or		al, bh								}	\
			__asm {	mov		R_Z80F, al							}	\
			__asm {	mov		R_Z80HL, dx							}	\
			__asm {	ret											}

#define	MCR_SBC_W(reg)												\
			__asm {	mov		ah, R_Z80F							}	\
			__asm {	mov		dx, R_Z80HL							}	\
			__asm {	mov		bx, dx								}	\
			__asm {	mov		cx, reg								}	\
			__asm {	sahf										}	\
			__asm {	sbb		dx, cx								}	\
			__asm {	lahf										}	\
			__asm {	and		ah, (S_FLAG or Z_FLAG or C_FLAG)	}	\
			__asm {	mov		R_Z80HL, dx							}	\
			__asm {	xor		dh, bh								}	\
			__asm {	mov		al, dh								}	\
			__asm {	xor		al, ch								}	\
			__asm {	and		al, H_FLAG							}	\
			__asm {	xor		ch, bh								}	\
			__asm {	and		ch, dh								}	\
			__asm {	rol		ch, 3								}	\
			__asm {	and		ch, V_FLAG							}	\
			__asm {	or		al, ah								}	\
			__asm {	or		al, ch								}	\
			__asm {	or		al, N_FLAG							}	\
			__asm {	mov		R_Z80F, al							}	\
			__asm {	ret											}
