typedef union {
	struct {
		BYTE	blue;
		BYTE	green;
		BYTE	red;
		BYTE	flag;
	} b;
	DWORD	d;
} PALETTE_TABLE;

#define	START_PAL		0x0a
#define	USE_PALS		0xc0
#define	START_EXT		(START_PAL + USE_PALS)
#define	EXT_PALS		0x28
#define	TOTAL_PALS		(USE_PALS + EXT_PALS)

#define	SCMD_SETWINDOWED	0x01
#define	SCMD_SETFULLSCREEN	0x02
#define	SCMD_SET256			0x04
#define	SCMD_SET65536		0x08
#define	SCMD_XORWINDOWED	0x10
#define	SCMD_XORFULLSCREEN	0x10

#define	SCMD_COLOR8			3
#define	SCMD_COLOR16		2
#define	SCMD_COLOR24		1
#define	SCMD_COLOR32		0

#define	SCMD_COLORMASK		0x03
#define	SCMD_FULLSCRN		0x04
#define	SCMD_WINDOWED		0x08
#define	SCMD_USEPAL			0x10
#define	SCMD_NONPAL			0x20

#define	SCMD_WINDOW8		(SCMD_WINDOWED | SCMD_COLOR8 | SCMD_USEPAL)
#define	SCMD_WINDOW16		(SCMD_WINDOWED | SCMD_COLOR16 | SCMD_NONPAL)
#define	SCMD_WINDOW24		(SCMD_WINDOWED | SCMD_COLOR24 | SCMD_NONPAL)
#define	SCMD_WINDOW32		(SCMD_WINDOWED | SCMD_COLOR32 | SCMD_NONPAL)

#define	SCMD_FSCREEN8		(SCMD_FULLSCRN | SCMD_COLOR8 | SCMD_USEPAL)
#define	SCMD_FSCREEN16		(SCMD_FULLSCRN | SCMD_COLOR16 | SCMD_NONPAL)
#define	SCMD_FSCREEN24		(SCMD_FULLSCRN | SCMD_COLOR24 | SCMD_NONPAL)
#define	SCMD_FSCREEN32		(SCMD_FULLSCRN | SCMD_COLOR32 | SCMD_NONPAL)


#define	X2MODE_WIDTH80		0
#define	X2MODE_WIDTH40		1
#define	X2MODE_4096			2

extern	BYTE			SCREENMODE;
extern	int				xm_palettes;
extern	PALETTE_TABLE	xm_palette[];
extern	BYTE			screenmap[];
extern	BYTE			renewalline[];
extern	BYTE			x2mode;

BYTE xm_setscreenmode(BYTE mode);

void xm_initwindowsize(WORD width, WORD height);
void xm_windowstats(void);
void xm_wincenter(void);

void xm_xmilsystempal(void);
void xm_xmilsyspalset(PALETTE_TABLE *degpal);

void ddraws_init(void);
int xm_InitDirectDraw(void);
void xm_TermDirectDraw(void);

void scrn_draws(void);
void scrn_drawall(void);
void scrn_palette(void);
void change_palette(void);
void change_xmode(BYTE x2flag);
WORD ddraw16bitpal(PALETTE_TABLE pal);

void mx_topwinui(void);
void mx_clearwinui(void);
void ddraws_redraw(void);
void change_drawlines(DWORD lines);
BYTE scrn_restore(void);

BYTE scrn_draw1(DWORD linepos);
