#include	<windows.h>
#include	<stdio.h>
#include	"common.h"
#include	"xmil.h"
#include	"x1.h"
#include	"x1_crtc.h"
#include	"x1_pcg.h"
#include	"x1_vram.h"
#include	"draw.h"
#include	"ddraws.h"
#include	"draw.mcr"
#include	"palettes.h"
#include	"draw_sub.h"

		BYTE	updatetmp[0x800+0x101];
		BYTE	scrnflash;
		BYTE	scrnallflash;
		BYTE	doubleatrchange;
		BYTE	palandply;
		BYTE	blinkflag;
		BYTE	blinktest = 0;

extern	BYTE	screenmap[];
extern	BYTE	dispmode;
extern	BYTE	pal_disp;

static	BYTE	lastdisp = 0;
		BYTE	dispflg = UPDATE_VRAM0;
		BYTE	*dispp = &GRP_RAM[GRAM_BANK0];
		BYTE	*dispp2 = &GRP_RAM[GRAM_BANK1];
		WORD	vramsize;
		BYTE	fontlpcnt;
		BYTE	vramylpcnt;
		WORD	vramylpad;
static	BYTE	blinktime = 1;

static	BYTE	ddrawflash = 0;
static	WORD	drawlines = 200;
		BYTE	fonttype = 0;
		BYTE	disp_flashscreen = 1;


void textdrawproc_renewal(void) {

	fonttype = 0;
	if (!(crtc.SCRN_BITS & SCRN_24KHZ)) {
		if (xmilcfg.TEXTMODE) {
			fonttype = KNJ_24KHz;
		}
	}
	else {
		fonttype = ANK_24KHz | KNJ_24KHz;
	}
	scrnallflash = 1;
}


void init_draw(void) {

	fontlpcnt = 8;
	vramylpcnt = 8;
	vramylpad = 160 * 16;
	vramsize = 40*25;

	init_drawtable();
	reflesh_palette();
	lastdisp = 0;
	dispflg = UPDATE_VRAM0;
	dispp = &GRP_RAM[GRAM_BANK0];
}


void fillupdatetmp(void) {

		__asm {
				mov		ebx, offset updatetmp
				mov		ecx, 0x200
filludt_lp:		or		dword ptr [ebx], (UPDATE_TVRAM * 01010101h)
				add		ebx, 4
				loop	filludt_lp
		}
}


static LABEL void flashupdatetmp(void) {

		__asm {
				push	ebx
				push	esi
				push	edi

				movzx	esi, crtc.TXT_TOP
				xor		dl, dl
										// ܂sׂĂc{pׂ
check_tateflag:	mov		edi, esi
				movzx	ecx, crtc.TXT_XL
tateflaglp_s:	cmp		di, TRAM_MAX
				jae		tatex2
				test	TXT_RAM[edi + TEXT_ATR], X1ATR_Yx2
				je		tatex1
				inc		di
				loop	tateflaglp_s
										// ׂďc{p 

tatex2:			movzx	ecx, crtc.TXT_XL
				shr		cl, 1

tatex2loop_s:	cmp		si, TRAM_MAX
				jae		flashupdatetmp_end
				mov		ax, (UPDATE_TVRAM or 04h) * 0101h		// c{p
				mov		bx, word ptr (TXT_RAM[esi + TEXT_ATR])

				test	bl, X1ATR_Xx2
				je		tatex2_norleft
												// {ptOĂ
				or		ax, 08h + 12h * 256		// S{p + Ec{p͊m
				test	bh, X1ATR_Xx2
				je		tatex2_pcg
				or		ah, 8					// E{prbgĂ
				jmp		tatex2_pcg

tatex2_norleft:	test	bh, X1ATR_Xx2			// S{płȂꍇ
				je		tatex2_pcg
				or		ah, 8					// Êݔ{p
tatex2_pcg:		mov		bx, word ptr (updatetmp[esi])
				and		bx, UPDATE_TVRAM * 0101h
				or		ax, bx					// UPDATEtO
				cmp		word ptr (updatetmp[esi]), ax
				je		tatex2noupdate
				or		ax, UPDATE_TVRAM * 0101h
				mov		word ptr (updatetmp[esi]), ax
tatex2noupdate:	add		si, 2
				loop	tatex2loop_s
				jmp		nextlinecheck

tatex1:			movzx	ecx, crtc.TXT_XL
				shr		cl, 1
				xor		dh, dh
tatex1loop_s:	cmp		si, TRAM_MAX
				jae		flashupdatetmp_end
				xor		ax, ax
				mov		bx, word ptr (TXT_RAM[esi + TEXT_ATR])
				or		dh, dh					// cm[}͊ɂH
				jne		tatex1_tate_e
				test	bl, X1ATR_Yx2
				je		tatex1_tate0
				mov		al, UPDATE_TVRAM or 1	// ׂc{p
				test	bh, X1ATR_Yx2
				je		tatex1_tate0
				mov		ah, UPDATE_TVRAM or 1	// Eׂc{p
				jmp		tatex1_tate_e
tatex1_tate0:	inc		dh						// cm[}̏o
tatex1_tate_e:
				test	bl, X1ATR_Xx2
				je		tatex1_norleft
												// {ptOĂ
				or		ax, 08h + (12h * 256)	// {p ͊m
				test	bh, X1ATR_Xx2
				je		tatex1_pcg
				or		ah, 8					// E{prbgĂ
				jmp		tatex1_pcg

tatex1_norleft:	test	bh, X1ATR_Xx2			// {płȂꍇ
				je		tatex1_pcg
				or		ah, 8					// Êݔ{p
tatex1_pcg:		mov		bx, word ptr (updatetmp[esi])
				and		bx, UPDATE_TVRAM * 0101h
				or		ax, bx
				cmp		word ptr (updatetmp[esi]), ax
				je		tatex1noupdate
				or		ax, UPDATE_TVRAM * 0101h
				mov		word ptr (updatetmp[esi]), ax
tatex1noupdate:	add		si, 2
				loop	tatex1loop_s

nextlinecheck:	inc		dl
				cmp		dl, crtc.TXT_YL
				jb		check_tateflag
flashupdatetmp_end:
				pop		edi
				pop		esi
				pop		ebx
				ret
	}
}



void updateblink(void) {

		__asm {
				dec		blinktime
				jns		blinkupflg_ed
				mov		blinktime, 30-1
				push	edi
				movzx	edi, crtc.TXT_TOP
				mov		ax, 010h
				xor		blinktest, al
				mov		cx, vramsize
				or		cx, cx
				je		blinkupflg

blinkup_lp:		test	TXT_RAM[edi + TEXT_ATR], al
				je		short blinknup_ed
				mov		ah, UPDATE_TVRAM
				or		updatetmp[edi], ah
blinknup_ed:	inc		edi
				dec		cx
				jne		blinkup_lp
				or		scrnflash, ah
				shr		ah, 5
blinkupflg:		pop		edi
				mov		blinkflag, ah
blinkupflg_ed:
		}
}


// ---------------------------------------------------------------------------

void pal4096to64(PALETTE_TABLE *pal, WORD *map) {

	int		p = 64;

	while(p--) {
		pal->d = GRPHPAL4096[*map++].d;
		pal++;
	}
}

void palettes(void) {

	int		i, j;
	BYTE	bit;
	BYTE	c;
	BYTE	skip8 = 0;
	BYTE	skip16 = 0;

	if (pal_disp & PAL_4096) {
		switch(pal_disp & 0xf) {
			case PAL_4096H:
				pal4096to64(xm_palette, PAL4096_BANK0);
				xm_palettes = 64;

				break;
			case PAL_4096L:
				pal4096to64(xm_palette, PAL4096_BANK1);
				xm_palettes = 64;
				break;
			case (PAL_4096H | PAL_64x2):
				pal4096to64(&xm_palette[ 0], PAL4096_BANK0);
				pal4096to64(&xm_palette[64], PAL4096_BANK1);
				xm_palettes = 128;
				break;
			case (PAL_4096L | PAL_64x2):
				pal4096to64(&xm_palette[ 0], PAL4096_BANK1);
				pal4096to64(&xm_palette[64], PAL4096_BANK0);
				xm_palettes = 128;
				break;
			default:						// fullcolor!
				return;
		}
		for (i=0; i<8; i++) {
			xm_palette[xm_palettes++].d = TEXTPALS[i].d;
		}
	}
	else if ((dispmode & SCRN64_MASK) == SCRN64_INVALID) {
		if ((xmilcfg.SKIP_LINE) && (!(crtc.SCRN_BITS & SCRN_24KHZ))) {
			skip8 = 8;
			skip16 = 16;
		}
		for (i=0, bit=1; i<8; i++, bit<<=1) {
			if (!(crtc.EXTPALMODE & 0x80)) {
				c = 0;
				if (crtc.PAL_B & bit) {
					c |= 1;
				}
				if (crtc.PAL_R & bit) {
					c |= 2;
				}
				if (crtc.PAL_G & bit) {
					c |= 4;
				}
			}
			else {
				c = i;
			}
			xm_palette[i].d = GRPHPALS[pal_disp][c].d;
			xm_palette[i+64].d = xm_palette[i+128].d
										= GRPHPALS[pal_disp][c+skip8].d;
			if (crtc.PLY & bit) {
				for (j=i+8; j<64; j+=8) {
					xm_palette[j].d = xm_palette[i].d;
					xm_palette[j+64].d = xm_palette[j+128].d
													= xm_palette[i+64].d;
				}
			}
			else {
				BYTE cnt = (crtc.BLACKPAL & 15) - 8;
				for (j=i+8; j<64; j+=8) {
					if (--cnt) {
						c = crtc.TEXT_PAL[j>>3];
					}
					else {
						c = 0;
					}
					xm_palette[j].d = TEXTPALS[c].d;
					xm_palette[j+64].d = TEXTPALS[c+skip8].d;
					xm_palette[j+128].d = TEXTPALS[c+skip16].d;
				}
			}
		}
		for (i=0; i<24; i++) {
			xm_palette[i+192].d = TEXTPALS[i].d;
		}
		for (i=0; i<16; i++) {
			xm_palette[i+192+24].d = GRPHPALS[pal_disp][i].d;
		}
		xm_palettes = 64+64+64+24+16;
	}
	else {
		for (i=0; i<64; i++) {
			xm_palette[i].d = GRPHPALS64[pal_disp][i].d;
		}
		for (i=0; i<8; i++) {
			xm_palette[i+64].d = TEXTPALS[i].d;
		}
		xm_palettes = 64+8;
	}
	change_palette();
}


static void x1vram_adjust(void) {

	BYTE	maxline;
	BYTE	underlines = 0;

	if (crtc.TXT_XL <= 40) {
		if (dispmode & SCRN_DRAW4096) {
			change_xmode(X2MODE_4096);
		}
		else {
			change_xmode(X2MODE_WIDTH40);
		}
	}
	else {
		change_xmode(X2MODE_WIDTH80);
	}

	fontlpcnt = (BYTE)crtc.FNT_YL;
	if (crtc.SCRN_BITS & SCRN_24KHZ) {
		fontlpcnt >>= 1;
	}
	if (crtc.SCRN_BITS & SCRN_UNDERLINE) {
		fontlpcnt -= 2;
		underlines = 2;
	}
	if (crtc.SCRN_BITS & SCRN_TEXTYx2) {
		fontlpcnt >>= 1;
		fontlpcnt &= 0xfe;
		if (((dispmode & SCRN64_MASK) == SCRN64_INVALID) && (fontlpcnt > 8)) {
			fontlpcnt = 8;
		}
		else if (fontlpcnt < 2) {
			fontlpcnt = 2;
		}
		else if (fontlpcnt > 32) {
			fontlpcnt = 32;
		}
		vramylpcnt = fontlpcnt + underlines;
		vramylpad = vramylpcnt * (SCREEN_WIDTH / 4) * 4;
		maxline = (BYTE)100 / vramylpcnt;
		if (maxline > crtc.TXT_YL) {
			maxline = crtc.TXT_YL;
		}
		vramsize = maxline * crtc.TXT_XL;
		drawlines = maxline * vramylpcnt * 2;
	}
	else {
		fontlpcnt &= 0xfe;
		if (((dispmode & SCRN64_MASK) == SCRN64_INVALID) && (fontlpcnt > 8)) {
			fontlpcnt = 8;
		}
		else if (fontlpcnt < 2) {
			fontlpcnt = 2;
		}
		else if (fontlpcnt > 32) {
			fontlpcnt = 32;
		}
		vramylpcnt = fontlpcnt + underlines;
		vramylpad = vramylpcnt * (SCREEN_WIDTH / 4) * 2;
		maxline = (BYTE)200 / vramylpcnt;
		if (maxline > crtc.TXT_YL) {
			maxline = crtc.TXT_YL;
		}
		vramsize = maxline * crtc.TXT_XL;
		drawlines = maxline * vramylpcnt;
	}
	change_drawlines(drawlines*2);
	if (vramsize >= (0x800 - crtc.TXT_TOP)) {
		vramsize = 0x800 - crtc.TXT_TOP;
	}
}

// -------------------------------------------------------------------------

static void (*screendraw[8])(void) = {
				width80x25_200line, width80x25_400line,
				width80x25_200line, width80x25_200line,
				width80x12_200line, width80x12_400line,
				width80x12_200line, width80x12_200line};

static void (*screendraw2[8])(void) = {
				width80x20_15khz, width80x20_24khz,
				width80x20_15khz, width80x20_24khz,
				width80x10_15khz, width80x10_24khz,
				width80x10_15khz, width80x10_24khz};


void scrnupdate(void) {

static	BYTE	framecnt = 0;
static	BYTE	disableraster = 0;

	if (disp_flashscreen) {
		if (++framecnt < xmilcfg.DRAW_SKIP) {
			return;
		}
		framecnt = 0;
	}
	else {
		if (ddrawflash) {
			ddrawflash = 0;
			scrn_drawall();
		}
	}

	if (lastdisp != dispmode) {
		lastdisp = dispmode;
		scrnallflash = 1;
		palandply = 1;
		if (!(dispmode & SCRN_BANK1)) {
			dispp = &GRP_RAM[GRAM_BANK0];
			dispp2 = &GRP_RAM[GRAM_BANK1];
			dispflg = UPDATE_VRAM0;
		}
		else {
			dispp = &GRP_RAM[GRAM_BANK1];
			dispp2 = &GRP_RAM[GRAM_BANK0];
			dispflg = UPDATE_VRAM1;
		}
	}
	if (scrnallflash) {
		scrnallflash = 0;
		fillupdatetmp();
		x1vram_adjust();
		scrnflash = 1;
	}
	if (doubleatrchange) {
		flashupdatetmp();
		doubleatrchange = 0;
	}
	if (palandply) {
		palandply = 0;
		palettes();
		ddrawflash = 1;
	}
	if (blinkflag) {
		updateblink();
	}

	if (scrnflash) {
		scrnflash = 0;
		switch(lastdisp & SCRN64_MASK) {
			case SCRN64_320x200:
				width40x25_64s();
				disableraster = 1;
				break;
			case SCRN64_L320x200x2:
				width40x25_64x2();
				disableraster = 1;
				break;
			case SCRN64_L640x200:
				width80x25_64s();
				disableraster = 1;
				break;
			case SCRN64_H320x400:
				width40x25_64h();
				disableraster = 1;
				break;
			case SCRN64_320x200x4096:
				width40x25_4096();
				disableraster = 1;
				break;
			case SCRN64_320x100:
				width40x12_64l();
				disableraster = 1;
				break;
			case SCRN64_320x100x2:
				width40x12_64x2();
				disableraster = 1;
				break;
			case SCRN64_L640x100:
				width80x12_64s();
				disableraster = 1;
				break;
			case SCRN64_H320x200:
				width40x12_64h();
				disableraster = 1;
				break;
			case SCRN64_320x100x4096:
				width40x12_4096();
				disableraster = 1;
				break;
//			case SCRN64_INVALID:
			default:
				if (!(crtc.SCRN_BITS & SCRN_UNDERLINE)) {
					screendraw[crtc.SCRN_BITS & 7]();
				}
				else {
					screendraw2[crtc.SCRN_BITS & 7]();
				}
				disableraster = 0;
				break;
		}
		ddrawflash = 1;
	}
	disp_flashscreen = xmilcfg.DRAW_SKIP | disableraster;

	if (ddrawflash) {
		if (disp_flashscreen) {
			ddrawflash = 0;
			scrn_draws();
			scrn_drawall();
		}
	}
	else {
		ddrawflash = scrn_restore();
	}
}



void scrnupdate1line(DWORD line) {

	if (line < drawlines) {
		if (palandply) {
			palandply = 0;
			palettes();
			ddrawflash = 1;
		}
		ddrawflash |= scrn_draw1(line*2);
		ddrawflash |= scrn_draw1(line*2+1);
	}
}

