#include	<windows.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<stdarg.h>
#include	<math.h>
#include	"dsounds.h"
#include	"opm.h"
#include	"opmcore.h"
#include	"dosio.h"
#include	"menu.h"

#define	OPM_CHAN(N)	(N & 7)
#define	OPM_SLOT(N)	((N >> 3)&3)

		OPM_CH	OPMCH[MAXCHANNEL];

extern	long	detunetable[8][32];
extern	long	attacktable[94];
extern	long	decaytable[94];
extern	long	keycodetable[];
extern	WORD	env_curve[];
extern	WORD	halftunetable[];
extern	WORD	detune2table[];
extern	long	decayleveltable[];
extern	BYTE	multipletable[];
extern	long	nulltable[];

		BYTE	opmmode;
		long	outdl;
		long	outdc;
		long	outdr;
		long	feedback2;
		long	feedback3;
		long	feedback4;

		PSG_CH	PSGCH[3];
		PSG_T	psg;

		BYTE	psgenv_mod = 0;
		BYTE	psgenv_vol = 0;
		BYTE	psgenv_volcnt = 0;
		WORD	psgenv_cnt = 0;
		WORD	psgenv_max = 0;

		DWORD	psgbase = (25000L << (16-2)) / (22050 / 5);

		WORD	psgnoise_cnt;
		WORD	psgnoise_freq;
		WORD	psgnoise_table[16];

extern	WORD	psg_puchidec;

static	BYTE	psgenv_pat[16] = {
					PSGENV_ONESHOT,
					PSGENV_ONESHOT,
					PSGENV_ONESHOT,
					PSGENV_ONESHOT,
					PSGENV_ONESHOT | PSGENV_INC,
					PSGENV_ONESHOT | PSGENV_INC,
					PSGENV_ONESHOT | PSGENV_INC,
					PSGENV_ONESHOT | PSGENV_INC,
					PSGENV_ONECYCLE,
					PSGENV_ONESHOT,
					0,
					PSGENV_ONESHOT | PSGENV_LASTON,
					PSGENV_ONECYCLE | PSGENV_INC,
					PSGENV_ONESHOT | PSGENV_INC | PSGENV_LASTON,
					PSGENV_INC,
					PSGENV_ONESHOT | PSGENV_INC};

extern	BYTE	inx1f_status = 0;
		WORD	inx1f_counter = 0;
static	FILEH	opmh = (FILEH)-1;
static	int		bufcnt = 0;
static	WORD	opmbuf[256];
static	BYTE	fmop[256];

static void keyon_off(OPM_CH *CH, BYTE value) {

	int			i;
	BYTE		b;
	OPM_SLOT	*SLOT = &CH->SLOT[0];

	for (i=0,b=0x8; i<4; i++,b<<=1,SLOT++) {
		if (value & b) {							// keyon
			if (SLOT->env_mode <= EM_RELEASE) {
				SLOT->freq_cnt = 0;
				if (i == SLOT1) {
					CH->op1fb = 0;
				}
				SLOT->env_mode = EM_ATTACK;
				SLOT->env_inc = SLOT->env_inc_attack;
				SLOT->env_cnt = EC_ATTACK;
				SLOT->env_end = EC_DECAY;
			}
		}
		else {										// keyoff
			if (SLOT->env_mode > EM_RELEASE) {
				SLOT->env_mode = EM_RELEASE;
				if (!(SLOT->env_cnt & EC_DECAY)) {
					SLOT->env_cnt = ((long)env_curve[SLOT->env_cnt >> \
											ENV_BITS] << ENV_BITS) + EC_DECAY;
				}
				SLOT->env_end = EC_OFF;
				SLOT->env_inc = SLOT->env_inc_release;
			}
		}
	}
}


static void set_algorhythm(OPM_CH *CH, BYTE value) {

	long	*outd;

	switch(value & 0xc0) {
		case 0x40:
			outd = &outdl;
			break;
		case 0x80:
			outd = &outdr;
			break;
		default:
			outd = &outdc;
			break;
	}
	switch(value & 7) {
		case 0:
			CH->connect1 = &feedback2;
			CH->connect2 = &feedback3;
			CH->connect3 = &feedback4;
			break;
		case 1:
			CH->connect1 = &feedback3;
			CH->connect2 = &feedback3;
			CH->connect3 = &feedback4;
			break;
		case 2:
			CH->connect1 = &feedback4;
			CH->connect2 = &feedback3;
			CH->connect3 = &feedback4;
			break;
		case 3:
			CH->connect1 = &feedback2;
			CH->connect2 = &feedback4;
			CH->connect3 = &feedback4;
			break;
		case 4:
			CH->connect1 = &feedback2;
			CH->connect2 = outd;
			CH->connect3 = &feedback4;
			break;
		case 5:
			CH->connect1 = 0;
			CH->connect2 = outd;
			CH->connect3 = outd;
			break;
		case 6:
			CH->connect1 = &feedback2;
			CH->connect2 = outd;
			CH->connect3 = outd;
			break;
		case 7:
			CH->connect1 = outd;
			CH->connect2 = outd;
			CH->connect3 = outd;
	}
	CH->connect4 = outd;
}


static void set_dt1_mul(OPM_SLOT *SLOT, BYTE value) {

	SLOT->multiple = multipletable[value&0x0f];
	SLOT->detune1 = detunetable[(value>>4)&7];
}


static void set_tl(OPM_SLOT *SLOT, BYTE value) {

	SLOT->totallevel = ((~value) & 0x007f) << (EVC_BITS - 7);
}


static void set_ks_ar(OPM_SLOT *SLOT, BYTE value) {

	SLOT->keyscale = (BYTE)(((~value)>>6)&3);
	SLOT->attack = (value&=0x1f) ? &attacktable[value<<1] : nulltable;
	SLOT->env_inc_attack = SLOT->attack[SLOT->envraito];
	if (SLOT->env_mode == EM_ATTACK) {
		SLOT->env_inc = SLOT->env_inc_attack;
	}
}


static void set_d1r(OPM_SLOT *SLOT, BYTE value) {

	SLOT->decay1 = (value&=0x1f) ? &decaytable[value<<1] : nulltable;
	SLOT->env_inc_decay1 = SLOT->decay1[SLOT->envraito];
	if (SLOT->env_mode == EM_DECAY1) {
		SLOT->env_inc = SLOT->env_inc_decay1;
	}
}


static void set_dt2_d2r(OPM_SLOT *SLOT, BYTE value) {

	SLOT->detune2 = detune2table[value>>6];
	SLOT->decay2 = (value&=0x1f) ? &decaytable[value<<1] : nulltable;
	SLOT->env_inc_decay2 = SLOT->decay2[SLOT->envraito];
	if (SLOT->env_mode == EM_DECAY2) {
		SLOT->env_inc = SLOT->env_inc_decay2;
	}
}


static void set_d1l_rr(OPM_SLOT *SLOT, BYTE value) {

	SLOT->decaylevel = decayleveltable[(value>>4)];
	SLOT->release = &decaytable[((value&0x0f)<<2)|2];
	SLOT->env_inc_release = SLOT->release[SLOT->envraito];
	if (SLOT->env_mode == EM_RELEASE) {
		SLOT->env_inc = SLOT->env_inc_release;
	}
}


static void OPMchannleupdate(OPM_CH *CH) {

	int			i;
	WORD		fc = CH->keynote;
	BYTE		kc = CH->kcode;
	BYTE		evr;
	OPM_SLOT	*SLOT;

	SLOT = &CH->SLOT[0];
	for (i=0; i<4; i++, SLOT++) {
		SLOT->freq_inc = SLOT->detune1[kc];
		SLOT->freq_inc = (keycodetable[fc + SLOT->detune2] + SLOT->detune1[kc]) * SLOT->multiple;
		evr = (BYTE)(kc >> SLOT->keyscale);
		if (SLOT->envraito != evr) {
			SLOT->envraito = evr;
			SLOT->env_inc_attack = SLOT->attack[evr];
			SLOT->env_inc_decay1 = SLOT->decay1[evr];
			SLOT->env_inc_decay2 = SLOT->decay2[evr];
			SLOT->env_inc_release = SLOT->release[evr];
		}
	}
}


//-----------------------------------------------------------------------------


void INX1F_reset(void) {

	int		i, j;

	opmmode = 0;
	for(i=0; i<MAXCHANNEL; i++) {
		OPMCH[i].keynote = 0;
		for(j=0; j<4; j++) {
			OPMCH[i].SLOT[j].env_mode = EM_OFF;
			OPMCH[i].SLOT[j].env_cnt = EC_OFF;
			OPMCH[i].SLOT[j].env_end = EC_OFF+1;
			OPMCH[i].SLOT[j].env_inc = 0;

			OPMCH[i].SLOT[j].detune1 = detunetable[0];
			OPMCH[i].SLOT[j].attack = nulltable;
			OPMCH[i].SLOT[j].decay1 = nulltable;
			OPMCH[i].SLOT[j].decay2 = nulltable;
			OPMCH[i].SLOT[j].release = &decaytable[0];
		}
	}
	for (i=0x20; i<0x100; i++) {
		INX1F_OPMctrl((BYTE)i, 0);
	}

	for (i=0; i<14; i++) {
		INX1F_PSGctrl((BYTE)i, 0);
	}
	INX1F_PSGctrl(7, 0x3f);
}


void INX1F_init(void) {

	INX1F_inittable();
	INX1F_reset();
}


static void setopmbuf(WORD value) {

	opmbuf[bufcnt] = value;
	if (++bufcnt >= 256) {
		file_write(opmh, (byte far *)opmbuf, 256*2);
		bufcnt = 0;
	}
}

static void setopmcnt(void) {

	if (inx1f_counter) {
		if (inx1f_counter & 0xff00) {
			setopmbuf(0);
		}
		setopmbuf(inx1f_counter);
		inx1f_counter = 0;
	}
}

void INX1F_logging(void) {

	LPSTR	r;
	BYTE	i;

	if (!inx1f_status) {
		if ((r = savefileselect("X1 OPM Log File\0*.x1f\0",
						"OPML%04u.X1F", "x1f", "OPM LOG̕ۑ")) != NULL) {
			inx1f_counter = 0;
			if ((opmh = file_create(r)) != (FILEH)-1) {
				bufcnt = 0;
				memcpy(fmop, "X1F", 4);
				file_write(opmh, fmop, 256);
				for (i=0; i<14; i++) {
					setopmbuf(0x0200 | i);
					setopmbuf(0x0300 | psg.data[i]);
				}
				inx1f_status = 1;
				xmenu_opmlog(1);
			}
		}
	}
	else {
		inx1f_status = 0;
		xmenu_opmlog(0);
		if (opmh != (FILEH)-1) {
			if (bufcnt) {
				file_write(opmh, opmbuf, bufcnt*2);
				bufcnt = 0;
			}
			file_close(opmh);
		}
	}
}

void INX1F_OPMctrl(BYTE reg, BYTE value) {

	BYTE		c;
	OPM_CH		*CH;
	OPM_SLOT	*SLOT;

	fmop[reg] = value;
	if ((inx1f_status) && ((reg >= 8) || (reg == 1))) {
		setopmcnt();
		setopmbuf(((WORD)reg << 8) | value);
	}
	c    = (BYTE)OPM_CHAN(reg);
	CH   = &OPMCH[c];
	SLOT = &CH->SLOT[OPM_SLOT(reg)];

	switch(reg & 0xe0) {
		case 0x00:
			switch(reg) {
				case 0x08:				// key on/off
					c = (BYTE)(value & 7);
					keyon_off(&OPMCH[c], value);
					break;
				case 0x14:				// mode
					opmmode = value;
					if ((value & 0x81) == 0x81) {
						for (c=0; c<8; c++) {
							BYTE i, b;
							SLOT = &OPMCH[c].SLOT[0];
							for (i=0,b=0x8; i<4; i++,b<<=1,SLOT++) {
								SLOT->freq_cnt = 0;
								if (i == SLOT1) {
									CH->op1fb = 0;
								}
								SLOT->env_mode = EM_ATTACK;
								SLOT->env_inc = SLOT->env_inc_attack;
								SLOT->env_cnt = EC_ATTACK;
								SLOT->env_end = EC_DECAY;
							}
						}
					}
					break;
			}
			break;
		case 0x20:
			switch(reg & 0x18) {
				case 0x00: 			// pan feedback connection
					CH->algorhythm = (BYTE)(value&7);
					CH->feedback = (BYTE)((8-((value>>3)&7))&7);
										// case 0: ret(0) / other ret(8-fb)
					set_algorhythm(CH, value);
					break;
				case 0x08:			// keycode
					CH->kcode = (BYTE)((value>>2) & 0x1f);
					CH->keynote = (((value>>4)&7) * (12 << KF_BITS)) +
									halftunetable[value&0x0f] + CH->keyfunc;
					OPMchannleupdate(CH);
					break;
				case 0x10:			// keyfunction
					CH->keynote &= (0xffff << KF_BITS);
					CH->keyfunc = (BYTE)(value >> (8-KF_BITS));
					CH->keynote |= CH->keyfunc;
					OPMchannleupdate(CH);
					break;
			}
			break;
		case 0x40:					// DT1 MUL
			set_dt1_mul(SLOT, value);
			OPMchannleupdate(CH);
			break;
		case 0x60:					// TL
			set_tl(SLOT, value);
			break;
		case 0x80:					// KS AR
			set_ks_ar(SLOT, value);
			OPMchannleupdate(CH);
			break;
		case 0xa0:					// D1R
			set_d1r(SLOT, value);
			break;
		case 0xc0:					// DT2 D2R
			set_dt2_d2r(SLOT, value);
			OPMchannleupdate(CH);
			break;
		case 0xe0:					// D1L RR
			set_d1l_rr(SLOT, value);
			break;
	}
}

void INX1F_PSGctrl(BYTE reg, BYTE value) {

	psg.data[reg] = value;
	if (inx1f_status) {
		setopmcnt();
		setopmbuf(0x0200 | reg);
		setopmbuf(0x0300 | value);
	}
	switch(reg) {
		case 0: case 1:
			if ((psg.val.tune1 & 0x0fff) >= 10) {
				PSGCH[0].psg_freq = (WORD)(psgbase / (psg.val.tune1 & 0xfff));
			}
			else {
				PSGCH[0].psg_freq = 0;
			}
			break;
		case 2: case 3:
			if ((psg.val.tune2 & 0x0fff) >= 10) {
				PSGCH[1].psg_freq = (WORD)(psgbase / (psg.val.tune2 & 0xfff));
			}
			else {
				PSGCH[1].psg_freq = 0;
			}
			break;
		case 4: case 5:
			if ((psg.val.tune3 & 0x0fff) >= 10) {
				PSGCH[2].psg_freq = (WORD)(psgbase / (psg.val.tune3 & 0xfff));
			}
			else {
				PSGCH[2].psg_freq = 0;
			}
			break;
		case 6:
			{
				int		i;
				int		value;
				int		freq;

				if ((value = psg.val.noise & 0x1f) == 0) {
					value = 1;
				}
				else {
					value <<= 1;
				}
				for (i=0; i<16; i++) {
					value++;
					if ((freq = (psgbase >> 1) / value) > 0xffffL) {
						freq = 0xffffL;
					}
					psgnoise_table[i] = (WORD)freq;
				}
				psgnoise_freq = psgnoise_table[0];
			}
			break;
		case 8:
			if (psg.val.vol1 & 0x10) {
				PSGCH[0].psg_volp = &psgenv_vol;
			}
			else {
				psg.val.vol1 &= (byte)0xf;
				PSGCH[0].psg_volp = &psg.val.vol1;
			}
			PSGCH[0].psg_puchinoise = psg_puchidec;
			break;
		case 9:
			if (psg.val.vol2 & 0x10) {
				PSGCH[1].psg_volp = &psgenv_vol;
			}
			else {
				psg.val.vol2 &= (byte)0xf;
				PSGCH[1].psg_volp = &psg.val.vol2;
			}
			PSGCH[1].psg_puchinoise = psg_puchidec;
			break;
		case 10:
			if (psg.val.vol3 & 0x10) {
				PSGCH[2].psg_volp = &psgenv_vol;
			}
			else {
				psg.val.vol3 &= (byte)0xf;
				PSGCH[2].psg_volp = &psg.val.vol3;
			}
			PSGCH[2].psg_puchinoise = psg_puchidec;
			break;
		case 11: case 12:
			if ((psgenv_max = (WORD)((DWORD)ds_rate * psg.val.envtime
												/ 125000L)) == 0) {
				psgenv_max = 1;
			}
			break;
		case 13:
			psgenv_mod = psgenv_pat[psg.val.env & 0x0f];
			psgenv_volcnt = 16;
			psgenv_cnt = 1;
			break;
	}
}


void INX1F_alltrash(void) {

	if (inx1f_status) {
		INX1F_logging();
	}
}
