#include	<windows.h>
#include	"common.h"
#include	"x1.h"
#include	"dosio.h"

// FM-7͏LĂȂׁAtHgtFCXɂĂ m[`FbN

static	char	ankfontname[] = "SUBSYS_C.ROM";
static	char	knjfontname[] = "KANJI.ROM";

typedef struct {
	BYTE	x1ank;
	BYTE	extank;
	BYTE	count;
} ANKCNV_TABLE;


ANKCNV_TABLE	extcnv[] = {
						// X68K, PC-88, FM-7
						{0x20, 0x20, 0x5f}, {0xa0, 0xa0, 0x40},
						// PC-88, FM-7
						{0x80, 0x80, 0x0f}, {0x8f, 0xee, 0x01},
						{0x90, 0x95, 0x02}, {0x92, 0x90, 0x04},
						{0x96, 0x8f, 0x01}, {0x97, 0x99, 0x01},
						{0x98, 0x9b, 0x01}, {0x99, 0x9a, 0x01},
						{0x9a, 0x98, 0x01}, {0x9b, 0x9d, 0x03},
						{0x9e, 0x9c, 0x01}, {0x9f, 0xef, 0x01},
						{0xe0, 0xec, 0x02}, {0xe2, 0xe8, 0x04},
						{0xe6, 0xe4, 0x02}, {0xe8, 0xf0, 0x01},
						{0xf6, 0xf3, 0x05}, {0xfb, 0xf2, 0x01},
						{0xfc, 0xf1, 0x01},
						// FM-7
						{0xf0, 0xfe, 0x01}, {0xfd, 0xfd, 0x01},
						{0xff, 0xf8, 0x01}};


											// vg^Cv
void ank8cnv(BYTE *src, int datacount);		// FM-7 datacount = 24
void fm7ankcpy(BYTE *dst, BYTE *src, WORD from, WORD to);
void fm7sjiscpy(BYTE *dst, BYTE *src, WORD from, WORD to);


// FM-7̃tHg gp
BYTE fm7fontread(BYTE loaded) {

	FILEH	fh;
	BYTE	loaded7font = 0;
	HANDLE	hwork;
	BYTE	*work;

	// A[P[g
	if ((hwork = GlobalAlloc(GPTR, 0x20000)) == NULL) {
		return(0);							// A[P[gɎs
	}

	// bNyу|C^擾
	if ((work = (BYTE *)GlobalLock(hwork)) == NULL) {
		GlobalFree(hwork);					// A[P[gɎs
		return(0);
	}


	// 8dot ANKǂݍޕKv͂H
	if (!(loaded & FONT_ANK8)) {

		// ǂݍł݂
		if ((fh = file_open_c(ankfontname)) != (FILEH)-1) {

			// Ƃ肠ǂ
			file_read(fh, work, 2048);
			file_close(fh);
			ank8cnv(work, 24);
			loaded7font |= FONT_ANK8;
		}
	}

	// 16dot ASCII y ǂݍޕKv͂邩H
	if ((~loaded) & (FONT_ANK16a | FONT_KNJ1)) {

		// ǂݍł݂
		if ((fh = file_open_c(knjfontname)) != (FILEH)-1) {
			if (file_lread(fh, work, 0x20000) == 0x20000) {

				// 16dot ASCIIǂݍށH
				if (!(loaded & FONT_ANK16a)) {

					// ǂݍ܂ĂȂ̂ 8x16tHgRs[
					fm7ankcpy(&KNJ_FNT[0x0200], work, 0x20, 0x7f);

					loaded7font |= FONT_ANK16a;
				}

				// ꐅǂݍށH
				if (!(loaded & FONT_KNJ1)) {

					// SJISR[h 0x8140 ` 0x84bf ̃Rs[
					fm7sjiscpy(&KNJ_FNT[0x01000], work, 0x8140, 0x84c0);

					// SJISR[h 0x8890 ` 0x989e ̃Rs[
					fm7sjiscpy(&KNJ_FNT[0x08000], work, 0x8890, 0x989f);

					loaded7font |= FONT_KNJ1;
				}
			}
			file_close(fh);
		}
	}

	// 
	GlobalUnlock(hwork);
	GlobalFree(hwork);
	return(loaded7font);
}


void ank8cnv(BYTE *src, int datacount) {

	int		i;

	for (i=0; i<datacount; i++) {
		memcpy(ANK_FNT[extcnv[i].x1ank],
					&src[extcnv[i].extank * 8], extcnv[i].count * 8);
	}
}


// ANK16̎w͈͂̃R[h Rs[
static void fm7ankcpy(BYTE *dst, BYTE *src, WORD from, WORD to) {

	int		y;
	BYTE	*p;
	WORD	ank;

	for (ank=from; ank<to; ank++) {
		// ANKtHg̃X^[gʒu
		p = src + 0x6000 + ((ank & 0x1f) * 0x20)
								+ ((DWORD)((ank / 0x20) - 1) * 0x400);
		for (y=0; y<16; y++) {
			*dst++ = *p;
			p += 2;
		}
	}
}


// ̎w͈͂̃R[h Rs[
static void fm7sjiscpy(BYTE *dst, BYTE *src, WORD from, WORD to) {

	int		y;
	BYTE	*p;
	WORD	sjis;
	WORD	jis;

	for (sjis=from; sjis<to; sjis++) {

		// R[hSJISJISɕϊ
		jis = sjis2jis(sjis);

		p = NULL;
		// ʂJISR[h͈͓H
		if (((jis & 0x0ff) >= 0x21) && ((jis & 0x0ff) <= 0x7e)) {
			// BITMAP̊̃|C^߂

								// 2121`277e
			if (((jis / 0x100) >= 0x21) && ((jis / 0x100) <= 0x27)) {
				p = src + ((jis & 0x1f) * 0x20)
							+ ((DWORD)((jis - 0x2000) / 0x100) * 0x400);

				if ((jis & 0xff) >= 0x60) {
					p += 0x2000;
				}
				else if ((jis & 0xff) >= 0x40) {
					p += 0x4000;
				}
			}
								// 3021`3f7e
			else if (((jis / 0x100) >= 0x30) && ((jis / 0x100) <= 0x3f)) {
				p = src + 0x08000 + ((jis & 0x1f) * 0x20)
							+ ((DWORD)((jis - 0x3000) / 0x100) * 0x400)
							+ ((DWORD)(((jis & 0xff) / 0x20) - 1) * 0x4000);
			}
								// 4021`4f7e
			else if (((jis / 0x100) >= 0x40) && ((jis / 0x100) <= 0x4f)) {
				p = src + 0x14000 + ((jis & 0x1f) * 0x20)
							+ ((DWORD)((jis - 0x4000) / 0x100) * 0x400)
							+ ((DWORD)(((jis & 0xff) / 0x20) - 1) * 0x4000);
			}
		}

		if (p != NULL) {					// KiR[hȂ
			// Rs[
			for (y=0; y<16; y++) {
				*dst++ = *p++;
				*dst++ = *p++;
			}
		}
		else {								// KiOR[h
			// 0 fill
			ZeroMemory(dst, 32);
			dst += 32;
		}
	}
}

