
#ifndef	NP2_I386HAX_HAXFUNC_H__
#define	NP2_I386HAX_HAXFUNC_H__

#if defined(SUPPORT_IA32_HAXM)

#define HAX_DEVICE_TYPE 0x4000

#define HAX_IOCTL_VERSION			CTL_CODE(HAX_DEVICE_TYPE, 0x900, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define HAX_IOCTL_CAPABILITY		CTL_CODE(HAX_DEVICE_TYPE, 0x910, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define HAX_IOCTL_SET_MEMLIMIT		CTL_CODE(HAX_DEVICE_TYPE, 0x911, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define HAX_IOCTL_CREATE_VM			CTL_CODE(HAX_DEVICE_TYPE, 0x901, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define HAX_VM_IOCTL_VCPU_CREATE	CTL_CODE(HAX_DEVICE_TYPE, 0x902, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define HAX_VM_IOCTL_ALLOC_RAM		CTL_CODE(HAX_DEVICE_TYPE, 0x903, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define HAX_VM_IOCTL_SET_RAM		CTL_CODE(HAX_DEVICE_TYPE, 0x904, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define HAX_VM_IOCTL_VCPU_DESTROY	CTL_CODE(HAX_DEVICE_TYPE, 0x905, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define HAX_VM_IOCTL_ADD_RAMBLOCK	CTL_CODE(HAX_DEVICE_TYPE, 0x913, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define HAX_VM_IOCTL_SET_RAM2		CTL_CODE(HAX_DEVICE_TYPE, 0x914, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define HAX_VM_IOCTL_PROTECT_RAM	CTL_CODE(HAX_DEVICE_TYPE, 0x915, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define HAX_VCPU_IOCTL_RUN			CTL_CODE(HAX_DEVICE_TYPE, 0x906, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define HAX_VCPU_IOCTL_SET_MSRS		CTL_CODE(HAX_DEVICE_TYPE, 0x907, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define HAX_VCPU_IOCTL_GET_MSRS		CTL_CODE(HAX_DEVICE_TYPE, 0x908, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define HAX_VCPU_IOCTL_SET_FPU		CTL_CODE(HAX_DEVICE_TYPE, 0x909, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define HAX_VCPU_IOCTL_GET_FPU		CTL_CODE(HAX_DEVICE_TYPE, 0x90a, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define HAX_VCPU_IOCTL_SETUP_TUNNEL CTL_CODE(HAX_DEVICE_TYPE, 0x90b, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define HAX_VCPU_IOCTL_INTERRUPT	CTL_CODE(HAX_DEVICE_TYPE, 0x90c, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define HAX_VCPU_SET_REGS			CTL_CODE(HAX_DEVICE_TYPE, 0x90d, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define HAX_VCPU_GET_REGS			CTL_CODE(HAX_DEVICE_TYPE, 0x90e, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define HAX_VCPU_IOCTL_KICKOFF		CTL_CODE(HAX_DEVICE_TYPE, 0x90f, METHOD_BUFFERED, FILE_ANY_ACCESS)

/* API version 2.0 */
#define HAX_VM_IOCTL_NOTIFY_QEMU_VERSION \
        CTL_CODE(HAX_DEVICE_TYPE, 0x910, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define HAX_IOCTL_VCPU_DEBUG \
        CTL_CODE(HAX_DEVICE_TYPE, 0x916, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define HAX_VCPU_IOCTL_SET_CPUID \
        CTL_CODE(HAX_DEVICE_TYPE, 0x917, METHOD_BUFFERED, FILE_ANY_ACCESS)


// hax_capabilityinfo wstatusp
#define HAX_CAP_STATUS_WORKING     (1 << 0)
#define HAX_CAP_MEMQUOTA           (1 << 1)
#define HAX_CAP_WORKSTATUS_MASK    0x01

// hax_capabilityinfo winfopiHAXMgpsȏꍇj
#define HAX_CAP_FAILREASON_VT      (1 << 0)
#define HAX_CAP_FAILREASON_NX      (1 << 1)

// hax_capabilityinfo winfopiHAXMgp\ȏꍇj
#define HAX_CAP_EPT                (1 << 0)
#define HAX_CAP_FASTMMIO           (1 << 1)
#define HAX_CAP_UG                 (1 << 2)
#define HAX_CAP_64BIT_RAMBLOCK     (1 << 3)
#define HAX_CAP_64BIT_SETRAM       (1 << 4)
#define HAX_CAP_TUNNEL_PAGE        (1 << 5)
#define HAX_CAP_DEBUG              (1 << 7)

#define HAX_MAX_VCPUS 16

#define HAX_RAM_INFO_ROM     0x01
#define HAX_RAM_INFO_INVALID 0x80

#ifdef __cplusplus
extern "C" {
#endif

#if defined(_WIN32)
#pragma pack(1)
typedef struct {
    UINT32 compat_version; // ݊̂o[WH
    UINT32 current_version; // ݂̃o[WH
} HAX_MODULE_VERSION;

typedef struct hax_capabilityinfo {
    UINT16 wstatus; // gpۂ̃tOȂ
    UINT16 winfo; // wstatusŎgp̏ꍇFHAXMŎgpł@\̃tOAgps̏ꍇFgps̗RtO
    UINT32 win_refcount; // 
    UINT64 mem_quota; // z}V(VM)Ŏgp\ȃ̏H
} HAX_CAPINFO;

typedef struct hax_set_memlimit {
    UINT8 enable_memlimit; // LH
    UINT8 pad[7]; // 
    UINT64 memory_limit; // TCYH
} HAX_SET_MEMLIMIT;

typedef struct hax_alloc_ram_info {
    UINT32 size; // o^郁̃TCY
    UINT32 pad; // 
    UINT64 va; // o^zXg̃AhXB4KBEłȂƑʖځBvaVirtual Address̗H
} HAX_ALLOC_RAM_INFO;

typedef struct hax_ramblock_info {
    UINT64 start_va; // o^zXg̃AhXB4KBEłȂƑʖځBvaVirtual Address̗H
    UINT64 size; // o^郁̃TCY
    UINT32 reserved; // 
} HAX_RAMBLOCK_INFO;

typedef struct hax_set_ram_info {
    UINT64 pa_start; // ̃QXgAhX(Guest Physical Address; GPA)Bɓo^Ăꍇ͏㏑B4KBEłȂƑʖ
    UINT32 size; // TCY
    UINT8 flags; // 0:ʏRAMAHAX_RAM_INFO_ROM:ROM̈AHAX_RAM_INFO_INVALID:蓖ĉiva0ɂj
    UINT8 pad[3]; // 
    UINT64 va; // zXg̃AhX(Host Virtual Address; HVA)Bi386haxfunc_allocRAMœo^ĂȂƑʖځB4KBEłȂƑʖ
} HAX_SET_RAM_INFO;

typedef struct hax_tunnel_info {
    UINT64 va; // struct hax_tunnel̃AhXiLXgĎgj
    UINT64 io_va; // f[^ƂpBexit_statusɂēeς
    UINT16 size; // struct hax_tunnel̃TCY
    UINT16 pad[3]; // 
} HAX_TUNNEL_INFO;

typedef struct hax_qemu_version {
    UINT32 cur_version; // sQEMUo[WH
    UINT32 least_version; // ŒKvQEMU APIo[WH
} HAX_QEMU_VERSION;

#define HAX_IO_OUT 0
#define HAX_IO_IN  1

// VMsf̌
enum exit_status {
    HAX_EXIT_IO = 1, // I/O|[gANZX
    HAX_EXIT_MMIO, // }bvhIOANZXiŋ߂FAST_MMIOgĂBp~Hj
    HAX_EXIT_REALMODE, // A[h̏ꍇ
    HAX_EXIT_INTERRUPT, // 荞ݔH
    HAX_EXIT_UNKNOWN, // s
    HAX_EXIT_HLT, // HLT߂sꂽ
    HAX_EXIT_STATECHANGE, // Vbg_ECPUpjbNȂǂŃZbgȊȎIƂ
    HAX_EXIT_PAUSED, // ꎞ~H
    HAX_EXIT_FAST_MMIO, // }bvhIOANZXiHAX_EXIT_MMIOɂ̂炵jtunnelio_vahax_fastmmio\̂̃AhX
    HAX_EXIT_PAGEFAULT, // y[WtH[gH
    HAX_EXIT_DEBUG // fobO
};
enum run_flag {
    HAX_EXIT = 0,
    HAX_RESUME = 1
};

typedef struct hax_tunnel {
	UINT32 _exit_reason; // ???
    UINT32 pad0; // 
    UINT32 _exit_status; // HAX_EXIT_Ȃ񂽂
    UINT32 user_event_pending; // ???
    int ready_for_interrupt_injection; // i386haxfunc_vcpu_interruptŊ荞݂󂯓鏀o
    int request_interrupt_window; // 荞݂̂ŏĉtOiKvȂƂɎ1ɐݒ肷j

    union {
        struct {
			// tunnel.io_va̓|[gւ̏o̓f[^A邢̓|[g̓̓f[^̏ݐ惁AhX
            UINT8 _direction; // ͂o͂̔BHAX_IO_OUT܂HAX_IO_IN
            UINT8 _df; // _count2ȏ̏ꍇAǂݎ鏇ԁB0̓CNgA1̓fNgiI/O|[gԍ͂̂܂܁j
            UINT16 _size; // |[gANZX̃TCYioCgj
            UINT16 _port; // o͐|[g
            UINT16 _count; // Ao͂f[^
            /* Followed owned by HAXM, QEMU should not touch them */
            /* bit 1 is 1 means string io */
            UINT8 _flags; // ???
            UINT8 _pad0; // 
            UINT16 _pad1; // 
            UINT32 _pad2; // 
            UINT64 _vaddr; // zXgzAhXH
        } io;
        struct {
            UINT64 gla; // QXgjAAhX̗HgĂȂ悤Ȃ̂ŕȂ
        } mmio;
        struct {
            UINT64 gpa; // QXgAhXH
#define HAX_PAGEFAULT_ACC_R  (1 << 0)
#define HAX_PAGEFAULT_ACC_W  (1 << 1)
#define HAX_PAGEFAULT_ACC_X  (1 << 2)
#define HAX_PAGEFAULT_PERM_R (1 << 4)
#define HAX_PAGEFAULT_PERM_W (1 << 5)
#define HAX_PAGEFAULT_PERM_X (1 << 6)
            UINT32 flags;
            UINT32 reserved1;
            UINT64 reserved2;
        } pagefault;
        struct {
            UINT64 dummy;
        } state;
        struct {
            UINT64 rip;
            UINT64 dr6;
            UINT64 dr7;
        } debug;
    };
	UINT64 apic_base;
} HAX_TUNNEL;
typedef struct hax_fastmmio {
    UINT64 gpa; // QXgAhX
    union {
        UINT64 value; // ݎ͏o͂lAǂݎ莞͒l̊i[ϐ
        UINT64 gpa2;  /* since API v4 */
    };
    UINT8 size; // f[^oCgi1, 2, 4 bytêꂩj
    UINT8 direction; // READ=0AWRITE=1AREAD&WRITE=2 (I/O|[g̎Ɖ̂tȂ̂ŒӁBQl: I/O|[głREAD=1, WRITE=0)
    UINT16 reg_index;  /* obsolete */
    UINT32 pad0; // 
    UINT64 _cr0; // CR0WX^H
    UINT64 _cr2; // CR2WX^H
    UINT64 _cr3; // CR3WX^H
    UINT64 _cr4; // CR4WX^H
} HAX_FASTMMIO;


#define HAX_MAX_MSR_ARRAY 0x20
typedef struct vmx_msr {
    UINT64 entry;
    UINT64 value;
} VMX_MSR;
typedef struct hax_msr_data {
    UINT16 nr_msr;
    UINT16 done;
    UINT16 pad[2];
	VMX_MSR entries[HAX_MAX_MSR_ARRAY];
} HAX_MSR_DATA;
#pragma pack()

#pragma pack(16)
typedef struct fx_layout {
    UINT16  fcw;
    UINT16  fsw;
    UINT8   ftw;
    UINT8   res1;
    UINT16  fop;
    union {
        struct {
            UINT32  fip;
            UINT16  fcs;
            UINT16  res2;
        };
        UINT64  fpu_ip;
    };
    union {
        struct {
            UINT32  fdp;
            UINT16  fds;
            UINT16  res3;
        };
        UINT64  fpu_dp;
    };
    UINT32    mxcsr;
    UINT32    mxcsr_mask;
    UINT8     st_mm[8][16];
    UINT8     mmx_1[8][16];
    UINT8     mmx_2[8][16];
    UINT8     pad[96];
} HAX_FX_LAYOUT;
#pragma pack()

#pragma pack(1)

typedef union interruptibility_state_t {
    UINT32 raw;
    struct {
        UINT32 sti_blocking   : 1;
        UINT32 movss_blocking : 1;
        UINT32 smi_blocking   : 1;
        UINT32 nmi_blocking   : 1;
        UINT32 reserved       : 28;
    };
    UINT64 pad;
} INTERRUPTIBILITY_STATE;

// Segment descriptor
typedef struct segment_desc_t {
    UINT16 selector;
    UINT16 _dummy;
    UINT32 limit;
    UINT64 base;
    union {
        struct {
            UINT32 type             : 4;
            UINT32 desc             : 1;
            UINT32 dpl              : 2;
            UINT32 present          : 1;
            UINT32                  : 4;
            UINT32 available        : 1;
            UINT32 long_mode        : 1;
            UINT32 operand_size     : 1;
            UINT32 granularity      : 1;
            UINT32 null             : 1;
            UINT32                  : 15;
        };
        UINT32 ar;
    };
    UINT32 ipad;
} SEGMENT_DESC;

// CPUWX^
typedef struct vcpu_state_t {
    union {
        UINT64 _regs[16];
        struct {
            union {
                struct {
                    UINT8 _al,
                            _ah;
                };
                UINT16    _ax;
                UINT32    _eax;
                UINT64    _rax;
            };
            union {
                struct {
                    UINT8 _cl,
                            _ch;
                };
                UINT16    _cx;
                UINT32    _ecx;
                UINT64    _rcx;
            };
            union {
                struct {
                    UINT8 _dl,
                            _dh;
                };
                UINT16    _dx;
                UINT32    _edx;
                UINT64    _rdx;
            };
            union {
                struct {
                    UINT8 _bl,
                            _bh;
                };
                UINT16    _bx;
                UINT32    _ebx;
                UINT64    _rbx;
            };
            union {
                UINT16    _sp;
                UINT32    _esp;
                UINT64    _rsp;
            };
            union {
                UINT16    _bp;
                UINT32    _ebp;
                UINT64    _rbp;
            };
            union {
                UINT16    _si;
                UINT32    _esi;
                UINT64    _rsi;
            };
            union {
                UINT16    _di;
                UINT32    _edi;
                UINT64    _rdi;
            };

            UINT64 _r8;
            UINT64 _r9;
            UINT64 _r10;
            UINT64 _r11;
            UINT64 _r12;
            UINT64 _r13;
            UINT64 _r14;
            UINT64 _r15;
        };
    };

    union {
        UINT32 _eip;
        UINT64 _rip;
    };

    union {
        UINT32 _eflags;
        UINT64 _rflags;
    };

    SEGMENT_DESC _cs;
    SEGMENT_DESC _ss;
    SEGMENT_DESC _ds;
    SEGMENT_DESC _es;
    SEGMENT_DESC _fs;
    SEGMENT_DESC _gs;
    SEGMENT_DESC _ldt;
    SEGMENT_DESC _tr;

    SEGMENT_DESC _gdt;
    SEGMENT_DESC _idt;

    UINT64 _cr0;
    UINT64 _cr2;
    UINT64 _cr3;
    UINT64 _cr4;

    UINT64 _dr0;
    UINT64 _dr1;
    UINT64 _dr2;
    UINT64 _dr3;
    UINT64 _dr6;
    UINT64 _dr7;
    UINT64 _pde;

    UINT32 _efer;

    UINT32 _sysenter_cs;
    UINT64 _sysenter_eip;
    UINT64 _sysenter_esp;

    UINT32 _activity_state;
    UINT32 pad;
    INTERRUPTIBILITY_STATE _interruptibility_state;
} HAX_VCPU_STATE;

// No access (R/W/X) is allowed
#define HAX_RAM_PERM_NONE 0x0
// All accesses (R/W/X) are allowed
#define HAX_RAM_PERM_RWX  0x7
#define HAX_RAM_PERM_MASK 0x7
typedef struct hax_protect_ram_info {
    UINT64 pa_start;
    UINT64 size;
    UINT32 flags;
    UINT32 reserved;
} HAX_PROTECT_RAM_INFO;

#define HAX_DEBUG_ENABLE     (1 << 0)
#define HAX_DEBUG_STEP       (1 << 1)
#define HAX_DEBUG_USE_SW_BP  (1 << 2)
#define HAX_DEBUG_USE_HW_BP  (1 << 3)

typedef struct hax_debug_t {
    UINT32 control;
    UINT32 reserved;
    UINT64 dr[8];
} HAX_DEBUG;

#define HAX_MAX_CPUID_ENTRIES 0x40

typedef struct hax_cpuid_entry_t {
    UINT32 function;
    UINT32 index;
    UINT32 flags;
    UINT32 eax;
    UINT32 ebx;
    UINT32 ecx;
    UINT32 edx;
    UINT32 pad[3];
} HAX_CPUID_ENTRY;

// `HAX_CPUID` is a variable-length type. The size of `HAX_CPUID` itself is only
// 8 bytes. `entries` is just a body placeholder, which will not actually occupy
// memory. The accessible memory of `entries` is decided by the allocation from
// user space, and the array length is specified by `total`.

typedef struct hax_cpuid_t {
    UINT32 total;
    UINT32 pad;
    HAX_CPUID_ENTRY entries[HAX_MAX_CPUID_ENTRIES];
} HAX_CPUID;

#pragma pack()
#endif

#ifdef __cplusplus
}
#endif

/***
  HAXM IOCTLp֐Q
 ***/

// HAXM IOCTL
UINT8 i386haxfunc_getversion(HAX_MODULE_VERSION *version); // HAXM̃o[W擾
UINT8 i386haxfunc_getcapability(HAX_CAPINFO *cap); // HAXMŎgp\ȋ@\擾
UINT8 i386haxfunc_setmemlimit(HAX_SET_MEMLIMIT *memlimit); // HAXM̃eʐZbgiŋ߂̔łł͈ӖȂHj
UINT8 i386haxfunc_createVM(UINT32 *vm_id); // HAXM̉z}V쐬ĉz}VIDԂ

// HAXM VM IOCTL
UINT8 i386haxfunc_notifyQEMUversion(HAX_QEMU_VERSION *hax_qemu_ver); // QEMUo[W̒ʒmiFast MMIŐςHʒmȂĂ͂Ȃj
UINT8 i386haxfunc_VCPUcreate(UINT32 vcpu_id); // HAXMz}VɎw肵ID̉zCPU쐬iCPU ID0`15Ŏwj
UINT8 i386haxfunc_allocRAM(HAX_ALLOC_RAM_INFO *allocraminfo); // HAXMz}VŎgpzXg͈̃͂o^
UINT8 i386haxfunc_addRAMblock(HAX_RAMBLOCK_INFO *ramblkinfo); // HAXMz}VŎgpzXg͈̃͂o^
UINT8 i386haxfunc_setRAM(HAX_SET_RAM_INFO *setraminfo); // HAXMz}V̕AhXɃzXg̃蓖āi͎Oi386haxfunc_allocRAMœo^KvjB蓖ẴAhXMMIOɂȂB

// HAXM VCPU IOCTL
UINT8 i386haxfunc_vcpu_run(); // z}VsJnBI/O|[gANZXE荞ݔŎspłȂȂsf
UINT8 i386haxfunc_vcpu_setup_tunnel(HAX_TUNNEL_INFO *info); // z}Vƃf[^Ƃ肷邽߂̃̈(tunnel)m
UINT8 i386haxfunc_vcpu_setMSRs(HAX_MSR_DATA *inbuf, HAX_MSR_DATA *outbuf); // fŗLWX^iModel Specific Register; MSRjݒ
UINT8 i386haxfunc_vcpu_getMSRs(HAX_MSR_DATA *outbuf); // fŗLWX^擾
UINT8 i386haxfunc_vcpu_setFPU(HAX_FX_LAYOUT *inbuf); // FPUWX^ݒ
UINT8 i386haxfunc_vcpu_getFPU(HAX_FX_LAYOUT *outbuf); // FPUWX^擾
UINT8 i386haxfunc_vcpu_setREGs(HAX_VCPU_STATE *inbuf); // WX^ݒ
UINT8 i386haxfunc_vcpu_getREGs(HAX_VCPU_STATE *outbuf); // WX^擾
UINT8 i386haxfunc_vcpu_interrupt(UINT32 vector); // w肵xN^̊荞݂𔭐
UINT8 i386haxfunc_vcpu_kickoff(); // 
UINT8 i386haxfunc_vcpu_debug(HAX_DEBUG *inbuf); // fobO̗L/fobO@ݒ肷
UINT8 i386haxfunc_vcpu_setCPUID(HAX_CPUID *inbuf); // CPUIDݒ肷

#endif

#endif	/* !NP2_I386HAX_HAXFUNC_H__ */
