/**
 * @file	cmbase.h
 * @brief	commng NX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include "commng.h"

/**
 * @brief commng NX
 */
class CComBase : public _commng
{
protected:
	CComBase(UINT nConnect);
	virtual ~CComBase();

	/**
	 * Read
	 * @param[out] pData
	 * @return result
	 */
	virtual UINT Read(UINT8* pData) = 0;

	/**
	 * Write
	 * @param[in] cData
	 * @return result
	 */
	virtual UINT Write(UINT8 cData) = 0;
	
	/**
	 * Write Retry
	 * @return result
	 */
	virtual UINT WriteRetry(){
		return 1; // 펞
	}
	
	/**
	 * ubNPʓ]Jn
	 */
	virtual void BeginBlockTransfer(){
	}
	/**
	 * ubNPʓ]I
	 */
	virtual void EndBlockTransfer(){
	}
	
	/**
	 * Last Write Success
	 * @return result
	 */
	virtual UINT LastWriteSuccess(){
		return 1; // 펞
	}

	/**
	 * Xe[^X𓾂
	 * @return Xe[^X
	 */
	virtual UINT8 GetStat() = 0;

	/**
	 * bZ[W
	 * @param[in] nMessage bZ[W
	 * @param[in] nParam p^
	 * @return Ug R[h
	 */
	virtual INTPTR Message(UINT nMessage, INTPTR nParam) = 0;

private:
	static UINT cRead(COMMNG cm, UINT8* pData);
	static UINT cWrite(COMMNG cm, UINT8 cData);
	static UINT cWriteRetry(COMMNG cm);
	static void cBeginBlockTransfer(COMMNG cm);
	static void cEndBlockTransfer(COMMNG cm);
	static UINT cLastWriteSuccess(COMMNG cm);
	static UINT8 cGetStat(COMMNG cm);
	static INTPTR cMessage(COMMNG cm, UINT nMessage, INTPTR nParam);
	static void cRelease(COMMNG cm);
};
