/**
 * @file	DlgProc.h
 * @brief	_CAO NX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include <commctrl.h>
#include "tstring.h"
#include "WndProc.h"

/**
 * @brief _CAO NX
 */
class CDlgProc : public CWndProc
{
public:
	CDlgProc();
	CDlgProc(UINT nIDTemplate, HWND hwndParent = NULL);
	virtual ~CDlgProc();
	virtual INT_PTR DoModal();
	virtual BOOL OnInitDialog();

	/**
	 * [_ _CAO {bNXI
	 * @param[in] nResult DoModaľĂяoɕԂl
	 */
	void CDlgProc::EndDialog(int nResult)
	{
		::EndDialog(m_hWnd, nResult);
	}

protected:
	LPCTSTR m_lpszTemplateName;		//!< ev[g
	HWND m_hwndParent;				//!< eEBhE

	virtual LRESULT WindowProc(UINT nMsg, WPARAM wParam, LPARAM lParam);
	virtual void OnOK();
	virtual void OnCancel();

#if defined(_WIN64)
	static INT_PTR CALLBACK DlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
#else	// defined(_WIN64)
	static BOOL CALLBACK DlgProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
#endif	// defined(_WIN64)
};


/**
 * @brief R{ {bNX
 */
class CComboBoxProc : public CWndProc
{
public:
	/**
	 * R{ {bNX̃Xg {bNXɕǉ܂
	 * @param[in] lpszString ǉꂽ null ŏI镶ւ̃|C^[
	 * @return 񂪑}ꂽʒuCfbNX
	 */
	int AddString(LPCTSTR lpszString)
	{
		return static_cast<int>(::SendMessage(m_hWnd, CB_ADDSTRING, 0, reinterpret_cast<LPARAM>(lpszString)));
	}

	/**
	 * R{ {bNX̃Xg {bNX̍ڐ擾ɂ́Ão[֐Ăяo܂
	 * @return ڂ̐
	 */
	int GetCount() const
	{
		return static_cast<int>(::SendMessage(m_hWnd, CB_GETCOUNT, 0, 0));
	}

	/**
	 * R{ {bNX̂ǂ̍ڂIꂽ𔻒肷邽߂ɂ̃o[֐Ăяo܂
	 * @return R{ {bNX̃Xg {bNXŌݑIĂ鍀ڂ̃CfbNX
	 */
	int GetCurSel() const
	{
		return static_cast<int>(::SendMessage(m_hWnd, CB_GETCURSEL, 0, 0));
	}

	/**
	 * w肵R{ {bNX̍ڂɊ֘AtꂽAvP[Vɗpӂꂽ 32 rbgl擾܂
	 * @param[in] nIndex R{ {bNX̃Xg {bNX̍ڂ̃CfbNX
	 * @return 32 rbgl
	 */
	DWORD_PTR GetItemData(int nIndex) const
	{
		return static_cast<DWORD_PTR>(::SendMessage(m_hWnd, CB_GETITEMDATA, static_cast<WPARAM>(nIndex), 0));
	}

	/**
	 * R{ {bNX̃Xg {bNXŎw肳ĂvtBbNX܂ލŏ̕܂
	 * @param[in] nStartAfter ŏ̍ڂ̑O̍ڂ̃CfbNX
	 * @param[in] lpszString 镶
	 * @return CfbNX
	 */
	int FindString(int nStartAfter, LPCTSTR lpszString) const
	{
		return static_cast<int>(::SendMessage(m_hWnd, CB_FINDSTRING, nStartAfter, reinterpret_cast<LPARAM>(lpszString)));
	}

	/**
	 * R{ {bNX̃Xg {bNXŎw肳Ăŏ̕܂
	 * @param[in] nStartAfter ŏ̍ڂ̑O̍ڂ̃CfbNX
	 * @param[in] lpszString 镶
	 * @return CfbNX
	 */
	int FindStringExact(int nStartAfter, LPCTSTR lpszString) const
	{
		return static_cast<int>(::SendMessage(m_hWnd, CB_FINDSTRINGEXACT, nStartAfter, reinterpret_cast<LPARAM>(lpszString)));
	}

	/**
	 * R{ {bNX̃Xg {bNXɕǉ܂
	 * @param[in] nIndex 󂯎郊Xg {bNẌʒu
	 * @param[in] lpszString ǉꂽ null ŏI镶ւ̃|C^[
	 * @return 񂪑}ꂽʒuCfbNX
	 */
	int InsertString(int nIndex, LPCTSTR lpszString)
	{
		return static_cast<int>(::SendMessage(m_hWnd, CB_INSERTSTRING, static_cast<WPARAM>(nIndex), reinterpret_cast<LPARAM>(lpszString)));
	}

	/**
	 * R{ {bNX̃Xg {bNXƃGfBbg Rg[炷ׂĂ̍ڂ폜܂B
	 */
	void ResetContent()
	{
		::SendMessage(m_hWnd, CB_RESETCONTENT, 0, 0);
	}

	/**
	 * 32 rbglR{ {bNX̎w荀ڂɊ֘At
	 * @param[in] nIndex ڂɎn܂CfbNXݒ肷邽߂̃\bh܂܂܂
	 * @param[in] dwItemData VlڂɊ֘AtɊ܂܂Ă܂
	 * @return G[̎ CB_ERR
	 */
	int SetItemData(int nIndex, DWORD_PTR dwItemData)
	{
		return static_cast<int>(::SendMessage(m_hWnd, CB_SETITEMDATA, static_cast<WPARAM>(nIndex), static_cast<LPARAM>(dwItemData)));
	}

	/**
	 * R{ {bNX̃Xg {bNX̕I܂
	 * @param[in] nSelect ̃CfbNXI悤Ɏw肵܂
	 * @return bZ[Wꍇ͑Iꂽڂ̃CfbNX
	 */
	int SetCurSel(int nSelect)
	{
		return static_cast<int>(::SendMessage(m_hWnd, CB_SETCURSEL, static_cast<WPARAM>(nSelect), 0));
	}
};

/**
 * @brief XC_[ {bNX
 */
class CSliderProc : public CWndProc
{
public:
	/**
	 * XC_[݈̌ʒu擾܂
	 * @return ݈ʒuԂ܂
	 */
	int GetPos() const
	{
		return static_cast<int>(::SendMessage(m_hWnd, TBM_GETPOS, 0, 0));
	}

	/**
	 * XC_[ Rg[ŃXC_[̍ŏ͈͂ݒ肵܂
	 * @param[in] nMin XC_[̍ŏ̈ʒu
	 * @param[in] bRedraw ĕ`̃tO
	 */
	void SetRangeMin(int nMin, BOOL bRedraw)
	{
		::SendMessage(m_hWnd, TBM_SETRANGEMIN, bRedraw, nMin);
	}

	/**
	 * XC_[ Rg[ŃXC_[̍ő͈͂ݒ肵܂
	 * @param[in] nMax XC_[̍ő̈ʒu
	 * @param[in] bRedraw ĕ`̃tO
	 */
	void SetRangeMax(int nMax, BOOL bRedraw)
	{
		::SendMessage(m_hWnd, TBM_SETRANGEMAX, bRedraw, nMax);
	}

	/**
	 * XC_[݈̌ʒuݒ肵܂
	 * @param[in] nPos VXC_[̈ʒuw肵܂
	 */
	void SetPos(int nPos)
	{
		::SendMessage(m_hWnd, TBM_SETPOS, TRUE, nPos);
	}
};

/**
 * @brief t@CI
 */
class CFileDlg
{
public:
	CFileDlg(BOOL bOpenFileDialog, LPCTSTR lpszDefExt = NULL, LPCTSTR lpszFileName = NULL, DWORD dwFlags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, LPCTSTR lpszFilter = NULL, HWND hParentWnd = NULL);
	int DoModal();

	/**
	 * t@C̎擾
	 * @return full path and filename
	 */
	LPCTSTR GetPathName() const
	{
		return m_ofn.lpstrFile;
	}

	/**
	 * Readoly?
	 * @return TRUE if readonly checked
	 */
	BOOL GetReadOnlyPref() const
	{
		return (m_ofn.Flags & OFN_READONLY) ? TRUE : FALSE;
	}

public:
	OPENFILENAME m_ofn;				//!< open file parameter block

protected:
	BOOL m_bOpenFileDialog;			//!< TRUE for file open, FALSE for file save
	std::tstring m_strFilter;		//!< filter string
	TCHAR m_szFileTitle[64];		//!< contains file title after return
	TCHAR m_szFileName[_MAX_PATH];	//!< contains full path name after return
};
