#include	"compiler.h"
#include	"cpucore.h"
#include	"pccore.h"
#include	"iocore.h"
#include	"memegc.h"
#include	"vram.h"

// PEGC v[[h
// ֘A: vram.c, vram.h, memvga.c, memvga.h

// ڂȂ̂ɍ̂łȂ肢łBBetter than nothing.
// Vt^ݒ肷ƓǂݎAhX܂ňꏏɂƂvIȐ݌v~XĂ܂B
// ǂ̂łΑŜĂč蒼ǂ܂

#ifdef SUPPORT_PEGC

// 
REG16 MEMCALL pegc_memvgaplane_rd16(UINT32 address){
	
	int i,j;
	UINT16 ret = 0;
	//UINT8 bit;

	UINT32 addr; // fPʂ̓ǂݍ݌AhX

	//UINT8 src, dst, pat1, pat2; // \[Xf[^AfBXeBl[Vf[^Ap^[f[^1&2
	UINT8 ropcode = 0; // X^Iy[Vݒ E0108h bit0`bit7
	UINT8 ropmethod = 0; // _Z̕@wip^[WX^܂̓J[pbgj E0108h bit11,10
	UINT8 ropupdmode = 0; // 1Ȃ烉X^Iy[Vgp E0108h bit12
	UINT8 planemask = 0; // v[݋֎~(0=, 1=֎~)@E0104h
	UINT32 pixelmask = 0; // rbgifjւ̏݋֎~(0=֎~, 1=) E010Ch
	UINT32 blocklength = 0; // ubN]rbg(]TCY-1) E0110h
	UINT32 srcbitshift = 0; // [h̃rbgVtg E0112h
	UINT32 dstbitshift = 0; // Cg̃rbgVtg E0112h
	UINT8 shiftdir = 1; // Vtgi0:inc, 1:decjE0108h bit9
	UINT8 srccpu = 1; // OɓǂݎVRAMf[^ł͂ȂCPUf[^gp邩 E0108h bit8

	// PEGCWX^ǂ݂
	ropcode = LOADINTELWORD(vramop.mio2+PEGC_REG_PLANE_ROP) & 0xff;
	ropmethod = (LOADINTELWORD(vramop.mio2+PEGC_REG_PLANE_ROP) >> 10) & 0x3;
	ropupdmode = (LOADINTELWORD(vramop.mio2+PEGC_REG_PLANE_ROP) >> 12) & 0x1;
	planemask = vramop.mio2[PEGC_REG_PLANE_ACCESS];
	pixelmask = LOADINTELDWORD(vramop.mio2 + PEGC_REG_MASK);
	blocklength = LOADINTELDWORD(vramop.mio2 + PEGC_REG_LENGTH) & 0x0fff;
	srcbitshift = (LOADINTELWORD(vramop.mio2+PEGC_REG_SHIFT)) & 0x1f;
	dstbitshift = (LOADINTELWORD(vramop.mio2+PEGC_REG_SHIFT) >> 8) & 0x1f;
	shiftdir = (LOADINTELWORD(vramop.mio2+PEGC_REG_PLANE_ROP) >> 9) & 0x1;
	srccpu = (LOADINTELWORD(vramop.mio2+PEGC_REG_PLANE_ROP) >> 8) & 0x1;
	
	// fPʂ̃AhXvZ
	addr = (address - 0xa8000) * 8;
	addr += srcbitshift;
	if(!shiftdir){
		if(pegc.remain == blocklength + 1){
		}else{
			addr -= dstbitshift;
		}
	}else{
		if(pegc.remain == blocklength + 1){
		}else{
			addr -= dstbitshift;
		}
	}
	addr &= 0x80000-1; // Ŝ
	
	pegc.lastdatalen = 0;
	if(!srccpu){
		if(!shiftdir){
			for(i=0;i<16;i++){
				UINT32 addrtmp = (addr + i) & (0x80000-1); // ǂݎʒu
				UINT32 pixmaskpos = (1 << ((15-i+8)&0xf)); // ݂̉fɑΉpixelmask̃rbgʒu
				UINT8 data = vramex[addrtmp];

				// compare data
				if((data ^ vramop.mio2[PEGC_REG_PALETTE1]) & ~planemask){
					ret |= (1<<i);
				}

				// update last data
				pegc.lastdata[pegc.lastdatalen + i] = data;

				// update pattern reg
				if((LOADINTELWORD(vramop.mio2+PEGC_REG_PLANE_ROP) >> 13) & 0x1){
					for(j=7;j>=0;j--){
						UINT16 regdata = LOADINTELWORD(vramop.mio2 + PEGC_REG_PATTERN + j*4);
						regdata = (regdata & ~(1 << i)) | (((data >> j) & 0x1) << i);
						STOREINTELWORD(vramop.mio2 + PEGC_REG_PATTERN + j*4, regdata);
					}
				}
			}
		}else{
			for(i=0;i<16;i++){
				UINT32 addrtmp = (addr - i) & (0x80000-1); // ǂݎʒu
				UINT32 pixmaskpos = (1 << ((i/8)*8 + (7-(i&0x7)))); // ݂̉fɑΉvaluepixelmask̃rbgʒu
				UINT8 data = vramex[addrtmp];

				// compare data
				if((data ^ vramop.mio2[PEGC_REG_PALETTE1]) & ~planemask){
					ret |= (1<<i);
				}

				// update last data
				pegc.lastdata[pegc.lastdatalen + i] = data;

				// update pattern reg
				if(LOADINTELWORD(vramop.mio2+PEGC_REG_PLANE_ROP) & 0x2000){
					for(j=7;j>=0;j--){
						UINT16 regdata = LOADINTELWORD(vramop.mio2 + PEGC_REG_PATTERN + j*4);
						regdata = (regdata & ~(1 << i)) | (((data >> j) & 0x1) << i);
						STOREINTELWORD(vramop.mio2 + PEGC_REG_PATTERN + j*4, regdata);
					}
				}
			}
		}
	}
	if(pegc.lastdatalen < 32) pegc.lastdatalen += 16;
	return ret;
}
void MEMCALL pegc_memvgaplane_wr16(UINT32 address, REG16 value){
	
	static int firstSkip = 0;

	int i,j;
	UINT8 bit;

	UINT32 addr; // fPʂ̏ݐAhX

	UINT8 src, dst, pat1 = 0, pat2 = 0; // \[Xf[^AfBXeBl[Vf[^Ap^[f[^1&2
	UINT8 ropcode = 0; // X^Iy[Vݒ E0108h bit0`bit7
	UINT8 ropmethod = 0; // _Z̕@wip^[WX^܂̓J[pbgj E0108h bit11,10
	UINT8 ropupdmode = 0; // 1Ȃ烉X^Iy[Vgp E0108h bit12
	UINT8 planemask = 0; // v[݋֎~(0=, 1=֎~)@E0104h
	UINT32 pixelmask = 0; // rbgifjւ̏݋֎~(0=֎~, 1=) E010Ch
	UINT32 blocklength = 0; // ubN]rbg(]TCY-1) E0110h
	UINT32 srcbitshift = 0; // [h̃rbgVtg E0112h
	UINT32 dstbitshift = 0; // Cg̃rbgVtg E0112h
	UINT8 shiftdir = 1; // Vtgi0:inc, 1:decjE0108h bit9
	UINT8 srccpu = 1; // OɓǂݎVRAMf[^ł͂ȂCPUf[^gp邩 E0108h bit8
	int datalen = 16;
	int exshiftmode;

	// PEGCWX^ǂ݂
	ropcode = LOADINTELWORD(vramop.mio2+PEGC_REG_PLANE_ROP) & 0xff;
	ropmethod = (LOADINTELWORD(vramop.mio2+PEGC_REG_PLANE_ROP) >> 10) & 0x3;
	ropupdmode = (LOADINTELWORD(vramop.mio2+PEGC_REG_PLANE_ROP) >> 12) & 0x1;
	planemask = vramop.mio2[PEGC_REG_PLANE_ACCESS];
	pixelmask = LOADINTELDWORD(vramop.mio2 + PEGC_REG_MASK);
	blocklength = LOADINTELDWORD(vramop.mio2 + PEGC_REG_LENGTH) & 0x0fff;
	srcbitshift = (LOADINTELWORD(vramop.mio2+PEGC_REG_SHIFT)) & 0x1f;
	dstbitshift = (LOADINTELWORD(vramop.mio2+PEGC_REG_SHIFT) >> 8) & 0x1f;
	shiftdir = (LOADINTELWORD(vramop.mio2+PEGC_REG_PLANE_ROP) >> 9) & 0x1;
	srccpu = (LOADINTELWORD(vramop.mio2+PEGC_REG_PLANE_ROP) >> 8) & 0x1;
	
	if(pegc.remain == 0){
		// f[^߂?
		pegc.remain = blocklength + 1;
		pegc.lastdatalen = 0;
	}else{
		firstSkip = 0;
	}
	if(firstSkip){
		firstSkip = 0;
		return;
	}

	exshiftmode = (!srccpu || ((blocklength + 1) & 0xf)!=0); // WORKAROUND
	
	// fPʂ̃AhXvZ
	addr = (address - 0xa8000) * 8;
	if(exshiftmode){
		if(pegc.remain == blocklength + 1){
			addr += dstbitshift;
			datalen -= dstbitshift;
		}
	}else{
		// WORKAROUND
		addr += dstbitshift;
	}
	addr &= 0x80000-1; // Ŝ

	// ???
	bit = (addr & 0x40000)?2:1;
	
	if(!shiftdir){
		// Ƃ肠CN^
		//  iȂ񂩂j
		//            +----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+
		//    i       |  0 |  1 |  2 |  3 |  4 |  5 |  6 |  7 |  8 |  9 | 10 | 11 | 12 | 13 | 14 | 15 |
		//            +----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+----+
		// value     bit7 bit6 bit5 bit4 bit3 bit2 bit1 bit0 bitF bitE bitD bitC bitB bitA bit9 bit8  
		// pixelmask bit7 bit6 bit5 bit4 bit3 bit2 bit1 bit0 bitF bitE bitD bitC bitB bitA bit9 bit8  planemask  SRC,DST,PAT
		//                                                                                                            
		// plane0 vramex[0]  [1]  [2]  [3]  [4]  [5]  [6]  [7]  [8]  [9] [10] [11] [12] [13] [14] [15]    bit0        bit0
		// plane1 vramex[0]  [1]  [2]  [3]  [4]  [5]  [6]  [7]  [8]  [9] [10] [11] [12] [13] [14] [15]    bit1        bit1
		// plane2 vramex[0]  [1]  [2]  [3]  [4]  [5]  [6]  [7]  [8]  [9] [10] [11] [12] [13] [14] [15]    bit2        bit2
		// plane3 vramex[0]  [1]  [2]  [3]  [4]  [5]  [6]  [7]  [8]  [9] [10] [11] [12] [13] [14] [15]    bit3        bit3
		// plane4 vramex[0]  [1]  [2]  [3]  [4]  [5]  [6]  [7]  [8]  [9] [10] [11] [12] [13] [14] [15]    bit4        bit4
		// plane5 vramex[0]  [1]  [2]  [3]  [4]  [5]  [6]  [7]  [8]  [9] [10] [11] [12] [13] [14] [15]    bit5        bit5
		// plane6 vramex[0]  [1]  [2]  [3]  [4]  [5]  [6]  [7]  [8]  [9] [10] [11] [12] [13] [14] [15]    bit6        bit6
		// plane7 vramex[0]  [1]  [2]  [3]  [4]  [5]  [6]  [7]  [8]  [9] [10] [11] [12] [13] [14] [15]    bit7        bit7

		for(i=0;i<datalen;i++){
			UINT32 addrtmp = (addr + i) & (0x80000-1); // ݈ʒu
			UINT32 pixmaskpos = (1 << ((i/8)*8 + (7-(i&0x7)))); // ݂̉fɑΉvaluepixelmask̃rbgʒu
			//if(pegc.remain > 32){
			if(pixelmask & pixmaskpos){ // ݋֎~`FbN
				// SRC̐ݒ
				if(srccpu){
					// CPUf[^g
					src = (value & pixmaskpos) ? 0xff : 0x00;
				}else{
					// OɓǂݎVRAMf[^g
					src = pegc.lastdata[i];
				}

				// DST̐ݒ ݂VRAMf[^擾
				dst = vramex[addrtmp];
				
				if(ropupdmode){
					// ROPgp
					vramex[addrtmp] = (vramex[addrtmp] & planemask); // \̃rbg0ɂĂ
					
					// PAT̐ݒ
					if(ropmethod==0){
						// p^[WX^gp
						int col = 0;
						for(j=7;j>=0;j--){
							col |= (LOADINTELWORD(vramop.mio2 + PEGC_REG_PATTERN + j*4) >> i) & 0x1;
							col <<= 1;
						}
						pat1 = pat2 = col;
					}else if(ropmethod==1){
						// pbg2gp
						pat1 = pat2 = vramop.mio2[PEGC_REG_PALETTE2];
					}else if(ropmethod==2){
						// pbg1gp
						pat1 = pat2 = vramop.mio2[PEGC_REG_PALETTE1];
					}else if(ropmethod==3){
						// pbg12gp
						pat1 = vramop.mio2[PEGC_REG_PALETTE1];
						pat2 = vramop.mio2[PEGC_REG_PALETTE2];
					}
					// ROPs
					if(vramop.mio2[PEGC_REG_PLANE_ROP] & (1<<7)) vramex[addrtmp] |= (src & dst & pat1) & (~planemask);
					if(vramop.mio2[PEGC_REG_PLANE_ROP] & (1<<6)) vramex[addrtmp] |= (src & dst & ~pat1) & (~planemask);
					if(vramop.mio2[PEGC_REG_PLANE_ROP] & (1<<5)) vramex[addrtmp] |= (src & ~dst & pat1) & (~planemask);
					if(vramop.mio2[PEGC_REG_PLANE_ROP] & (1<<4)) vramex[addrtmp] |= (src & ~dst & ~pat1) & (~planemask);
					if(vramop.mio2[PEGC_REG_PLANE_ROP] & (1<<3)) vramex[addrtmp] |= (~src & dst & pat2) & (~planemask);
					if(vramop.mio2[PEGC_REG_PLANE_ROP] & (1<<2)) vramex[addrtmp] |= (~src & dst & ~pat2) & (~planemask);
					if(vramop.mio2[PEGC_REG_PLANE_ROP] & (1<<1)) vramex[addrtmp] |= (~src & ~dst & pat2) & (~planemask);
					if(vramop.mio2[PEGC_REG_PLANE_ROP] & (1<<0)) vramex[addrtmp] |= (~src & ~dst & ~pat2) & (~planemask);
				}else{
					// SRC0ɑ΂planemask&DST, 1ɑ΂~planemask|DST
					vramex[addrtmp] = 0;
					for(j=0;j<8;j++){
						if(src & (1<<j)){
							vramex[addrtmp] |= (~planemask | dst) & (1<<j);
						}else{
							vramex[addrtmp] |= (planemask & dst) & (1<<j);
						}
					}
				}
				// ???
				vramupdate[LOW15(addrtmp >> 3)] |= bit;
			}
			pegc.remain--;
			// ]TCY`FbN
			if(pegc.remain == 0){
				goto endloop; // 
			}
		}
	}else{
		for(i=0;i<datalen;i++){
			UINT32 addrtmp = (addr - i) & (0x80000-1); // ݈ʒu
			UINT32 pixmaskpos = (1 << ((i/8)*8 + (7-(i&0x7)))); // ݂̉fɑΉvaluepixelmask̃rbgʒu
			if(pixelmask & pixmaskpos){ // ݋֎~`FbN
				// SRC̐ݒ
				if(srccpu){
					// CPUf[^g
					src = (value & pixmaskpos) ? 0xff : 0x00;
				}else{
					// OɓǂݎVRAMf[^g
					src = pegc.lastdata[i];
				}

				// DST̐ݒ ݂VRAMf[^擾
				dst = vramex[addrtmp];
				
				if(ropupdmode){
					// ROPgp
					vramex[addrtmp] = (vramex[addrtmp] & planemask); // \̃rbg0ɂĂ
					
					// PAT̐ݒ
					if(ropmethod==0){
						// p^[WX^gp
						int col = 0;
						for(j=7;j>=0;j--){
							col |= (LOADINTELWORD(vramop.mio2 + PEGC_REG_PATTERN + j*4) >> i) & 0x1;
							col <<= 1;
						}
						pat1 = pat2 = col;
					}else if(ropmethod==1){
						// pbg2gp
						pat1 = pat2 = vramop.mio2[PEGC_REG_PALETTE2];
					}else if(ropmethod==2){
						// pbg1gp
						pat1 = pat2 = vramop.mio2[PEGC_REG_PALETTE1];
					}else if(ropmethod==3){
						// pbg12gp
						pat1 = vramop.mio2[PEGC_REG_PALETTE1];
						pat2 = vramop.mio2[PEGC_REG_PALETTE2];
					}
					// ROPs
					if(vramop.mio2[PEGC_REG_PLANE_ROP] & (1<<7)) vramex[addrtmp] |= (src & dst & pat1) & (~planemask);
					if(vramop.mio2[PEGC_REG_PLANE_ROP] & (1<<6)) vramex[addrtmp] |= (src & dst & ~pat1) & (~planemask);
					if(vramop.mio2[PEGC_REG_PLANE_ROP] & (1<<5)) vramex[addrtmp] |= (src & ~dst & pat1) & (~planemask);
					if(vramop.mio2[PEGC_REG_PLANE_ROP] & (1<<4)) vramex[addrtmp] |= (src & ~dst & ~pat1) & (~planemask);
					if(vramop.mio2[PEGC_REG_PLANE_ROP] & (1<<3)) vramex[addrtmp] |= (~src & dst & pat2) & (~planemask);
					if(vramop.mio2[PEGC_REG_PLANE_ROP] & (1<<2)) vramex[addrtmp] |= (~src & dst & ~pat2) & (~planemask);
					if(vramop.mio2[PEGC_REG_PLANE_ROP] & (1<<1)) vramex[addrtmp] |= (~src & ~dst & pat2) & (~planemask);
					if(vramop.mio2[PEGC_REG_PLANE_ROP] & (1<<0)) vramex[addrtmp] |= (~src & ~dst & ~pat2) & (~planemask);
				}else{
					// SRC0ɑ΂planemask&DST, 1ɑ΂~planemask|DST
					vramex[addrtmp] = 0;
					for(j=0;j<8;j++){
						if(src & (1<<j)){
							vramex[addrtmp] |= (~planemask | dst) & (1<<j);
						}else{
							vramex[addrtmp] |= (planemask & dst) & (1<<j);
						}
					}
				}
				// ???
				vramupdate[LOW15(addrtmp >> 3)] |= bit;
			}
			
			pegc.remain--;
			// ]TCY`FbN
			if(pegc.remain == 0){
				goto endloop; // 
			}
		}
	}
endloop:
	gdcs.grphdisp |= bit;
	
	if(pegc.remain == 0){
		if(exshiftmode){
			// nothing to do
		}else{
			// WORKAROUND
			if(dstbitshift){
				firstSkip = 1;
			}
		}
	}
	if(pegc.lastdatalen > 16) {
		pegc.lastdatalen -= 16;
	}else{
		pegc.lastdatalen = 0;
	}
}
UINT32 MEMCALL pegc_memvgaplane_rd32(UINT32 address){
	// TODO: 
	return 0;
}
void MEMCALL pegc_memvgaplane_wr32(UINT32 address, UINT32 value){
	// TODO: 
}

void pegc_reset(const NP2CFG *pConfig) {

	ZeroMemory(&pegc, sizeof(pegc));
	
	pegc.enable = np2cfg.usepegcplane;

	(void)pConfig;
}

void pegc_bind(void) {

}

#endif