/**
 * @file	serial.c
 * @brief	Keyboard & RS-232C Interface
 *
 * ֘AFpit.c, sysport.c
 */

#include	"compiler.h"
#include	"cpucore.h"
#include	"commng.h"
#include	"pccore.h"
#include	"iocore.h"
#include	"keystat.h"


// ---- Keyboard

void keyboard_callback(NEVENTITEM item) {

	if (item->flag & NEVENT_SETEVENT) {
		if ((keybrd.ctrls) || (keybrd.buffers)) {
			if (!(keybrd.status & 2)) {
				keybrd.status |= 2;
				if (keybrd.ctrls) {
					keybrd.ctrls--;
					keybrd.data = keybrd.ctr[keybrd.ctrpos];
					keybrd.ctrpos = (keybrd.ctrpos + 1) & KB_CTRMASK;
				}
				else if (keybrd.buffers) {
					keybrd.buffers--;
					keybrd.data = keybrd.buf[keybrd.bufpos];
					keybrd.bufpos = (keybrd.bufpos + 1) & KB_BUFMASK;
				}
//				TRACEOUT(("recv -> %02x", keybrd.data));
			}
			pic_setirq(1);
			nevent_set(NEVENT_KEYBOARD, keybrd.xferclock,
										keyboard_callback, NEVENT_RELATIVE);
		}
	}
}

static void IOOUTCALL keyboard_o41(UINT port, REG8 dat) {

	if (keybrd.cmd & 1) {
//		TRACEOUT(("send -> %02x", dat));
		keystat_ctrlsend(dat);
	}
	else {
		keybrd.mode = dat;
	}
	(void)port;
}

static void IOOUTCALL keyboard_o43(UINT port, REG8 dat) {

//	TRACEOUT(("out43 -> %02x %.4x:%.8x", dat, CPU_CS, CPU_EIP));
	if ((!(dat & 0x08)) && (keybrd.cmd & 0x08)) {
		keyboard_resetsignal();
	}
	if (dat & 0x10) {
		keybrd.status &= ~(0x38);
	}
	keybrd.cmd = dat;
	(void)port;
}

static REG8 IOINPCALL keyboard_i41(UINT port) {

	(void)port;
	keybrd.status &= ~2;
	pic_resetirq(1);
//	TRACEOUT(("in41 -> %02x %.4x:%.8x", keybrd.data, CPU_CS, CPU_EIP));
	return(keybrd.data);
}

static REG8 IOINPCALL keyboard_i43(UINT port) {

	(void)port;
//	TRACEOUT(("in43 -> %02x %.4x:%.8x", keybrd.status, CPU_CS, CPU_EIP));
	return(keybrd.status | 0x85);
}


// ----

static const IOOUT keybrdo41[2] = {
					keyboard_o41,	keyboard_o43};

static const IOINP keybrdi41[2] = {
					keyboard_i41,	keyboard_i43};


void keyboard_reset(const NP2CFG *pConfig) {

	ZeroMemory(&keybrd, sizeof(keybrd));
	keybrd.data = 0xff;
	keybrd.mode = 0x5e;

	(void)pConfig;
}

void keyboard_bind(void) {

	keystat_ctrlreset();
	keyboard_changeclock();
	iocore_attachsysoutex(0x0041, 0x0cf1, keybrdo41, 2);
	iocore_attachsysinpex(0x0041, 0x0cf1, keybrdi41, 2);
}

void keyboard_resetsignal(void) {

	nevent_reset(NEVENT_KEYBOARD);
	keybrd.cmd = 0;
	keybrd.status = 0;
	keybrd.ctrls = 0;
	keybrd.buffers = 0;
	keystat_ctrlreset();
	keystat_resendstat();
}

void keyboard_ctrl(REG8 data) {

	if ((data == 0xfa) || (data == 0xfc)) {
		keybrd.ctrls = 0;
	}
	if (keybrd.ctrls < KB_CTR) {
		keybrd.ctr[(keybrd.ctrpos + keybrd.ctrls) & KB_CTRMASK] = data;
		keybrd.ctrls++;
		if (!nevent_iswork(NEVENT_KEYBOARD)) {
			nevent_set(NEVENT_KEYBOARD, keybrd.xferclock,
										keyboard_callback, NEVENT_ABSOLUTE);
		}
	}
}

void keyboard_send(REG8 data) {

	if (keybrd.buffers < KB_BUF) {
		keybrd.buf[(keybrd.bufpos + keybrd.buffers) & KB_BUFMASK] = data;
		keybrd.buffers++;
		if (!nevent_iswork(NEVENT_KEYBOARD)) {
			nevent_set(NEVENT_KEYBOARD, keybrd.xferclock,
										keyboard_callback, NEVENT_ABSOLUTE);
		}
	}
	else {
		keybrd.status |= 0x10;
	}
}

void keyboard_changeclock(void) {

	keybrd.xferclock = pccore.realclock / 1920;
}



// ---- RS-232C

	COMMNG	cm_rs232c = NULL;
	
// RS-232C Mobt@TCY
#define RS232C_BUFFER		(1 << 6)
#define RS232C_BUFFER_MASK	(RS232C_BUFFER - 1)
// RS-232C Mobt@ɂf[^iRS232C_BUFFER_CLRC~8{[[gjbԓǂݎȂΎ̂ĂiȂŊoIɎwj
#define RS232C_BUFFER_CLRC	16

static UINT8 rs232c_buf[RS232C_BUFFER]; // RS-232C MOobt@@{ׂ݂͑łȂWindowsoR̒ʐM̓A^CɂȂȂȏdȂilɍȂj
static UINT8 rs232c_buf_rpos = 0; // RS-232C MOobt@ ǂݎʒu
static UINT8 rs232c_buf_wpos = 0; // RS-232C MOobt@ ݈ʒu
static int rs232c_removecounter = 0; // f[^j`FbNpJE^

// RS-232C FIFOMobt@TCY
#define RS232C_FIFO_WRITEBUFFER		256
#define RS232C_FIFO_WRITEBUFFER_MASK	(RS232C_FIFO_WRITEBUFFER - 1)
static UINT8 rs232c_fifo_writebuf[RS232C_FIFO_WRITEBUFFER]; // RS-232C FIFOMOobt@
static int rs232c_fifo_writebuf_rpos = 0; // RS-232C FIFOMOobt@ ǂݎʒu
static int rs232c_fifo_writebuf_wpos = 0; // RS-232C FIFOMOobt@ ݈ʒu

// RS-232C MgC
static void rs232c_writeretry() {

	int ret;
//#if defined(SUPPORT_RS232C_FIFO)
//	// FIFO[h̎
//	if(rs232cfifo.port138 & 0x1){
//		if(rs232c_fifo_writebuf_wpos == rs232c_fifo_writebuf_rpos) return; // obt@Ȃ牽Ȃ
//	}else
//#endif
//	{
		if((rs232c.result & 0x4) != 0) {
			return; // TxEMPĊɑMĂ邩mFiȂ瑗Msvj
		}
	//}
	if (cm_rs232c) {
		cm_rs232c->writeretry(cm_rs232c); // MgC
		ret = cm_rs232c->lastwritesuccess(cm_rs232c); // M`FbN
		if(ret==0){
			return; // sĂ玟Ɏz
		}
#if defined(SUPPORT_RS232C_FIFO)
		// FIFO[h̎
		if(rs232cfifo.port138 & 0x1){
			int fifowbufused;
			
			// obt@ǂݎʒui߂
			rs232c_fifo_writebuf_rpos = (rs232c_fifo_writebuf_rpos+1) & RS232C_FIFO_WRITEBUFFER_MASK;
			
			fifowbufused = (rs232c_fifo_writebuf_wpos - rs232c_fifo_writebuf_rpos) & RS232C_FIFO_WRITEBUFFER_MASK;
			if(fifowbufused > RS232C_FIFO_WRITEBUFFER * 3 / 4){
				rs232c.result &= ~0x1; // obt@tȂTxRDY낷
			}else{
				rs232c.result |= 0x1; // obt@󂫂ȂTxRDY𗧂Ă
			}
			if(!(rs232c.result & 0x5)){
				// obt@tȂ犄荞݂͎~߂Ă
			}else{
				if (sysport.c & 6) { // TxEMP, TxRDYŊ荞݁H
					rs232c.send = 0;
#if defined(SUPPORT_RS232C_FIFO)
					rs232cfifo.irqflag = 1;
#endif
					pic_setirq(4); // 荞
				}
			}
			// obt@ɗ܂Ăf[^邾
			while(fifowbufused = ((rs232c_fifo_writebuf_wpos - rs232c_fifo_writebuf_rpos) & RS232C_FIFO_WRITEBUFFER_MASK)){
				if(fifowbufused > RS232C_FIFO_WRITEBUFFER * 3 / 4){
					rs232c.result &= ~0x1; // obt@tȂTxRDY낷
				}else{
					rs232c.result |= 0x1; // obt@󂫂ȂTxRDY𗧂Ă
				}
				cm_rs232c->write(cm_rs232c, (UINT8)rs232c_fifo_writebuf[rs232c_fifo_writebuf_rpos]);
				ret = cm_rs232c->lastwritesuccess(cm_rs232c);
				if(!ret){
					return; // ܂߂Ȃ̂ő҂
				}else{
					// obt@ǂݎʒui߂
					rs232c_fifo_writebuf_rpos = (rs232c_fifo_writebuf_rpos+1) & RS232C_FIFO_WRITEBUFFER_MASK;
				}
			}
			rs232c.result |= 0x5; // obt@󂫂ȂTxEMP,TxRDY𗧂Ă
			cm_rs232c->endblocktranster(cm_rs232c); // ubN][h
		}else
#endif
		{
			rs232c.result |= 0x5; // MTxEMP, TxRDY𗧂Ă
		}
		if (sysport.c & 6) { // TxEMP, TxRDYŊ荞݁H
			rs232c.send = 0;
#if defined(SUPPORT_RS232C_FIFO)
			rs232cfifo.irqflag = 1;
#endif
			pic_setirq(4); // 荞
		}
		else {
			rs232c.send = 1; // Mς݃tO𗧂ĂiTxRE, TxEErbgƊ荞ݔj
		}
	}
}

// RS-232C  np2N1񂾂Ă΂
void rs232c_construct(void) {

	if(cm_rs232c){
		commng_destroy(cm_rs232c);
	}
	cm_rs232c = NULL;
}

// RS-232C  np2I1񂾂Ă΂
void rs232c_destruct(void) {

	commng_destroy(cm_rs232c);
	cm_rs232c = NULL;
}

// RS-232C |[gI[v ۂɃANZX܂Ń|[gI[vȂdl
void rs232c_open(void) {

	if (cm_rs232c == NULL) {
		cm_rs232c = commng_create(COMCREATE_SERIAL, FALSE);
	}
}

// RS-232C ʐMpR[obN {[[g8 /bŌĂ΂i: 2400bpsȂ2400/8 = 300/bj
void rs232c_callback(void) {

	BOOL	intr = FALSE; // 荞݃tO
	BOOL	fifomode = FALSE; // FIFO[htO
	int		bufused; // MOobt@gp
	BOOL	bufremoved = FALSE;
	
	// JĂȂRS-232C|[gI[v
	rs232c_open();

	// MɎsĂ烊gC
	rs232c_writeretry();

	// MOobt@̎gp󋵂擾
	bufused = (rs232c_buf_wpos - rs232c_buf_rpos) & RS232C_BUFFER_MASK;
	if(bufused==0){
		rs232c_removecounter = 0; // obt@ȂÂf[^폜JE^Zbg
	}
	
	// MiuPD8251 Recieve Enablej`FbN
	if(!(rs232c.cmd & 0x04) && bufused==0) {
		// M֎~ŎMobt@ȂȂMȂ
	}else{
		// M\邢͎Mobt@Ɏc肪Ώ
#if defined(SUPPORT_RS232C_FIFO)
		// FIFO[h`FbN
		fifomode = (rs232cfifo.port138 & 0x1);
		if(fifomode){
			rs232c_removecounter = 0; // FIFO[hł͌Âf[^Ȃ
			if(bufused == RS232C_BUFFER-1){
				if(!rs232cfifo.irqflag){
					// 荞݂Ă犄荞݌ZbgĊ荞
					rs232cfifo.irqflag = 2;
					pic_setirq(4);
				}
				return; // obt@ςȂҋ@
			}
			if(rs232cfifo.irqflag){
				return; // 荞݌tOĂΑҋ@
			}
		}
#endif

		// Âf[^폜JE^CNg
		rs232c_removecounter = (rs232c_removecounter + 1) % RS232C_BUFFER_CLRC;
		if (bufused > 0 && rs232c_removecounter==0 || bufused == RS232C_BUFFER-1){
			rs232c_buf_rpos = (rs232c_buf_rpos+1) & RS232C_BUFFER_MASK; // JE^1ԌÂ̂̂Ă
			bufremoved = TRUE;
		}
		// MiuPD8251 Recieve Enablej̎A|[g玟̃f[^ǂݎ
		if ((rs232c.cmd & 0x04) && (cm_rs232c) && (cm_rs232c->read(cm_rs232c, &rs232c_buf[rs232c_buf_wpos]))) {
			rs232c_buf_wpos = (rs232c_buf_wpos+1) & RS232C_BUFFER_MASK; // ǂݎꂽobt@݈ʒui߂
		}
		// obt@Ƀf[^I/O|[gǂݎf[^ɃZbgĊ荞
		if (rs232c_buf_rpos != rs232c_buf_wpos) {
			rs232c.data = rs232c_buf[rs232c_buf_rpos]; // f[^1o
			if(!(rs232c.result & 2) || bufremoved) { // RxRDYɗĂΉȂ  ꕔ\tgs̂߃obt@jꂽƂ̂ݍĊ荞
				rs232c.result |= 2; // RxRDY𗧂Ă
#if defined(SUPPORT_RS232C_FIFO)
				if(fifomode){
					// FIFO[h̎荞݌Zbg
					rs232cfifo.irqflag = 2;
					//OutputDebugString(_T("READ INT!\n"));
					intr = TRUE;
				}else
#endif
				if (sysport.c & 1) {
					// FIFO[hłȂƂARxRErbgiRxRDY荞ݗLjĂ犄荞
					intr = TRUE;
				}
			}
		}
	}

	// Mς݃tOĂƂATxRE, TxEErbgiTxRDY, TxEMP荞ݗLjĂ犄荞
	if (sysport.c & 6) {
		if (rs232c.send) {
			rs232c.send = 0; // Mς݃tO
#if defined(SUPPORT_RS232C_FIFO)
			// FIFO[h̎荞݌Zbg
			rs232cfifo.irqflag = 1;
#endif
			intr = TRUE;
		}
	}

	// WORKAROUND: TxEMP荞ݗL̎Aobt@ȂЂ犄荞ݑiWin3.1MɉivɊ荞ݑ҂ɂȂ̂j
//#if defined(SUPPORT_RS232C_FIFO)
//	if(!fifomode)
//#endif
	if (sysport.c & 2) {
		if (!rs232c.send) {
			intr = TRUE;
		}
	}

	// 荞݃tOĂΊ荞
	if (intr) {
		pic_setirq(4);
	}
}

// Xe[^X擾
// bit 7: ~CI (RI, RING)
// bit 6: ~CS (CTS)
// bit 5: ~CD (DCD, RLSD)
// bit 4: reserved
// bit 3: reserved
// bit 2: reserved
// bit 1: reserved
// bit 0: ~DSR (DR)
UINT8 rs232c_stat(void) {

	rs232c_open();
	return(cm_rs232c->getstat(cm_rs232c));
}

// G[Ԏ擾 (bit0: peB, bit1: I[o[, bit2: t[~O, bit3: u[NM)
UINT8 rs232c_geterror(void) {
	
	if (cm_rs232c) {
		UINT8 errorcode = 0;
		cm_rs232c->msg(cm_rs232c, COMMSG_GETERROR, (INT_PTR)(&errorcode));
		return errorcode;
	}
	return 0;
}

// G[
void rs232c_clearerror(void) {
	
	if (cm_rs232c) {
		cm_rs232c->msg(cm_rs232c, COMMSG_CLRERROR, 0);
	}
}

// MIDI panic
void rs232c_midipanic(void) {

	if (cm_rs232c) {
		cm_rs232c->msg(cm_rs232c, COMMSG_MIDIRESET, 0);
	}
}


// ----

// I/O 30h f[^WX^ Write
static void IOOUTCALL rs232c_o30(UINT port, REG8 dat) {

	static int lastfail = 0;
	int ret;
	BOOL	fifomode = FALSE; // FIFO[htO

#if defined(SUPPORT_RS232C_FIFO)
	// FIFO[hłȂƂ130h͖
	fifomode = (rs232cfifo.port138 & 0x1);
	if(!fifomode && port==0x130){
		lastfail = 0;
		return;
	}
#endif
	if(!(rs232c.cmd & 0x01)) return; // M֎~Ȃ甲
	if (cm_rs232c) {
		rs232c_writeretry();
#if defined(SUPPORT_RS232C_FIFO)
		// FIFO[h̎
		if(fifomode){
			int fifowbufused;

			// obt@ɓ
			fifowbufused = (rs232c_fifo_writebuf_wpos - rs232c_fifo_writebuf_rpos) & RS232C_FIFO_WRITEBUFFER_MASK;
			if(fifowbufused == RS232C_FIFO_WRITEBUFFER-1){
				rs232c_fifo_writebuf_rpos = (rs232c_fifo_writebuf_rpos+1) & RS232C_FIFO_WRITEBUFFER_MASK; // JE^1ԌÂ̂̂Ă
			}
			rs232c.result &= ~0x4; // TxEMP
			if(fifowbufused > RS232C_FIFO_WRITEBUFFER * 3 / 4){
				rs232c.result &= ~0x1; // obt@tȂTxRDY낷
			}else{
				rs232c.result |= 0x1; // obt@󂫂ȂTxRDYĂ
			}
			rs232c_fifo_writebuf[rs232c_fifo_writebuf_wpos] = dat;
			rs232c_fifo_writebuf_wpos = (rs232c_fifo_writebuf_wpos+1) & RS232C_FIFO_WRITEBUFFER_MASK; // obt@݈ʒui߂
			// obt@ɗ܂Ăf[^邾
			while(fifowbufused = ((rs232c_fifo_writebuf_wpos - rs232c_fifo_writebuf_rpos) & RS232C_FIFO_WRITEBUFFER_MASK)){
				if(fifowbufused > RS232C_FIFO_WRITEBUFFER * 3 / 4){
					rs232c.result &= ~0x1; // obt@tȂTxRDY낷
				}else{
					rs232c.result |= 0x1; // obt@󂫂ȂTxRDYĂ
				}
				cm_rs232c->write(cm_rs232c, (UINT8)rs232c_fifo_writebuf[rs232c_fifo_writebuf_rpos]);
				ret = cm_rs232c->lastwritesuccess(cm_rs232c);
				if(!ret){
					if(fifowbufused > RS232C_FIFO_WRITEBUFFER / 2){
						cm_rs232c->beginblocktranster(cm_rs232c); // obt@ȏ㖄܂ĂubN][hɕύX
					}
					if(!(rs232c.result & 0x5)){
						// obt@tȂ犄荞݂͎~߂Ă
					}else{
						// 1bytełĂ犄荞
						if (sysport.c & 6) { // TxEMP, TxRDYŊ荞݁H
							rs232c.send = 0;
#if defined(SUPPORT_RS232C_FIFO)
							rs232cfifo.irqflag = 1;
#endif
							pic_setirq(4); // 荞
						}
						lastfail = 1;
					}
					return; // ܂߂Ȃ̂ő҂
				}else{
					// obt@ǂݎʒui߂
					rs232c_fifo_writebuf_rpos = (rs232c_fifo_writebuf_rpos+1) & RS232C_FIFO_WRITEBUFFER_MASK;
				}
			}
			rs232c.result |= 0x5; // obt@ȂTxEMP,TxRDY𗧂Ă
			cm_rs232c->endblocktranster(cm_rs232c); // ubN][h
		}else
#endif
		{
			cm_rs232c->write(cm_rs232c, (UINT8)dat);
			ret = cm_rs232c->lastwritesuccess(cm_rs232c);
			rs232c.result &= ~0x5; // MTxEMP, TxRDY낷
			if(!ret){
				lastfail = 1;
				return; // ܂߂Ȃ̂ő҂
			}
			rs232c.result |= 0x5; // MTxEMP, TxRDY𗧂Ă
		}
	}
	if (lastfail && (sysport.c & 6)) {
		// O񎸔sĂ瑦荞
		rs232c.send = 0;
#if defined(SUPPORT_RS232C_FIFO)
		rs232cfifo.irqflag = 1;
#endif
		pic_setirq(4);
	}
	else {
		rs232c.send = 1; // 荞݂{[[gɂȂȂ悤ɂ
	}
	lastfail = 0;
	(void)port;
}

// I/O 32h [hZbg,R}h[h Write
static void IOOUTCALL rs232c_o32(UINT port, REG8 dat) {

	if (!(dat & 0xfd)) {
		rs232c.dummyinst++;
	}
	else {
		if ((rs232c.dummyinst >= 3) && (dat == 0x40)) {
			rs232c.pos = 0;
		}
		rs232c.dummyinst = 0;
	}
	switch(rs232c.pos) {
		case 0x00:			// reset
			rs232c_clearerror();
			rs232c.pos++;
			break;

		case 0x01:			// mode
			rs232c.rawmode = dat;
			if (!(dat & 0x03)) {
				rs232c.mul = 10 * 16;
			}
			else {
				rs232c.mul = ((dat >> 1) & 6) + 10;
				if (dat & 0x10) {
					rs232c.mul += 2;
				}
				switch(dat & 0xc0) {
					case 0x80:
						rs232c.mul += 3;
						break;
					case 0xc0:
						rs232c.mul += 4;
						break;
					default:
						rs232c.mul += 2;
						break;
				}
				switch(dat & 0x03) {
					case 0x01:
						rs232c.mul >>= 1;
						break;
					case 0x03:
						rs232c.mul *= 32;
						break;
					default:
						rs232c.mul *= 8;
						break;
				}
			}
			pit_setrs232cspeed((pit.ch + 2)->value);
			rs232c.pos++;
			break;

		case 0x02:			// cmd
			//sysport.c &= ~7;
			//sysport.c |= (dat & 7);
			//rs232c.pos++;
			if(dat & 0x40){
				// reset
				rs232c.pos = 1;
				rs232c_clearerror();
			}
			if(dat & 0x10){
				rs232c_clearerror();
			}
			if(!(rs232c.cmd & 0x04) && (dat & 0x04)){
				if (cm_rs232c) {
					cm_rs232c->msg(cm_rs232c, COMMSG_PURGE, (INTPTR)&rs232c.cmd);
				}
			}
			rs232c.cmd = dat;
			if (cm_rs232c) {
				cm_rs232c->msg(cm_rs232c, COMMSG_SETCOMMAND, (INTPTR)&rs232c.cmd);
			}
			break;
	}
	(void)port;
}

// I/O 30h f[^WX^ Read
static REG8 IOINPCALL rs232c_i30(UINT port) {

	UINT8 ret = rs232c.data;

#if defined(SUPPORT_RS232C_FIFO)
	// FIFO[hłȂƂ130h͖
	if(!(rs232cfifo.port138 & 0x1) && port==0x130){
		return 0xff;
	}
#endif
	
	rs232c_writeretry();

#if defined(SUPPORT_RS232C_FIFO)
	if(port==0x130){
		if (rs232c_buf_rpos == rs232c_buf_wpos) {
			// ǂ
			if ((cm_rs232c) && (cm_rs232c->read(cm_rs232c, &rs232c_buf[rs232c_buf_wpos]))) {
				rs232c_buf_wpos = (rs232c_buf_wpos+1) & RS232C_BUFFER_MASK;
				rs232c.data = rs232c_buf[rs232c_buf_rpos]; // f[^1o
			}
		}
	}
#endif
	if (rs232c_buf_rpos != rs232c_buf_wpos) {
		rs232c_buf_rpos = (rs232c_buf_rpos+1) & RS232C_BUFFER_MASK; // obt@ǂݎʒu1i߂
		rs232c.data = rs232c_buf[rs232c_buf_rpos]; // f[^1o
	}
#if defined(SUPPORT_RS232C_FIFO)
	if(port==0x130){
		if (rs232c_buf_rpos != rs232c_buf_wpos) { // Mׂf[^邩mF
			int bufused; // MOobt@gp
			// MOobt@̎gp󋵂擾
			bufused = (rs232c_buf_wpos - rs232c_buf_rpos) & RS232C_BUFFER_MASK;

			rs232c.data = rs232c_buf[rs232c_buf_rpos]; // ̃f[^o

			if(bufused > RS232C_BUFFER * 3 / 4){
				// obt@c肪Ȃ̂ŋ}Ŋ荞
				//if (sysport.c & 1) {
					rs232cfifo.irqflag = 2;
					pic_setirq(4);
				//}
			}
			//OutputDebugString(_T("READ!\n"));
		}else{
			rs232c.result &= ~0x2;
			rs232cfifo.irqflag = 3;
			pic_setirq(4);
			//rs232c.data = 0xff;
			//pic_resetirq(4);
			//OutputDebugString(_T("READ END!\n"));
		}
	}else
#endif
	{
		int bufused; // MOobt@gp
		// MOobt@̎gp󋵂擾
		bufused = (rs232c_buf_wpos - rs232c_buf_rpos) & RS232C_BUFFER_MASK;
		if(bufused > RS232C_BUFFER * 3 / 4){
			// obt@c肪Ȃ̂ŋ}Ŋ荞
			if (sysport.c & 1) {
				// FIFO[hłȂƂARxRErbgiRxRDY荞ݗLjĂ犄荞
				pic_setirq(4);
			}
		}else{
			// ]T̂ŎCallback̃^C~OŊ荞
			rs232c.result &= ~0x2; // RxRDY
		}
	}
	rs232c_removecounter = 0;
	return(ret);
}

// I/O 32h Xe[^X Read
static REG8 IOINPCALL rs232c_i32(UINT port) {

	UINT8 ret;

	rs232c_writeretry();
	
	ret = rs232c.result;
	ret |= (rs232c_geterror() & 7) << 3;
	if (!(rs232c_stat() & 0x01)) {
		return(ret | 0x80);
	}
	else {
		(void)port;
		return(ret | 0x00);
	}
}

/*
 * I/O 132h FIFO CXe[^X
 * bit 3`7ɂ UNDOCUMENTED 9801/9821 Vol.2ɋLڂ̓e͌
 * 
 * bit 7: s
 * bit 6: uCNMM
 * bit 5: t[~OG[
 * bit 4: I[o[G[
 * bit 3: peBG[
 * bit 2: RxRDY
 * bit 1: TxRDY
 * bit 0: TxEMP
 */
static REG8 IOINPCALL rs232c_i132(UINT port) {

	UINT8 ret;
	UINT8 err; // G[(bit0: peB, bit1: I[o[, bit2: t[~O, bit3: u[NM)
	
	rs232c_writeretry();
	
	ret = rs232c.result; // bit0: TxRDY, bit1: RxRDY, bit2: TxEMP
	err = rs232c_geterror();
	ret = ((ret >> 2) & 0x1) | ((ret << 1) & 0x6) | ((err << 3) & 0x78);
	
	if (!(rs232c_stat() & 0x01)) {
		return(ret | 0x80);
	}
	else {
		(void)port;
		return(ret | 0x00);
	}
}

// I/O 134h fXe[^XWX^
#if defined(SUPPORT_RS232C_FIFO)
static REG8 IOINPCALL rs232c_i134(UINT port) {
	
	REG8	ret = 0;
	static UINT8	lastret = 0;
	UINT8	stat = rs232c_stat();
	
	/* stat
	 * bit 7: ~CI (RI, RING)
	 * bit 6: ~CS (CTS)
	 * bit 5: ~CD (DCD, RLSD)
	 * bit 0: ~DSR (DR)
	 */
	if(~stat & 0x20){
		ret |= 0x80; // CD
	}
	if(~stat & 0x80){
		ret |= 0x40; // CI
	}
	if(~stat & 0x01){
		ret |= 0x20; // DR
	}
	if(~stat & 0x40){
		ret |= 0x10; // CS
	}
	ret |= ((lastret >> 4) ^ ret) & 0xf; // diff
	lastret = ret;
	(void)port;
	return(ret);
}

// I/O 136h FIFO荞ݎQƃWX^
static REG8 IOINPCALL rs232c_i136(UINT port) {

	rs232cfifo.port136 ^= 0x40;
	
	if(rs232cfifo.irqflag){
		rs232cfifo.port136 &= ~0xf;
		if(rs232cfifo.irqflag == 3){
			rs232cfifo.port136 |= 0x6;
			//rs232cfifo.irqflag = 0;
			//OutputDebugString(_T("CHECK READ END INT!\n"));
		}else if(rs232cfifo.irqflag == 2){
			rs232cfifo.port136 |= 0x4;
			//OutputDebugString(_T("CHECK READ INT!\n"));
		}else if(rs232cfifo.irqflag == 1){
			rs232cfifo.port136 |= 0x2;
			//rs232cfifo.irqflag = 0;
			//OutputDebugString(_T("CHECK WRITE INT!\n"));
		}
		rs232cfifo.irqflag &= ~0x7;
		pic_resetirq(4);
	}else{
		rs232cfifo.port136 |= 0x1;
		pic_resetirq(4);
		//OutputDebugString(_T("NULL INT!\n"));
	}

	return(rs232cfifo.port136);
}

// I/O 138h FIFORg[WX^
static void IOOUTCALL rs232c_o138(UINT port, REG8 dat) {

	if(dat & 0x2){
		//int i;
		//// MFIFOZbg
		//rs232c_buf_rpos = rs232c_buf_wpos;
		//if(rs232cfifo.irqflag==2) rs232cfifo.irqflag = 0;
		//if(cm_rs232c){
		//	for(i=0;i<256;i++){
		//		cm_rs232c->read(cm_rs232c, &rs232c_buf[rs232c_buf_wpos]);
		//	}
		//}
		//pic_resetirq(4);
	}
	rs232cfifo.port138 = dat;
	(void)port;
}
static REG8 IOINPCALL rs232c_i138(UINT port) {

	UINT8 ret = rs232cfifo.port138;
	
	return(ret);
}

// V-FAST[hʐMxݒ@֘A: pit.c pit_setrs232cspeed
void rs232c_vfast_setrs232cspeed(UINT8 value) {
	if(value == 0) return;
	if(!(rs232cfifo.vfast & 0x80)) return; // V FAST[hłȂꍇ͂ȂɂȂ
	if (cm_rs232c) {
		int speedtbl[16] = {
			0, 115200, 57600, 38400,
			28800, 0, 19200, 0,
			14400, 0, 0, 0,
			9600, 0, 0, 0,
		}; // V-FASTʐMxe[u
		int newspeed;
		newspeed = speedtbl[rs232cfifo.vfast & 0xf];
		if(newspeed != 0){
			// ʐMxύX
			cm_rs232c->msg(cm_rs232c, COMMSG_CHANGESPEED, (INTPTR)&newspeed);
		}else{
			// V-FASTʐMxe[uɂȂƂAʏ̑xݒɂ
			PITCH	pitch;
			pitch = pit.ch + 2;
			pit_setrs232cspeed(pitch->value);
		}
	}
}

// V-FAST[hWX^
static void IOOUTCALL rs232c_o13a(UINT port, REG8 dat) {

	if((rs232cfifo.vfast & 0x80) && !(dat & 0x80)){
		PITCH	pitch;
		// V FAST[h
		rs232cfifo.vfast = dat;
		pitch = pit.ch + 2;
		pit_setrs232cspeed(pitch->value);
	}else{
		// V FAST[hZbg
		rs232cfifo.vfast = dat;
		rs232c_vfast_setrs232cspeed(rs232cfifo.vfast);
	}
	rs232cfifo.irqflag &= ~0x7;
	(void)port;
}
static REG8 IOINPCALL rs232c_i13a(UINT port) {

	UINT8 ret = rs232cfifo.vfast;
	return(ret);
}
#endif



// ----

static const IOOUT rs232co30[2] = {
					rs232c_o30,	rs232c_o32};

static const IOINP rs232ci30[2] = {
					rs232c_i30,	rs232c_i32};

void rs232c_reset(const NP2CFG *pConfig) {

	commng_destroy(cm_rs232c);
	cm_rs232c = NULL;
	rs232c.result = 0x05;
	rs232c.data = 0xff;
	rs232c.send = 1;
	rs232c.pos = 0;
	rs232c.cmd = 0x27; // ftHgőM
	rs232c.cmdvalid = 1; // Xe[gZ[u݊ێp
	rs232c.reserved = 0;
	rs232c.dummyinst = 0;
	rs232c.mul = 10 * 16;
	rs232c.rawmode = 0;
	
#if defined(SUPPORT_RS232C_FIFO)
	ZeroMemory(&rs232cfifo, sizeof(rs232cfifo));
#endif
	
	if (cm_rs232c == NULL) {
		cm_rs232c = commng_create(COMCREATE_SERIAL, TRUE);
	}
	
	(void)pConfig;
}

void rs232c_bind(void) {

	iocore_attachsysoutex(0x0030, 0x0cf1, rs232co30, 2);
	iocore_attachsysinpex(0x0030, 0x0cf1, rs232ci30, 2);
	
#if defined(SUPPORT_RS232C_FIFO)
	iocore_attachout(0x130, rs232c_o30);
	iocore_attachinp(0x130, rs232c_i30);
	iocore_attachout(0x132, rs232c_o32);
	iocore_attachinp(0x132, rs232c_i132);
	//iocore_attachout(0x134, rs232c_o134);
	iocore_attachinp(0x134, rs232c_i134);
	//iocore_attachout(0x136, rs232c_o136);
	iocore_attachinp(0x136, rs232c_i136);
	iocore_attachout(0x138, rs232c_o138);
	iocore_attachinp(0x138, rs232c_i138);
	iocore_attachout(0x13a, rs232c_o13a);
	iocore_attachinp(0x13a, rs232c_i13a);
#endif

	// Xe[gZ[u݊ێp
	if(!rs232c.cmdvalid){
		rs232c.cmd = 0x27; // ftHgőM
		rs232c.cmdvalid = 1;
	}
}

