/**
 * @file	threadbase.h
 * @brief	XbhNX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include <pthread.h>
#include <unistd.h>

/**
 * @brief XbhNX
 */
class CThreadBase
{
public:
	CThreadBase();
	virtual ~CThreadBase();

	bool Start();
	void Stop();
	void SetStackSize(size_t stack_size);
	static void Delay(unsigned int usec);

protected:
	virtual bool Task()=0;		//!< Xbh ^XN

private:
	pthread_t m_thread;			//!< Xbh tO
	bool m_bCreated;			//!< Xbh쐬tO
	bool m_bDone;				//!< ItO
	size_t m_stack_size;		//!< X^bN TCY
	static void* StartRoutine(void* arg);
};

/**
 * X^bN TCY̐ݒ
 * @param[in] stack_size X^bN TCY
 */
inline void CThreadBase::SetStackSize(size_t stack_size)
{
	m_stack_size = stack_size;
}

/**
 * X[v
 * @param[in] usec }CNb
 */
inline void CThreadBase::Delay(unsigned int usec)
{
	::usleep(usec);
}
