/**
 * @file	WndProc.cpp
 * @brief	vV[W NX̓̒`s܂
 */

#include "compiler.h"
#include "WndProc.h"
#include <assert.h>
#define ASSERT assert	/*!< assert */

//! NX
// static const TCHAR s_szClassName[] = TEXT("WndProcBase");

//! CX^X
HINSTANCE CWndProc::sm_hInstance;
//! \[X
HINSTANCE CWndProc::sm_hResource;

DWORD CWndProc::sm_dwThreadId;							//!< ̃Xbh ID
HHOOK CWndProc::sm_hHookOldCbtFilter = NULL;			//!< tbN tB^[
CWndProc* CWndProc::sm_pWndInit = NULL;					//!< ̃CX^X
std::map<HWND, CWndProc*>* CWndProc::sm_pWndMap = NULL;	//!< EBhE }bv

/**
 * 
 * @param[in] hInstance CX^X
 */
void CWndProc::Initialize(HINSTANCE hInstance)
{
	sm_hInstance = hInstance;
	sm_hResource = hInstance;

	sm_dwThreadId = ::GetCurrentThreadId();
	sm_hHookOldCbtFilter = ::SetWindowsHookEx(WH_CBT, CbtFilterHook, NULL, sm_dwThreadId);

	sm_pWndMap = new std::map<HWND, CWndProc*>;

#if 0
	WNDCLASS wc;
	ZeroMemory(&wc, sizeof(wc));
	wc.style = CS_BYTEALIGNCLIENT | CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wc.lpfnWndProc = WndProc;
	wc.hInstance = hInstance;
	wc.hIcon = ::LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON2));
	wc.hCursor = ::LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = static_cast<HBRUSH>(::GetStockObject(NULL_BRUSH));
	wc.lpszClassName = s_szClassName;
	::RegisterClass(&wc);
#endif	// 0
}

/**
 * 
 */
void CWndProc::Deinitialize()
{
	if (sm_hHookOldCbtFilter != NULL)
	{
		::UnhookWindowsHookEx(sm_hHookOldCbtFilter);
		sm_hHookOldCbtFilter = NULL;
	}
	if(sm_pWndMap != NULL){
		delete sm_pWndMap;
		sm_pWndMap = NULL;
	}
}

/**
 * \[X̌
 * @param[in] lpszName \[X ID
 * @param[in] lpszType \[X̌^ւ̃|C^
 * @return CX^X
 */
HINSTANCE CWndProc::FindResourceHandle(LPCTSTR lpszName, LPCTSTR lpszType)
{
	HINSTANCE hInst = GetResourceHandle();
	if ((hInst != GetInstanceHandle()) && (::FindResource(hInst, lpszName, lpszType) != NULL))
	{
		return hInst;
	}
	return GetInstanceHandle();
}

/**
 * RXgN^
 */
CWndProc::CWndProc()
	: CWndBase(NULL)
	, m_pfnSuper(NULL)
{
}

/**
 * fXgN^
 */
CWndProc::~CWndProc()
{
	DestroyWindow();
}

/**
 * EBhẼnhw肳ĂꍇACWndProc IuWFNgւ̃|C^[Ԃ܂
 * @param[in] hWnd EBhE nh
 * @return |C^
 */
CWndProc* CWndProc::FromHandlePermanent(HWND hWnd)
{
	std::map<HWND, CWndProc*>* pMap = sm_pWndMap;
	if (pMap)
	{
		std::map<HWND, CWndProc*>::iterator it = pMap->find(hWnd);
		if (it != pMap->end())
		{
			return it->second;
		}
	}
	return NULL;
}

/**
 * Windows ̃EBhEA^b`܂
 * @param[in] hWndNew EBhE nh
 * @retval TRUE 
 * @retval FALSE s
 */
BOOL CWndProc::Attach(HWND hWndNew)
{
	std::map<HWND, CWndProc*>* pMap = sm_pWndMap;
	if ((hWndNew != NULL) && (pMap))
	{
		(*pMap)[hWndNew] = this;
		m_hWnd = hWndNew;
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}

/**
 * Windows ̃nh؂藣ÃnhԂ܂
 * @return EBhE nh
 */
HWND CWndProc::Detach()
{
	HWND hWnd = m_hWnd;
	if (hWnd != NULL)
	{
		std::map<HWND, CWndProc*>* pMap = sm_pWndMap;
		if (pMap)
		{
			std::map<HWND, CWndProc*>::iterator it = pMap->find(hWnd);
			if (it != pMap->end())
			{
				pMap->erase(it);
			}
		}
		m_hWnd = NULL;
	}
	return hWnd;
}

/**
 * ̃o[֐̓EBhETuNXOɁAق̃TuNXɕKvȑ邽߂Ƀt[[NĂ΂܂
 */
void CWndProc::PreSubclassWindow()
{
	// no default processing
}

/**
 * EBhE𓮓ITuNXACWnd IuWFNgɌѕt邽߂ɂ̃o[֐Ăяo܂
 * @param[in] hWnd EBhE nh
 * @retval TRUE 
 * @retval FALSE s
 */
BOOL CWndProc::SubclassWindow(HWND hWnd)
{
	if (!Attach(hWnd))
	{
		return FALSE;
	}

	PreSubclassWindow();

	WNDPROC newWndProc = &CWndProc::WndProc;
	WNDPROC oldWndProc = reinterpret_cast<WNDPROC>(::SetWindowLongPtr(hWnd, GWLP_WNDPROC, reinterpret_cast<LONG_PTR>(newWndProc)));
	if ((m_pfnSuper == NULL) && (oldWndProc != newWndProc))
	{
		m_pfnSuper = oldWndProc;
	}
	return TRUE;
}

/**
 * Rg[𓮓ITuNXACWnd IuWFNgɌѕt邽߂ɂ̃o[֐Ăяo܂
 * @param[in] nID Rg[ ID
 * @param[in] pParent Rg[̐e
 * @retval TRUE 
 * @retval FALSE s
 */
BOOL CWndProc::SubclassDlgItem(UINT nID, CWndProc* pParent)
{
	HWND hWndControl = ::GetDlgItem(pParent->m_hWnd, nID);
	if (hWndControl != NULL)
	{
		return SubclassWindow(hWndControl);
	}
	return FALSE;
}

/**
 * WndProc Ɍ̒lݒ肵 CWnd IuWFNg HWND ŎʂEBhE؂藣߂ɁÃo[֐Ăяo܂
 * @return TuNXꂽEBhEւ̃nh
 */
HWND CWndProc::UnsubclassWindow()
{
	if (m_pfnSuper != NULL)
	{
		::SetWindowLongPtr(m_hWnd, GWLP_WNDPROC, reinterpret_cast<LONG_PTR>(m_pfnSuper));
		m_pfnSuper = NULL;
	}
	return Detach();
}

/**
 * w肳ꂽEBhE쐬A CWndProc IuWFNgɃA^b`܂
 * @param[in] dwExStyle gEBhE X^C
 * @param[in] lpszClassName o^ĂVXe EBhE NX̖O
 * @param[in] lpszWindowName EBhE̕\
 * @param[in] dwStyle EBhE X^C
 * @param[in] x ʂ܂͐eEBhE̍[EBhȄʒu܂ł̐̋
 * @param[in] y ʂ܂͐eEBhȄ[EBhȄʒu܂ł̐̋
 * @param[in] nWidth EBhE̕ (sNZP)
 * @param[in] nHeight EBhE̍ (sNZP)
 * @param[in] hwndParent eEBhEւ̃nh
 * @param[in] nIDorHMenu EBhE ID
 * @param[in] lpParam [U[ f[^
 * @retval TRUE 
 * @retval FALSE s
 */
BOOL CWndProc::CreateEx(DWORD dwExStyle, LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, int x, int y, int nWidth, int nHeight, HWND hwndParent, HMENU nIDorHMenu, LPVOID lpParam)
{
	// Xbĥ݋
	if (sm_dwThreadId != ::GetCurrentThreadId())
	{
		PostNcDestroy();
		return FALSE;
	}

	CREATESTRUCT cs;
	cs.dwExStyle = dwExStyle;
	cs.lpszClass = lpszClassName;
	cs.lpszName = lpszWindowName;
	cs.style = dwStyle;
	cs.x = x;
	cs.y = y;
	cs.cx = nWidth;
	cs.cy = nHeight;
	cs.hwndParent = hwndParent;
	cs.hMenu = nIDorHMenu;
	cs.hInstance = sm_hInstance;
	cs.lpCreateParams = lpParam;

	if (!PreCreateWindow(cs))
	{
		PostNcDestroy();
		return FALSE;
	}

	HookWindowCreate(this);
	HWND hWnd = ::CreateWindowEx(cs.dwExStyle, cs.lpszClass, cs.lpszName, cs.style, cs.x, cs.y, cs.cx, cs.cy, cs.hwndParent, cs.hMenu, cs.hInstance, cs.lpCreateParams);
	if (!UnhookWindowCreate())
	{
		PostNcDestroy();
	}

	return (hWnd != NULL) ? TRUE : FALSE;
}

/**
 * CWnd IuWFNgɌѕtꂽ Windows ̃EBhE쐬OɁAt[[NĂяo܂
 * @param[in,out] cs CREATESTRUCT ̍\
 * @retval TRUE p
 */
BOOL CWndProc::PreCreateWindow(CREATESTRUCT& cs)
{
	return TRUE;
}

/**
 * EBhE쐬tbN
 * @param[in] pWnd EBhE
 */
void CWndProc::HookWindowCreate(CWndProc* pWnd)
{
	// Xbĥ݋
	ASSERT(sm_dwThreadId == ::GetCurrentThreadId());

	if (sm_pWndInit == pWnd)
	{
		return;
	}

	ASSERT(sm_hHookOldCbtFilter != NULL);
	ASSERT(pWnd != NULL);
	ASSERT(pWnd->m_hWnd == NULL);
	ASSERT(sm_pWndInit == NULL);
	sm_pWndInit = pWnd;
}

/**
 * EBhE쐬AtbN
 * @retval true tbN
 * @retval false tbNȂ
 */
bool CWndProc::UnhookWindowCreate()
{
	if (sm_pWndInit != NULL)
	{
		sm_pWndInit = NULL;
		return false;
	}
	return true;
}

/**
 * tbN tB^
 * @param[in] nCode R[h
 * @param[in] wParam p^
 * @param[in] lParam p^
 * @return Ug R[h
 */
LRESULT CALLBACK CWndProc::CbtFilterHook(int nCode, WPARAM wParam, LPARAM lParam)
{
	if (nCode == HCBT_CREATEWND)
	{
		HWND hWnd = reinterpret_cast<HWND>(wParam);
		LPCREATESTRUCT lpcs = reinterpret_cast<LPCBT_CREATEWND>(lParam)->lpcs;

		CWndProc* pWndInit = sm_pWndInit;
		if (pWndInit != NULL)
		{
			pWndInit->Attach(hWnd);
			pWndInit->PreSubclassWindow();

			WNDPROC newWndProc = &CWndProc::WndProc;
			WNDPROC oldWndProc = reinterpret_cast<WNDPROC>(::SetWindowLongPtr(hWnd, GWLP_WNDPROC, reinterpret_cast<LONG_PTR>(newWndProc)));
			if (oldWndProc != newWndProc)
			{
				pWndInit->m_pfnSuper = oldWndProc;
			}
			sm_pWndInit = NULL;
		}
	}
	return ::CallNextHookEx(sm_hHookOldCbtFilter, nCode, wParam, lParam);
}

/**
 * CWndProc IuWFNgɊ֘Atꂽ Windows ̃EBhEj܂
 * @return EBhEjꂽꍇ 0 ȊOԂ܂BȊȌꍇ 0 Ԃ܂
 */
BOOL CWndProc::DestroyWindow()
{
	if (m_hWnd == NULL)
	{
		return FALSE;
	}

	CWndProc* pWnd = FromHandlePermanent(m_hWnd);

	HWND oldhWnd = m_hWnd;
	if (pWnd != NULL)
	{
		UnsubclassWindow(); //  Detach();
	}

	const BOOL bResult = ::DestroyWindow(oldhWnd);

	return bResult;
}

/**
 * EBhE vV[W
 * @param[in] hWnd EBhE nh
 * @param[in] message  Windows bZ[Ww肵܂
 * @param[in] wParam bZ[W̏Ŏgt񋟂܂B̃p[^̒l̓bZ[WɈˑ܂
 * @param[in] lParam bZ[W̏Ŏgt񋟂܂B̃p[^̒l̓bZ[WɈˑ܂
 * @return bZ[WɈˑlԂ܂
 */
LRESULT CALLBACK CWndProc::WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	CWndProc* pWnd = FromHandlePermanent(hWnd);
	if (pWnd == NULL)
	{
		return ::DefWindowProc(hWnd, message, wParam, lParam);
	}
	else
	{
		return pWnd->WindowProc(message, wParam, lParam);
	}
}

/**
 * CWndProc IuWFNg Windows vV[W (WindowProc) pӂĂ܂
 * @param[in] nMsg  Windows bZ[Ww肵܂
 * @param[in] wParam bZ[W̏Ŏgt񋟂܂B̃p[^̒l̓bZ[WɈˑ܂
 * @param[in] lParam bZ[W̏Ŏgt񋟂܂B̃p[^̒l̓bZ[WɈˑ܂
 * @return bZ[WɈˑlԂ܂
 */
LRESULT CWndProc::WindowProc(UINT nMsg, WPARAM wParam, LPARAM lParam)
{
	if (nMsg == WM_COMMAND)
	{
		if (OnCommand(wParam, lParam))
		{
			return 0;
		}
	}
	else if (nMsg == WM_NOTIFY)
	{
		NMHDR* pNMHDR = reinterpret_cast<NMHDR*>(lParam);
		if (pNMHDR->hwndFrom != NULL)
		{
			LRESULT lResult = 0;
			if (OnNotify(wParam, lParam, &lResult))
			{
				return lResult;
			}
		}
	}
	else if (nMsg == WM_NCDESTROY)
	{
		OnNcDestroy(wParam, lParam);
		return 0;
	}
	return DefWindowProc(nMsg, wParam, lParam);
}

/**
 * [U[j[̍ڂIƂɁAt[[NɂČĂяo܂
 * @param[in] wParam p^
 * @param[in] lParam p^
 * @retval TRUE AvP[ṼbZ[W
 */
BOOL CWndProc::OnCommand(WPARAM wParam, LPARAM lParam)
{
	return FALSE;
}

/**
 * t[[ŃACxgRg[ɔꍇARg[ꕔ̎ނ̏vRg[eEBhEɒʒm邽߂ɁÃo[֐Ăяo܂
 * @param[in] wParam bZ[WRg[炻̃bZ[W𑗐MRg[ʂ܂
 * @param[in] lParam ʒmR[hƒǉ܂ޒʒmbZ[W (NMHDR) ̍\̂ւ̃|C^[
 * @param[out] pResult bZ[WꂽƂʂi[R[h LRESULT ̕ϐւ̃|C^[
 * @retval TRUE bZ[W
 * @retval FALSE bZ[WȂ
 */
BOOL CWndProc::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult)
{
	return FALSE;
}

/**
 * Windows ̃EBhEjƂɔNCAg̈悪jƁAŌɌĂяoꂽo[֐́At[[NɂČĂяo܂
 * @param[in] wParam p^
 * @param[in] lParam p^
 */
void CWndProc::OnNcDestroy(WPARAM wParam, LPARAM lParam)
{
	LONG_PTR pfnWndProc = ::GetWindowLongPtr(m_hWnd, GWLP_WNDPROC);
	DefWindowProc(WM_NCDESTROY, wParam, lParam);
	if (::GetWindowLong(m_hWnd, GWLP_WNDPROC) == pfnWndProc)
	{
		if (m_pfnSuper != NULL)
		{
			::SetWindowLongPtr(m_hWnd, GWLP_WNDPROC, reinterpret_cast<LONG_PTR>(m_pfnSuper));
			m_pfnSuper = NULL;
		}
	}
	Detach();

	// call special post-cleanup routine
	PostNcDestroy();
}

/**
 * EBhEjꂽɊ OnNcDestroy ̃o[֐ɂČĂяo܂
 */
void CWndProc::PostNcDestroy()
{
}

/**
 * ̃EBhE vV[WĂяo܂
 * @param[in] nMsg  Windows bZ[Ww肵܂
 * @param[in] wParam bZ[Wˑ̒ǉw肵܂
 * @param[in] lParam bZ[Wˑ̒ǉw肵܂
 * @return ꂽbZ[WɈˑ܂
 */
LRESULT CWndProc::DefWindowProc(UINT nMsg, WPARAM wParam, LPARAM lParam)
{
	if (m_pfnSuper != NULL)
	{
		return ::CallWindowProc(m_pfnSuper, m_hWnd, nMsg, wParam, lParam);
	}
	else
	{
		return ::DefWindowProc(m_hWnd, nMsg, wParam, lParam);
	}
}
