/**
 * @file	sdasio.h
 * @brief	ASIO I[fBI NX̐錾уC^[tFCX̒`܂
 */

#pragma once

#include "asio\asiosdk.h"
#include "asio\asiodriverlist.h"
#include "sdbase.h"

/**
 * @brief ASIO I[fBI NX
 */
class CSoundDeviceAsio : public CSoundDeviceBase
{
public:
	static void Initialize();
	static void EnumerateDevices(std::vector<LPCTSTR>& devices);

	CSoundDeviceAsio();
	virtual ~CSoundDeviceAsio();
	virtual bool Open(LPCTSTR lpDevice = NULL, HWND hWnd = NULL);
	virtual void Close();
	virtual UINT CreateStream(UINT nSamplingRate, UINT nChannels, UINT nBufferSize = 0);
	virtual void DestroyStream();
	virtual bool PlayStream();
	virtual void StopStream();

private:
	static CSoundDeviceAsio* sm_pInstance;			/*!< ݂̃CX^X */
	IASIO* m_pAsioDriver;							/*!< ASIO hCo */
	UINT m_nBufferLength;							/*!< obt@ TCY */
	std::vector<ASIOBufferInfo> m_bufferInfo;		/*!< obt@ */
	ASIOCallbacks m_callback;						/*!< R[obN */
	static AsioDriverList sm_asioDriverList;		/*!< hCo Xg */
	static void cBufferSwitch(long doubleBufferIndex, ASIOBool directProcess);
	static void cSampleRateDidChange(ASIOSampleRate sRate);
	static long cAsioMessage(long selector, long value, void* message, double* opt);
	static ASIOTime* cBufferSwitchTimeInfo(ASIOTime* params, long doubleBufferIndex, ASIOBool directProcess);
	void BufferSwitch(long doubleBufferIndex, ASIOBool directProcess);
};
