/**
 * @file	ct1741.h
 * @brief	Interface of the Creative SoundBlaster16 CT1741
 */

#pragma once

#ifdef SUPPORT_SOUND_SB16

#include "sound.h"
#include "io/dmac.h"

// DSPZbg
typedef enum {
	CT1741_DSPRST_NORMAL,
	CT1741_DSPRST_RESET,
	CT1741_DSPRST_SPECIAL,
} CT1741_DSPRST;

// DMA][h
typedef enum {
	CT1741_DMAMODE_NONE,
	CT1741_DMAMODE_2, 
	CT1741_DMAMODE_3, 
	CT1741_DMAMODE_4, 
	CT1741_DMAMODE_8,
	CT1741_DMAMODE_16,
	CT1741_DMAMODE_16A,
} CT1741_DMAMODE;

// DSP[h
typedef enum {
	CT1741_DSPMODE_NONE, // ĐĂȂ
	CT1741_DSPMODE_DAC, // PIOĐ[h
	CT1741_DSPMODE_DMA, // DMAĐ[h
	CT1741_DSPMODE_DMA_PAUSE, // DMAĐ[hiꎞ~j
	CT1741_DSPMODE_DMA2, // DMAĐ[hiŌ݊pj
	CT1741_DSPMODE_DMA_IN, // DMA^[h
} CT1741_DSPMODE;

// DSP DMAobt@TCY
#define CT1741_DMA_BUFSIZE  1024
// DSP DMAobt@}XN
#define CT1741_DMA_BUFMASK  (CT1741_DMA_BUFSIZE - 1)
// DSP DMAǂݎP
#define CT1741_DMA_READINTERVAL	(CT1741_DMA_BUFSIZE / 8)

// DSP R}hobt@TCY
#define CT1741_DSP_BUFSIZE 64

// DSP DMA@p~tO͖gp]݊̂ߎcĂ
typedef struct {
	BOOL stereo; // XeIĐ
	BOOL obsolete1; // p~
	BOOL autoinit; // pĐ[h
	CT1741_DMAMODE mode; // DMA][h
	UINT32 obsolete2; // p~
	UINT32 obsolete3; // p~
	UINT32 total; // DMA]f[^
	UINT32 obsolete4;  // p~
	UINT32 obsolete5; // p~
	SINT16 obsolete6[CT1741_DMA_BUFSIZE]; // p~
	DMACH dmach; // gpDMA`l
	UINT32 obsolete7; // p~

	UINT bufsize; // TEhĐp̏zobt@TCYBf[^read/write4bytePʁi16bitXeI1TvPʁjōs
	UINT bufdatas; // obt@̃f[^oCg
	UINT bufpos; // obt@̓ǂݎʒuBbufwposƈvĂ悢ǂzĂ͂Ȃ
	UINT bufwpos; // obt@݈̏ʒuBxbufposɒǂĂ͂Ȃivsj
	UINT32 obsolete_pos12; // TvOϊpip~j
	UINT32 obsolete_step12; // TvOϊpip~j
	UINT8 buffer[CT1741_DMA_BUFSIZE]; // PCMobt@
	UINT32 rate2; // ĐTvO[gip~j

	UINT8 lastautoinit; // ŌɎgppĐ[h
	UINT8 last16mode; // ŌɎgp16bit][h
	UINT32 laststartcount; // ŌɎgpDMA]TCY
	UINT32 laststartaddr; // ŌɎgpDMA]JnAhX
} DMA_INFO;

// DSP@p~tO͖gp]݊̂ߎcĂ
typedef struct {
	DMA_INFO dma; // DMA]
	UINT8 resetout; // DSP_RESETOUT
	UINT8 cmd; // DSPR}h
	UINT8 cmdlen; // DSPR}hp[^
	UINT8 obsolete1; // p~
	UINT8 obsolete2[CT1741_DSP_BUFSIZE]; // p~
	struct {
		UINT8 data[CT1741_DSP_BUFSIZE];
		UINT32 datalen;
		UINT32 reserved;
	} dspin; // DSP̓obt@ CPU -> DSP
	struct {
		UINT8 data[CT1741_DSP_BUFSIZE];
		UINT32 rpos;
		UINT32 datalen;
	} dspout; // DSPo̓Oobt@ DSP -> CPU
	UINT8 testreg; // DSPeXgpWX^
	UINT32 wbusy; // ݒǂ
	CT1741_DSPMODE mode; // DSP[h
	UINT32 freq; // DSP̃TvO[g
	UINT8 dmairq; // DSPI/O|[gœǂݏIRQ@ۂDMA̒lƂ͈Ⴄ̂ŒӁict1741_set_dma_irq, ct1741_get_dma_irqQƂ̂Ɓj
	UINT8 dmachnum; // DSPI/O|[gœǂݏDMA`lԍ@ۂDMA̒lƂ͈Ⴄ̂ŒӁict1741_set_dma_ch, ct1741_get_dma_chQƂ̂Ɓj
	UINT8 cmd_o; // ODSPR}h

	int smpcounter2; // DMA]Jnȍ~ɑꂽLȃf[^̍v
	int smpcounter; // DMA]Jnȍ~ɑꂽDMAf[^̍viȃf[^܂ށj

	UINT8 speaker; // o͗L
	UINT8 uartmode; // MIDIo̓[h
} DSP_INFO;

// SB16
typedef struct {
	UINT8	dmairq; // SB16IRQ
	UINT8	dmachnum; // SB16DMA`lԍ
	UINT16	base; // SB16̃x[XAhX

	UINT8	mixsel; // SB16~LT[WX^̃ANZXCfbNX
	UINT8	mixreg[0x100]; // SB16~LT[WX^
	UINT32	mixregexp[0x100]; // SB16~LT[WX^iʃXP[Zς݁j

	DSP_INFO dsp_info; // DSP
} SB16;

// Xe[gZ[u݊ێp
#define SIZEOF_SB16_OLD	4704

// DSP PIOobt@TCY
#define CT1741_PIO_BUFSIZE 16384
// DSP PIOobt@}XN
#define CT1741_PIO_BUFMASK (CT1741_PIO_BUFSIZE - 1)

// ĐpɎgp
typedef struct {
	UINT8 buffer[CT1741_PIO_BUFSIZE];
	int bufpos;
	int bufwpos;
	int bufdatas;
} CT1741_PLAYINFO_PIO;
typedef struct {
	int bufdatasrem; // ~uԂ܂łɑĂf[^
	int playwaitcounter; // ĐfBCJE^

	// PIOĐpobt@Ȃ
	CT1741_PLAYINFO_PIO pio;

	// G~[^̍ĐTvO[g
	UINT32 playrate;
} CT1741_PLAYINFO;

extern CT1741_PLAYINFO ct1741_playinfo;

// eĐ[h̃ACg
extern int CT1741_BUF_ALIGN[];

#ifdef __cplusplus
extern "C"
{
#endif

#if defined(SUPPORT_MULTITHREAD)
void ct1741cs_enter_criticalsection(void);
void ct1741cs_leave_criticalsection(void);
#endif

void ct1741_initialize(UINT rate);

void ct1741_setpicirq(void);
void ct1741_resetpicirq(void);

void ct1741_set_dma_irq(UINT8 irq);
UINT8 ct1741_get_dma_irq();

void ct1741_set_dma_ch(UINT8 dmach);
UINT8 ct1741_get_dma_ch();

void ct1741_dma(NEVENTITEM item);
void ct1741_startdma();

REG8 DMACCALL ct1741dmafunc(REG8 func);

void SOUNDCALL ct1741_getpcm(DMA_INFO* ct, SINT32* pcm, UINT count);

#ifdef __cplusplus
};
#endif

#endif