/**
 * @file	wab.h
 * @brief	Window Accelerator Board Interface
 *
 * @author	$Author: SimK $
 */

#pragma once

// XXX: ]Ă1600x1600ȏɂȂȂ̂ōĂ͂ŏ\
#define WAB_MAX_WIDTH	1600
#define WAB_MAX_HEIGHT	1600

#ifdef __cplusplus
extern "C" {
#endif
	
typedef struct {
	int		posx;
	int		posy;
	int		multiwindow;
	int		multithread;
	int		halftone;
	int		forcevga;
	int		readonly; // from np2oscfg
} NP2WABCFG;

typedef int NP2WAB_DrawFrame();
typedef struct {
	REG8 relay; // ʏo̓[ԁibit0=EBhEANZ[^, bit1=RGB INX[, ȊÕrbgReservedBbit0,10098OtBbN
	REG8 paletteChanged; // pbgvXVtO
	int realWidth; // ʉ𑜓x()
	int realHeight; // ʉ𑜓x()
	int wndWidth; // `̈TCY()
	int wndHeight; // `̈TCY()
	int fps; // tbV[gi̍킹Ă邩Ȃǌ_ŉĂȂj
	int lastWidth; // ÕEBhEANZ[^̉𑜓xifoCXč쐬pj
	int lastHeight; // ÕEBhEANZ[^̉𑜓xifoCXč쐬pj
	
	int	relaystateint;
	int	relaystateext;

	int vramoffs;
} NP2WAB;

typedef struct {
	int multiwindow; // ʑ[h
	int ready; // 0ȊOȂ`Ăǂ
	HWND hWndMain; // CEBhẼnh
	HWND hWndWAB; // EBhEANZ[^ʑ̃nh
	HDC hDCWAB; // EBhEANZ[^ʑHDC
	HBITMAP hBmpBuf; // obt@rbg}bviɓ{j
	HDC     hDCBuf; // obt@HDC
	NP2WAB_DrawFrame *drawframe; // ʕ`֐BhDCBufɃANZ[^ʃf[^]B
} NP2WABWND;

void np2wab_init(HINSTANCE hInstance, HWND g_hWndMain);
void np2wab_reset(const NP2CFG *pConfig);
void np2wab_bind(void);
void np2wab_drawframe(void);
void np2wab_shutdown(void);

void np2wab_setRelayState(REG8 state);
void np2wab_setScreenSize(int width, int height);
void np2wab_setScreenSizeMT(int width, int height);

void wabwin_readini(void);
void wabwin_writeini(void);

void np2wab_forceupdate(void);

extern NP2WAB		np2wab;
extern NP2WABCFG	np2wabcfg;
extern NP2WABWND	np2wabwnd;
//
//extern int		np2wab.relaystateint;
//extern int		np2wab.relaystateext;

#ifdef __cplusplus
}
#endif

