/**
 * @file	mt32snd.h
 * @brief	MT32Sound ANZX NX̐錾уC^[tFCX̒`܂
 */

#pragma once

#if defined(MT32SOUND_DLL)

/**
 * @brief MT32Sound ANZX NX
 */
class MT32Sound
{
public:
	static MT32Sound* GetInstance();

	MT32Sound();
	~MT32Sound();
	bool Initialize();
	void Deinitialize();
	bool IsEnabled() const;
	void SetRate(UINT nRate);

	bool Open();
	void Close();
	void ShortMsg(UINT32 msg);
	void LongMsg(const UINT8* lpBuffer, UINT cchBuffer);
	UINT Mix(SINT32* lpBuffer, UINT cchBuffer);

private:
	static MT32Sound sm_instance;	//!< B̃CX^Xł

	//! @brief [h֐
	struct ProcItem
	{
		LPCSTR lpSymbol;			//!< ֐
		size_t nOffset;				//!< ItZbg
	};

	// `
	typedef int (*FnOpen)(int rate, int reverb, int def, int revtype, int revtime, int revlvl); 	/*!< I[v */
	typedef int (*FnClose)(void);																	/*!< N[Y */
	typedef int (*FnWrite)(unsigned char data);														/*!< Cg */
	typedef int (*FnMix)(void *buff, unsigned long size);											/*!< ~bNX */

	HMODULE m_hModule;	/*!< W[ */
	bool m_bOpened;		/*!< I[v tO */
	UINT m_nRate;		/*!< TvO [g */
	FnOpen m_fnOpen;	/*!< I[v֐ */
	FnClose m_fnClose;	/*!< N[Y֐ */
	FnWrite m_fnWrite;	/*!< Cg֐ */
	FnMix m_fnMix;		/*!< ~bNX֐ */
};

/**
 * CX^X擾
 * @return CX^X
 */
inline MT32Sound* MT32Sound::GetInstance()
{
	return &sm_instance;
}

/**
 * L?
 * @retval true L
 * @retval false 
 */
inline bool MT32Sound::IsEnabled() const
{
	return (m_hModule != NULL);
}

/**
 * TvO [gݒ
 * @param[in] nRate [g
 */
inline void MT32Sound::SetRate(UINT nRate)
{
	m_nRate = nRate;
}

#endif
