/**
 * @file	subwnd.cpp
 * @brief	Tu EBhE̊NX̓̒`s܂
 */

#include "compiler.h"
#include "resource.h"
#include "subwnd.h"
#include "np2.h"
#include "np2mt.h"
#include "soundmng.h"
#include "mousemng.h"
#include "winloc.h"
#include "dialog/np2class.h"
#include "misc\tstring.h"

extern WINLOCEX np2_winlocexallwin(HWND base);

//! NX
static const TCHAR s_szClassName[] = TEXT("NP2-SubWnd");

/**
 * 
 * @param[in] hInstance CX^X
 */
void CSubWndBase::Initialize(HINSTANCE hInstance)
{
	WNDCLASS wc;
	ZeroMemory(&wc, sizeof(wc));
	wc.style = CS_BYTEALIGNCLIENT | CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wc.lpfnWndProc = ::DefWindowProc;
	wc.cbWndExtra = NP2GWLP_SIZE;
	wc.hInstance = hInstance;
	wc.hIcon = ::LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON2));
	wc.hCursor = ::LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = static_cast<HBRUSH>(::GetStockObject(NULL_BRUSH));
	wc.lpszClassName = s_szClassName;
	RegisterClass(&wc);
}

/**
 * RXgN^
 */
CSubWndBase::CSubWndBase()
	: m_wlex(NULL)
{
}

/**
 * fXgN^
 */
CSubWndBase::~CSubWndBase()
{
}

/**
 * EBhE쐬
 * @param[in] nCaptionID LvV ID
 * @param[in] dwStyle X^C
 * @param[in] x XW
 * @param[in] y YW
 * @param[in] nWidth 
 * @param[in] nHeight 
 * @param[in] hwndParent eEBhE
 * @param[in] nIDorHMenu ID  j[
 * @retval TRUE 
 * @retval FALSE s
 */
BOOL CSubWndBase::Create(UINT nCaptionID, DWORD dwStyle, int x, int y, int nWidth, int nHeight, HWND hwndParent, HMENU nIDorHMenu)
{
	BOOL r;
	std::tstring rCaption(LoadTString(nCaptionID));
	r = CreateEx(0, s_szClassName, rCaption.c_str(), dwStyle, x, y, nWidth, nHeight, hwndParent, nIDorHMenu);
	winloc_DisableCornerRound(m_hWnd);
	return r;
}

/**
 * EBhE쐬
 * @param[in] lpCaption LvV
 * @param[in] dwStyle X^C
 * @param[in] x XW
 * @param[in] y YW
 * @param[in] nWidth 
 * @param[in] nHeight 
 * @param[in] hwndParent eEBhE
 * @param[in] nIDorHMenu ID  j[
 * @retval TRUE 
 * @retval FALSE s
 */
BOOL CSubWndBase::Create(LPCTSTR lpCaption, DWORD dwStyle, int x, int y, int nWidth, int nHeight, HWND hwndParent, HMENU nIDorHMenu)
{
	BOOL r = CreateEx(0, s_szClassName, lpCaption, dwStyle, x, y, nWidth, nHeight, hwndParent, nIDorHMenu);
	winloc_DisableCornerRound(m_hWnd);
	return r;
}

/**
 * EBhE ^Cv̐ݒ
 * @param[in] nType ^Cv
 */
void CSubWndBase::SetWndType(UINT8 nType)
{
	WINLOCEX wlex = ::np2_winlocexallwin(g_hWndMain);
	winlocex_setholdwnd(wlex, m_hWnd);
	np2class_windowtype(m_hWnd, nType);
	winlocex_move(wlex);
	winlocex_destroy(wlex);
}

/**
 * CWndProc IuWFNg Windows vV[W (WindowProc) pӂĂ܂
 * @param[in] nMsg  Windows bZ[Ww肵܂
 * @param[in] wParam bZ[W̏Ŏgt񋟂܂B̃p[^̒l̓bZ[WɈˑ܂
 * @param[in] lParam bZ[W̏Ŏgt񋟂܂B̃p[^̒l̓bZ[WɈˑ܂
 * @return bZ[WɈˑlԂ܂
 */
LRESULT CSubWndBase::WindowProc(UINT nMsg, WPARAM wParam, LPARAM lParam)
{
	switch (nMsg)
	{
		case WM_KEYDOWN:
		case WM_KEYUP:
			::SendMessage(g_hWndMain, nMsg, wParam, lParam);
			break;

		case WM_ENTERMENULOOP:
			if(!np2_multithread_Enabled())
			{
				CSoundMng::GetInstance()->Disable(SNDPROC_SUBWIND);
			}
			break;

		case WM_EXITMENULOOP:
			if(!np2_multithread_Enabled())
			{
				CSoundMng::GetInstance()->Enable(SNDPROC_SUBWIND);
			}
			break;

		case WM_ENTERSIZEMOVE:
			if(!np2_multithread_Enabled())
			{
				CSoundMng::GetInstance()->Disable(SNDPROC_SUBWIND);
			}
			winlocex_destroy(m_wlex);
			m_wlex = np2_winlocexallwin(m_hWnd);
			break;

		case WM_MOVING:
			if (np2oscfg.WINSNAP) { // Xibvݒʂ np21w ver0.86 rev22
				winlocex_moving(m_wlex, reinterpret_cast<RECT*>(lParam));
			}
			break;

		case WM_EXITSIZEMOVE:
			::winlocex_destroy(m_wlex);
			m_wlex = NULL;
			if(!np2_multithread_Enabled())
			{
				CSoundMng::GetInstance()->Enable(SNDPROC_SUBWIND);
			}
			break;

		case WM_MOUSEMOVE:
		case WM_NCMOUSEMOVE:
			mousemng_updatemouseon(false);
			break;

		case WM_CLOSE:
			DestroyWindow();
			break;

		default:
			return CWndProc::WindowProc(nMsg, wParam, lParam);
	}
	return 0L;
}
