! mkrom.S
! This programme makes rom image files from floppy disk.
! To compile:	
!	as86 -0 -o mkrom.o mkrom.S
!	ld86 -0 -d -s -o mkrom.com.tmp mkrom.o
!	dd if=mkrom.com.tmp of=mkrom.com bs=1 skip=256
!	rm mkrom.com.tmp mkrom.o


ROM_BYTES		= 0x8000
BYTES_PER_CYLINDER	= 1024 * 8 * 2
TIMES_PER_MK_ROM	= ROM_BYTES / BYTES_PER_CYLINDER
BUFFER_SEG		= 0x6000
BUFFER_OFF		= 0
DISK_INT		= 0x1b
DOS_INT			= 0x21

CR			= 0x0d
LF			= 0x0a
END_CHAR		= '$'

ANY			= 0


use16

.text		
.bss
.data

.align	0

.globl	_main

	.org	0x100
_main:
	mov	ax, #0x0390
	int	#DISK_INT	; initialize disk
	
	mov	bx, #rom_00000
	call	mk_rom
	mov	bx, #rom_c0000
	call	mk_rom
	mov	bx, #rom_c8000
	call	mk_rom
	mov	bx, #rom_d0000
	call	mk_rom
	mov	bx, #rom_d8000
	call	mk_rom
	mov	bx, #rom_e8000
	call	mk_rom
	mov	bx, #rom_f0000
	call	mk_rom
	mov	bx, #rom_f8000
	call	mk_rom
	
	mov	ax, #0x4c00
	int	#DOS_INT	; exit

! already must set rom_???? to bx
mk_rom:
	mov	bx_orig, bx
	
	mov	ah, #0x3c
	mov	dx, bx_orig
	mov	cx, #0
	int	#DOS_INT	; create handle
	jc	create_error_exit
	mov	handle, ax
	
	mov	cx, #TIMES_PER_MK_ROM
	mov	bp, #BUFFER_OFF

cylinder_loop:
	push	cx
	mov	cl, cylinder
	mov	dh, #0		; head
	mov	dl, #1		; sector
	mov	ch, #3		; sector len
	mov	bx, #BYTES_PER_CYLINDER
	mov	ax, #BUFFER_SEG
	mov	es, ax
	mov	ax, #0xd690	; multi track
	int	#DISK_INT	; read disk
	jc	read_error_exit
	inc	cylinder
	add	bp, #BYTES_PER_CYLINDER	
	pop	cx
	loop	cylinder_loop
		
	mov	bx, handle
	mov	cx, #ROM_BYTES	; len
	mov	dx, #BUFFER_OFF	; off
	mov	ax, #BUFFER_SEG
	mov	ds, ax		; seg
	mov	ah, #0x40
	int	#DOS_INT	; write handle
	mov	ax, cs
	mov	ds, ax
	jc	write_error_exit

	mov	ah, #0x3e
	mov	bx, handle
	int	#DOS_INT	; close handle

	mov	dx, bx_orig
	call	print
	mov	dx, #mk_rom_msg
	call	print
	ret
	
print:	
	mov	ah, #0x09
	int	#DOS_INT	; print
	ret
create_error_exit:
	mov	dx, #create_error_msg
	jmp	error_exit
read_error_exit:
	mov	dx, #read_error_msg
	jmp	error_exit
write_error_exit:
	mov	dx, #write_error_msg
	jmp	error_exit
error_exit:
	call	print
	mov	ax, #0x4c01
	int	#DOS_INT	; exit
		
handle:
		.word	ANY
cylinder:
		.word	1	; 0 is IPL
bx_orig:
		.word	ANY
mk_rom_msg:
		.ascii	" made."
		.byte	CR, LF, END_CHAR	
create_error_msg:	
		.ascii	"create handle error"
		.byte	CR, LF, END_CHAR
read_error_msg:	
		.ascii	"read disk error (disk bios)"
		.byte	CR, LF, END_CHAR
write_error_msg:	
		.ascii	"write handle error"
		.byte	CR, LF, END_CHAR
	
rom_00000:
	.ascii	"00000.rom"	; filename
	.byte	0
	.byte	END_CHAR	; for print
rom_c0000:
	.ascii	"c0000.rom"	; filename
	.byte	0
	.byte	END_CHAR	; for print
rom_c8000:
	.ascii	"c8000.rom"	; filename
	.byte	0
	.byte	END_CHAR	; for print
rom_d0000:
	.ascii	"d0000.rom"	; filename
	.byte	0
	.byte	END_CHAR	; for print
rom_d8000:
	.ascii	"d8000.rom"	; filename
	.byte	0
	.byte	END_CHAR	; for print
rom_e8000:
	.ascii	"e8000.rom"	; filename
	.byte	0
	.byte	END_CHAR	; for print
rom_f0000:
	.ascii	"f0000.rom"	; filename
	.byte	0
	.byte	END_CHAR	; for print
rom_f8000:
	.ascii	"f8000.rom"	; filename
	.byte	0
	.byte	END_CHAR	; for print

end
