! ipl.S
! This programme writes rom images to floppy disk.
! To compile:	
!	as86 -0 -o ipl.o ipl.S
!	ld86 -0 -d -s -o ipl.dat ipl.o
!	chmod a-x ipl.dat	
!	rm ipl.o


ROM_BYTES		= 0x8000	
BYTES_PER_CYLINDER	= 1024 * 8 * 2
TIMES_PER_MK_ROM	= ROM_BYTES / BYTES_PER_CYLINDER	


use16

.text		
.bss
.data

.align	0

.globl	_main

	.org	0
_main:
	mov	ax, cs
	mov	ds, ax
	
	mov	ax, #0x0390
	int	#0x1b		; initialize disk
	
	mov	bx, #rom_00000
	call	mk_rom
	mov	bx, #rom_c0000
	call	mk_rom
	mov	bx, #rom_c8000
	call	mk_rom
	mov	bx, #rom_d0000
	call	mk_rom
	mov	bx, #rom_d8000
	call	mk_rom
	mov	bx, #rom_e8000
	call	mk_rom
	mov	bx, #rom_f0000
	call	mk_rom
	mov	bx, #rom_f8000
	call	mk_rom
	
	mov	si, #succeed_msg
	mov	cx, succeed_msg_len
	jmp	print

! already must set rom_????? to bx
mk_rom:
	mov	cx, #TIMES_PER_MK_ROM
	mov	bp, [bx+2]
cylinder_loop:
	push	cx
	mov	cl, cylinder
	mov	dh, #0		; head
	mov	dl, #1		; sector
	mov	ch, #3		; sector len
	mov	ax, [bx+0]
	mov	es, ax
	push	bx
	mov	bx, #BYTES_PER_CYLINDER
	mov	ax, #0xd590	; multi track
	int	#0x1b		; write disk
	pop	bx
	jc	write_error_exit
	inc	cylinder
	add	bp, #BYTES_PER_CYLINDER
	pop	cx
	loop	cylinder_loop
	ret

print:
	mov	al, #0x04
	out	#0x68, al
	mov	al, #0x0f
	out	#0x68, al
	
	cld
	
	push	cx
	shl	cx, #1
	mov	ax, #0xa000
	mov	es, ax
	mov	di, #0
	rep
	movsb
	pop	cx
	
	mov	ax, #0xa200
	mov	es, ax
	mov	di, #0
	mov	ax, #0x00e1
	rep
	stosw

print_loop:
	jmp	print_loop	
	
		
write_error_exit:
	mov	si, #write_error_msg
	mov	cx, write_error_msg_len
	jmp	print

cylinder:
	.word	1		; 0 is IPL
	
write_error_msg:
	.ascii	"e"
	.byte	0
	.ascii	"r"
	.byte	0
	.ascii	"r"
	.byte	0
	.ascii	"o"
	.byte	0
	.ascii	"r"
	.byte	0
write_error_msg_len:
	.word	5
succeed_msg:
	.ascii	"s"
	.byte	0
	.ascii	"u"
	.byte	0
	.ascii	"c"
	.byte	0
	.ascii	"c"
	.byte	0
	.ascii	"e"
	.byte	0
	.ascii	"e"
	.byte	0
	.ascii	"d"
	.byte	0
succeed_msg_len:
	.word	7
			
rom_00000:
	.word	0x0000		; seg
	.word	0x0000		; off
rom_c0000:
	.word	0xc000		; seg
	.word	0x0000		; off
rom_c8000:
	.word	0xc800		; seg
	.word	0x0000		; off
rom_d0000:
	.word	0xd000		; seg
	.word	0x0000		; off
rom_d8000:
	.word	0xd800		; seg
	.word	0x0000		; off
rom_e8000:
	.word	0xe800		; seg
	.word	0x0000		; off
rom_f0000:
	.word	0xf000		; seg
	.word	0x0000		; off
rom_f8000:
	.word	0xf800		; seg
	.word	0x0000		; off

end
