! mkimage.S
! This programme makes a floppy disk image file as "fd0".
! To compile:	
!	as86 -0 -o mkimage.o mkimage.S
!	ld86 -0 -d -s -o mkimage.com.tmp mkimage.o
!	dd if=mkimage.com.tmp of=mkimage.com bs=1 skip=256
!	rm mkimage.com.tmp mkimage.o


BUFFER_SEG		= 0x6000
BUFFER_OFF		= 0	
BYTES_PER_CYLINDER	= 1024 * 8 * 2
CYLINDER_NUM		= 77	; 0 - 76, 1cylinder = 2track

CR			= 0x0d
LF			= 0x0a
END_CHAR		= '$'

ANY			= 0


use16

.text		
.bss
.data

.align	0

.globl	_main

	.org	0x100
_main:
	mov	ax, #0x0390
	int	#0x1b		; initialize disk
	
	mov	ah, #0x3c
	mov	dx, #filename
	mov	cx, #0
	int	#0x21		; open handle
	jc	open_error_exit
	mov	handle, ax
	
cylinder_loop:
	mov	cl, cylinder
	mov	dh, #0		; head
	mov	dl, #1		; sector
	mov	ch, #3		; sector len
	mov	bx, #BYTES_PER_CYLINDER
	mov	ax, #BUFFER_SEG
	mov	es, ax
	mov	bp, #BUFFER_OFF
	mov	ax, #0xd690	; multi track
	int	#0x1b		; read disk
	jc	read_error_exit
	
	mov	cx, #BYTES_PER_CYLINDER
	mov	bx, handle
	mov	ax, #BUFFER_SEG
	mov	ds, ax
	mov	dx, #BUFFER_OFF
	mov	ah, #0x40
	int	#0x21		; write handle
	mov	ax, cs
	mov	ds, ax
	jc	write_error_exit
	
	inc	cylinder
	mov	al, cylinder
	cmp	al, #CYLINDER_NUM
	jb	cylinder_loop
	
	mov	ah, #0x3e
	mov	bx, handle
	int	#0x21		; close handle
	mov	ax, #0x4c00
	int	#0x21		; exit
	
open_error_exit:
	mov	dx, #open_errormsg
	jmp	error_exit
read_error_exit:
	mov	dx, #read_errormsg
	jmp	error_exit
write_error_exit:
	mov	dx, #write_errormsg
	jmp	error_exit
error_exit:
	mov	ah, #0x09
	int	#0x21		; print
	mov	ax, #0x4c01
	int	#0x21		; exit

handle:
		.word	ANY
cylinder:
		.byte	0
filename:	
		.ascii	"fd0"
		.byte	0
open_errormsg:	
		.ascii	"open file error"
		.byte	CR, LF, END_CHAR
read_errormsg:	
		.ascii	"read disk error (disk bios)"
		.byte	CR, LF, END_CHAR
write_errormsg:	
		.ascii	"write file error"
		.byte	CR, LF, END_CHAR
	
	end
