! writeipl.S
! This programme writes IPL to a floppy disk.
! To compile:
!	as86 -0 -o writeipl.o writeipl.S
!	ld86 -0 -d -s -o writeipl.com.tmp writeipl.o
!	dd if=writeipl.com.tmp of=writeipl.com bs=1 skip=256
!	rm writeipl.com.tmp writeipl.o


BUFFER_SEG		= 0x6000
BUFFER_OFF		= 0	
DOS_INT			= 0x21

CR			= 0x0d
LF			= 0x0a
END_CHAR		= '$'

ANY			= 0

	
use16

.text		
.bss
.data

.align	0

.globl	_main

	.org	0x100
_main:
	mov	ax, #0x3d00
	mov	dx, #filename
	int	#DOS_INT	; open handle
	jc	open_error_exit
	mov	handle, ax

	mov	ax, #0x4202
	mov	bx, handle
	mov	cx, #0
	mov	dx, #0
	int	#DOS_INT	; seek to bottom
	jc	seek_error_exit	
	mov	len, ax
		
	mov	ax, #0x4200
	mov	bx, handle
	mov	cx, #0
	mov	dx, #0
	int	#DOS_INT	; seek to top
	jc	seek_error_exit	
	
	mov	cx, len
	mov	bx, handle
	mov	ax, #BUFFER_SEG
	mov	ds, ax
	mov	dx, #BUFFER_OFF
	mov	ah, #0x3f
	int	#DOS_INT	; read handle
	mov	ax, cs
	mov	ds, ax
	jc	read_error_exit

	mov	ah, #0x3e
	mov	bx, handle
	int	#DOS_INT	; close handle
	
	mov	cl, #0		; cylinder
	mov	dh, #0		; head
	mov	dl, #1		; sector
	mov	ch, #3		; sector len
	mov	bx, #1024
	mov	ax, #BUFFER_SEG
	mov	es, ax
	mov	ax, #BUFFER_OFF
	mov	bp, ax
	mov	ax, #0xd590	; multi track
	int	#0x1b		; write disk
	jc	write_error_exit

	mov	ah, #0x09
	mov	dx, #succeed_msg
	int	#DOS_INT	; print
	mov	ax, #0x4c00
	int	#DOS_INT	; exit
	
open_error_exit:
	mov	dx, #open_error_msg
	jmp	error_exit
seek_error_exit:
	mov	dx, #seek_error_msg
	jmp	error_exit
read_error_exit:
	mov	dx, #read_error_msg
	jmp	error_exit
write_error_exit:
	mov	dx, #write_error_msg
	jmp	error_exit
error_exit:
	mov	ah, #0x09
	int	#DOS_INT	; print
	mov	ax, #0x4c01
	int	#DOS_INT	; exit

handle:
		.word	ANY
len:
		.word	ANY
filename:	
		.ascii	"ipl.dat"
		.byte	0
open_error_msg:	
		.ascii	"open handle error"
		.byte	CR, LF, END_CHAR
seek_error_msg:	
		.ascii	"seek handle error"
		.byte	CR, LF, END_CHAR
read_error_msg:	
		.ascii	"read handle error"
		.byte	CR, LF, END_CHAR
write_error_msg:	
		.ascii	"write disk error (disk bios)"
		.byte	CR, LF, END_CHAR
succeed_msg:
		.ascii	"succeeded"
		.byte	CR, LF, END_CHAR

end
