! cpli98.S
! This programme copies a file from Linux to 98.
! To compile:	
!	as86 -0 -o cpli98.o cpli98.S
!	ld86 -0 -d -s -o cpli98.com.tmp cpli98.o
!	dd if=cpli98.com.tmp of=cpli98.com bs=1 skip=256
!	rm cpli98.com.tmp cpli98.o

DOS_INT			= 0x21
MISC_INT		= 0xe0
BUFFER_SIZE		= 16384
	
CR			= 0x0d
LF			= 0x0a
END_CHAR		= '$'

ANY			= 0


use16

.text		
.bss
.data

.align	0

.globl	_main

	.org	0x100
_main:
	mov	ah, #0x5b
	mov	cx, #0				  ; normal attribute
	mov	dx, #new_file_name
	int	#DOS_INT			  ; create new file
	jc	errorexit_create_new_file
	mov	new_file_handle, ax
	
	mov	ah, #0x45
	mov	bx, new_file_handle
	int	#DOS_INT			  ; dup handle
	jc	errorexit_dup_handle
	mov	dup_handle, ax

	mov	ax, #1
	mov	bx, dup_handle
	int	#MISC_INT
	jc	errorexit_misc_int
	
read_write_loop:
	mov	ah, #0x3f
	mov	dx, #buffer
	mov	cx, #BUFFER_SIZE
	mov	bx, dup_handle
	int	#DOS_INT
	jc	errorexit_read_handle
	cmp	ax, #0
	jz	exit
	
	mov	cx, ax
	mov	ah, #0x40
	mov	dx, #buffer
	mov	bx, new_file_handle
	int	#DOS_INT
	jc	errorexit_write_handle
	cmp	ax, cx
	jnz	errorexit_write_handle

	jmp	read_write_loop

exit:
	mov	ax, #2
	int	#MISC_INT
	
 	mov	ah, #0x3e	
	mov	bx, new_file_handle
	int	#DOS_INT

	mov	ax, #0x4c00
	int	#DOS_INT
	
errorexit_create_new_file:
	mov	dx, #create_new_file_errormsg
	jmp	errorexit
errorexit_dup_handle:
	mov	dx, #dup_handle_errormsg
	jmp	errorexit
errorexit_misc_int:
	mov	dx, #misc_int_errormsg
	jmp	errorexit
errorexit_read_handle:
	mov	dx, #read_handle_errormsg
	jmp	errorexit
errorexit_write_handle:
	mov	dx, #read_handle_errormsg
	jmp	errorexit
errorexit:
	mov	ah, #0x09
	int	#DOS_INT			  ; print
	mov	ax, #0x4c01
	int	#DOS_INT			  ; exit

buffer:
		.space	BUFFER_SIZE
new_file_handle:
		.word	ANY
dup_handle:
		.word	ANY
new_file_name:	
		.ascii	"newfile"
		.byte	0
create_new_file_errormsg:	
		.ascii	"create new file error"
		.byte	CR, LF, END_CHAR
dup_handle_errormsg:	
		.ascii	"duplicate handle error"
		.byte	CR, LF, END_CHAR
misc_int_errormsg:	
		.ascii	"internal error"
		.byte	CR, LF, END_CHAR
read_handle_errormsg:	
		.ascii	"read handle error"
		.byte	CR, LF, END_CHAR
write_handle_errormsg:	
		.ascii	"write handle error"
		.byte	CR, LF, END_CHAR
	end
