! mkimaged.S
! This programme makes a floppy disk image file as "fd0" using DOS system call.
! To compile:
!	as86 -0 -o mkimaged.o mkimaged.S
!	ld86 -0 -s -o mkimaged.com.tmp mkimaged.o
!	dd if=mkimaged.com.tmp of=mkimaged.com bs=1 skip=288
!	rm mkimaged.com.tmp mkimaged.o


BUFFER_SEG		= 0x6000
BUFFER_OFF		= 0	
BYTES_PER_CYLINDER	= 1024 * 8 * 2
#CYLINDER_NUM		= 77	; 0 - 76, 1cylinder = 2track
SECTOR_NUM		= 0x4d0	; 0 - 0x4cf

CR			= 0x0d
LF			= 0x0a
END_CHAR		= '$'

ANY			= 0


use16

.text		
.bss
.data

.align	0

.globl	_main

	.org	0x100
_main:
	mov	ah, #0x3c
	mov	dx, #filename
	mov	cx, #0
	int	#0x21		; open handle
	jc	open_error_exit
	mov	handle, ax
	
cylinder_loop:
	mov	dx, sector
	mov	cx, #16
	mov	bx, #BUFFER_OFF
	mov	ax, #BUFFER_SEG
	push	ds
	mov	ds, ax
	mov	al, #0		; drive A:
	int	#0x25		; read disk
	popf			; int25h push flag
	pop	ds
	jc	read_error_exit
	
	mov	cx, #BYTES_PER_CYLINDER
	mov	bx, handle
	mov	ax, #BUFFER_SEG
	mov	ds, ax
	mov	dx, #BUFFER_OFF
	mov	ah, #0x40
	int	#0x21		; write handle
	mov	ax, cs
	mov	ds, ax
	jc	write_error_exit

	add	sector, #16
	mov	ax, sector
	cmp	ax, #SECTOR_NUM
	jb	cylinder_loop
	
	mov	ah, #0x3e
	mov	bx, handle
	int	#0x21		; close handle
	mov	ax, #0x4c00
	int	#0x21		; exit
	
open_error_exit:
	mov	dx, #open_errormsg
	jmp	error_exit
read_error_exit:
	mov	dx, #read_errormsg
	jmp	error_exit
write_error_exit:
	mov	dx, #write_errormsg
	jmp	error_exit
error_exit:
	mov	ah, #0x09
	int	#0x21		; print
	mov	ax, #0x4c01
	int	#0x21		; exit

handle:
		.word	ANY
sector:
		.byte	0
filename:	
		.ascii	"fd0"
		.byte	0
open_errormsg:	
		.ascii	"open file error"
		.byte	CR, LF, END_CHAR
read_errormsg:	
		.ascii	"read disk error"
		.byte	CR, LF, END_CHAR
write_errormsg:	
		.ascii	"write file error"
		.byte	CR, LF, END_CHAR
	
	end
