CODE    SEGMENT
        ASSUME  CS:CODE,DS:CODE,SS:STACK
        
START:  MOV     AX,CODE
        MOV     DS,AX
        
        MOV     AH,9
        MOV     DX,OFFSET READB
        INT     21H
        
;CREATE
        MOV     DX,OFFSET FBIOS
        MOV     CX,20H
        MOV     AH,3CH
        INT     21H
        MOV     WORD PTR[FHNDL],AX
;READ
        MOV     AX,0E800H
        MOV     ES,AX
        MOV     CX,64
        XOR     SI,SI
        CALL    SETBUF
        MOV     AX,0F800H
        MOV     ES,AX
        MOV     CX,32
        XOR     SI,SI
        CALL    SETBUF
        CALL    CLOSEH
;MESSAGE
        MOV     AH,9
        MOV     DX,OFFSET GETB
        INT     21H
        
;CREATE
        MOV     DX,OFFSET FSOUND
        MOV     CX,20H
        MOV     AH,3CH
        INT     21H
        MOV     WORD PTR[FHNDL],AX
;READ
        MOV     AX,0CC00H
        MOV     ES,AX
        MOV     CX,16
        XOR     SI,SI
        CALL    SETBUF
        CALL    CLOSEH
;MESSAGE
        MOV     AH,9
        MOV     DX,OFFSET GETS
        INT     21H
        
        MOV     AH,4CH
        INT     21H

SETBUF:
LOOP1:  MOV     DX,1024
        MOV     BX,OFFSET BUFF
LOOP2:  MOV     AL,ES:[SI]
        MOV     [BX],AL
        INC     SI
        INC     BX
        DEC     DX
        JNZ     LOOP2
        PUSH    CX
        CALL    WRITEH
        POP     CX
        LOOP    LOOP1
        RET

WRITEH: MOV     DX,OFFSET BUFF
        MOV     CX,1024
        MOV     BX,WORD PTR[FHNDL]
        MOV     AH,40H
        INT     21H
        RET

CLOSEH: MOV     BX,WORD PTR[FHNDL]
        MOV     AH,3EH
        INT     21H
        RET

FHNDL:  DW      0
FBIOS:  DB      'BIOS.ROM',0
FSOUND: DB      'SOUND.ROM',0
BUFF:   DB      1024 DUP(0)
READB:  DB      'Reading...',0DH,0AH,'$'
GETB:   DB      'Get bios rom.',0DH,0AH,'$'
GETS:   DB      'Get sound rom.',0DH,0AH,'$'
CODE    ENDS

STACK   SEGMENT STACK
        DW      32 DUP(?)
STACK   ENDS

        END
