//	DMAC HD63450
//	coded by EG6+

#ifndef	_HD63450_H
#define	_HD63450_H

// bit define
#define	BIT0	0x01
#define	BIT1	0x02
#define	BIT2	0x04
#define	BIT3	0x08
#define	BIT4	0x10
#define	BIT5	0x20
#define	BIT6	0x40
#define	BIT7	0x80

// DMA Reg. channel offset
typedef	unsigned	DMA_Channel;
#define	DMA_CH0		0x00	// FDD
#define	DMA_CH1		0x40	// SASI/SCSI
#define	DMA_CH2		0x80	// IOCS
#define	DMA_CH3		0xc0	// ADPCM

// DMA Reg. offset
#define	DMA_CSR		0x00
#define	DMA_CER		0x01
#define	DMA_DCR		0x04
#define	DMA_OCR		0x05
#define	DMA_SCR		0x06
#define	DMA_CCR		0x07
#define	DMA_MTC		0x0a
#define	DMA_MAR		0x0c
#define	DMA_DAR		0x14
#define	DMA_BTC		0x1a
#define	DMA_BAR		0x1c
#define	DMA_NIV		0x25
#define	DMA_EIV		0x27
#define	DMA_MFC		0x29
#define	DMA_CPR		0x2d
#define	DMA_DFC		0x31
#define	DMA_BFC		0x39
#define	DMA_GCR		0x3f


class HD63450
{
private:
	unsigned char	DMA_Reg[0x40*4];
	void			DataCopy(DMA_Channel Channel);
	void			ArrayChainCopy(DMA_Channel Channel);
	void			LinkArrayChainCopy(DMA_Channel Channel);
public:
	unsigned char	read(unsigned short Addr);
	unsigned short	read2(unsigned short Addr);
	unsigned long	read4(unsigned short Addr);
	void			write(unsigned short Addr,unsigned char Data);
	void			write2(unsigned short Addr,unsigned short Data);
	void			write4(unsigned short Addr,unsigned long Data);
	void			init(void);
};


#endif	// end of HD63450
