#ifdef		WIN32
#include	<windows.h>
#endif

#include	<stdio.h>
#include	"../include.h/directiv.h"
#include	"../include.h/memory.h"
#include	"../include.h/mc68k.h"
#include	"../include.h/console.h"
#include	"../include.h/monitor.h"

extern	MEMORY	mem;
extern	MONITOR	mon;



#ifdef		WIN32
void	MC68K::decode(unsigned short code)
{
	unsigned char	RN1,RN2,RN3;		//Register Number
	unsigned long	TR1;				//Temp Register
	unsigned char	TC1,TC2,TC3;		//Temp Char
	unsigned short	TS1,TS2,TS3;		//Temp Short
	unsigned long	TL1,TL2,TL3;		//Temp Long



	if(interrupt()!=0)		return;		//荞݃gbv

#ifdef	_DEBUG
if((VSR&0x0020)!=0){	sprintf(buf,"%08lX ",PC);	CO;	}
#endif

	switch(code & 0xf000){
		case	0x0000:
#include	"../mc68k_cx.cpp/68_c0.cpp"
		case	0x1000:
#include	"../mc68k_cx.cpp/68_moveb.cpp"
		case	0x2000:
#include	"../mc68k_cx.cpp/68_movel.cpp"
		case	0x3000:
#include	"../mc68k_cx.cpp/68_movew.cpp"
		case	0x4000:
#include	"../mc68k_cx.cpp/68_c4.cpp"
		case	0x5000:
#include	"../mc68k_cx.cpp/68_c5.cpp"
		case	0x6000:
#include	"../mc68k_cx.cpp/68_c6.cpp"
		case	0x7000:
#include	"../mc68k_cx.cpp/68_moveq.cpp"
		case	0x8000:
#include	"../mc68k_cx.cpp/68_c8.cpp"
		case	0x9000:
#include	"../mc68k_cx.cpp/68_c9.cpp"
		case	0xb000:
#include	"../mc68k_cx.cpp/68_cb.cpp"
		case	0xc000:
#include	"../mc68k_cx.cpp/68_cc.cpp"
		case	0xd000:
#include	"../mc68k_cx.cpp/68_cd.cpp"
		case	0xe000:
#include	"../mc68k_cx.cpp/68_ce.cpp"
		default:
			i_gic();	return;
	}
}
#endif



#ifdef		BE68K
void	MC68K::decode(unsigned short code)
{

//	if(interrupt()!=0)		return;		//

#ifdef	_DEBUG
if((VSR&0x0020)!=0){	sprintf(buf,"%08lX ",PC);	CO;	}
#endif

	switch(code & 0xf000){
		case	0x0000:
			mc68k_c0(code);
			return;
		case	0x1000:
			mc68k_moveb(code);
			return;
		case	0x2000:
			mc68k_movel(code);
			return;
		case	0x3000:
			mc68k_movew(code);
			return;
		case	0x4000:
			mc68k_c4(code);
			return;
		case	0x5000:
			mc68k_c5(code);
			return;
		case	0x6000:
			mc68k_c6(code);
			return;
		case	0x7000:
			mc68k_moveq(code);
			return;
		case	0x8000:
			mc68k_c8(code);
			return;
		case	0x9000:
			mc68k_c9(code);
			return;
		case	0xb000:
			mc68k_cb(code);
			return;
		case	0xc000:
			mc68k_cc(code);
			return;
		case	0xd000:
			mc68k_cd(code);
			return;
		case	0xe000:
			mc68k_ce(code);
			return;
		default:
			i_gic();
			return;
	}
}
#endif
