#ifdef		WIN32
#include	<windows.h>
#endif

#include	<stdio.h>

#ifdef		BE68K
#include	<unistd.h>
#include	"../include/be68k.h"
#endif

#include	"../include.h/directiv.h"
#include	"../include.h/memory.h"
#include	"../include.h/mc68k.h"
#include	"../include.h/console.h"
#include	"../include.h/monitor.h"

#ifdef		WIN32
extern	HWND	hWnd_w1;
#endif

#ifdef		BE68K
extern	DispView	*MonView;
#endif

extern	MEMORY	mem;
extern	MONITOR	mon;


extern	char				szInifilePath[MAX_PATH];



//荞ݏ

void	MC68K::i_rst(void)		//ReSeT
{
#ifdef	_DEBUG
	if((VSR&0x0020)!=0){	sprintf(buf,"MC68K Reset\n");	CO;	}
#endif
	VSR		&=0xbfff;
	PC		=m68_read4(0x00000004);
	A[7]	=m68_read4(0x00000000);
	Sleep(1);
	VSR		|=0x4000;
}



void	MC68K::i_chk(void)		//CHecK
{
#ifdef	_DEBUG
	if((VSR&0x0020)!=0){	sprintf(buf,"CHK interrupt\n");	CO;	}
#endif
	PC=m68_read4(0x00000018);
}



void	MC68K::i_gic(void)		//General Invalid Code
{
#ifdef	_DEBUG
if((VSR&0x0020)!=0){
	BD0;	sprintf(buf,"General Invalid Code\n",PC);	CO;	}
#endif
//	A[7]-=4;	m68_write4(A[7],PC+2);
//	A[7]-=2;	m68_write4(A[7],SR);
//	SR|=0x2700;	SR&=0x7fff;
//	PC=m68_read4(0x00000010);
	TTC=1;				//g[X̃u[N
	PC+=2;
}



void	MC68K::i_ae(void)		//Cpu Address Error
{
//߃tFb`ł̃AhXG[
//	PC=ŌɎs(̖߂PCύXA̖߂ŊAhX
//	̖߃tFb`ŃG[FvOłPCύX̑Ó`Fb
//	NBG[ȂAobύXケ̃G[ɃWvj
//f[^ANZXł̃AhXG[
//	PC=f[^ANZX߂̂obH
#ifdef	_DEBUG
	if((VSR&0x0020)!=0){	sprintf(buf,"Cpu Address Error\n");	CO;	}
#endif
//	SP-=8;
//	mem.write4b(SP  ,PC+2);
//	mem.write4b(SP+4,SR);
//	PC=mem.read4b(VBR+0x00000024);
}



/*
void	MC68K::i_dae(void)		//Dma Address Error
{
//f[^ANZXł̃AhXG[
//	PC=f[^ANZX߂̂obH
#ifdef	_DEBUG
	if((VSR&0x0020)!=0){	sprintf(buf,"Dma Address Error\n");	CO;	}
#endif
	SP-=8;
	mem.write4b(SP  ,PC+2);
	mem.write4b(SP+4,SR);
	PC=mem.read4b(VBR+0x00000028);
}
*/



void	MC68K::stat(void)
{
	unsigned long	b=0x8000;

	sprintf(buf,"D0  =%08lX D1  =%08lX D2  =%08lX D3  =%08lX PC  =%08lX\n",
		D[0], D[1], D[2], D[3] ,PC);	CO;
	sprintf(buf,"D4  =%08lX D5  =%08lX D6  =%08lX D7  =%08lX\n",
		D[4], D[5], D[6], D[7]);	CO;
	sprintf(buf,"A0  =%08lX A1  =%08lX A2  =%08lX A3  =%08lX SSP =%08lX\n",
		A[0], A[1], A[2], A[3] ,SSP);	CO;
	sprintf(buf,"A4  =%08lX A5  =%08lX A6  =%08lX A7  =%08lX USP =%08lX\n",
		A[4], A[5], A[6], A[7] ,USP);	CO;
	sprintf(buf,"          T S  <I>   XNZVC\nSR  =");	CO;
	sprintf(buf,"%04lX ",SR);	CO;
	for(;b!=0;b/=2)
		if((SR&b)==0){	sprintf(buf,"0");	CO;	}
			else	{	sprintf(buf,"1");	CO;	}
	sprintf(buf,"                              VSR =%04X\n",VSR);	CO;
}



void		MC68K::init(void)
{
	VSR=0x0030;

	IDS=GetPrivateProfileInt("system",
		"interrupt_delay_step",0x100,szInifilePath);
	SR|=0x2000;											//Supervisor state

//Power On Reset
	i_rst();
}
