//	MC68K code ADDX



case	0x0100:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ADDX.B D%d,D%d\n",
	RN1,RN2);	CO;	}
#endif
	TC1=(unsigned char)D[RN2];
	if((SR&CCR_XON)==0)	TC2=(unsigned char)D[RN1];
		else			TC2=(unsigned char)D[RN1]+1;
	TC3=TC1+TC2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TC3==0)				SR|=CCR_ZON;
	if((TC3&0x80)!=0)		SR|=CCR_NON;
		else
	if(((TC1^TC2)&0x80)!=0)	SR|=CCR_VON;
	if(TC3<TC1){			SR|=CCR_CON;
							SR|=CCR_XON;	}

	D[RN2]=(D[RN2]&0xffffff00)|TC3;
	PC+=2;	return;



case	0x0140:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ADDX.W D%d,D%d\n",
	RN1,RN2);	CO;	}
#endif
	TS1=(unsigned short)D[RN2];
	if((SR&CCR_XON)==0)	TS2=(unsigned short)D[RN1];
		else			TS2=(unsigned short)D[RN1]+1;
	TS3=TS1+TS2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					SR|=CCR_ZON;
	if((TS3&0x8000)!=0)			SR|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
	if(TS3<TS1){				SR|=CCR_CON;
								SR|=CCR_XON;	}

	D[RN2]=(D[RN2]&0xffff0000)|TS3;
	PC+=2;	return;



case	0x0180:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ADDX.L D%d,D%d\n",
	RN1,RN2);	CO;	}
#endif
	TL1=D[RN2];
	if((SR&CCR_XON)==0)	TL2=D[RN1];
		else			TL2=D[RN1]+1;
	TL3=TL1+TL2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						SR|=CCR_ZON;
	if((TL3&0x80000000)!=0)			SR|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	SR|=CCR_VON;
	if(TL3<TL1){					SR|=CCR_CON;
									SR|=CCR_XON;	}

	D[RN2]=TL3;
	PC+=2;	return;





case	0x0108:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ADDX.B -(A%d),-(A%d)\n",
	RN1,RN2);	CO;	}
#endif
	A[RN1]--;	A[RN2]--;
	TC1=m68_read1(A[RN2]);
	if((SR&CCR_XON)==0)	TC2=m68_read1(A[RN1]);
		else			TC2=m68_read1(A[RN1])+1;
	TC3=TC1+TC2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TC3==0)				SR|=CCR_ZON;
	if((TC3&0x80)!=0)		SR|=CCR_NON;
		else
	if(((TC1^TC2)&0x80)!=0)	SR|=CCR_VON;
	if(TC3<TC1){			SR|=CCR_CON;
							SR|=CCR_XON;	}

	m68_write1(A[RN2],TC3);
	PC+=2;	return;



case	0x0148:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ADDX.W -(A%d),-(A%d)\n",
	RN1,RN2);	CO;	}
#endif
	A[RN1]-=2;	A[RN2]-=2;
	TS1=m68_read2(A[RN2]);
	if((SR&CCR_XON)==0)	TS2=m68_read2(A[RN1]);
		else			TS2=m68_read2(A[RN1])+1;
	TS3=TS1+TS2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					SR|=CCR_ZON;
	if((TS3&0x8000)!=0)			SR|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
	if(TS3<TS1){				SR|=CCR_CON;
								SR|=CCR_XON;	}

	m68_write2(A[RN2],TS3);
	PC+=2;	return;



case	0x0188:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ADDX.L -(A%d),-(A%d)\n",
	RN1,RN2);	CO;	}
#endif
	A[RN1]-=4;	A[RN2]-=4;
	TL1=m68_read4(A[RN2]);
	if((SR&CCR_XON)==0)	TL2=m68_read4(A[RN1]);
		else			TL2=m68_read4(A[RN1])+1;
	TL3=TL1+TL2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						SR|=CCR_ZON;
	if((TL3&0x80000000)!=0)			SR|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	SR|=CCR_VON;
	if(TL3<TL1){					SR|=CCR_CON;
									SR|=CCR_XON;	}

	m68_write4(A[RN2],TL3);
	PC+=2;	return;



