//	MC68K code ASL



case	0x0100:
case	0x0300:
case	0x0500:
case	0x0700:
case	0x0900:
case	0x0b00:
case	0x0d00:
case	0x0f00:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ASL.B #$%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	if(RN2==0)	RN2=8;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	for(TC1=0;TC1!=RN2;TC1++){
		if((TL1&0x80)==0)	SR&=CCR_XOFF&CCR_COFF;
			else			SR|=CCR_XON |CCR_CON;
		TL1<<=1;
		if(((D[RN1]^TL1)&0x80)!=0)	SR|=CCR_VON;	}
	if((unsigned char)TL1==0)	SR|=CCR_ZON;
	if((TL1&0x80)!=0)			SR|=CCR_NON;
	D[RN1]=(D[RN1]&0xffffff00)|(TL1&0xff);
	PC+=2;	return;



case	0x0140:
case	0x0340:
case	0x0540:
case	0x0740:
case	0x0940:
case	0x0b40:
case	0x0d40:
case	0x0f40:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ASL.W #$%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	if(RN2==0)	RN2=8;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	for(TC1=0;TC1!=RN2;TC1++){
		if((TL1&0x8000)==0)	SR&=CCR_XOFF&CCR_COFF;
			else			SR|=CCR_XON |CCR_CON;
		TL1<<=1;
		if(((D[RN1]^TL1)&0x8000)!=0)	SR|=CCR_VON;	}
	if((unsigned short)TL1==0)	SR|=CCR_ZON;
	if((TL1&0x8000)!=0)			SR|=CCR_NON;
	D[RN1]=(D[RN1]&0xffff0000)|(TL1&0xffff);
	PC+=2;	return;



case	0x0180:
case	0x0380:
case	0x0580:
case	0x0780:
case	0x0980:
case	0x0b80:
case	0x0d80:
case	0x0f80:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ASL.L #$%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	if(RN2==0)	RN2=8;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	for(TC1=0;TC1!=RN2;TC1++){
		if((TL1&0x80000000)==0)	SR&=CCR_XOFF&CCR_COFF;
			else				SR|=CCR_XON |CCR_CON;
		TL1<<=1;
		if(((D[RN1]^TL1)&0x80000000)!=0)	SR|=CCR_VON;	}
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;
	D[RN1]=TL1;
	PC+=2;	return;





case	0x0120:
case	0x0320:
case	0x0520:
case	0x0720:
case	0x0920:
case	0x0b20:
case	0x0d20:
case	0x0f20:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ASL.B D%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	TC2=(char)(D[RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		if((TL1&0x80)==0)	SR&=CCR_XOFF&CCR_COFF;
			else			SR|=CCR_XON |CCR_CON;
		TL1<<=1;
		if(((D[RN1]^TL1)&0x80)!=0)	SR|=CCR_VON;	}
	if((unsigned char)TL1==0)	SR|=CCR_ZON;
	if((TL1&0x80)!=0)			SR|=CCR_NON;
	D[RN1]=(D[RN1]&0xffffff00)|(TL1&0xff);
	PC+=2;	return;



case	0x0160:
case	0x0360:
case	0x0560:
case	0x0760:
case	0x0960:
case	0x0b60:
case	0x0d60:
case	0x0f60:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ASL.W D%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	TC2=(char)(D[RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		if((TL1&0x8000)==0)	SR&=CCR_XOFF&CCR_COFF;
			else			SR|=CCR_XON |CCR_CON;
		TL1<<=1;
		if(((D[RN1]^TL1)&0x8000)!=0)	SR|=CCR_VON;	}
	if((unsigned short)TL1==0)	SR|=CCR_ZON;
	if((TL1&0x8000)!=0)			SR|=CCR_NON;
	D[RN1]=(D[RN1]&0xffff0000)|(TL1&0xffff);
	PC+=2;	return;



case	0x01a0:
case	0x03a0:
case	0x05a0:
case	0x07a0:
case	0x09a0:
case	0x0ba0:
case	0x0da0:
case	0x0fa0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ASL.L D%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	TC2=(char)(D[RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		if((TL1&0x80000000)==0)	SR&=CCR_XOFF&CCR_COFF;
			else				SR|=CCR_XON |CCR_CON;
		TL1<<=1;
		if(((D[RN1]^TL1)&0x80000000)!=0)	SR|=CCR_VON;	}
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;
	D[RN1]=TL1;
	PC+=2;	return;





case	0x01d0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ASL.W (A%d)\n",
	RN1);	CO;	}
#endif
	TR1=A[RN1];
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0)	SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
	if(TS2==0)					SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=2;	return;



case	0x01d8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ASL.W (A%d)+\n",
	RN1);	CO;	}
#endif
	TR1=A[RN1];
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0)	SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
	if(TS2==0)					SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	A[RN1]+=2;
	PC+=2;	return;



case	0x01e0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ASL.W -(A%d)\n",
	RN1);	CO;	}
#endif
	A[RN1]-=2;
	TR1=A[RN1];
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0)	SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
	if(TS2==0)					SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=2;	return;



case	0x01e8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"ASL.W $%04X(A%d)\n",
	num2(1),RN1);	CO;	}
#endif
	TR1=A[RN1]+(short)num2(1);
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0)	SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
	if(TS2==0)					SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=4;	return;



case	0x01f0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"ASL.W $%02X(A%d,X%d)\n",
	num2(1),RN1,RN3);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=A[RN1]+(char)num1(1)+(short)D[RN3];
	else	TR1=A[RN1]+(char)num1(1)+       D[RN3];
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0)	SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
	if(TS2==0)					SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=4;	return;



case	0x01f8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"ASL.W $%04X\n",
	num2(1));	CO;	}
#endif
	TR1=(short)num2(1);
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0)	SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
	if(TS2==0)					SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"ASL.W $%08X\n",
	num4(1));	CO;	}
#endif
	TR1=(short)num4(1);
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0)	SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
	if(TS2==0)					SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=6;	return;



		default:
			i_gic();	return;
	}



