//	MC68K code ASR



case	0x0000:
case	0x0200:
case	0x0400:
case	0x0600:
case	0x0800:
case	0x0a00:
case	0x0c00:
case	0x0e00:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ASR.B #$1,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	if(RN2==0)	RN2=8;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	for(TC1=0;TC1!=RN2;TC1++){
		if((TL1&1)==0)	SR&=CCR_XOFF&CCR_COFF;
			else		SR|=CCR_XON |CCR_CON;
		TL1=(char)TL1>>1;						}
	if((unsigned char)TL1==0)	SR|=CCR_ZON;
	if((TL1&0x80)!=0)			SR|=CCR_NON;
	D[RN1]=(D[RN1]&0xffffff00)|(TL1&0xff);
	PC+=2;	return;



case	0x0040:
case	0x0240:
case	0x0440:
case	0x0640:
case	0x0840:
case	0x0a40:
case	0x0c40:
case	0x0e40:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ASR.W #$1,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	if(RN2==0)	RN2=8;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	for(TC1=0;TC1!=RN2;TC1++){
		if((TL1&1)==0)	SR&=CCR_XOFF&CCR_COFF;
			else		SR|=CCR_XON |CCR_CON;
		TL1=(short)TL1>>1;						}
	if((unsigned short)TL1==0)	SR|=CCR_ZON;
	if((TL1&0x8000)!=0)			SR|=CCR_NON;
	D[RN1]=(D[RN1]&0xffff0000)|(TL1&0xffff);
	PC+=2;	return;



case	0x0080:
case	0x0280:
case	0x0480:
case	0x0680:
case	0x0880:
case	0x0a80:
case	0x0c80:
case	0x0e80:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ASR.L #$1,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	if(RN2==0)	RN2=8;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	for(TC1=0;TC1!=RN2;TC1++){
		if((TL1&1)==0)	SR&=CCR_XOFF&CCR_COFF;
			else		SR|=CCR_XON |CCR_CON;
		TL1=(long)TL1>>1;						}
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;
	D[RN1]=TL1;
	PC+=2;	return;





case	0x0020:
case	0x0220:
case	0x0420:
case	0x0620:
case	0x0820:
case	0x0a20:
case	0x0c20:
case	0x0e20:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ASR.B D%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	TC2=(char)(D[RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		if((TL1&1)==0)	SR&=CCR_XOFF&CCR_COFF;
			else		SR|=CCR_XON |CCR_CON;
		TL1=(char)TL1>>1;						}
	if((unsigned char)TL1==0)	SR|=CCR_ZON;
	if((TL1&0x80)!=0)			SR|=CCR_NON;
	D[RN1]=(D[RN1]&0xffffff00)|(TL1&0xff);
	PC+=2;	return;



case	0x0060:
case	0x0260:
case	0x0460:
case	0x0660:
case	0x0860:
case	0x0a60:
case	0x0c60:
case	0x0e60:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ASR.W D%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	TC2=(char)(D[RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		if((TL1&1)==0)	SR&=CCR_XOFF&CCR_COFF;
			else		SR|=CCR_XON |CCR_CON;
		TL1=(short)TL1>>1;						}
	if((unsigned short)TL1==0)	SR|=CCR_ZON;
	if((TL1&0x8000)!=0)			SR|=CCR_NON;
	D[RN1]=(D[RN1]&0xffff0000)|(TL1&0xffff);
	PC+=2;	return;



case	0x00a0:
case	0x02a0:
case	0x04a0:
case	0x06a0:
case	0x08a0:
case	0x0aa0:
case	0x0ca0:
case	0x0ea0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ASR.L D%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	TC2=(char)(D[RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		if((TL1&1)==0)	SR&=CCR_XOFF&CCR_COFF;
			else		SR|=CCR_XON |CCR_CON;
		TL1=(long)TL1>>1;						}
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;
	D[RN1]=TL1;
	PC+=2;	return;





case	0x00d0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ASR.W (A%d)\n",
	RN1);	CO;	}
#endif
	TR1=A[RN1];
	TS1=m68_read2(TR1);
	TS2=(short)TS1>>1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&1)==0)		SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if(TS2==0)			SR|=CCR_ZON;
	if((TS2&0x8000)!=0)	SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=2;	return;



case	0x00d8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ASR.W (A%d)+\n",
	RN1);	CO;	}
#endif
	TR1=A[RN1];
	TS1=m68_read2(TR1);
	TS2=(short)TS1>>1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&1)==0)		SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if(TS2==0)			SR|=CCR_ZON;
	if((TS2&0x8000)!=0)	SR|=CCR_NON;
	m68_write2(TR1,TS2);
	A[RN1]+=2;
	PC+=2;	return;



case	0x00e0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ASR.W -(A%d)\n",
	RN1);	CO;	}
#endif
	A[RN1]-=2;
	TR1=A[RN1];
	TS1=m68_read2(TR1);
	TS2=(short)TS1>>1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&1)==0)		SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if(TS2==0)			SR|=CCR_ZON;
	if((TS2&0x8000)!=0)	SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=2;	return;



case	0x00e8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"ASR.W $%04X(A%d)\n",
	num2(1),RN1);	CO;	}
#endif
	TR1=A[RN1]+(short)num2(1);
	TS1=m68_read2(TR1);
	TS2=(short)TS1>>1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&1)==0)		SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if(TS2==0)			SR|=CCR_ZON;
	if((TS2&0x8000)!=0)	SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=4;	return;



case	0x00f0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"ASR.W $%02X(A%d,X%d)\n",
	num2(1),RN1,RN3);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=A[RN1]+(char)num1(1)+(short)D[RN3];
	else	TR1=A[RN1]+(char)num1(1)+       D[RN3];
	TS1=m68_read2(TR1);
	TS2=(short)TS1>>1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&1)==0)		SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if(TS2==0)			SR|=CCR_ZON;
	if((TS2&0x8000)!=0)	SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=4;	return;



case	0x00f8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"ASR.W $%04X\n",
	num2(1));	CO;	}
#endif
	TR1=(short)num2(1);
	TS1=m68_read2(TR1);
	TS2=(short)TS1>>1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&1)==0)		SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if(TS2==0)			SR|=CCR_ZON;
	if((TS2&0x8000)!=0)	SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"ASR.W $%08X\n",
	num4(1));	CO;	}
#endif
	TR1=(short)num4(1);
	TS1=m68_read2(TR1);
	TS2=(short)TS1>>1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&1)==0)		SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if(TS2==0)			SR|=CCR_ZON;
	if((TS2&0x8000)!=0)	SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=6;	return;



		default:
			i_gic();	return;
	}



