//	MC68K code BCLR



case	0x0180:
case	0x0380:
case	0x0580:
case	0x0780:
case	0x0980:
case	0x0b80:
case	0x0d80:
case	0x0f80:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"BCLR D%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=1<<(D[RN2]&0x1F);
	if((D[RN1]&TL1)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	D[RN1]&=~TL1;
	PC+=2;	return;



case	0x0190:
case	0x0390:
case	0x0590:
case	0x0790:
case	0x0990:
case	0x0b90:
case	0x0d90:
case	0x0f90:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"BCLR D%d,(A%d)\n",
	RN2,RN1);	CO;	}
#endif
	TR1=A[RN1];
	TC2=1<<(D[RN2]&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^~TC2);
	PC+=2;	return;



case	0x0198:
case	0x0398:
case	0x0598:
case	0x0798:
case	0x0998:
case	0x0b98:
case	0x0d98:
case	0x0f98:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"BCLR D%d,(A%d)+\n",
	RN2,RN1);	CO;	}
#endif
	TR1=A[RN1];
	TC2=1<<(D[RN2]&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^~TC2);
	A[RN1]++;
	PC+=2;	return;



case	0x01a0:
case	0x03a0:
case	0x05a0:
case	0x07a0:
case	0x09a0:
case	0x0ba0:
case	0x0da0:
case	0x0fa0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"BCLR D%d,-(A%d)\n",
	RN2,RN1);	CO;	}
#endif
	A[RN1]--;
	TR1=A[RN1];
	TC2=1<<(D[RN2]&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^~TC2);
	PC+=2;	return;



case	0x01a8:
case	0x03a8:
case	0x05a8:
case	0x07a8:
case	0x09a8:
case	0x0ba8:
case	0x0da8:
case	0x0fa8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"BCLR D%d,$%04X(A%d)\n",
	RN2,num2(1),RN1);	CO;	}
#endif
	TR1=A[RN1]+(short)num2(1);
	TC2=1<<(D[RN2]&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^~TC2);
	PC+=4;	return;



case	0x01b0:
case	0x03b0:
case	0x05b0:
case	0x07b0:
case	0x09b0:
case	0x0bb0:
case	0x0db0:
case	0x0fb0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"BCLR D%d,$%02X(A%d,X%d)\n",
	RN2,num1(1),RN1,RN3);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
				TR1=A[RN1]+(char)num1(1)+(short)D[RN3];	//16bitg
		else	TR1=A[RN1]+(char)num1(1)+       D[RN3];	//32bitgp
	TC2=1<<(D[RN2]&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^~TC2);
	PC+=4;	return;



case	0x01b8:
case	0x03b8:
case	0x05b8:
case	0x07b8:
case	0x09b8:
case	0x0bb8:
case	0x0db8:
case	0x0fb8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"BCLR D%d,$%04X\n",
	RN2,num2(1));	CO;	}
#endif
			TR1=(short)num2(1);
			TC2=1<<(D[RN2]&0x7);	TC1=m68_read1(TR1);
			if((TC1&TC2)==0)	SR|=CCR_ZON;
				else			SR&=CCR_ZOFF;
			m68_write1(TR1,TC1^~TC2);
			PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"BCLR D%d,$%08X\n",
	RN2,num4(1));	CO;	}
#endif
			TR1=num4(1);
			TC2=1<<(D[RN2]&0x7);	TC1=m68_read1(TR1);
			if((TC1&TC2)==0)	SR|=CCR_ZON;
				else			SR&=CCR_ZOFF;
			m68_write1(TR1,TC1^~TC2);
			PC+=6;	return;



		case	2:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"BCLR D%d,$%04X(PC)\n",
	RN2,num2(1));	CO;	}
#endif
			TR1=PC+(short)num2(1);
			TC2=1<<(D[RN2]&0x7);	TC1=m68_read1(TR1);
			if((TC1&TC2)==0)	SR|=CCR_ZON;
				else			SR&=CCR_ZOFF;
			m68_write1(TR1,TC1^~TC2);
			PC+=4;	return;



		default:
			i_gic();	return;
	}





case	0x0880:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"BCLR #$%1X,D%d\n",
	num1(1),RN1);	CO;	}
#endif
	TL1=1<<(num1(1)&0x1F);
	if((D[RN1]&TL1)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	D[RN1]^=~TL1;
	PC+=4;	return;



case	0x0890:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"BCLR #$%1X,(A%d)\n",
	num1(1),RN1);	CO;	}
#endif
	TR1=A[RN1];
	TC2=1<<(num1(1)&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^~TC2);
	PC+=4;	return;



case	0x0898:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"BCLR #$%1X,(A%d)+\n",
	num1(1),RN1);	CO;	}
#endif
	TR1=A[RN1];
	TC2=1<<(num1(1)&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^~TC2);
	A[RN1]++;
	PC+=4;	return;



case	0x08a0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"BCLR #$%1X,-(A%d)\n",
	num1(1),RN1);	CO;	}
#endif
	A[RN1]--;
	TR1=A[RN1];
	TC2=1<<(num1(1)&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^~TC2);
	PC+=4;	return;



case	0x08a8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"BCLR #$%1X,$%04X(A%d)\n",
	num1(1),num2(2),RN1);	CO;	}
#endif
	TR1=A[RN1]+(short)num2(2);
	TC2=1<<(num1(1)&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^~TC2);
	PC+=6;	return;



case	0x08b0:
	RN3=(num2(2)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"BCLR #$%1X,$%02X(A%d,X%d)\n",
	num1(1),num1(2),RN1,RN3);	CO;	}
#endif
	if((num2(2)&0x0800)==0)
				TR1=A[RN1]+(char)num1(2)+(short)D[RN3];	//16bitg
		else	TR1=A[RN1]+(char)num1(2)+       D[RN3];	//32bitgp
	TC2=1<<(num1(1)&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^~TC2);
	PC+=6;	return;



case	0x08b8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"BCLR #$%1X,$%04X\n",
	num1(1),num2(2));	CO;	}
#endif
			TR1=(short)num2(2);
			TC2=1<<(num1(1)&0x7);	TC1=m68_read1(TR1);
			if((TC1&TC2)==0)	SR|=CCR_ZON;
				else			SR&=CCR_ZOFF;
			m68_write1(TR1,TC1^~TC2);
			PC+=6;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;	sprintf(buf,"BCLR #$%1X,$%08X\n",
	num1(1),num4(2));	CO;	}
#endif
			TR1=num4(2);
			TC2=1<<(num1(1)&0x7);	TC1=m68_read1(TR1);
			if((TC1&TC2)==0)	SR|=CCR_ZON;
				else			SR&=CCR_ZOFF;
			m68_write1(TR1,TC1^~TC2);
			PC+=8;	return;



		case	2:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"BCLR #$%1X,$%04X(PC)\n",
	num1(1),num2(2));	CO;	}
#endif
			TR1=PC+(short)num2(2);
			TC2=1<<(num1(1)&0x7);	TC1=m68_read1(TR1);
			if((TC1&TC2)==0)	SR|=CCR_ZON;
				else			SR&=CCR_ZOFF;
			m68_write1(TR1,TC1^~TC2);
			PC+=6;	return;



		default:
			i_gic();	return;
	}
