//	MC68K	0x4xxx Opecode MiSC



case	0xe70:
	switch(RN1){
		case	0:
			if(!(SR&0x2000)){								//User state
				BD0;	sprintf(buf,"RESET <User State! TRAP!>\n");
				CO;		goto	_TRAP;										}
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"RESET\n");	CO;	}
#endif
			PC+=2;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"NOP\n");	CO;	}
#endif
			PC+=2;	return;



		case	2:
			if(!(SR&0x2000)){								//User state
				BD1;
				sprintf(buf,"STOP #$%04X <User State! TRAP!>\n",num2(1));
				CO;		goto	_TRAP;										}
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"STOP #$%04X\n",num2(1));	CO;	}
#endif
			SR=num2(1);
			PC+=4;	return;



		case	3:
			if(!(SR&0x2000)){								//User state
				BD0;	sprintf(buf,"RTE <User State! TRAP!>\n");
				CO;		goto	_TRAP;										}
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"RTE\n");	CO;	}
#endif
			TSR=SR;

			SR=m68_read2(A[7]);	A[7]+=2;
			PC=m68_read4(A[7]);	A[7]+=4;

			if((TSR^SR)&0x2000)								//Change state
				if(SR&0x2000){	USP=A[7];	A[7]=SSP;	}	//User to Super
					else	{	SSP=A[7];	A[7]=USP;	}	//Super to User
			return;



		case	5:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"RTS\n");	CO;	}
#endif
			PC=m68_read4(A[7]);
			A[7]+=4;
			return;



		case	6:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"TRAPV\n");	CO;	}
#endif
			if((SR&CCR_VON)==0)	PC+=2;
				else			goto	_TRAP;
			return;




		case	7:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"RTR\n");	CO;	}
#endif
			SR=(SR&0xff00)|(unsigned char)m68_read2(A[7]);
			A[7]+=2;
			PC=m68_read4(A[7]);
			A[7]+=4;
			return;



		default:
			i_gic();	return;
}
