//	MC68K code CHK



case	0x0180:		//data register 0-7
case	0x0380:
case	0x0580:
case	0x0780:
case	0x0980:
case	0x0b80:
case	0x0d80:
case	0x0f80:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CHK D%d,D%d\n",RN1,RN2);	CO;	}
#endif
	if((short)D[RN2]<0){
		SR|=CCR_NON;	i_chk();	return;	}
	if((short)D[RN2]>(short)D[RN1]){
		SR&=CCR_NOFF;	i_chk();	return;	}
	PC+=2;	return;



case	0x0190:		//data register 0-7
case	0x0390:
case	0x0590:
case	0x0790:
case	0x0990:
case	0x0b90:
case	0x0d90:
case	0x0f90:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CHK (A%d),D%d\n",RN1,RN2);	CO;	}
#endif
	if((short)D[RN2]<0){
		SR|=CCR_NON;	i_chk();	return;	}
	if((short)D[RN2]>m68_read2(A[RN1])){
		SR&=CCR_NOFF;	i_chk();	return;	}
	PC+=2;	return;



case	0x0198:		//data register 0-7
case	0x0398:
case	0x0598:
case	0x0798:
case	0x0998:
case	0x0b98:
case	0x0d98:
case	0x0f98:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CHK (A%d)+,D%d\n",
	RN1,RN2);	CO;	}
#endif
	if((short)D[RN2]<0){
		SR|=CCR_NON;	A[RN1]+=2;	i_chk();	return;	}
	if((short)D[RN2]>m68_read2(A[RN1])){
		SR&=CCR_NOFF;	A[RN1]+=2;	i_chk();	return;	}
	A[RN1]+=2;	PC+=2;	return;



case	0x01a0:		//data register 0-7
case	0x03a0:
case	0x05a0:
case	0x07a0:
case	0x09a0:
case	0x0ba0:
case	0x0da0:
case	0x0fa0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CHK -(A%d),D%d\n",
	RN1,RN2);	CO;	}
#endif
	A[RN1]-=2;
	if((short)D[RN2]<0){
		SR|=CCR_NON;	i_chk();	return;	}
	if((short)D[RN2]>m68_read2(A[RN1])){
		SR&=CCR_NOFF;	i_chk();	return;	}
	PC+=2;	return;



case	0x01a8:		//data register 0-7
case	0x03a8:
case	0x05a8:
case	0x07a8:
case	0x09a8:
case	0x0ba8:
case	0x0da8:
case	0x0fa8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CHK $%04X(A%d),D%d\n",
	num2(1),RN1,RN2);	CO;	}
#endif
	if((short)D[RN2]<0){
		SR|=CCR_NON;	i_chk();	return;	}
	if((short)D[RN2]>m68_read2(A[RN1]+(short)num2(1))){
		SR&=CCR_NOFF;	i_chk();	return;	}
	PC+=4;	return;



case	0x01b0:		//data register 0-7
case	0x03b0:
case	0x05b0:
case	0x07b0:
case	0x09b0:
case	0x0bb0:
case	0x0db0:
case	0x0fb0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CHK $%02X(A%d,X%d),D%d\n",
	num2(1),RN1,RN3,RN2);	CO;	}
#endif
	if((short)D[RN2]<0){
		SR|=CCR_NON;	i_chk();	return;	}
	if((num2(1)&0x0800)==0)
			if((short)D[RN2]>m68_read2(A[RN1]+(char)num1(1)+(short)D[RN3])){
				SR&=CCR_NOFF;	i_chk();	return;	}
	else	if((short)D[RN2]>m68_read2(A[RN1]+(char)num1(1)+       D[RN3])){
				SR&=CCR_NOFF;	i_chk();	return;	}
	PC+=4;	return;



case	0x01b8:		//data register 0-7
case	0x03b8:
case	0x05b8:
case	0x07b8:
case	0x09b8:
case	0x0bb8:
case	0x0db8:
case	0x0fb8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CHK $%04X,D%d\n",
	num2(1),RN2);	CO;	}
#endif
			if((short)D[RN2]<0){
				SR|=CCR_NON;	i_chk();	return;	}
			if((short)D[RN2]>m68_read2((short)num2(1))){
				SR&=CCR_NOFF;	i_chk();	return;	}
			PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"CHK $%08X,D%d\n",
	num4(1),RN2);	CO;	}
#endif
			if((short)D[RN2]<0){
				SR|=CCR_NON;	i_chk();	return;	}
			if((short)D[RN2]>m68_read2(num4(1))){
				SR&=CCR_NOFF;	i_chk();	return;	}
			PC+=6;	return;



		case	2:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CHK $%04X(PC),D%d\n",
	num2(1),RN2);	CO;	}
#endif
	if((short)D[RN2]<0){
		SR|=CCR_NON;	i_chk();	return;	}
	if((short)D[RN2]>m68_read2(PC+(short)num2(1))){
		SR&=CCR_NOFF;	i_chk();	return;	}
	PC+=4;	return;



		case	3:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CHK $%02X(PC,X%d),D%d\n",
	num2(1),RN3,RN2);	CO;	}
#endif
	if((short)D[RN2]<0){
		SR|=CCR_NON;	i_chk();	return;	}
	if((num2(1)&0x0800)==0)
			if((short)D[RN2]>m68_read2(PC+(char)num1(1)+(short)D[RN3])){
				SR&=CCR_NOFF;	i_chk();	return;	}
	else	if((short)D[RN2]>m68_read2(PC+(char)num1(1)+       D[RN3])){
				SR&=CCR_NOFF;	i_chk();	return;	}
	PC+=4;	return;



		case	4:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CHK #$%04X,D%d\n",
	num2(1),RN2);	CO;	}
#endif
	if((short)D[RN2]<0){
		SR|=CCR_NON;	i_chk();	return;	}
	if((short)D[RN2]>(short)num2(1)){
		SR&=CCR_NOFF;	i_chk();	return;	}
	PC+=4;	return;



		default:
			i_gic();	return;
	}
