//	MC68K code CLR



case	0x0200:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CLR.B D%d\n",RN1);	CO;	}
#endif
	D[RN1]&=0xffffff00;
	SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	SR|=CCR_ZON;
	PC+=2;	return;



case	0x0210:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CLR.B (A%d)\n",RN1);	CO;	}
#endif
	m68_write1(A[RN1],0);
	SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	SR|=CCR_ZON;
	PC+=2;	return;



case	0x0218:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CLR.B (A%d)+\n",RN1);	CO;	}
#endif
	m68_write1(A[RN1],0);
	SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	SR|=CCR_ZON;
	A[RN1]++;
	PC+=2;	return;



case	0x0220:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CLR.B -(A%d)\n",RN1);	CO;	}
#endif
	A[RN1]--;
	m68_write1(A[RN1],0);
	SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	SR|=CCR_ZON;
	PC+=2;	return;



case	0x0228:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CLR.B $%04X(A%d)\n",
	num2(1),RN1);	CO;	}
#endif
	m68_write1(A[RN1]+(short)num2(1),0);
	SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	SR|=CCR_ZON;
	PC+=4;	return;



case	0x0230:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CLR.B $%02X(A%d,X%d)\n",
	num2(1),RN1,RN3);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			m68_write1(A[RN1]+(char)num1(1)+(short)D[RN2],0);	//16bitg
	else	m68_write1(A[RN1]+(char)num1(1)+       D[RN2],0);	//32bitg
	SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	SR|=CCR_ZON;
	PC+=4;	return;



case	0x0238:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CLR.B $%04X\n",
	num2(1));	CO;	}
#endif
			m68_write1((short)num2(1),0);	//16bitg
			SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
			SR|=CCR_ZON;
			PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"CLR.B $%08X\n",
	num4(1));	CO;	}
#endif
			m68_write1(num4(1),0);	
			SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
			SR|=CCR_ZON;
			PC+=6;	return;



		default:
			i_gic();	return;
	}





case	0x0240:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CLR.W D%d\n",RN1);	CO;	}
#endif
	D[RN1]&=0xffff0000;
	SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	SR|=CCR_ZON;
	PC+=2;	return;



case	0x0250:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CLR.W (A%d)\n",RN1);	CO;	}
#endif
	m68_write2(A[RN1],0);
	SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	SR|=CCR_ZON;
	PC+=2;	return;



case	0x0258:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CLR.W (A%d)+\n",RN1);	CO;	}
#endif
	m68_write2(A[RN1],0);
	SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	SR|=CCR_ZON;
	A[RN1]+=2;
	PC+=2;	return;



case	0x0260:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CLR.W -(A%d)\n",RN1);	CO;	}
#endif
	A[RN1]-=2;
	m68_write2(A[RN1],0);
	SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	SR|=CCR_ZON;
	PC+=2;	return;



case	0x0268:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CLR.W $%04X(A%d)\n",
	num2(1),RN1);	CO;	}
#endif
	m68_write2(A[RN1]+(short)num2(1),0);
	SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	SR|=CCR_ZON;
	PC+=4;	return;



case	0x0270:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CLR.W $%02X(A%d,X%d)\n",
	num2(1),RN1,RN3);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			m68_write2(A[RN1]+(char)num1(1)+(short)D[RN2],0);	//16bitg
	else	m68_write2(A[RN1]+(char)num1(1)+       D[RN2],0);	//32bitg
	SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	SR|=CCR_ZON;
	PC+=4;	return;



case	0x0278:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CLR.W $%04X\n",
	num2(1));	CO;	}
#endif
			m68_write2((short)num2(1),0);	//16bitg
			SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
			SR|=CCR_ZON;
			PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"CLR.W $%08X\n",
	num4(1));	CO;	}
#endif
			m68_write2(num4(1),0);	
			SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
			SR|=CCR_ZON;
			PC+=6;	return;



		default:
			i_gic();	return;
	}





case	0x0280:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CLR.L D%d\n",RN1);	CO;	}
#endif
	D[RN1]=0;
	SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	SR|=CCR_ZON;
	PC+=2;	return;



case	0x0290:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CLR.L (A%d)\n",RN1);	CO;	}
#endif
	m68_write4(A[RN1],0);
	SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	SR|=CCR_ZON;
	PC+=2;	return;



case	0x0298:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CLR.L (A%d)+\n",RN1);	CO;	}
#endif
	m68_write4(A[RN1],0);
	SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	SR|=CCR_ZON;
	A[RN1]+=4;
	PC+=2;	return;



case	0x02a0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CLR.L -(A%d)\n",RN1);	CO;	}
#endif
	A[RN1]-=2;
	m68_write4(A[RN1],0);
	SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	SR|=CCR_ZON;
	PC+=2;	return;



case	0x02a8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CLR.L $%04X(A%d)\n",
	num2(1),RN1);	CO;	}
#endif
	m68_write4(A[RN1]+(short)num2(1),0);
	SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	SR|=CCR_ZON;
	PC+=4;	return;



case	0x02b0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CLR.L $%02X(A%d,X%d)\n",
	num2(1),RN1,RN3);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			m68_write4(A[RN1]+(char)num1(1)+(short)D[RN2],0);	//16bitg
	else	m68_write4(A[RN1]+(char)num1(1)+       D[RN2],0);	//32bitg
	SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	SR|=CCR_ZON;
	PC+=4;	return;



case	0x02b8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CLR.L $%04X\n",
	num2(1));	CO;	}
#endif
			m68_write4((short)num2(1),0);	//16bitg
			SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
			SR|=CCR_ZON;
			PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"CLR.L $%08X\n",
	num4(1));	CO;	}
#endif
			m68_write4(num4(1),0);	
			SR&=CCR_NOFF&CCR_VOFF&CCR_COFF;
			SR|=CCR_ZON;
			PC+=6;	return;



		default:
			i_gic();	return;
	}





