//	MC68K code CMPA



case	0x00c0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CMPA.W D%d,A%d\n",
	RN1,RN2);	CO;	}
#endif
	TS1=(unsigned short)A[RN2];
	TS2=(unsigned short)D[RN1];
	TS3=TS1-TS2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					SR|=CCR_ZON;
	if((TS3&0x8000)!=0)			SR|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
	if(TS3>TS1){				SR|=CCR_CON;
								SR|=CCR_XON;	}

	PC+=2;	return;



case	0x00c8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CMPA.W A%d,A%d\n",
	RN1,RN2);	CO;	}
#endif
	TS1=(unsigned short)A[RN2];
	TS2=(unsigned short)A[RN1];
	TS3=TS1-TS2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					SR|=CCR_ZON;
	if((TS3&0x8000)!=0)			SR|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
	if(TS3>TS1){				SR|=CCR_CON;
								SR|=CCR_XON;	}

	PC+=2;	return;



case	0x00d0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CMPA.W (A%d),A%d\n",
	RN1,RN2);	CO;	}
#endif
	TS1=(unsigned short)A[RN2];
	TS2=(short)m68_read2(A[RN1]);
	TS3=TS1-TS2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					SR|=CCR_ZON;
	if((TS3&0x8000)!=0)			SR|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
	if(TS3>TS1){				SR|=CCR_CON;
								SR|=CCR_XON;	}

	PC+=2;	return;



case	0x00d8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CMPA.W (A%d)+,A%d\n",
	RN1,RN2);	CO;	}
#endif
	TS1=(unsigned short)A[RN2];
	TS2=(short)m68_read2(A[RN1]);
	TS3=TS1-TS2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					SR|=CCR_ZON;
	if((TS3&0x8000)!=0)			SR|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
	if(TS3>TS1){				SR|=CCR_CON;
								SR|=CCR_XON;	}

	A[RN1]+=2;
	PC+=2;	return;



case	0x00e0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CMPA.W -(A%d),A%d\n",
	RN1,RN2);	CO;	}
#endif
	A[RN1]-=2;
	TS1=(unsigned short)A[RN2];
	TS2=(short)m68_read2(A[RN1]);
	TS3=TS1-TS2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					SR|=CCR_ZON;
	if((TS3&0x8000)!=0)			SR|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
	if(TS3>TS1){				SR|=CCR_CON;
								SR|=CCR_XON;	}

	PC+=2;	return;



case	0x00e8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CMPA.W $%04X(A%d),A%d\n",
	num2(1),RN1,RN2);	CO;	}
#endif
	TS1=(unsigned short)A[RN2];
	TS2=(short)m68_read2(A[RN1]+(short)num2(1));
	TS3=TS1-TS2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					SR|=CCR_ZON;
	if((TS3&0x8000)!=0)			SR|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
	if(TS3>TS1){				SR|=CCR_CON;
								SR|=CCR_XON;	}

	PC+=4;	return;



case	0x00f0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CMPA.W $%02X(A%d,X%d),A%d\n",
	num1(1),RN1,RN3,RN2);	CO;	}
#endif
	TS1=(unsigned short)A[RN2];
	if((num2(1)&0x0800)==0)
			TS2=(short)m68_read2(A[RN1]+(char)num1(1)+(short)D[RN3]);
	else	TS2=(short)m68_read2(A[RN1]+(char)num1(1)+       D[RN3]);
	TS3=TS1-TS2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					SR|=CCR_ZON;
	if((TS3&0x8000)!=0)			SR|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
	if(TS3>TS1){				SR|=CCR_CON;
								SR|=CCR_XON;	}

	PC+=4;	return;



case	0x00f8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CMPA.W $%04X,A%d\n",
	num2(1),RN2);	CO;	}
#endif
			TS1=(unsigned short)A[RN2];
			TS2=(short)m68_read2((short)num2(1));
			TS3=TS1-TS2;

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TS3==0)					SR|=CCR_ZON;
			if((TS3&0x8000)!=0)			SR|=CCR_NON;
				else
			if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
			if(TS3>TS1){				SR|=CCR_CON;
										SR|=CCR_XON;	}

			PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"CMPA.W $%08X,A%d\n",
	num4(1),RN2);	CO;	}
#endif
			TS1=(unsigned short)A[RN2];
			TS2=(short)m68_read2(num4(1));
			TS3=TS1-TS2;

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TS3==0)					SR|=CCR_ZON;
			if((TS3&0x8000)!=0)			SR|=CCR_NON;
				else
			if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
			if(TS3>TS1){				SR|=CCR_CON;
										SR|=CCR_XON;	}

			PC+=6;	return;



		case	2:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CMPA.W $%04X(PC),A%d\n",
	num2(1),RN2);	CO;	}
#endif
			TS1=(unsigned short)A[RN2];
			TS2=(short)m68_read2(PC+(short)num2(1));
			TS3=TS1-TS2;

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TS3==0)					SR|=CCR_ZON;
			if((TS3&0x8000)!=0)			SR|=CCR_NON;
				else
			if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
			if(TS3>TS1){				SR|=CCR_CON;
										SR|=CCR_XON;	}

			PC+=4;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CMPA.W $%02X(PC,X%d),A%d\n",
	num1(1),RN3,RN2);	CO;	}
#endif
			TS1=(unsigned short)A[RN2];
			if((num2(1)&0x0800)==0)
					TS2=(short)m68_read2(PC+(char)num1(1)+(short)D[RN3]);
			else	TS2=(short)m68_read2(PC+(char)num1(1)+       D[RN3]);
			TS3=TS1-TS2;

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TS3==0)					SR|=CCR_ZON;
			if((TS3&0x8000)!=0)			SR|=CCR_NON;
				else
			if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
			if(TS3>TS1){				SR|=CCR_CON;
										SR|=CCR_XON;	}

			PC+=4;	return;



		case	4:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CMPA.W #$%04X,A%d\n",
	num2(1),RN3,RN2);	CO;	}
#endif
			TS1=(unsigned short)A[RN2];
			TS2=(short)m68_read2((short)num2(1));
			TS3=TS1-TS2;

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TS3==0)					SR|=CCR_ZON;
			if((TS3&0x8000)!=0)			SR|=CCR_NON;
				else
			if(((TS1^TS2)&0x8000)!=0)	SR|=CCR_VON;
			if(TS3>TS1){				SR|=CCR_CON;
										SR|=CCR_XON;	}

			PC+=4;	return;



		default:
			i_gic();	return;
	}





case	0x01c0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CMPA.L D%d,A%d\n",
	RN1,RN2);	CO;	}
#endif
	TL1=A[RN2];
	TL2=D[RN1];
	TL3=TL1-TL2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						SR|=CCR_ZON;
	if((TL3&0x80000000)!=0)			SR|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	SR|=CCR_VON;
	if(TL3>TL1){					SR|=CCR_CON;
									SR|=CCR_XON;	}

	PC+=2;	return;



case	0x01c8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CMPA.L A%d,A%d\n",
	RN1,RN2);	CO;	}
#endif
	TL1=A[RN2];
	TL2=A[RN1];
	TL3=TL1-TL2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						SR|=CCR_ZON;
	if((TL3&0x80000000)!=0)			SR|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	SR|=CCR_VON;
	if(TL3>TL1){					SR|=CCR_CON;
									SR|=CCR_XON;	}

	PC+=2;	return;



case	0x01d0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CMPA.L (A%d),A%d\n",
	RN1,RN2);	CO;	}
#endif
	TL1=A[RN2];
	TL2=m68_read4(A[RN1]);
	TL3=TL1-TL2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						SR|=CCR_ZON;
	if((TL3&0x80000000)!=0)			SR|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	SR|=CCR_VON;
	if(TL3>TL1){					SR|=CCR_CON;
									SR|=CCR_XON;	}

	PC+=2;	return;



case	0x01d8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CMPA.L (A%d)+,A%d\n",
	RN1,RN2);	CO;	}
#endif
	TL1=A[RN2];
	TL2=m68_read4(A[RN1]);
	TL3=TL1-TL2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						SR|=CCR_ZON;
	if((TL3&0x80000000)!=0)			SR|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	SR|=CCR_VON;
	if(TL3>TL1){					SR|=CCR_CON;
									SR|=CCR_XON;	}

	A[RN1]+=2;
	PC+=2;	return;



case	0x01e0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"CMPA.L -(A%d),A%d\n",
	RN1,RN2);	CO;	}
#endif
	A[RN1]-=2;
	TL1=A[RN2];
	TL2=m68_read4(A[RN1]);
	TL3=TL1-TL2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						SR|=CCR_ZON;
	if((TL3&0x80000000)!=0)			SR|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	SR|=CCR_VON;
	if(TL3>TL1){					SR|=CCR_CON;
									SR|=CCR_XON;	}

	PC+=2;	return;



case	0x01e8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CMPA.L $%04X(A%d),A%d\n",
	num2(1),RN1,RN2);	CO;	}
#endif
	TL1=A[RN2];
	TL2=m68_read4(A[RN1]+(short)num2(1));
	TL3=TL1-TL2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						SR|=CCR_ZON;
	if((TL3&0x80000000)!=0)			SR|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	SR|=CCR_VON;
	if(TL3>TL1){					SR|=CCR_CON;
									SR|=CCR_XON;	}

	PC+=4;	return;



case	0x01f0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CMPA.L $%02X(A%d,X%d),A%d\n",
	num1(1),RN1,RN3,RN2);	CO;	}
#endif
	TL1=A[RN2];
	if((num2(1)&0x0800)==0)
			TL2=m68_read4(A[RN1]+(char)num1(1)+(short)D[RN3]);
	else	TL2=m68_read4(A[RN1]+(char)num1(1)+       D[RN3]);
	TL3=TL1-TL2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						SR|=CCR_ZON;
	if((TL3&0x80000000)!=0)			SR|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	SR|=CCR_VON;
	if(TL3>TL1){					SR|=CCR_CON;
									SR|=CCR_XON;	}

	PC+=4;	return;



case	0x01f8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CMPA.L $%04X,A%d\n",
	num2(1),RN2);	CO;	}
#endif
			TL1=A[RN2];
			TL2=m68_read4((short)num2(1));
			TL3=TL1-TL2;

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TL3==0)						SR|=CCR_ZON;
			if((TL3&0x80000000)!=0)			SR|=CCR_NON;
				else
			if(((TL1^TL2)&0x80000000)!=0)	SR|=CCR_VON;
			if(TL3>TL1){					SR|=CCR_CON;
											SR|=CCR_XON;	}

			PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"CMPA.L $%08X,A%d\n",
	num4(1),RN2);	CO;	}
#endif
			TL1=A[RN2];
			TL2=m68_read4(num4(1));
			TL3=TL1-TL2;

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TL3==0)						SR|=CCR_ZON;
			if((TL3&0x80000000)!=0)			SR|=CCR_NON;
				else
			if(((TL1^TL2)&0x80000000)!=0)	SR|=CCR_VON;
			if(TL3>TL1){					SR|=CCR_CON;
											SR|=CCR_XON;	}

			PC+=6;	return;



		case	2:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CMPA.L $%04X(PC),A%d\n",
	num2(1),RN2);	CO;	}
#endif
			TL1=A[RN2];
			TL2=m68_read4(PC+(short)num2(1));
			TL3=TL1-TL2;

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TL3==0)						SR|=CCR_ZON;
			if((TL3&0x80000000)!=0)			SR|=CCR_NON;
				else
			if(((TL1^TL2)&0x80000000)!=0)	SR|=CCR_VON;
			if(TL3>TL1){					SR|=CCR_CON;
											SR|=CCR_XON;	}

			PC+=4;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"CMPA.L $%02X(PC,X%d),A%d\n",
	num1(1),RN3,RN2);	CO;	}
#endif
			TL1=A[RN2];
			if((num2(1)&0x0800)==0)
					TL2=m68_read4(PC+(char)num1(1)+(short)D[RN3]);
			else	TL2=m68_read4(PC+(char)num1(1)+       D[RN3]);
			TL3=TL1-TL2;

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TL3==0)						SR|=CCR_ZON;
			if((TL3&0x80000000)!=0)			SR|=CCR_NON;
				else
			if(((TL1^TL2)&0x80000000)!=0)	SR|=CCR_VON;
			if(TL3>TL1){					SR|=CCR_CON;
											SR|=CCR_XON;	}

			PC+=4;	return;



		case	4:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"CMPA.L #$%08X,A%d\n",
	num4(1),RN2);	CO;	}
#endif
			TL1=A[RN2];
			TL2=num4(1);
			TL3=TL1-TL2;

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TL3==0)						SR|=CCR_ZON;
			if((TL3&0x80000000)!=0)			SR|=CCR_NON;
				else
			if(((TL1^TL2)&0x80000000)!=0)	SR|=CCR_VON;
			if(TL3>TL1){					SR|=CCR_CON;
											SR|=CCR_XON;	}

			PC+=6;	return;



		default:
			i_gic();	return;
	}



