//	MC68K code EORI



case	0x0a00:		//byte size , data regster direct
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EORI.B #$%02X,D%d\n",
	num1(1),RN1);	CO;	}
#endif
	D[RN1]^=num1(1);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if((D[RN1]&0xff)==0)	SR|=CCR_ZON;
	if((D[RN1]&0x80)!=0)	SR|=CCR_NON;
	PC+=4;	return;



	case	0x0a10:		//byte size , mem addr
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EORI.B #$%02X,(A%d)\n",
	num1(1),RN1);	CO;	}
#endif
	TC1=m68_read1(A[RN1])^num1(1);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;
	m68_write1(A[RN1],TC1);
	PC+=4;	return;



case	0x0a18:		//byte size , mem addr ,postinc
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EORI.B #$%02X,(A%d)+\n",
	num1(1),RN1);	CO;	}
#endif
	TC1=m68_read1(A[RN1])^num1(1);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;
	m68_write1(A[RN1],TC1);
	A[RN1]++;
	PC+=4;	return;



case	0x0a20:		//byte size , mem addr ,pridec
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EORI.B #$%02X,-(A%d)\n",
	num1(1),RN1);	CO;	}
#endif
	A[RN1]--;
	TC1=m68_read1(A[RN1])^num1(1);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;
	m68_write1(A[RN1],TC1);
	PC+=4;	return;



	case	0x0a28:		//byte size , mem addr with disp
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"EORI.B #$%02X,$%04X(A%d)\n",
	num1(1),num2(2),RN1);	CO;	}
#endif
	TC1=m68_read1(A[RN1]+(short)num2(2))^num1(1);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;
	m68_write1(A[RN1]+(short)num2(2),TC1);
	PC+=6;	return;



case	0x0a30:		//byte size , mem addr with index
	RN3=(num2(2)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"EORI.B #$%02X,$%02X(A%d,X%d)\n",
	num1(1),num1(2),RN1,RN3);	CO;	}
#endif
	if((num2(2)&0x0800)==0)
				TR1=A[RN1]+(char)num1(2)+(short)D[RN3];	//16bitg
		else	TR1=A[RN1]+(char)num1(2)+       D[RN3];	//32bitgp
	TC1=m68_read1(TR1)^num1(1);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;
	m68_write1(TR1,TC1);
	PC+=6;	return;



case	0x0a38:				//byte size , abs
	switch(RN1){
		case	0:		//word size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"EORI.B #$%02X,$%04X\n",
	num1(1),num2(2));	CO;	}
#endif
			TR1=(short)num2(2);
			TC1=m68_read1(TR1)^num1(1);
			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC1==0)			SR|=CCR_ZON;
			if((TC1&0x80)!=0)	SR|=CCR_NON;
			m68_write1(TR1,TC1);
			PC+=6;	return;



		case	1:		//long size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;	sprintf(buf,"EORI.B #$%02X,$%08X\n",
	num1(1),num4(2));	CO;	}
#endif
			TR1=num4(2);
			TC1=m68_read1(TR1)^num1(1);
			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC1==0)			SR|=CCR_ZON;
			if((TC1&0x80)!=0)	SR|=CCR_NON;
			m68_write1(TR1,TC1);
			PC+=8;	return;



		case	4:		//EORI to CCR
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EORI #$%02X,CCR\n",
	num1(1));	CO;	}
#endif
			SR^=num1(1);
			PC+=4;	return;



		default:
			i_gic();	return;
	}





case	0x0a40:		//word size , data regster direct
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EORI.W #$%04X,D%d\n",
	num2(1),RN1);	CO;	}
#endif
	D[RN1]^=num2(1);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if((D[RN1]&0xffff)==0)	SR|=CCR_ZON;
	if((D[RN1]&0x8000)!=0)	SR|=CCR_NON;
	PC+=4;	return;



case	0x0a50:		//mem addr
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EORI.W #$%04X,(A%d)\n",
	num2(1),RN1);	CO;	}
#endif
	TS1=m68_read2(A[RN1])^num2(1);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;
	m68_write2(A[RN1],TS1);
	PC+=4;	return;



case	0x0a58:		//mem addr ,postinc
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EORI.W #$%04X,(A%d)+\n",
	num2(1),RN1);	CO;	}
#endif
	TS1=m68_read2(A[RN1])^num2(1);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;
	m68_write2(A[RN1],TS1);
	A[RN1]+=2;
	PC+=4;	return;



case	0x0a60:		//mem addr ,pridec
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EORI.W #$%04X,-(A%d)\n",
	num2(1),RN1);	CO;	}
#endif
	A[RN1]-=2;
	TS1=m68_read2(A[RN1])^num2(1);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;
	m68_write2(A[RN1],TS1);
	PC+=4;	return;



case	0x0a68:		//mem addr with disp
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"EORI.W #$%04X,$%04X(A%d)\n",
	num2(1),num2(2),RN1);	CO;	}
#endif
	TS1=m68_read2(A[RN1]+(short)num2(2))^num2(1);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;
	m68_write2(A[RN1]+(short)num2(2),TS1);
	PC+=6;	return;



case	0x0a70:		//byte size , mem addr with index
	RN3=(num2(2)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"EORI.W #$%04X,$%02X(A%d,X%d)\n",
	num2(1),num1(2),RN1,RN3);	CO;	}
#endif
	if((num2(2)&0x0800)==0)
				TR1=A[RN1]+(char)num1(2)+(short)D[RN3];	//16bitg
		else	TR1=A[RN1]+(char)num1(2)+       D[RN3];	//32bitgp
	TS1=m68_read2(TR1)^num2(1);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;
	m68_write2(TR1,TS1);
	PC+=6;	return;



case	0x0a78:				//abs
	switch(RN1){
		case	0:		//word size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"EORI.W #$%04X,$%04X\n",
	num2(1),num2(2));	CO;	}
#endif
			TR1=(short)num2(2);
			TS1=m68_read2(TR1)^num2(1);
			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TS1==0)			SR|=CCR_ZON;
			if((TS1&0x8000)!=0)	SR|=CCR_NON;
			m68_write2(TR1,TS1);
			PC+=6;	return;



		case	1:		//long size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;	sprintf(buf,"EORI.W #$%04X,$%08X\n",
	num2(1),num4(2));	CO;	}
#endif
			TR1=num4(2);
			TS1=m68_read2(TR1)^num2(1);
			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TS1==0)			SR|=CCR_ZON;
			if((TS1&0x8000)!=0)	SR|=CCR_NON;
			m68_write2(TR1,TS1);
			PC+=8;	return;



		case	4:		//EORI to SR
			if(!(SR&0x2000)){								//User state
				BD1;
				sprintf(buf,"EORI #$%04X,SR <User State! TRAP!>\n",num2(1));
				CO;		goto	_TRAP;										}
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EORI #$%04X,SR\n",
	num2(1));	CO;	}
#endif
			TSR=SR;	SR^=num2(1);
			if((TSR^SR)&0x2000)								//Change state
				if(SR&0x2000){	USP=A[7];	A[7]=SSP;	}	//User to Super
					else	{	SSP=A[7];	A[7]=USP;	}	//Super to User
			PC+=4;	return;



		default:
			i_gic();	return;
	}





case	0x0a80:		//long size , data regster direct
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"EORI.L #$%08X,D%d\n",
	num4(1),RN1);	CO;	}
#endif
	D[RN1]^=num4(1);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(D[RN1]==0)				SR|=CCR_ZON;
	if((D[RN1]&0x80000000)!=0)	SR|=CCR_NON;
	PC+=6;	return;



case	0x0a90:		//mem addr
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"EORI.L #$%08X,(A%d)\n",
	num4(1),RN1);	CO;	}
#endif
	TL1=m68_read4(A[RN1])^num4(1);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;
	m68_write4(A[RN1],TL1);
	PC+=6;	return;



case	0x0a98:		//mem addr ,postinc
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"EORI.L #$%08X,(A%d)+\n",
	num4(1),RN1);	CO;	}
#endif
	TL1=m68_read4(A[RN1])^num4(1);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;
	m68_write4(A[RN1],TL1);
	A[RN1]+=4;
	PC+=6;	return;



case	0x0aa0:		//mem addr ,pridec
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"EORI.L #$%08X,-(A%d)\n",
	num4(1),RN1);	CO;	}
#endif
	A[RN1]-=4;
	TL1=m68_read4(A[RN1])^num4(1);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;
	m68_write4(A[RN1],TL1);
	PC+=6;	return;



case	0x0aa8:		//mem addr with disp
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;	sprintf(buf,"EORI.L #$%08X,$%04X(A%d)\n",
	num4(1),num2(3),RN1);	CO;	}
#endif
	TL1=m68_read4(A[RN1]+(short)num2(3))^num4(1);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;
	m68_write4(A[RN1]+(short)num2(3),TL1);
	PC+=8;	return;



case	0x0ab0:		//byte size , mem addr with index
	RN3=(num2(3)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;	sprintf(buf,"EORI.L #$%08X,$%02X(A%d,X%d)\n",
	num4(1),num1(3),RN1,RN3);	CO;	}
#endif
	if((num2(3)&0x0800)==0)
				TR1=A[RN1]+(char)num1(3)+(short)D[RN3];	//16bitg
		else	TR1=A[RN1]+(char)num1(3)+       D[RN3];	//32bitgp
	TL1=m68_read4(TR1)^num4(1);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;
	m68_write4(TR1,TL1);
	PC+=8;	return;



case	0x0ab8:				//abs
	switch(RN1){
		case	0:		//word size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;	sprintf(buf,"EORI.L #$%08X,$%04X\n",
	num4(1),num2(3));	CO;	}
#endif
			TR1=(short)num2(3);
			TL1=m68_read4(TR1)^num4(1);
			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL1==0)				SR|=CCR_ZON;
			if((TL1&0x80000000)!=0)	SR|=CCR_NON;
			m68_write4(TR1,TL1);
			PC+=8;	return;



		case	1:		//long size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD4;	sprintf(buf,"EORI.L #$%08X,$%08X\n",
	num4(1),num4(3));	CO;	}
#endif
			TR1=num4(3);
			TL1=m68_read4(TR1)^num4(1);
			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL1==0)				SR|=CCR_ZON;
			if((TL1&0x80000000)!=0)	SR|=CCR_NON;
			m68_write4(TR1,TL1);
			PC+=10;	return;


		default:
			i_gic();	return;
	}
