//	MC68K code LSL



case	0x0108:
case	0x0308:
case	0x0508:
case	0x0708:
case	0x0908:
case	0x0b08:
case	0x0d08:
case	0x0f08:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"LSL.B #$%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	if(RN2==0)	RN2=8;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	for(TC1=0;TC1!=RN2;TC1++){
		if((TL1&0x80)==0)	SR&=CCR_XOFF&CCR_COFF;
			else			SR|=CCR_XON |CCR_CON;
		TL1<<=1;									}
	if((unsigned char)TL1==0)	SR|=CCR_ZON;
	if((TL1&0x80)!=0)			SR|=CCR_NON;
	D[RN1]=(D[RN1]&0xffffff00)|(TL1&0xff);
	PC+=2;	return;



case	0x0148:
case	0x0348:
case	0x0548:
case	0x0748:
case	0x0948:
case	0x0b48:
case	0x0d48:
case	0x0f48:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"LSL.W #$%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	if(RN2==0)	RN2=8;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	for(TC1=0;TC1!=RN2;TC1++){
		if((TL1&0x8000)==0)	SR&=CCR_XOFF&CCR_COFF;
			else			SR|=CCR_XON |CCR_CON;
		TL1<<=1;									}
	if((unsigned short)TL1==0)	SR|=CCR_ZON;
	if((TL1&0x8000)!=0)			SR|=CCR_NON;
	D[RN1]=(D[RN1]&0xffff0000)|(TL1&0xffff);
	PC+=2;	return;



case	0x0188:
case	0x0388:
case	0x0588:
case	0x0788:
case	0x0988:
case	0x0b88:
case	0x0d88:
case	0x0f88:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"LSL.L #$%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	if(RN2==0)	RN2=8;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	for(TC1=0;TC1!=RN2;TC1++){
		if((TL1&0x80000000)==0)	SR&=CCR_XOFF&CCR_COFF;
			else				SR|=CCR_XON |CCR_CON;
		TL1<<=1;										}
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;
	D[RN1]=TL1;
	PC+=2;	return;





case	0x0128:
case	0x0328:
case	0x0528:
case	0x0728:
case	0x0928:
case	0x0b28:
case	0x0d28:
case	0x0f28:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"LSL.B D%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	TC2=(char)(D[RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		if((TL1&0x80)==0)	SR&=CCR_XOFF&CCR_COFF;
			else			SR|=CCR_XON |CCR_CON;
		TL1<<=1;									}
	if((unsigned char)TL1==0)	SR|=CCR_ZON;
	if((TL1&0x80)!=0)			SR|=CCR_NON;
	D[RN1]=(D[RN1]&0xffffff00)|(TL1&0xff);
	PC+=2;	return;



case	0x0168:
case	0x0368:
case	0x0568:
case	0x0768:
case	0x0968:
case	0x0b68:
case	0x0d68:
case	0x0f68:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"LSL.W D%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	TC2=(char)(D[RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		if((TL1&0x8000)==0)	SR&=CCR_XOFF&CCR_COFF;
			else			SR|=CCR_XON |CCR_CON;
		TL1<<=1;									}
	if((unsigned short)TL1==0)	SR|=CCR_ZON;
	if((TL1&0x8000)!=0)			SR|=CCR_NON;
	D[RN1]=(D[RN1]&0xffff0000)|(TL1&0xffff);
	PC+=2;	return;



case	0x01a8:
case	0x03a8:
case	0x05a8:
case	0x07a8:
case	0x09a8:
case	0x0ba8:
case	0x0da8:
case	0x0fa8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"LSL.L D%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	TC2=(char)(D[RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		if((TL1&0x80000000)==0)	SR&=CCR_XOFF&CCR_COFF;
			else				SR|=CCR_XON |CCR_CON;
		TL1<<=1;										}
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;
	D[RN1]=TL1;
	PC+=2;	return;





case	0x03d0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"LSL.W (A%d)\n",
	RN1);	CO;	}
#endif
	TR1=A[RN1];
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0)	SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if((unsigned short)TS2==0)	SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=2;	return;



case	0x03d8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"LSL.W (A%d)+\n",
	RN1);	CO;	}
#endif
	TR1=A[RN1];
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0)	SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if((unsigned short)TS2==0)	SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	A[RN1]+=2;
	PC+=2;	return;



case	0x03e0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"LSL.W -(A%d)\n",
	RN1);	CO;	}
#endif
	A[RN1]-=2;
	TR1=A[RN1];
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0)	SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if((unsigned short)TS2==0)	SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=2;	return;



case	0x03e8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"LSL.W $%04X(A%d)\n",
	num2(1),RN1);	CO;	}
#endif
	TR1=A[RN1]+(short)num2(1);
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0)	SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if((unsigned short)TS2==0)	SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=4;	return;



case	0x03f0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"LSL.W $%02X(A%d,X%d)\n",
	num2(1),RN1,RN3);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=A[RN1]+(char)num1(1)+(short)D[RN3];
	else	TR1=A[RN1]+(char)num1(1)+       D[RN3];
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0)	SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if((unsigned short)TS2==0)	SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=4;	return;



case	0x03f8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"LSL.W $%04X\n",
	num2(1));	CO;	}
#endif
	TR1=(short)num2(1);
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0)	SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if((unsigned short)TS2==0)	SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"LSL.W $%08X\n",
	num4(1));	CO;	}
#endif
	TR1=(short)num4(1);
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0)	SR&=CCR_XOFF&CCR_COFF;
		else			SR|=CCR_XON |CCR_CON;
	if((unsigned short)TS2==0)	SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=6;	return;



		default:
			i_gic();	return;
	}



